/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BootstrapHandlerHelperTest {
    BootstrapHandlerHelperTest() {
    }

    @Test
    void getServiceUrl_nullPathInfo_returnsDot() {
        VaadinServletRequest request = this.createRequest(null, "", "/", "");
        Assertions.assertEquals((Object)".", (Object)BootstrapHandlerHelper.getServiceUrl((VaadinRequest)request));
    }

    @Test
    void getServiceUrl_simplePath_returnsCorrectRelativePath() {
        VaadinServletRequest request = this.createRequest("/some/path", "", "/some/path", "");
        Assertions.assertEquals((Object)"./..", (Object)BootstrapHandlerHelper.getServiceUrl((VaadinRequest)request));
    }

    @Test
    void getServiceUrl_encodedSlashInPath_treatsAsOneSegment() {
        VaadinServletRequest request = this.createRequest("/wild/a/b", "", "/wild/a%2Fb", "");
        Assertions.assertEquals((Object)"./..", (Object)BootstrapHandlerHelper.getServiceUrl((VaadinRequest)request));
    }

    @Test
    void getServiceUrl_encodedSlashWithContextPath_treatsAsOneSegment() {
        VaadinServletRequest request = this.createRequest("/wild/a/b", "", "/ctx/wild/a%2Fb", "/ctx");
        Assertions.assertEquals((Object)"./..", (Object)BootstrapHandlerHelper.getServiceUrl((VaadinRequest)request));
    }

    @Test
    void getServiceUrl_multipleEncodedSlashes_countsCorrectly() {
        VaadinServletRequest request = this.createRequest("/wild/a/b/c", "", "/wild/a%2Fb%2Fc", "");
        Assertions.assertEquals((Object)"./..", (Object)BootstrapHandlerHelper.getServiceUrl((VaadinRequest)request));
    }

    @Test
    void getServiceUrl_pathWithSpaces_unaffected() {
        VaadinServletRequest request = this.createRequest("/file with spaces.js", "", "/file%20with%20spaces.js", "");
        Assertions.assertEquals((Object)".", (Object)BootstrapHandlerHelper.getServiceUrl((VaadinRequest)request));
    }

    @Test
    void getServiceUrl_normalPathWithServletPath_returnsCorrectPath() {
        VaadinServletRequest request = this.createRequest("/view/sub", "/app", "/app/view/sub", "");
        Assertions.assertEquals((Object)"./..", (Object)BootstrapHandlerHelper.getServiceUrl((VaadinRequest)request));
    }

    private VaadinServletRequest createRequest(String pathInfo, String servletPath, String requestURI, String contextPath) {
        HttpServletRequest httpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpRequest.getPathInfo()).thenReturn((Object)pathInfo);
        Mockito.when((Object)httpRequest.getServletPath()).thenReturn((Object)servletPath);
        Mockito.when((Object)httpRequest.getRequestURI()).thenReturn((Object)requestURI);
        Mockito.when((Object)httpRequest.getContextPath()).thenReturn((Object)contextPath);
        VaadinServletService service = (VaadinServletService)Mockito.mock(VaadinServletService.class);
        return new VaadinServletRequest(httpRequest, service);
    }
}

