/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.JacksonUtilsTest;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementListenersTest;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.PropertyChangeDeniedException;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.SignalComputation;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

class ElementBindPropertyTest {
    private static MockVaadinServletService service;
    private LinkedList<ErrorEvent> events;

    ElementBindPropertyTest() {
    }

    @BeforeAll
    public static void init() {
        service = new MockVaadinServletService();
    }

    @AfterAll
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @BeforeEach
    public void before() {
        this.events = this.mockLockedSessionWithErrorHandler();
    }

    @AfterEach
    public void after() {
        CurrentInstance.clearAll();
        this.events = null;
    }

    @Test
    public void bindProperty_nullProperty_throwException() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)"bar");
        Assertions.assertThrows(IllegalArgumentException.class, () -> element.bindProperty(null, (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0)));
    }

    @Test
    public void bindProperty_illegalProperty_throwException() {
        Element element = new Element("foo");
        ValueSignal signal = new ValueSignal((Object)"bar");
        Assertions.assertThrows(IllegalArgumentException.class, () -> element.bindProperty("textContent", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> element.bindProperty("classList", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> element.bindProperty("className", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> element.bindProperty("outerHTML", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0)));
    }

    @Test
    public void bindProperty_notComponent_doNotThrowException() {
        Element element = new Element("foo");
        UI.getCurrent().getElement().appendChild(new Element[]{element});
        ValueSignal signal = new ValueSignal((Object)"bar");
        element.bindProperty("foobar", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindProperty_setPropertyWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertThrows(BindingActiveException.class, () -> component.getElement().setProperty("foo", "baz"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindProperty_nullSignal_throwsNPE() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertThrows(NullPointerException.class, () -> component.getElement().bindProperty("foo", null, null));
    }

    @Test
    public void bindProperty_removePropertyWhileBindingIsActive_throwException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertThrows(BindingActiveException.class, () -> component.getElement().removeProperty("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindPropertyComputedSignal_getPropertyValue_returnsCorrectValue() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        Signal computedSignal = Signal.computed((SignalComputation & Serializable)() -> "computed-" + (String)signal.get());
        component.getElement().bindProperty("foo", computedSignal, null);
        Assertions.assertEquals((Object)"computed-bar", (Object)component.getElement().getProperty("foo", "default"));
    }

    @Test
    public void bindPropertyMappedSignal_getPropertyValue_returnsCorrectValue() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        Signal mappedSignal = signal.map((SignalMapper & Serializable)text -> "mapped-" + text);
        component.getElement().bindProperty("foo", mappedSignal, null);
        Assertions.assertEquals((Object)"mapped-bar", (Object)component.getElement().getProperty("foo", "default"));
    }

    @Test
    public void bindPropertyJacksonNull_getPropertyValue_returnsCorrectValue() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal dependency = new ValueSignal(null);
        Signal computedSignal = Signal.computed((SignalComputation & Serializable)() -> {
            dependency.get();
            return null;
        });
        component.getElement().bindProperty("foo", computedSignal, null);
        Assertions.assertEquals((Object)JacksonUtils.nullNode(), (Object)component.getElement().getPropertyRaw("foo"));
        Assertions.assertEquals(null, (Object)component.getElement().getProperty("foo"));
    }

    @Test
    public void bindPropertyJacksonObjectNode_getPropertyValue_returnsCorrectValue() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal dependency = new ValueSignal(null);
        Signal computedSignal = Signal.computed((SignalComputation & Serializable)() -> {
            dependency.get();
            return JacksonUtils.createObjectNode();
        });
        component.getElement().bindProperty("bar", computedSignal, null);
        Assertions.assertEquals((Object)JacksonUtils.createObjectNode(), (Object)component.getElement().getPropertyRaw("bar"));
        Assertions.assertEquals((Object)"{}", (Object)component.getElement().getProperty("bar"));
    }

    @Test
    public void bindProperty_addPropertyChangeListenerAttached_listenerReceivesValueChange() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicReference listenerValue = new AtomicReference();
        component.getElement().addPropertyChangeListener("foo", "event", (PropertyChangeListener & Serializable)event -> listenerValue.set(event.getValue()));
        Assertions.assertEquals((Object)DisabledUpdateMode.ONLY_WHEN_ENABLED, (Object)((ElementListenerMap)component.getElement().getNode().getFeature(ElementListenerMap.class)).getPropertySynchronizationMode("foo"), (String)"The property should be synchronized");
        ElementListenerMap listenerMap = (ElementListenerMap)component.getElement().getNode().getFeature(ElementListenerMap.class);
        Assertions.assertEquals(Collections.singleton("}foo"), ElementListenersTest.getExpressions(listenerMap, "event"), (String)"A DOM event synchronization should be defined");
        signal.set((Object)"changedValue");
        Assertions.assertEquals((Object)"changedValue", listenerValue.get());
    }

    @Test
    public void bindProperty_addPropertyChangeListenerDetached_listenerReceivesValueChange() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicReference listenerValue = new AtomicReference();
        component.getElement().addPropertyChangeListener("foo", "event", (PropertyChangeListener & Serializable)event -> listenerValue.set(event.getValue()));
        signal.set((Object)"changedValue");
        Assertions.assertEquals((Object)"changedValue", listenerValue.get());
        component.removeFromParent();
        signal.set((Object)"secondChangedValue");
        Assertions.assertEquals((Object)"changedValue", listenerValue.get());
        Assertions.assertEquals((Object)"changedValue", (Object)component.getElement().getProperty("foo"));
    }

    @Test
    public void bindBooleanProperty_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)true);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertNull((Object)component.getElement().getProperty("foo"));
    }

    @Test
    public void bindBooleanProperty_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        component.removeFromParent();
        signal.set((Object)false);
        Assertions.assertTrue((boolean)this.events.isEmpty());
        Assertions.assertTrue((boolean)component.getElement().getProperty("foo", false));
    }

    @Test
    public void bindBooleanProperty_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertTrue((boolean)component.getElement().getProperty("foo", false));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindBooleanProperty_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertTrue((boolean)component.getElement().getProperty("foo", false));
        component.removeFromParent();
        signal.set((Object)false);
        Assertions.assertEquals((Object)false, (Object)signal.peek());
        Assertions.assertTrue((boolean)component.getElement().getProperty("foo", false));
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertFalse((boolean)component.getElement().getProperty("foo", true));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindDoubleProperty_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)1.0);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertNull((Object)component.getElement().getProperty("foo"));
    }

    @Test
    public void bindDoubleProperty_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)1.0);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        component.removeFromParent();
        signal.set((Object)2.0);
        Assertions.assertTrue((boolean)this.events.isEmpty());
        Assertions.assertEquals((double)1.0, (double)component.getElement().getProperty("foo", -1.0), (double)0.0);
    }

    @Test
    public void bindDoubleProperty_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)1.0);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((double)1.0, (double)component.getElement().getProperty("foo", -1.0), (double)0.0);
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindDoubleProperty_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)1.0);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((double)1.0, (double)component.getElement().getProperty("foo", -1.0), (double)0.0);
        component.removeFromParent();
        signal.set((Object)2.0);
        Assertions.assertEquals((double)2.0, (double)((Double)signal.peek()), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)component.getElement().getProperty("foo", -1.0), (double)0.0);
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertEquals((double)2.0, (double)component.getElement().getProperty("foo", -1.0), (double)0.0);
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindIntegerProperty_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)1);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertNull((Object)component.getElement().getProperty("foo"));
    }

    @Test
    public void bindIntegerProperty_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)1);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        component.removeFromParent();
        signal.set((Object)2);
        Assertions.assertTrue((boolean)this.events.isEmpty());
        Assertions.assertEquals((int)1, (int)component.getElement().getProperty("foo", -1));
    }

    @Test
    public void bindIntegerProperty_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)1);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((int)1, (int)component.getElement().getProperty("foo", -1));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindIntegerProperty_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)1);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((int)1, (int)component.getElement().getProperty("foo", -1));
        component.removeFromParent();
        signal.set((Object)2);
        Assertions.assertEquals((long)2L, (long)((Integer)signal.peek()).intValue());
        Assertions.assertEquals((int)1, (int)component.getElement().getProperty("foo", -1));
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertEquals((int)2, (int)component.getElement().getProperty("foo", -1));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindStringProperty_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertNull((Object)component.getElement().getProperty("foo", null));
    }

    @Test
    public void bindStringProperty_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        component.removeFromParent();
        signal.set((Object)"baz");
        Assertions.assertTrue((boolean)this.events.isEmpty());
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getProperty("foo", "default"));
    }

    @Test
    public void bindStringProperty_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getProperty("foo", "default"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindStringProperty_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"bar");
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getProperty("foo", "default"));
        component.removeFromParent();
        signal.set((Object)"baz");
        Assertions.assertEquals((Object)"baz", (Object)signal.peek());
        Assertions.assertEquals((Object)"bar", (Object)component.getElement().getProperty("foo", "default"));
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertEquals((Object)"baz", (Object)component.getElement().getProperty("foo", "default"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindBeanProperty_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)this.createJohn());
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        Assertions.assertNull((Object)component.getElement().getProperty("foo", null));
    }

    @Test
    public void bindBeanProperty_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        JacksonUtilsTest.Person john = this.createJohn();
        ValueSignal signal = new ValueSignal((Object)john);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        component.removeFromParent();
        signal.set((Object)this.createPerson("Jack", 52.0, false));
        this.assertPersonEquals(john, (JsonNode)component.getElement().getPropertyRaw("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindBeanProperty_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        JacksonUtilsTest.Person john = this.createJohn();
        ValueSignal signal = new ValueSignal((Object)john);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        this.assertPersonEquals(john, (JsonNode)component.getElement().getPropertyRaw("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindBeanProperty_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        JacksonUtilsTest.Person john = this.createJohn();
        ValueSignal signal = new ValueSignal((Object)john);
        component.getElement().bindProperty("foo", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        this.assertPersonEquals(john, (JsonNode)component.getElement().getPropertyRaw("foo"));
        component.removeFromParent();
        JacksonUtilsTest.Person jack = this.createJack();
        signal.set((Object)jack);
        Assertions.assertEquals((Object)jack, (Object)signal.peek());
        this.assertPersonEquals(john, (JsonNode)component.getElement().getPropertyRaw("foo"));
        UI.getCurrent().add(new Component[]{component});
        this.assertPersonEquals(jack, (JsonNode)component.getElement().getPropertyRaw("foo"));
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindListProperty_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal(Arrays.asList(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertNull((Object)component.getElement().getProperty("foo", null));
    }

    @Test
    public void bindListProperty_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal(Arrays.asList(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertEquals((Object)"John", (Object)this.getFromList(component, "foo", 0).get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromList(component, "foo", 1).get("name").asString());
        component.removeFromParent();
        signal.set(Arrays.asList(this.createJack(), this.createJohn()));
        Assertions.assertEquals((Object)"John", (Object)this.getFromList(component, "foo", 0).get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromList(component, "foo", 1).get("name").asString());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindListProperty_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal(Arrays.asList(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertEquals((Object)"John", (Object)this.getFromList(component, "foo", 0).get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromList(component, "foo", 1).get("name").asString());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindListProperty_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal(Arrays.asList(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertEquals((Object)"John", (Object)this.getFromList(component, "foo", 0).get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromList(component, "foo", 1).get("name").asString());
        component.removeFromParent();
        signal.set(Arrays.asList(this.createJack(), this.createJohn()));
        Assertions.assertEquals((Object)"Jack", (Object)((JacksonUtilsTest.Person)((List)signal.peek()).getFirst()).name());
        Assertions.assertEquals((Object)"John", (Object)((JacksonUtilsTest.Person)((List)signal.peek()).getLast()).name());
        Assertions.assertEquals((Object)"John", (Object)this.getFromList(component, "foo", 0).get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromList(component, "foo", 1).get("name").asString());
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromList(component, "foo", 0).get("name").asString());
        Assertions.assertEquals((Object)"John", (Object)this.getFromList(component, "foo", 1).get("name").asString());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindMapProperty_componentNotAttached_bindingIgnored() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal(this.createPersonMap(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertNull((Object)component.getElement().getProperty("foo", null));
    }

    @Test
    public void bindMapProperty_componentDetached_bindingIgnored() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal(this.createPersonMap(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertEquals((Object)"John", (Object)this.getFromMap(component, "foo", "0").get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromMap(component, "foo", "1").get("name").asString());
        component.removeFromParent();
        signal.set(this.createPersonMap(this.createJack(), this.createJohn()));
        Assertions.assertEquals((Object)"John", (Object)this.getFromMap(component, "foo", "0").get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromMap(component, "foo", "1").get("name").asString());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindMapProperty_componentAttached_bindingActive() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal(this.createPersonMap(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertEquals((Object)"John", (Object)this.getFromMap(component, "foo", "0").get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromMap(component, "foo", "1").get("name").asString());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindMapProperty_componentReAttached_bindingSynced() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal(this.createPersonMap(this.createJohn(), this.createJack()));
        component.getElement().bindProperty("foo", (Signal)signal, null);
        Assertions.assertEquals((Object)"John", (Object)this.getFromMap(component, "foo", "0").get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromMap(component, "foo", "1").get("name").asString());
        component.removeFromParent();
        signal.set(this.createPersonMap(this.createJack(), this.createJohn()));
        Assertions.assertEquals((Object)"Jack", (Object)((JacksonUtilsTest.Person)((Map)signal.peek()).get("0")).name());
        Assertions.assertEquals((Object)"John", (Object)((JacksonUtilsTest.Person)((Map)signal.peek()).get("1")).name());
        Assertions.assertEquals((Object)"John", (Object)this.getFromMap(component, "foo", "0").get("name").asString());
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromMap(component, "foo", "1").get("name").asString());
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertEquals((Object)"Jack", (Object)this.getFromMap(component, "foo", "0").get("name").asString());
        Assertions.assertEquals((Object)"John", (Object)this.getFromMap(component, "foo", "1").get("name").asString());
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    @Test
    public void bindProperty_writeCallbackThrows() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.getElement().bindProperty("prop", (Signal)signal, (SerializableConsumer & Serializable)value -> {
            throw new RuntimeException("test");
        });
        Assertions.assertEquals((Object)"foo", (Object)component.getElement().getProperty("prop"));
        component.getElement().addPropertyChangeListener("prop", "change", (PropertyChangeListener & Serializable)event -> Assertions.fail((String)"Property change listener should not be triggered when write callback throws"));
        Assertions.assertThrows(RuntimeException.class, () -> this.emulateClientUpdate(component.getElement(), "prop", "bar"));
    }

    @Test
    public void bindProperty_normalCallback_valueChangeEventTriggered() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.getElement().bindProperty("prop", (Signal)signal, arg_0 -> ((ValueSignal)signal).set(arg_0));
        AtomicReference eventValue = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(0);
        component.getElement().addPropertyChangeListener("prop", "change", (PropertyChangeListener & Serializable)event -> {
            eventValue.set(event.getValue());
            counter.incrementAndGet();
        });
        this.emulateClientUpdate(component.getElement(), "prop", "bar");
        Assertions.assertEquals((Object)"bar", eventValue.get());
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void bindProperty_transformingCallback_valueChangeEventTriggered() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.getElement().bindProperty("prop", (Signal)signal, (SerializableConsumer & Serializable)v -> signal.set((Object)v.toUpperCase()));
        AtomicReference eventValue = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(0);
        component.getElement().addPropertyChangeListener("prop", "change", (PropertyChangeListener & Serializable)event -> {
            eventValue.set(event.getValue());
            counter.incrementAndGet();
        });
        this.emulateClientUpdate(component.getElement(), "prop", "bar");
        Assertions.assertEquals((Object)"BAR", eventValue.get());
        Assertions.assertEquals((int)1, (int)counter.get());
    }

    @Test
    public void bindProperty_noOpCallback_valueChangeEventNotTriggered() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        component.getElement().bindProperty("prop", (Signal)signal, (SerializableConsumer & Serializable)value -> {});
        component.getElement().addPropertyChangeListener("prop", "change", (PropertyChangeListener & Serializable)event -> Assertions.fail((String)"Property change listener should not be triggered with a no-op callback"));
        this.emulateClientUpdate(component.getElement(), "prop", "bar");
    }

    private void emulateClientUpdate(Element element, String property, String value) {
        ElementPropertyMap childModel = ElementPropertyMap.getModel((StateNode)element.getNode());
        try {
            childModel.deferredUpdateFromClient(property, (Serializable)((Object)value));
        }
        catch (PropertyChangeDeniedException e) {
            Assertions.fail((String)("Failed to update property from client: " + e.getMessage()));
        }
    }

    private void assertPersonEquals(JacksonUtilsTest.Person person, JsonNode jsonNode) {
        Assertions.assertEquals((Object)person.name(), (Object)jsonNode.get("name").asString());
        Assertions.assertEquals((double)person.age(), (double)jsonNode.get("age").asDouble(), (double)0.0);
        Assertions.assertEquals((Object)person.canSwim(), (Object)jsonNode.get("canSwim").asBoolean());
    }

    private JacksonUtilsTest.Person createPerson(String name, double age, boolean canSwim) {
        return new JacksonUtilsTest.Person(name, age, canSwim);
    }

    private JacksonUtilsTest.Person createJohn() {
        return this.createPerson("John", 42.0, true);
    }

    private JacksonUtilsTest.Person createJack() {
        return this.createPerson("Jack", 52.0, false);
    }

    private Map<String, JacksonUtilsTest.Person> createPersonMap(JacksonUtilsTest.Person ... persons) {
        HashMap<String, JacksonUtilsTest.Person> map = new HashMap<String, JacksonUtilsTest.Person>();
        for (int i = 0; i < persons.length; ++i) {
            map.put(String.valueOf(i), persons[i]);
        }
        return map;
    }

    private ObjectNode getFromList(Component component, String propertyName, int index) {
        ArrayNode arrayNode = (ArrayNode)component.getElement().getPropertyRaw(propertyName);
        return (ObjectNode)arrayNode.get(index);
    }

    private ObjectNode getFromMap(Component component, String propertyName, String key) {
        ObjectNode objectNode = (ObjectNode)component.getElement().getPropertyRaw(propertyName);
        return (ObjectNode)objectNode.get(key);
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }
}

