/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractNodeTest {
    @Test
    public void insertWithNullParameter() {
        Node parent = this.createParentNode();
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.insertChild(0, (Element[])null));
    }

    @Test
    public void insertNullChild() {
        Node parent = this.createParentNode();
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.insertChild(0, new Element[]{null}));
    }

    @Test
    public void appendChildren() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1, child2});
        this.assertChildren(parent, child1, child2);
    }

    protected void assertChildren(Node<?> parent, Element ... children) {
        Assertions.assertEquals((int)children.length, (int)parent.getChildCount());
        for (int i = 0; i < children.length; ++i) {
            this.assertChild(parent, i, children[i]);
        }
    }

    protected void assertChild(Node<?> parent, int index, Element child) {
        Assertions.assertEquals((Object)child, (Object)parent.getChild(index));
    }

    @Test
    public void insertChildFirst() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1});
        parent.insertChild(0, new Element[]{child2});
        this.assertChildren(parent, child2, child1);
    }

    @Test
    public void insertChildMiddle() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2});
        parent.insertChild(1, new Element[]{child3});
        this.assertChildren(parent, child1, child3, child2);
    }

    @Test
    public void insertChildAsLast() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2});
        parent.insertChild(2, new Element[]{child3});
        this.assertChildren(parent, child1, child2, child3);
    }

    @Test
    public void insertChildAfterLast() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.insertChild(3, new Element[]{child3}));
    }

    @Test
    public void removeChildFirst() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2, child3});
        parent.removeChild(new Element[]{child1});
        this.assertChildren(parent, child2, child3);
    }

    @Test
    public void removeChildFirstIndex() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2, child3});
        parent.removeChild(0);
        this.assertChildren(parent, child2, child3);
    }

    @Test
    public void removeChildrenFirst() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2, child3});
        parent.removeChild(new Element[]{child1, child2});
        this.assertChildren(parent, child3);
    }

    @Test
    public void removeChildMiddle() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2, child3});
        parent.removeChild(new Element[]{child2});
        this.assertChildren(parent, child1, child3);
    }

    @Test
    public void removeChildMiddleIndex() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2, child3});
        parent.removeChild(1);
        this.assertChildren(parent, child1, child3);
    }

    @Test
    public void removeChildrenMiddle() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        Element child4 = new Element("child4");
        parent.appendChild(new Element[]{child1, child2, child3, child4});
        parent.removeChild(new Element[]{child2, child3});
        this.assertChildren(parent, child1, child4);
    }

    @Test
    public void removeChildLast() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2, child3});
        parent.removeChild(new Element[]{child3});
        this.assertChildren(parent, child1, child2);
    }

    @Test
    public void removeChildLastIndex() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        parent.appendChild(new Element[]{child1, child2, child3});
        parent.removeChild(2);
        this.assertChildren(parent, child1, child2);
    }

    @Test
    public void removeChildrenLast() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        Element child4 = new Element("child4");
        parent.appendChild(new Element[]{child1, child2, child3, child4});
        parent.removeChild(new Element[]{child3, child4});
        this.assertChildren(parent, child1, child2);
    }

    @Test
    public void removeAllChildren() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        Element child4 = new Element("child4");
        parent.appendChild(new Element[]{child1, child2, child3, child4});
        parent.removeAllChildren();
        this.assertChildren(parent, new Element[0]);
    }

    @Test
    public void removeAllChildrenEmpty() {
        Node parent = this.createParentNode();
        parent.removeAllChildren();
        this.assertChildren(parent, new Element[0]);
    }

    @Test
    public void testGetChildren() {
        Node parent = this.createParentNode();
        Element child1 = ElementFactory.createDiv();
        Element child2 = ElementFactory.createDiv();
        Element child3 = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child1, child2, child3});
        List children = parent.getChildren().collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(child1, child2, child3), children);
    }

    @Test
    public void testGetChildren_empty() {
        Node parent = this.createParentNode();
        Assertions.assertEquals((long)0L, (long)parent.getChildren().count());
    }

    @Test
    public void removeNonChild() {
        Node parent = this.createParentNode();
        Element otherElement = new Element("other");
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.removeChild(new Element[]{otherElement}));
    }

    @Test
    public void getChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        Element child3 = new Element("child3");
        Element child4 = new Element("child4");
        parent.appendChild(new Element[]{child1, child2, child3, child4});
        Assertions.assertEquals((Object)child1, (Object)parent.getChild(0));
        Assertions.assertEquals((Object)child2, (Object)parent.getChild(1));
        Assertions.assertEquals((Object)child3, (Object)parent.getChild(2));
        Assertions.assertEquals((Object)child4, (Object)parent.getChild(3));
    }

    @Test
    public void getNegativeChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1, child2});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.getChild(-1));
    }

    @Test
    public void getAfterLastChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1, child2});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.getChild(2));
    }

    @Test
    public void appendChild() {
        Node parent = this.createParentNode();
        Element child = new Element("child");
        parent.appendChild(new Element[]{child});
        this.assertChildren(parent, child);
    }

    @Test
    public void appendNullChild() {
        Node parent = this.createParentNode();
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.appendChild((Element[])null));
    }

    @Test
    public void replaceNullChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        parent.appendChild(new Element[]{child1});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.setChild(0, null));
    }

    @Test
    public void removeNullChild() {
        Node parent = this.createParentNode();
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.removeChild((Element[])null));
    }

    @Test
    public void replaceBeforeFirstChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.setChild(-1, child2));
    }

    @Test
    public void setForEmptyParent() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        parent.setChild(0, child1);
        this.assertChildren(parent, child1);
    }

    @Test
    public void replaceAfterLastChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1});
        parent.setChild(1, child2);
        this.assertChildren(parent, child1, child2);
    }

    @Test
    public void replaceAfterAfterLastChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.setChild(2, child2));
    }

    @Test
    public void replaceChildWithItself() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        parent.appendChild(new Element[]{child1});
        parent.getNode().clearChanges();
        parent.setChild(0, child1);
        AtomicInteger changesCausedBySetChild = new AtomicInteger(0);
        ((ElementChildrenList)parent.getNode().getFeature(ElementChildrenList.class)).collectChanges(change -> changesCausedBySetChild.incrementAndGet());
        Assertions.assertEquals((int)0, (int)changesCausedBySetChild.get());
    }

    @Test
    public void removeChildBeforeFirst() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        parent.appendChild(new Element[]{child1});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.removeChild(-1));
    }

    @Test
    public void removeChildAfterLast() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        parent.appendChild(new Element[]{child1});
        Assertions.assertThrows(IllegalArgumentException.class, () -> parent.removeChild(1));
    }

    @Test
    public void appendAttachedChild() {
        Node parent = this.createParentNode();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Element target = ElementFactory.createDiv();
        target.appendChild(new Element[]{child});
        Assertions.assertEquals((Object)child.getParent(), (Object)target);
        this.checkIsNotChild(parent, child);
    }

    @Test
    public void indexOfChild_firstChild() {
        Node parent = this.createParentNode();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Assertions.assertEquals((int)0, (int)parent.indexOfChild(child));
    }

    @Test
    public void indexOfChild_childInTheMiddle() {
        Node parent = this.createParentNode();
        Element child1 = ElementFactory.createDiv();
        Element child2 = ElementFactory.createAnchor();
        Element child3 = ElementFactory.createButton();
        parent.appendChild(new Element[]{child1, child2, child3});
        Assertions.assertEquals((int)1, (int)parent.indexOfChild(child2));
    }

    @Test
    public void indexOfChild_notAChild() {
        Node parent = this.createParentNode();
        Element child = ElementFactory.createDiv();
        Assertions.assertEquals((int)-1, (int)parent.indexOfChild(child));
    }

    @Test
    public void appendFirstChildToOwnParent() {
        Node parent = this.createParentNode();
        Element child1 = ElementFactory.createDiv();
        Element child2 = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child1, child2});
        parent.appendChild(new Element[]{child1});
        this.assertChildren(parent, child2, child1);
    }

    @Test
    public void appendLastChildToOwnParent() {
        Node parent = this.createParentNode();
        Element child1 = ElementFactory.createDiv();
        Element child2 = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child1, child2});
        parent.appendChild(new Element[]{child2});
        this.assertChildren(parent, child1, child2);
    }

    @Test
    public void appendManyChildrenToOwnParent() {
        Node parent = this.createParentNode();
        Element child1 = ElementFactory.createDiv();
        Element child2 = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child1, child2});
        parent.appendChild(new Element[]{child2, child1});
        this.assertChildren(parent, child2, child1);
    }

    @Test
    public void appendExistingAndNewChildren() {
        Node parent = this.createParentNode();
        Element child1 = ElementFactory.createDiv();
        Element child2 = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child1});
        parent.appendChild(new Element[]{child2, child1});
        this.assertChildren(parent, child2, child1);
    }

    @Test
    public void insertAttachedChild() {
        Node parent = this.createParentNode();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Element target = ElementFactory.createDiv();
        target.appendChild(new Element[]{ElementFactory.createAnchor()});
        target.insertChild(0, new Element[]{child});
        Assertions.assertEquals((Object)child.getParent(), (Object)target);
        this.checkIsNotChild(parent, child);
    }

    @Test
    public void setAttachedChild() {
        Node parent = this.createParentNode();
        Element child = ElementFactory.createDiv();
        parent.appendChild(new Element[]{child});
        Element target = ElementFactory.createDiv();
        target.appendChild(new Element[]{ElementFactory.createAnchor()});
        target.setChild(0, child);
        Assertions.assertEquals((Object)child.getParent(), (Object)target);
        this.checkIsNotChild(parent, child);
    }

    @Test
    public void removeFromParent() {
        Node parent = this.createParentNode();
        Element otherElement = new Element("other");
        parent.appendChild(new Element[]{otherElement});
        Assertions.assertEquals((Object)parent, (Object)otherElement.getParentNode());
        otherElement.removeFromParent();
        Assertions.assertNull((Object)otherElement.getParentNode());
    }

    @Test
    public void replaceFirstChild() {
        Node parent = this.createParentNode();
        Element child1 = new Element("child1");
        Element child2 = new Element("child2");
        parent.appendChild(new Element[]{child1});
        parent.setChild(0, child2);
        Assertions.assertNull((Object)child1.getParentNode());
        Assertions.assertEquals((Object)parent, (Object)child2.getParentNode());
    }

    protected void checkIsNotChild(Node<?> parent, Element child) {
        Assertions.assertNotEquals((Object)child.getParentNode(), parent);
        Assertions.assertFalse((boolean)parent.getChildren().anyMatch(el -> el.equals((Object)child)));
    }

    protected void assertMethodsReturnType(Class<? extends Node<?>> clazz, Set<String> ignore) {
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isBridge() || method.getName().startsWith("get") || method.getName().startsWith("has") || method.getName().startsWith("is") || ignore.contains(method.getName())) continue;
            Type returnType = GenericTypeReflector.getExactReturnType((Method)method, clazz);
            Assertions.assertEquals(clazz, (Object)returnType, (String)("Method " + method.getName() + " has invalid return type"));
        }
    }

    protected abstract Node createParentNode();
}

