/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.BrowserWindowResizeEvent;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.WindowSize;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class PageWindowSizeSignalTest {
    PageWindowSizeSignalTest() {
    }

    @Test
    void windowSizeSignal_isReadOnly() {
        Page page = new Page((UI)new MockUI());
        Signal signal = page.windowSizeSignal();
        Assertions.assertFalse((boolean)(signal instanceof ValueSignal), (String)"windowSizeSignal() should return a read-only signal");
    }

    @Test
    void windowSizeSignal_multipleResizes_tracksLatest() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        Signal signal = page.windowSizeSignal();
        Assertions.assertEquals((Object)new WindowSize(0, 0), (Object)signal.peek());
        this.fireResizeEvent(ui, 1024, 768);
        Assertions.assertEquals((Object)new WindowSize(1024, 768), (Object)signal.peek());
        this.fireResizeEvent(ui, 1920, 1080);
        Assertions.assertEquals((Object)new WindowSize(1920, 1080), (Object)signal.peek());
        this.fireResizeEvent(ui, 800, 600);
        Assertions.assertEquals((Object)new WindowSize(800, 600), (Object)signal.peek());
    }

    @Test
    void addBrowserWindowResizeListener_andWindowSizeSignal_shareJsSetup() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        AtomicReference listenerEvent = new AtomicReference();
        page.addBrowserWindowResizeListener(listenerEvent::set);
        Signal signal = page.windowSizeSignal();
        this.fireResizeEvent(ui, 1280, 720);
        Assertions.assertNotNull(listenerEvent.get());
        Assertions.assertEquals((int)1280, (int)((BrowserWindowResizeEvent)listenerEvent.get()).getWidth());
        Assertions.assertEquals((int)720, (int)((BrowserWindowResizeEvent)listenerEvent.get()).getHeight());
        Assertions.assertEquals((Object)new WindowSize(1280, 720), (Object)signal.peek());
    }

    @Test
    void windowSizeSignal_thenAddBrowserWindowResizeListener_shareJsSetup() {
        MockUI ui = new MockUI();
        Page page = new Page((UI)ui);
        Signal signal = page.windowSizeSignal();
        AtomicReference listenerEvent = new AtomicReference();
        page.addBrowserWindowResizeListener(listenerEvent::set);
        this.fireResizeEvent(ui, 1920, 1080);
        Assertions.assertEquals((Object)new WindowSize(1920, 1080), (Object)signal.peek());
        Assertions.assertNotNull(listenerEvent.get());
        Assertions.assertEquals((int)1920, (int)((BrowserWindowResizeEvent)listenerEvent.get()).getWidth());
        Assertions.assertEquals((int)1080, (int)((BrowserWindowResizeEvent)listenerEvent.get()).getHeight());
    }

    private void fireResizeEvent(MockUI ui, int width, int height) {
        ObjectNode eventData = JacksonUtils.createObjectNode();
        eventData.put("event.w", width);
        eventData.put("event.h", height);
        eventData.put("for", "trailing");
        ((ElementListenerMap)ui.getElement().getNode().getFeature(ElementListenerMap.class)).fireEvent(new DomEvent(ui.getElement(), "window-resize", (JsonNode)eventData));
    }
}

