/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.tests.util.SingleCaptureConsumer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

class PendingJavaScriptInvocationTest {
    private static final JsonNode fooJsonString = JacksonUtils.createNode((Object)"foo");
    private PendingJavaScriptInvocation invocation;
    private SingleCaptureConsumer<JsonNode> jsonSuccessConsumer;
    private SingleCaptureConsumer<String> stringSuccessConsumer;
    private SingleCaptureConsumer<String> errorConsumer;
    private BiConsumer<JsonNode, Throwable> jsonFutureHandler;
    private BiConsumer<String, Throwable> stringFutureHandler;

    PendingJavaScriptInvocationTest() {
    }

    @BeforeEach
    public void setUp() {
        this.invocation = new PendingJavaScriptInvocation(new Element("dummy").getNode(), new UIInternals.JavaScriptInvocation("", new Object[0]));
        this.jsonSuccessConsumer = new SingleCaptureConsumer();
        this.stringSuccessConsumer = new SingleCaptureConsumer();
        this.errorConsumer = new SingleCaptureConsumer();
        this.jsonFutureHandler = PendingJavaScriptInvocationTest.futureHandler(this.jsonSuccessConsumer, this.errorConsumer);
        this.stringFutureHandler = PendingJavaScriptInvocationTest.futureHandler(this.stringSuccessConsumer, this.errorConsumer);
    }

    private static <T> BiConsumer<T, Throwable> futureHandler(Consumer<T> successConsumer, Consumer<String> errorConsumer) {
        return (successValue, error) -> {
            if (error != null) {
                Assertions.assertEquals(PendingJavaScriptResult.JavaScriptException.class, error.getClass());
                errorConsumer.accept(error.getMessage());
            } else {
                successConsumer.accept(successValue);
            }
        };
    }

    @Test
    public void untypedIgnoreErrors_success() {
        this.invocation.then(this.jsonSuccessConsumer);
        this.invocation.complete(fooJsonString);
        this.assertJsonSuccess();
    }

    @Test
    public void untypedIgnoreErrors_fail() {
        this.invocation.then(this.jsonSuccessConsumer);
        this.invocation.completeExceptionally(fooJsonString);
        this.assertNoUpdate();
    }

    @Test
    public void untypedCaptureErrors_success() {
        this.invocation.then(this.jsonSuccessConsumer, this.errorConsumer);
        this.invocation.complete(fooJsonString);
        this.assertJsonSuccess();
    }

    @Test
    public void untypedCaptureErrors_fail() {
        this.invocation.then(this.jsonSuccessConsumer, this.errorConsumer);
        this.invocation.completeExceptionally(fooJsonString);
        this.assertFail();
    }

    @Test
    public void untypedFuture_success() {
        this.invocation.toCompletableFuture().whenComplete(this.jsonFutureHandler);
        this.invocation.complete(fooJsonString);
        this.assertJsonSuccess();
    }

    @Test
    public void untypedFuture_fail() {
        this.invocation.toCompletableFuture().whenComplete(this.jsonFutureHandler);
        this.invocation.completeExceptionally(fooJsonString);
        this.assertFail();
    }

    @Test
    public void typedIgnoreErrors_success() {
        this.invocation.then(String.class, this.stringSuccessConsumer);
        this.invocation.complete(fooJsonString);
        this.assertStringSuccess();
    }

    @Test
    public void typedCaptureErrors_fail() {
        this.invocation.then(String.class, this.stringSuccessConsumer);
        this.invocation.completeExceptionally(fooJsonString);
        this.assertNoUpdate();
    }

    @Test
    public void typedCaptureErrors_success() {
        this.invocation.then(String.class, this.stringSuccessConsumer, this.errorConsumer);
        this.invocation.complete(fooJsonString);
        this.assertStringSuccess();
    }

    @Test
    public void typedIgnoreErrors_fail() {
        this.invocation.then(String.class, this.stringSuccessConsumer, this.errorConsumer);
        this.invocation.completeExceptionally(fooJsonString);
        this.assertFail();
    }

    @Test
    public void typedFuture_success() {
        this.invocation.toCompletableFuture(String.class).whenComplete(this.stringFutureHandler);
        this.invocation.complete(fooJsonString);
        this.assertStringSuccess();
    }

    @Test
    public void typedFuture_fail() {
        this.invocation.toCompletableFuture(String.class).whenComplete(this.stringFutureHandler);
        this.invocation.completeExceptionally(fooJsonString);
        this.assertFail();
    }

    @Test
    public void multipleSuccessHandlers() {
        this.invocation.then(this.jsonSuccessConsumer, this.errorConsumer);
        this.invocation.then(String.class, this.stringSuccessConsumer);
        this.invocation.complete(fooJsonString);
        Assertions.assertSame((Object)fooJsonString, (Object)this.jsonSuccessConsumer.getCapturedValue());
        Assertions.assertEquals((Object)"foo", (Object)this.stringSuccessConsumer.getCapturedValue());
        this.assertNoErrorValue();
    }

    @Test
    public void multipleErrorHandlers() {
        SingleCaptureConsumer extraErrorHandler = new SingleCaptureConsumer();
        this.invocation.then(this.jsonSuccessConsumer, this.errorConsumer);
        this.invocation.then(String.class, this.stringSuccessConsumer, extraErrorHandler);
        this.invocation.completeExceptionally(fooJsonString);
        this.assertNoStringSuccessValue();
        this.assertNoJsonSuccessValue();
        Assertions.assertSame((Object)"foo", (Object)this.errorConsumer.getCapturedValue());
        Assertions.assertSame((Object)"foo", extraErrorHandler.getCapturedValue());
    }

    @Test
    public void thenAfterSend_throws() {
        this.invocation.setSentToBrowser();
        Assertions.assertThrows(IllegalStateException.class, () -> this.invocation.then(this.jsonSuccessConsumer));
    }

    @Test
    public void subscribeAfterCancel_callFailHandler() {
        this.invocation.cancelExecution();
        this.invocation.then(this.jsonSuccessConsumer, this.errorConsumer);
        this.assertFail("Execution canceled");
    }

    @Test
    public void susbscribeBeforeCancel_callFailHandler() {
        this.invocation.then(this.jsonSuccessConsumer, this.errorConsumer);
        this.invocation.cancelExecution();
        this.assertFail("Execution canceled");
    }

    @Test
    public void blockFromInvokingThread_throws() throws Exception {
        MockVaadinSession session = new MockVaadinSession();
        session.runWithLock(() -> {
            CompletableFuture completableFuture = this.invocation.toCompletableFuture();
            for (Callable action : this.createBlockingActions(completableFuture)) {
                try {
                    action.call();
                    Assertions.fail((String)"Blocking on a pending invocation while holding the session lock should throw");
                }
                catch (IllegalStateException illegalStateException) {}
            }
            return null;
        });
    }

    @Test
    public void blockFromSessionThreadAfterCompleting_doesNotThrow() throws Exception {
        MockVaadinSession session = new MockVaadinSession();
        session.runWithLock(() -> {
            CompletableFuture completableFuture = this.invocation.toCompletableFuture();
            ObjectNode value = JacksonUtils.createObjectNode();
            this.invocation.complete((JsonNode)value);
            for (Callable action : this.createBlockingActions(completableFuture)) {
                JsonNode actionValue = (JsonNode)action.call();
                Assertions.assertSame((Object)value, (Object)actionValue);
            }
            return null;
        });
    }

    @Test
    public void blockFromSessionThreadAfterFailing_doesNotThrow() throws Exception {
        MockVaadinSession session = new MockVaadinSession();
        session.runWithLock(() -> {
            CompletableFuture completableFuture = this.invocation.toCompletableFuture();
            String errorMessage = "error message";
            this.invocation.completeExceptionally(JacksonUtils.createNode((Object)errorMessage));
            for (Callable action : this.createBlockingActions(completableFuture)) {
                try {
                    action.call();
                    Assertions.fail((String)"Execution should have failed");
                }
                catch (CompletionException | ExecutionException e) {
                    PendingJavaScriptResult.JavaScriptException cause = (PendingJavaScriptResult.JavaScriptException)e.getCause();
                    Assertions.assertEquals((Object)errorMessage, (Object)cause.getMessage());
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockFromOtherThread_doesNotThrow() throws Exception {
        MockVaadinSession session = new MockVaadinSession();
        VaadinSession.setCurrent((VaadinSession)session);
        ExecutorService executor = Executors.newFixedThreadPool(3);
        session.lock();
        try {
            CompletableFuture completableFuture = this.invocation.toCompletableFuture();
            List<Future> futures = this.createBlockingActions(completableFuture).stream().map(executor::submit).collect(Collectors.toList());
            Assertions.assertEquals((long)0L, (long)futures.stream().filter(Future::isDone).count(), (String)"All futures should be pending");
            ObjectNode value = JacksonUtils.createObjectNode();
            this.invocation.complete((JsonNode)value);
            executor.shutdown();
            executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
            Assertions.assertEquals((long)futures.size(), (long)futures.stream().filter(Future::isDone).count(), (String)"All futures should be done");
            futures.forEach(arg_0 -> PendingJavaScriptInvocationTest.lambda$blockFromOtherThread_doesNotThrow$5((JsonNode)value, arg_0));
        }
        finally {
            session.unlock();
            executor.shutdown();
        }
    }

    private <T> List<Callable<T>> createBlockingActions(CompletableFuture<T> completableFuture) {
        Callable[] callableArray = new Callable[3];
        callableArray[0] = completableFuture::get;
        callableArray[1] = () -> completableFuture.get(1L, TimeUnit.HOURS);
        callableArray[2] = completableFuture::join;
        return Arrays.asList(callableArray);
    }

    private void assertStringSuccess() {
        this.assertNoJsonSuccessValue();
        Assertions.assertEquals((Object)"foo", (Object)this.stringSuccessConsumer.getCapturedValue());
        this.assertNoErrorValue();
    }

    private void assertJsonSuccess() {
        Assertions.assertSame((Object)fooJsonString, (Object)this.jsonSuccessConsumer.getCapturedValue());
        this.assertNoStringSuccessValue();
        this.assertNoErrorValue();
    }

    private void assertFail() {
        this.assertFail("foo");
    }

    private void assertFail(String expectedMessage) {
        this.assertNoJsonSuccessValue();
        this.assertNoStringSuccessValue();
        Assertions.assertSame((Object)expectedMessage, (Object)this.errorConsumer.getCapturedValue());
    }

    private void assertNoUpdate() {
        this.assertNoStringSuccessValue();
        this.assertNoJsonSuccessValue();
        this.assertNoErrorValue();
    }

    private void assertNoJsonSuccessValue() {
        Assertions.assertFalse((boolean)this.jsonSuccessConsumer.isCaptured(), (String)"Json success consumer should not be invoked");
    }

    private void assertNoStringSuccessValue() {
        Assertions.assertFalse((boolean)this.stringSuccessConsumer.isCaptured(), (String)"String success consumer should not be invoked");
    }

    private void assertNoErrorValue() {
        Assertions.assertFalse((boolean)this.errorConsumer.isCaptured(), (String)"Error consumer should not be invoked");
    }

    private static /* synthetic */ void lambda$blockFromOtherThread_doesNotThrow$5(JsonNode value, Future future) {
        try {
            JsonNode futureValue = (JsonNode)future.get();
            Assertions.assertSame((Object)value, (Object)futureValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

