/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.local.ValueSignal;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UILocaleSignalTest
extends SignalsUnitTest {
    UILocaleSignalTest() {
    }

    @Test
    public void localeSignal_initialValue_matchesGetLocale() {
        UI ui = UI.getCurrent();
        ValueSignal signal = ui.localeSignal();
        Assertions.assertNotNull((Object)signal, (String)"localeSignal() should never return null");
        Assertions.assertEquals((Object)ui.getLocale(), (Object)signal.peek(), (String)"Signal value should match getLocale()");
    }

    @Test
    public void localeSignal_setLocale_signalUpdated() {
        Locale newLocale;
        UI ui = UI.getCurrent();
        ValueSignal signal = ui.localeSignal();
        Locale initialLocale = ui.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        ui.setLocale(newLocale);
        Assertions.assertEquals((Object)newLocale, (Object)signal.peek(), (String)"Signal should reflect the new locale after setLocale()");
        Assertions.assertEquals((Object)newLocale, (Object)ui.getLocale(), (String)"getLocale() should also return the new locale");
    }

    @Test
    public void localeSignal_writeToSignal_updatesGetLocale() {
        Locale newLocale;
        UI ui = UI.getCurrent();
        ValueSignal signal = ui.localeSignal();
        Locale initialLocale = ui.getLocale();
        if (initialLocale.equals(newLocale = Locale.FRENCH)) {
            newLocale = Locale.GERMAN;
        }
        signal.set((Object)newLocale);
        Assertions.assertEquals((Object)newLocale, (Object)ui.getLocale(), (String)"getLocale() should reflect the new locale after writing to signal");
        Assertions.assertEquals((Object)newLocale, (Object)signal.peek(), (String)"Signal should have the new value");
    }

    @Test
    public void localeSignal_sameInstance_returnedOnMultipleCalls() {
        UI ui = UI.getCurrent();
        ValueSignal signal1 = ui.localeSignal();
        ValueSignal signal2 = ui.localeSignal();
        Assertions.assertSame((Object)signal1, (Object)signal2, (String)"localeSignal() should return the same instance on multiple calls");
    }

    @Test
    public void localeSignal_multipleLocaleChanges_signalFollows() {
        UI ui = UI.getCurrent();
        ValueSignal signal = ui.localeSignal();
        ui.setLocale(Locale.FRENCH);
        Assertions.assertEquals((Object)Locale.FRENCH, (Object)signal.peek());
        ui.setLocale(Locale.GERMAN);
        Assertions.assertEquals((Object)Locale.GERMAN, (Object)signal.peek());
        ui.setLocale(Locale.JAPANESE);
        Assertions.assertEquals((Object)Locale.JAPANESE, (Object)signal.peek());
    }

    @Test
    public void localeSignal_multipleSignalWrites_getLocaleFollows() {
        UI ui = UI.getCurrent();
        ValueSignal signal = ui.localeSignal();
        signal.set((Object)Locale.FRENCH);
        Assertions.assertEquals((Object)Locale.FRENCH, (Object)ui.getLocale());
        signal.set((Object)Locale.GERMAN);
        Assertions.assertEquals((Object)Locale.GERMAN, (Object)ui.getLocale());
        signal.set((Object)Locale.JAPANESE);
        Assertions.assertEquals((Object)Locale.JAPANESE, (Object)ui.getLocale());
    }
}

