/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.local.ValueSignal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HasStyleSignalTest
extends SignalsUnitTest {
    @Test
    public void bindClassName_signalBound_classNameToggledWhenAttached() {
        HasStyleComponent component = new HasStyleComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindClassName("active", (Signal)signal);
        Assertions.assertFalse((boolean)component.hasClassName("active"));
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.hasClassName("active"));
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.hasClassName("active"));
    }

    @Test
    public void bindClassName_signalTrue_classNameAdded() {
        HasStyleComponent component = new HasStyleComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindClassName("highlight", (Signal)signal);
        Assertions.assertTrue((boolean)component.hasClassName("highlight"));
    }

    @Test
    public void bindClassName_attachedThenDetached_stopsUpdates() {
        HasStyleComponent component = new HasStyleComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindClassName("active", (Signal)signal);
        Assertions.assertTrue((boolean)component.hasClassName("active"));
        UI.getCurrent().remove(new Component[]{component});
        signal.set((Object)false);
        Assertions.assertTrue((boolean)component.hasClassName("active"));
    }

    @Test
    public void bindClassName_multipleClassNames_independentBindings() {
        HasStyleComponent component = new HasStyleComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal1 = new ValueSignal((Object)true);
        ValueSignal signal2 = new ValueSignal((Object)false);
        component.bindClassName("class1", (Signal)signal1);
        component.bindClassName("class2", (Signal)signal2);
        Assertions.assertTrue((boolean)component.hasClassName("class1"));
        Assertions.assertFalse((boolean)component.hasClassName("class2"));
        signal2.set((Object)true);
        Assertions.assertTrue((boolean)component.hasClassName("class1"));
        Assertions.assertTrue((boolean)component.hasClassName("class2"));
        signal1.set((Object)false);
        Assertions.assertFalse((boolean)component.hasClassName("class1"));
        Assertions.assertTrue((boolean)component.hasClassName("class2"));
    }

    @Test
    public void bindClassName_addClassNameWhileBound_throwsException() {
        HasStyleComponent component = new HasStyleComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindClassName("active", (Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> component.addClassName("active"));
    }

    @Test
    public void bindClassName_bindAgainWhileBound_throwsException() {
        HasStyleComponent component = new HasStyleComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindClassName("active", (Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> component.bindClassName("active", (Signal)new ValueSignal((Object)false)));
    }

    @Tag(value="div")
    public static class HasStyleComponent
    extends Component
    implements HasStyle {
    }
}

