/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.internal.FrontendVersion;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Platform {
    private final String nodeDownloadRoot;
    private final OS os;
    private final Architecture architecture;
    private final String classifier;
    private static final int NODE_VERSION_THRESHOLD_MAC_ARM64 = 16;
    public static final String ALPINE_RELEASE_FILE_PATH = "/etc/alpine-release";

    public Platform(OS os, Architecture architecture) {
        this("https://nodejs.org/dist/", os, architecture, null);
    }

    public Platform(String nodeDownloadRoot, OS os, Architecture architecture, String classifier) {
        this.nodeDownloadRoot = nodeDownloadRoot;
        this.os = os;
        this.architecture = architecture;
        this.classifier = classifier;
    }

    public static Platform guess() {
        OS os = OS.guess();
        Architecture architecture = Architecture.guess();
        Path alpineReleaseFilePath = Paths.get(ALPINE_RELEASE_FILE_PATH, new String[0]);
        if (os == OS.LINUX && Files.exists(alpineReleaseFilePath, new LinkOption[0])) {
            return new Platform("https://unofficial-builds.nodejs.org/download/release/", os, architecture, "musl");
        }
        return new Platform(os, architecture);
    }

    public String getArchiveExtension() {
        return this.os.getArchiveExtension();
    }

    public String getCodename() {
        return this.os.getCodename();
    }

    public boolean isWindows() {
        return this.os == OS.WINDOWS;
    }

    public boolean isMac() {
        return this.os == OS.MAC;
    }

    public boolean isLinux() {
        return this.os == OS.LINUX;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public OS getOs() {
        return this.os;
    }

    public String getNodeClassifier(FrontendVersion nodeVersion) {
        String result = this.getCodename() + "-" + this.resolveArchitecture(nodeVersion).getName();
        return this.classifier != null ? result + "-" + this.classifier : result;
    }

    public String getNodeDownloadRoot() {
        return this.nodeDownloadRoot;
    }

    private Architecture resolveArchitecture(FrontendVersion nodeVersion) {
        Integer nodeMajorVersion;
        if (this.isMac() && this.architecture == Architecture.ARM64 && ((nodeMajorVersion = Integer.valueOf(nodeVersion.getMajorVersion())) == null || nodeMajorVersion < 16)) {
            return Architecture.X64;
        }
        return this.architecture;
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        SUN_OS;


        public static OS guess() {
            String osName = System.getProperty("os.name");
            return osName.contains("Windows") ? WINDOWS : (osName.contains("Mac") ? MAC : (osName.contains("SunOS") ? SUN_OS : LINUX));
        }

        public String getArchiveExtension() {
            if (this == WINDOWS) {
                return "zip";
            }
            return "tar.gz";
        }

        public String getCodename() {
            if (this == MAC) {
                return "darwin";
            }
            if (this == WINDOWS) {
                return "win";
            }
            if (this == SUN_OS) {
                return "sunos";
            }
            return "linux";
        }
    }

    static enum Architecture {
        X86,
        X64,
        PPC64LE,
        S390X,
        ARM64,
        ARMV7L;


        public static Architecture guess() {
            String arch = System.getProperty("os.arch");
            String version = System.getProperty("os.version");
            if ("ppc64le".equals(arch)) {
                return PPC64LE;
            }
            if ("aarch64".equals(arch)) {
                return ARM64;
            }
            if ("s390x".equals(arch)) {
                return S390X;
            }
            if ("arm".equals(arch) && version.contains("v7")) {
                return ARMV7L;
            }
            return arch.contains("64") ? X64 : X86;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

