/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.Template;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public class TaskCopyTemplateFiles
implements FallibleCommand {
    private final ClassFinder classFinder;
    private final Options options;

    TaskCopyTemplateFiles(ClassFinder classFinder, Options options) {
        this.classFinder = classFinder;
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        Class jsModuleAnnotationClass;
        HashSet<Class<Template>> classes = new HashSet<Class<Template>>(this.classFinder.getSubTypesOf(Template.class));
        try {
            jsModuleAnnotationClass = this.classFinder.loadClass(JsModule.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new ExecutionFailedException(e);
        }
        for (Class clazz : classes) {
            for (Annotation jsmAnnotation : clazz.getAnnotationsByType(jsModuleAnnotationClass)) {
                String path = this.getJsModuleAnnotationValue(jsmAnnotation);
                File source = FrontendUtils.resolveFrontendPath(this.options.getNpmFolder(), path, this.options.getFrontendDirectory());
                if (source == null) {
                    throw new ExecutionFailedException("Unable to locate file " + path);
                }
                File templateDirectory = this.options.isDevBundleBuild() ? new File(DevBundleUtils.getDevBundleFolder(this.options.getNpmFolder(), this.options.getBuildDirectoryName()), "config/templates/") : new File(this.options.getResourceOutputDirectory(), "config/templates/");
                Path targetFile = templateDirectory.toPath().resolve(path);
                try {
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    Files.copy(source.toPath(), targetFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new ExecutionFailedException(e);
                }
            }
        }
    }

    private String getJsModuleAnnotationValue(Annotation jsmAnnotation) throws ExecutionFailedException {
        try {
            Object value = jsmAnnotation.getClass().getDeclaredMethod("value", new Class[0]).invoke((Object)jsmAnnotation, new Object[0]);
            return (String)value;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExecutionFailedException(e);
        }
    }
}

