/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCleanFrontendFiles
implements FallibleCommand {
    public static final String NODE_MODULES = "node_modules";
    private File projectRoot;
    private List<String> generatedFiles = List.of("node_modules", "package.json", "package-lock.json", "pnpm-lock.yaml", "bun.lockb", "bun.lock", "tsconfig.json", "types.d.ts", ".pnpmfile.cjs", ".npmrc", "vite.generated.ts", "vite.config.ts");
    private Set<File> existingFiles = new HashSet<File>();
    private List<String> hillaGenerated = List.of("file-routes.ts", "file-routes.json");

    public TaskCleanFrontendFiles(Options options) {
        this.projectRoot = options.getNpmFolder();
        Arrays.stream(this.projectRoot.listFiles(file -> this.generatedFiles.contains(file.getName()))).forEach(this.existingFiles::add);
        boolean hillaUsed = FrontendBuildUtils.isHillaUsed(options.getFrontendDirectory(), options.getClassFinder());
        if (this.existingFiles.contains(new File(this.projectRoot, "package.json")) || hillaUsed) {
            this.existingFiles.add(new File(this.projectRoot, NODE_MODULES));
        }
        if (!hillaUsed) {
            this.hillaGenerated.forEach(file -> new File(options.getFrontendGeneratedFolder(), (String)file).delete());
        }
    }

    @Override
    public void execute() throws ExecutionFailedException {
        List filesToRemove = Arrays.stream(this.projectRoot.listFiles(file -> this.generatedFiles.contains(file.getName()) && !this.existingFiles.contains(file))).collect(Collectors.toList());
        for (File file2 : filesToRemove) {
            this.log().debug("Removing file {}", (Object)file2);
            try {
                if (file2.isDirectory()) {
                    FrontendUtils.deleteDirectory(file2);
                    continue;
                }
                file2.delete();
            }
            catch (IOException ioe) {
                this.log().warn("Could not delete file {} due to {}", (Object)file2, (Object)ioe.getMessage());
                this.log().debug("Failed to remove file", (Throwable)ioe);
            }
        }
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

