/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.DepsTests;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.ScannerDependenciesTest;
import com.vaadin.flow.server.frontend.scanner.ScannerTestComponents;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ScannerThemeTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void should_takeThemeFromTheView() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RootViewWithTheme.class);
        Assert.assertEquals(ScannerTestComponents.Theme4.class, (Object)deps.getThemeDefinition().getTheme());
        DepsTests.assertImportsExcludingUI(deps.getModules(), "./theme-4.js");
        Assert.assertEquals((long)0L, (long)deps.getPackages().size());
        DepsTests.assertImports(deps.getScripts(), "frontend://theme-0.js");
    }

    @Test
    public void should_takeThemeFromLayout() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RootViewWithLayoutTheme.class);
        Assert.assertEquals(ScannerTestComponents.Theme1.class, (Object)deps.getThemeDefinition().getTheme());
        Assert.assertEquals((Object)"dark", (Object)deps.getThemeDefinition().getVariant());
        DepsTests.assertImportCount(6, deps.getModules());
        Assert.assertEquals((long)1L, (long)deps.getPackages().size());
        DepsTests.assertImportCount(5, deps.getScripts());
        Assert.assertTrue((boolean)deps.getPackages().containsKey("@foo/first-view"));
        Assert.assertEquals((Object)"0.0.1", deps.getPackages().get("@foo/first-view"));
    }

    @Test
    public void should_takeTheme_when_AnyRouteValue() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.SecondView.class);
        Assert.assertEquals(ScannerTestComponents.Theme1.class, (Object)deps.getThemeDefinition().getTheme());
        DepsTests.assertImportCount(5, deps.getModules());
        Assert.assertEquals((long)0L, (long)deps.getPackages().size());
        DepsTests.assertImportCount(2, deps.getScripts());
    }

    @Test
    public void should_throw_when_MultipleThemes() {
        this.exception.expect(IllegalStateException.class);
        ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RootViewWithMultipleTheme.class, ScannerTestComponents.FirstView.class);
    }

    @Test
    public void should_throw_when_ThemeAndNoTheme() {
        this.exception.expect(IllegalStateException.class);
        ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.FirstView.class, ScannerTestComponents.RootViewWithoutTheme.class);
    }

    @Test
    public void should_notFindAnyTheme_when_noThemeAnnotationIsGiven() {
        ClassFinder.DefaultClassFinder finder = (ClassFinder.DefaultClassFinder)Mockito.spy((Object)new ClassFinder.DefaultClassFinder(Collections.singleton(ScannerTestComponents.RootViewWithoutThemeAnnotation.class)));
        FrontendDependencies deps = new FrontendDependencies((ClassFinder)finder, true, null, true);
        Assert.assertNull((String)"No default theme should have been selected", (Object)deps.getThemeDefinition());
    }

    @Test
    public void should_takeThemeFromExporter_when_exporterFound() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.ThemeExporter.class);
        Assert.assertEquals(ScannerTestComponents.Theme2.class, (Object)deps.getThemeDefinition().getTheme());
    }

    @Test
    public void should_useExtendedClassTheme_when_noThemeDefinedByExporter() throws Exception {
        ClassFinder.DefaultClassFinder finder = (ClassFinder.DefaultClassFinder)Mockito.spy((Object)new ClassFinder.DefaultClassFinder(new HashSet<Class>(Arrays.asList(ScannerTestComponents.NoThemeExporter.class, ScannerTestComponents.RootViewWithTheme.class))));
        FrontendDependencies deps = new FrontendDependencies((ClassFinder)finder, true, null, true);
        Assert.assertEquals((String)"Theme4 should have been returned as theme", ScannerTestComponents.Theme4.class, (Object)deps.getThemeDefinition().getTheme());
        DepsTests.assertImportsExcludingUI(deps.getModules(), "./theme-4.js");
    }

    @Test
    public void should_notAttemptToOverrideTheme_when_noExportersFound() throws ClassNotFoundException {
        ClassFinder.DefaultClassFinder finder = (ClassFinder.DefaultClassFinder)Mockito.spy((Object)new ClassFinder.DefaultClassFinder(Collections.singleton(ScannerTestComponents.RootViewWithTheme.class)));
        new FrontendDependencies((ClassFinder)finder, true, null, true);
        ((ClassFinder.DefaultClassFinder)Mockito.verify((Object)finder, (VerificationMode)Mockito.times((int)0))).loadClass("com.vaadin.flow.theme.lumo.Lumo");
    }

    @Test
    public void should_takeThemeFromLayout_ifLayoutAlreadyVisited() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RootViewWithLayoutTheme.class, ScannerTestComponents.RootView2WithLayoutTheme.class);
        Assert.assertEquals(ScannerTestComponents.Theme1.class, (Object)deps.getThemeDefinition().getTheme());
    }
}

