/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.ClassInfo;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.DepsTests;
import com.vaadin.flow.server.frontend.scanner.FrontendClassVisitor;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.ScannerTestComponents;
import com.vaadin.flow.server.frontend.scanner.samples.RouteInterfaceComponent;
import com.vaadin.flow.theme.NoTheme;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class ScannerDependenciesTest {
    static FrontendDependencies getFrontendDependencies(Class<?> ... classes) {
        FrontendDependencies frontendDependencies = new FrontendDependencies((ClassFinder)new ClassFinder.DefaultClassFinder(new HashSet(new ArrayList(Arrays.asList(classes)))){

            public boolean shouldInspectClass(String className) {
                return className.startsWith("com.vaadin");
            }
        }, true, null, true);
        return frontendDependencies;
    }

    @Test
    public void visitRouteEntryPoint_ExpectToAlsoVisitImplementedInterface() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(RouteInterfaceComponent.class);
        Assert.assertTrue((String)"Missing dependency from implemented interface", (boolean)DepsTests.merge(deps.getModules()).contains("myModule.js"));
        DepsTests.assertImportCount(1, deps.getCss());
        Assert.assertEquals((String)"Invalid css import", (Object)"frontend://styles/interface.css", (Object)((CssData)DepsTests.merge(deps.getCss()).get(0)).getValue());
    }

    @Test
    public void should_extractClassesFromSignatures() {
        HashSet classes = new HashSet();
        FrontendClassVisitor visitor = new FrontendClassVisitor(new ClassInfo("foo"));
        visitor.addSignatureToClasses(classes, "(Lcom/vaadin/flow/component/tabs/Tabs;Ljava/lang/String;Ljava/lang/Character;CLjava/lang/Integer;ILjava/lang/Long;JLjava/lang/Double;DLjava/lang/Float;FLjava/lang/Byte;BLjava/lang/Boolean;Z)Lcom/vaadin/flow/component/button/Button;");
        Assert.assertArrayEquals((Object[])new String[]{"java.lang.Float", "com.vaadin.flow.component.button.Button", "java.lang.Character", "java.lang.Long", "java.lang.Double", "java.lang.Boolean", "com.vaadin.flow.component.tabs.Tabs", "java.lang.String", "java.lang.Byte", "java.lang.Integer"}, (Object[])classes.toArray());
        int count = classes.size();
        visitor.addSignatureToClasses(classes, "([Lcom/vaadin/flow/component/Component;)V");
        Assert.assertEquals((long)(count + 1), (long)classes.size());
        Assert.assertTrue((boolean)classes.contains("com.vaadin.flow.component.Component"));
        visitor.addSignatureToClasses(classes, "(Lcom/vaadin/flow/component/orderedlayout/FlexComponent$Alignment;[Lcom/vaadin/flow/component/Component;)");
        Assert.assertEquals((long)(count + 2), (long)classes.size());
        Assert.assertTrue((boolean)classes.contains("com.vaadin.flow.component.orderedlayout.FlexComponent$Alignment"));
        visitor.addSignatureToClasses(classes, this.getClass().getName());
        Assert.assertTrue((boolean)classes.contains(this.getClass().getName()));
        visitor.addSignatureToClasses(classes, "com/vaadin/flow/server/frontend/FrontendDependenciesTestComponents$AnotherComponent");
        Assert.assertTrue((boolean)classes.contains("com.vaadin.flow.server.frontend.FrontendDependenciesTestComponents$AnotherComponent"));
    }

    @Test
    public void should_visitNpmPakageAnnotations() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.Component1.class, ScannerTestComponents.Component2.class);
        Assert.assertEquals((long)4L, (long)deps.getPackages().size());
        Assert.assertTrue((boolean)deps.getPackages().containsKey("@vaadin/component-1"));
        Assert.assertTrue((boolean)deps.getPackages().containsKey("@vaadin/component-2"));
        Assert.assertTrue((boolean)deps.getPackages().containsKey("@vaadin/component-0"));
        Assert.assertTrue((boolean)deps.getPackages().containsKey("@vaadin/vaadin-foo"));
        Assert.assertEquals((Object)"1.1.1", deps.getPackages().get("@vaadin/component-1"));
        Assert.assertEquals((Object)"222.222.222", deps.getPackages().get("@vaadin/component-2"));
        Assert.assertEquals((Object)"=2.1.0", deps.getPackages().get("@vaadin/component-0"));
        Assert.assertEquals((Object)"1.23.114-alpha1", deps.getPackages().get("@vaadin/vaadin-foo"));
    }

    @Test
    public void should_visitSuperNpmPakageAnnotations() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.ComponentExtending.class);
        Assert.assertEquals((long)1L, (long)deps.getPackages().size());
        Assert.assertTrue((boolean)deps.getPackages().containsKey("@vaadin/component-extended"));
        Assert.assertEquals((Object)"2.1.0", deps.getPackages().get("@vaadin/component-extended"));
    }

    @Test
    public void when_MultipleVersions_should_returnFirstVisitedOne() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.Component0.class);
        Assert.assertEquals((Object)"=2.1.0", deps.getPackages().get("@vaadin/component-0"));
    }

    @Test
    public void should_summarize_when_MultipleViews() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.SecondView.class, ScannerTestComponents.FirstView.class);
        Assert.assertEquals(ScannerTestComponents.Theme1.class, (Object)deps.getThemeDefinition().getTheme());
        DepsTests.assertImportCount(9, deps.getModules());
        Assert.assertEquals((long)1L, (long)deps.getPackages().size());
        DepsTests.assertImportCount(6, deps.getScripts());
        Assert.assertEquals((long)1L, (long)deps.getAssets().size());
    }

    @Test
    public void should_visit_Constructor() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.SecondView.class);
        DepsTests.assertHasImports(deps.getModules(), "./component-3.js");
    }

    @Test
    public void should_resolveComponentFactories() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.ThirdView.class);
        Assert.assertEquals((long)0L, (long)deps.getPackages().size());
        DepsTests.assertImportCount(0, deps.getScripts());
        DepsTests.assertImportsExcludingUI(deps.getModules(), "./my-component.js", "./my-static-factory.js", "./my-another-component.js");
    }

    @Test
    public void should_notVisitNonAnnotatredClasses() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.UnAnnotatedClass.class);
        Assert.assertEquals((String)"Only UI should be found", (long)1L, (long)deps.getEntryPoints().size());
    }

    @Test
    public void should_cacheVisitedClasses() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RoutedClassWithoutAnnotations.class);
        Assert.assertEquals((long)2L, (long)deps.getEntryPoints().size());
        Assert.assertTrue((String)"Should cache visited classes", (deps.getClasses().size() > 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)deps.getClasses().contains(Route.class.getName()));
        Assert.assertTrue((boolean)deps.getClasses().contains(ScannerTestComponents.RoutedClassWithoutAnnotations.class.getName()));
    }

    @Test
    public void should_cacheSuperVisitedClasses() {
        List<Class> visited = Arrays.asList(Route.class, NoTheme.class, JsModule.class, ScannerTestComponents.RoutedClassWithAnnotations.class, ScannerTestComponents.RoutedClassWithoutAnnotations.class, ScannerTestComponents.RoutedClass.class, ScannerTestComponents.BridgeClass.class);
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RoutedClass.class);
        Assert.assertEquals((String)"Should find RoutedClass and UI", (long)2L, (long)deps.getEntryPoints().size());
        int visitedClassesAmount = deps.getClasses().size();
        for (Class clz : visited) {
            Assert.assertTrue((String)("should cache " + clz.getName()), (boolean)deps.getClasses().contains(clz.getName()));
        }
        deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RoutedClassWithoutAnnotations.class, ScannerTestComponents.RoutedClass.class);
        Assert.assertEquals((String)"Should contain UI, RoutedClass and its parent", (long)3L, (long)deps.getEntryPoints().size());
        Assert.assertEquals((long)visitedClassesAmount, (long)deps.getClasses().size());
        for (Class clz : visited) {
            Assert.assertTrue((String)("should cache " + clz.getName()), (boolean)deps.getClasses().contains(clz.getName()));
        }
    }

    @Test
    public void should_visitDynamicRouteWithTwoImports() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.DynamicComponentClassWithTwoImports.class);
        DepsTests.assertImportsExcludingUI(deps.getModules(), "dynamic-component.js", "another-dynamic-component.js");
    }

    @Test
    public void should_visitDynamicRoute() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RouteWithNestedDynamicRouteClass.class);
        DepsTests.assertImportsExcludingUI(deps.getModules(), "dynamic-route.js", "dynamic-component.js", "dynamic-layout.js");
    }

    @Test
    public void should_visitFactoryBeans() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RouteWithViewBean.class);
        DepsTests.assertImportsExcludingUI(deps.getModules(), "dynamic-component.js");
    }

    @Test
    public void should_visitServices() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(ScannerTestComponents.RouteWithService.class);
        DepsTests.assertImportsExcludingUI(deps.getModules(), "dynamic-component.js", "dynamic-layout.js");
    }

    @Test
    public void should_visitMethodAnnotations() {
        FrontendDependencies deps = ScannerDependenciesTest.getFrontendDependencies(MethodAnnotationRoute.class);
        DepsTests.assertImportsExcludingUI(deps.getModules(), "./search-layout.js", "./search-field.js");
    }

    @Route
    public static class MethodAnnotationRoute {
        private MyPmo myPmo;
    }

    @LinkTo(value=SearchFieldComponentDefinitionCreator.class)
    public static @interface UISearchField {

        @JsModule(value="./search-field.js")
        public static class SearchField
        extends Component {
        }

        @JsModule(value="./search-layout.js")
        public static class SearchLayout
        extends Component {
        }

        @LinkTo(value=SearchLayoutComponentDefinitionCreator.class)
        public static @interface UISearchLayout {

            public static class SearchLayoutComponentDefinitionCreator
            implements ComponentDefinitionCreator<UISearchLayout> {
                public Supplier<Component> create(UISearchLayout annotation, AnnotatedElement annotatedElement) {
                    return () -> new SearchLayout();
                }
            }
        }

        public static class SearchFieldComponentDefinitionCreator
        implements ComponentDefinitionCreator<UISearchField> {
            public Supplier<Component> create(UISearchField annotation, AnnotatedElement annotatedElement) {
                return () -> new SearchField();
            }
        }
    }

    public static @interface LinkTo {
        public Class<?> value();
    }

    public static interface ComponentDefinitionCreator<T> {
    }

    @UISearchField.UISearchLayout
    public static class MyPmo {
        @UISearchField
        public String getText() {
            return "value to be displayed";
        }
    }
}

