/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.DepsTests;
import com.vaadin.flow.server.frontend.scanner.EntryPointData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.samples.ErrorComponent;
import com.vaadin.flow.server.frontend.scanner.samples.JsModuleOrderComponent;
import com.vaadin.flow.server.frontend.scanner.samples.JsOrderComponent;
import com.vaadin.flow.server.frontend.scanner.samples.MyServiceListener;
import com.vaadin.flow.server.frontend.scanner.samples.MyUIInitListener;
import com.vaadin.flow.server.frontend.scanner.samples.RouteComponent;
import com.vaadin.flow.server.frontend.scanner.samples.RouteComponentWithMethodReference;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class FrontendDependenciesTest {
    private ClassFinder classFinder = (ClassFinder)Mockito.mock(ClassFinder.class);

    @Before
    public void setUp() throws ClassNotFoundException {
        Mockito.when((Object)this.classFinder.loadClass(Mockito.anyString())).thenAnswer(q -> {
            String className = (String)q.getArgument(0);
            if (className.equals("com.vaadin.flow.theme.lumo.Lumo")) {
                return FakeLumo.class;
            }
            return Class.forName(className);
        });
        ((ClassFinder)Mockito.doAnswer(invocation -> FrontendDependenciesTest.class.getClassLoader().getResource((String)invocation.getArgument(0))).when((Object)this.classFinder)).getResource(Mockito.anyString());
        Mockito.when((Object)this.classFinder.shouldInspectClass(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.classFinder.loadClass(UI.class.getName())).thenReturn(UI.class);
    }

    @Test
    public void routedComponent_entryPointsAreCollected() {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.singleton(RouteComponent.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImportsExcludingUI(dependencies.getModules(), "foo.js");
        DepsTests.assertImports(dependencies.getScripts(), "bar.js");
    }

    @Test
    public void appShellConfigurator_collectedAsEntryPoint() throws ClassNotFoundException {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(MyAppShell.class));
        Mockito.when((Object)this.classFinder.loadClass(FakeLumo.class.getName())).thenReturn(FakeLumo.class);
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        Assert.assertEquals((String)"UI, AppShell should be found", (long)3L, (long)dependencies.getEntryPoints().size());
        AbstractTheme theme = dependencies.getTheme();
        Assert.assertNotNull((String)"Theme not found in entry point", (Object)theme);
        ThemeDefinition themeDefinition = dependencies.getThemeDefinition();
        Assert.assertNotNull((String)"ThemeDefinition is not filled", (Object)themeDefinition);
        Assert.assertEquals(FakeLumo.class, (Object)themeDefinition.getTheme());
    }

    @Test
    public void themeDefiningClassAndName_throwsException() throws ClassNotFoundException {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(FaultyThemeAnnotation.class));
        Mockito.when((Object)this.classFinder.loadClass(FakeLumo.class.getName())).thenReturn(FakeLumo.class);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new FrontendDependencies(this.classFinder, false, null, true));
        Assert.assertEquals((String)"Unexpected message for the thrown exception", (Object)"Theme name and theme class can not both be specified. Theme name uses Lumo and can not be used in combination with custom theme class.", (Object)exception.getMessage());
    }

    @Test
    public void noDefaultThemeAvailable_throwsException() throws ClassNotFoundException {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(MyAppThemeShell.class));
        Mockito.when((Object)this.classFinder.loadClass("com.vaadin.flow.theme.lumo.Lumo")).thenThrow(ClassNotFoundException.class);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new FrontendDependencies(this.classFinder, false, null, true));
        Assert.assertEquals((String)"Thrown exception didn't contain correct message", (Object)"Lumo dependency needs to be available on the classpath when using a theme name.", (Object)exception.getMessage());
    }

    @Test
    public void appThemeDefined_getsLumoAsTheme() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(MyAppThemeShell.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        Assert.assertEquals((String)"Faulty default theme received", FakeLumo.class, (Object)dependencies.getThemeDefinition().getTheme());
    }

    @Test
    public void themeDefined_themeCssLoaded() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(MyAppShell.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        boolean cssFound = false;
        for (ChunkInfo key : dependencies.getCss().keySet()) {
            cssFound = cssFound || ((List)dependencies.getCss().get(key)).stream().anyMatch(css -> css.getValue().equals("@vaadin/vaadin-lumo-styles/lumo.css"));
        }
        Assert.assertTrue((boolean)cssFound);
    }

    @Test
    public void themeNotDefined_ButReferenced_themeCssNotLoaded() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(ThemeReferenceShell.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        boolean cssFound = false;
        for (ChunkInfo key : dependencies.getCss().keySet()) {
            cssFound = cssFound || ((List)dependencies.getCss().get(key)).stream().anyMatch(css -> css.getValue().equals("@vaadin/vaadin-lumo-styles/lumo.css"));
        }
        Assert.assertFalse((boolean)cssFound);
    }

    @Test
    public void onlyThemeVariantDefined_getsLumoAsTheme_preserveVariant() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(ThemeVariantOnly.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        Assert.assertEquals((String)"Faulty default theme received", FakeLumo.class, (Object)dependencies.getThemeDefinition().getTheme());
        Assert.assertEquals((String)"Faulty variant received", (Object)"dark", (Object)dependencies.getThemeDefinition().getVariant());
    }

    @Test
    public void defaultThemeAnnotation_getsLumoAsTheme() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(AppShellConfigurator.class)).thenReturn(Collections.singleton(DefaultThemeAnnotation.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        AbstractTheme theme = dependencies.getTheme();
        Assert.assertNotNull((String)"Theme should be found for @Theme with default values", (Object)theme);
        ThemeDefinition themeDefinition = dependencies.getThemeDefinition();
        Assert.assertNotNull((String)"ThemeDefinition should be filled", (Object)themeDefinition);
        Assert.assertEquals((String)"Should default to Lumo theme", FakeLumo.class, (Object)themeDefinition.getTheme());
        Assert.assertEquals((String)"Variant should be empty", (Object)"", (Object)themeDefinition.getVariant());
        Assert.assertEquals((String)"Theme name should be empty", (Object)"", (Object)themeDefinition.getName());
    }

    @Test
    public void hasErrorParameterComponent_entryPointIsCollected() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(HasErrorParameter.class)).thenReturn(Collections.singleton(ErrorComponent.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImportsExcludingUI(dependencies.getModules(), "./src/bar.js");
        DepsTests.assertImports(dependencies.getScripts(), "./src/baz.js");
    }

    @Test
    public void componentInsideUiInitListener_entryPointsAreCollected() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(UIInitListener.class)).thenReturn(Collections.singleton(MyUIInitListener.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImportsExcludingUI(dependencies.getModules(), "baz.js");
        DepsTests.assertImports(dependencies.getScripts(), "foobar.js");
    }

    @Test
    public void componentInsideUiInitListenerInsideServiceInitListener_entryPointsAreCollected() {
        Mockito.when((Object)this.classFinder.getSubTypesOf(VaadinServiceInitListener.class)).thenReturn(Collections.singleton(MyServiceListener.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImportsExcludingUI(dependencies.getModules(), "baz.js");
        DepsTests.assertImports(dependencies.getScripts(), "foobar.js");
    }

    @Test
    public void jsScriptOrderIsPreserved() {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.singleton(JsOrderComponent.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImports(dependencies.getScripts(), "a.js", "b.js", "c.js");
    }

    @Test
    public void jsModuleOrderIsPreserved() {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.singleton(JsModuleOrderComponent.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImportsExcludingUI(dependencies.getModules(), "c.js", "b.js", "a.js");
    }

    @Test
    public void extractsAndScansClassesFromMethodReferences() {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.singleton(RouteComponentWithMethodReference.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImportsExcludingUI(dependencies.getModules(), "baz.js", "bar.js", "foo.js");
    }

    @Test
    public void defaultThemeIsNotLoadedForExporters() throws Exception {
        FakeLumo.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Mockito.when((Object)this.classFinder.getSubTypesOf(WebComponentExporter.class)).thenReturn(Stream.of(MyExporter.class).collect(Collectors.toSet()));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, true, null, true);
        Assert.assertNull((Object)dependencies.getTheme());
        Assert.assertNull((Object)dependencies.getThemeDefinition());
    }

    @Test
    public void collectEntryPoints_uiIsAlwaysCollected() {
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        Optional<EntryPointData> uiEndpointData = dependencies.getEntryPoints().stream().filter(entryPoint -> entryPoint.getName().equals(UI.class.getName())).findAny();
        Assert.assertTrue((String)"UI should be visited", (boolean)uiEndpointData.isPresent());
    }

    @Test
    public void classInMultipleEntryPoints_collectEntryPointsNotOverrideInitial() {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.singleton(TestRoute.class));
        Mockito.when((Object)this.classFinder.getSubTypesOf(HasErrorParameter.class)).thenReturn(Collections.singleton(TestRoute.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        DepsTests.assertImports(dependencies.getModules(), "reference.js", "@vaadin/common-frontend/ConnectionIndicator.js");
    }

    @Test
    public void layoutClasses_collectedAsEntrypoint() {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Layout.class)).thenReturn(Collections.singleton(MainLayout.class));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        Optional<EntryPointData> layoutEndpointData = dependencies.getEntryPoints().stream().filter(entryPoint -> entryPoint.getName().equals(MainLayout.class.getName())).findAny();
        Assert.assertTrue((String)"MainLayout should be visited", (boolean)layoutEndpointData.isPresent());
        DepsTests.assertImports(dependencies.getModules(), "reference.js", "@vaadin/common-frontend/ConnectionIndicator.js");
    }

    @Test
    public void visitedExporter_previousEntryPointsNotOverridden() throws Exception {
        FakeLumo.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn(Collections.singleton(ReferenceExporter.class));
        Mockito.when((Object)this.classFinder.getSubTypesOf(WebComponentExporter.class)).thenReturn(Stream.of(ReferenceExporter.class).collect(Collectors.toSet()));
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, true, null, true);
        DepsTests.assertImports(dependencies.getModules(), "reference.js", "@vaadin/common-frontend/ConnectionIndicator.js");
    }

    @Test
    public void shouldVisit_shouldNotMatchOnPartOfPackage() {
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, true, null, true);
        Assert.assertTrue((String)"second package should match fully not as starts with 'spring != springseason'", (boolean)dependencies.shouldVisit("org.springseason.samples"));
        Assert.assertTrue((String)"second package should match fully not as starts with 'spring != springseason'", (boolean)dependencies.shouldVisit("org.springseason"));
        Assert.assertFalse((String)"should not visit with only 2 packages 'org.spring'", (boolean)dependencies.shouldVisit("org.spring"));
        Assert.assertTrue((String)"second package should match fully not as starts with 'sun != sunny'", (boolean)dependencies.shouldVisit("com.sunny.app"));
        Assert.assertTrue((String)"second package should match fully not as starts with 'sun != sunny'", (boolean)dependencies.shouldVisit("com.sunny"));
        Assert.assertFalse((String)"should not visit with only 2 packages 'com.sun'", (boolean)dependencies.shouldVisit("com.sun"));
    }

    @Test
    public void classScanningForChildAndParentEntryPoint_ordered_childrenSeeClassesFromParent() {
        LinkedHashSet hierarchy = Stream.of(ParentRoute.class, AnnotatedChildRoute.class, ChildRoute.class, GrandChildRoute.class).collect(Collectors.toCollection(LinkedHashSet::new));
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn((Object)hierarchy);
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        hierarchy.forEach(entryPointClass -> FrontendDependenciesTest.verifyEntryPointData(dependencies, entryPointClass));
    }

    @Test
    public void classScanningForChildAndParentEntryPoint_shuffled_childrenSeeClassesFromParent() {
        LinkedHashSet hierarchy = Stream.of(GrandChildRoute.class, AnnotatedChildRoute.class, ParentRoute.class, ChildRoute.class).collect(Collectors.toCollection(LinkedHashSet::new));
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn((Object)hierarchy);
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        hierarchy.forEach(entryPointClass -> FrontendDependenciesTest.verifyEntryPointData(dependencies, entryPointClass));
    }

    @Test
    public void classScanningForChildAndParentEntryPoint_reversed_childrenSeeClassesFromParent() {
        LinkedHashSet hierarchy = Stream.of(GrandChildRoute.class, ChildRoute.class, AnnotatedChildRoute.class, ParentRoute.class).collect(Collectors.toCollection(LinkedHashSet::new));
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(Route.class)).thenReturn((Object)hierarchy);
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        hierarchy.forEach(entryPointClass -> FrontendDependenciesTest.verifyEntryPointData(dependencies, entryPointClass));
    }

    @Test
    public void classScanningForNpmPackage_collectsNpmAssets() throws ClassNotFoundException {
        LinkedHashSet hierarchy = Stream.of(Assets.class).collect(Collectors.toCollection(LinkedHashSet::new));
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(NpmPackage.class.getName())).thenReturn((Object)hierarchy);
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        Assert.assertEquals((long)1L, (long)dependencies.getAssets().size());
        Assert.assertEquals((long)1L, (long)((List)dependencies.getAssets().get("images")).size());
        Assert.assertEquals((Object)"images/22x25/**:22x25", ((List)dependencies.getAssets().get("images")).get(0));
    }

    @Test
    public void classScanningForNpmPackage_duplicatePackages_collectsAllNpmAssets() throws ClassNotFoundException {
        LinkedHashSet hierarchy = Stream.of(Assets.class, DuplicatedAssets.class).collect(Collectors.toCollection(LinkedHashSet::new));
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(NpmPackage.class.getName())).thenReturn((Object)hierarchy);
        FrontendDependencies dependencies = new FrontendDependencies(this.classFinder, false, null, true);
        Assert.assertEquals((long)1L, (long)dependencies.getAssets().size());
        Assert.assertEquals((long)2L, (long)((List)dependencies.getAssets().get("images")).size());
        Assert.assertTrue((boolean)((List)dependencies.getAssets().get("images")).contains("images/22x25/**:22x25"));
        Assert.assertTrue((boolean)((List)dependencies.getAssets().get("images")).contains("images/28x28/**:28x28"));
    }

    private static EntryPointData getEntryPointByClass(FrontendDependencies dependencies, Class<?> entryPointClass) {
        Optional<EntryPointData> childEntryPoint = dependencies.getEntryPoints().stream().filter(entryPoint -> entryPoint.getName().equals(entryPointClass.getName())).findAny();
        Assert.assertTrue((boolean)childEntryPoint.isPresent());
        return childEntryPoint.get();
    }

    private static void verifyEntryPointData(FrontendDependencies dependencies, Class<?> entryPointClass) {
        EntryPointData entryPointData = FrontendDependenciesTest.getEntryPointByClass(dependencies, entryPointClass);
        Assert.assertNotNull((Object)entryPointData.reachableClasses);
        Assert.assertFalse((boolean)entryPointData.reachableClasses.isEmpty());
        Assert.assertTrue((entryPointData.reachableClasses.size() > 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)entryPointData.getModules());
        Assert.assertEquals((long)1L, (long)entryPointData.getModules().size());
        Assert.assertEquals((Object)"reference.js", entryPointData.getModules().iterator().next());
    }

    @Theme(themeClass=FakeLumo.class)
    public static class MyAppShell
    implements AppShellConfigurator {
    }

    @CssImport(value="@vaadin/vaadin-lumo-styles/lumo.css")
    public static class FakeLumo
    implements AbstractTheme {
        public String getBaseUrl() {
            return null;
        }

        public String getThemeUrl() {
            return null;
        }
    }

    @Theme(value="my-theme", themeClass=FakeLumo.class)
    public static class FaultyThemeAnnotation
    implements AppShellConfigurator {
    }

    @Theme(value="my-theme")
    public static class MyAppThemeShell
    implements AppShellConfigurator {
    }

    public static class ThemeReferenceShell
    implements AppShellConfigurator {
        FakeLumo lumo = new FakeLumo();
    }

    @Theme(variant="dark")
    public static class ThemeVariantOnly
    implements AppShellConfigurator {
    }

    @Theme
    public static class DefaultThemeAnnotation
    implements AppShellConfigurator {
    }

    public static class MyExporter
    extends WebComponentExporter<MyComponent> {
        public MyExporter() {
            super("tag-tag");
        }

        protected void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    @Route(value="reference")
    @Tag(value="div")
    public static class TestRoute
    extends Component
    implements HasErrorParameter<NotFoundException> {
        Referenced ref = new Referenced();

        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            return 0;
        }
    }

    @Tag(value="div")
    @Layout
    @JsModule(value="reference.js")
    public static class MainLayout
    extends Component
    implements RouterLayout {
    }

    @Route(value="reference")
    public static class ReferenceExporter
    extends WebComponentExporter<MyComponent> {
        public ReferenceExporter() {
            super("tag-tag");
        }

        protected void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
            Referenced ref = new Referenced();
        }
    }

    @Route(value="parent")
    public static class ParentRoute
    extends Component
    implements HasComponents {
        private Referenced myComponent = new Referenced();

        public ParentRoute() {
            this.add(new Component[]{this.myComponent});
        }
    }

    @Route(value="child")
    public static class AnnotatedChildRoute
    extends ParentRoute {
    }

    public static class ChildRoute
    extends ParentRoute {
    }

    public static class GrandChildRoute
    extends ChildRoute {
    }

    @NpmPackage(value="images", version="1.1.1", assets={"images/22x25/**:22x25"})
    @Tag(value="div")
    public static class Assets
    extends Component {
    }

    @Tag(value="div")
    @NpmPackage(value="images", version="1.1.1", assets={"images/28x28/**:28x28"})
    public static class DuplicatedAssets
    extends Component {
    }

    @JsModule(value="reference.js")
    @Tag(value="div")
    public static class Referenced
    extends Component {
    }

    public static class MyComponent
    extends Component {
    }
}

