/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendAnnotatedClassVisitor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FrontendAnnotatedClassVisitorTest {
    private FrontendAnnotatedClassVisitor visitor;

    @Before
    public void setup() {
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[]{TestAnnotation.class, AnnotatedClass.class, ValuesForKey.class, DefaultValues.class});
        this.visitor = new FrontendAnnotatedClassVisitor((ClassFinder)finder, TestAnnotation.class.getName());
    }

    @Test
    public void getValues_noAnnotationsFound_returnEmptySet() {
        Set values = this.visitor.getValues("value");
        Assert.assertTrue((String)"Values set should be empty", (boolean)values.isEmpty());
        values = this.visitor.getValues("other");
        Assert.assertTrue((String)"Others set should be empty", (boolean)values.isEmpty());
    }

    @Test
    public void getValuesForKey_noAnnotationsFound_returnEmptySet() {
        Set values = this.visitor.getValuesForKey("value", "Bar", "other");
        Assert.assertTrue((String)"Values set should be empty", (boolean)values.isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getValue_noAnnotationsFound_shouldThrowException() {
        this.visitor.getValue("value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getValue_multipleAnnotationsFound_shouldThrowException() {
        this.visitor.visitClass(AnnotatedClass.class.getName());
        this.visitor.getValue("value");
    }

    @Test
    public void getValues_defaultValues_returnsEmptySet() {
        this.visitor.visitClass(DefaultValues.class.getName());
        Assert.assertTrue((boolean)this.visitor.getValues("value").isEmpty());
        Assert.assertTrue((boolean)this.visitor.getValues("other").isEmpty());
    }

    @Test
    public void getValues_returnsOrderedSet() {
        this.visitor.visitClass(AnnotatedClass.class.getName());
        ArrayList values = new ArrayList(this.visitor.getValues("value"));
        Assert.assertEquals(List.of("Bar", "Baz", "OnlyValue"), values);
        values = new ArrayList(this.visitor.getValues("other"));
        Assert.assertEquals(List.of("aa", "bb", "OnlyOther"), values);
        this.visitor.visitClass(ValuesForKey.class.getName());
        values = new ArrayList(this.visitor.getValues("value"));
        Assert.assertEquals(List.of("Bar", "Baz", "OnlyValue", "Hey", "Ho"), values);
        values = new ArrayList(this.visitor.getValues("other"));
        Assert.assertEquals(List.of("aa", "bb", "OnlyOther", "zz", "11", "yy", "22", "xx"), values);
    }

    @Test
    public void getValuesForKey_returnsMatchingValues() {
        this.visitor.visitClass(ValuesForKey.class.getName());
        ArrayList values = new ArrayList(this.visitor.getValuesForKey("value", "Hey", "other"));
        Assert.assertEquals(List.of("zz", "yy", "xx"), values);
        values = new ArrayList(this.visitor.getValuesForKey("value", "Ho", "other"));
        Assert.assertEquals(List.of("11", "22"), values);
    }

    @Test
    public void getValuesForKey_defaultValues_returnsEmptySet() {
        this.visitor.visitClass(DefaultValues.class.getName());
        Assert.assertTrue((boolean)this.visitor.getValuesForKey("value", "default", "other").isEmpty());
    }

    @Test
    public void getValue_attributeNotDefined_returnsDefaultValue() {
        this.visitor.visitClass(DefaultValues.class.getName());
        Assert.assertEquals((Object)"default", (Object)this.visitor.getValue("value"));
        Assert.assertEquals((Object)"other", (Object)this.visitor.getValue("other"));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    @Repeatable(value=Container.class)
    private static @interface TestAnnotation {
        public String value() default "default";

        public String other() default "other";

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        @Inherited
        @Documented
        public static @interface Container {
            public TestAnnotation[] value();
        }
    }

    @TestAnnotation.Container(value={@TestAnnotation(value="Bar", other="aa"), @TestAnnotation(value="Baz", other="bb"), @TestAnnotation(value="OnlyValue"), @TestAnnotation(other="OnlyOther"), @TestAnnotation})
    private static class AnnotatedClass {
        private AnnotatedClass() {
        }
    }

    @TestAnnotation.Container(value={@TestAnnotation(value="Hey", other="zz"), @TestAnnotation(value="Ho", other="11"), @TestAnnotation(value="Hey", other="yy"), @TestAnnotation(value="Ho", other="22"), @TestAnnotation(value="Hey", other="xx")})
    private static class ValuesForKey {
        private ValuesForKey() {
        }
    }

    @TestAnnotation
    private static class DefaultValues {
        private DefaultValues() {
        }
    }
}

