/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.ScannerTestComponents;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ClassFinderTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void should_Fail_when_DifferentClasLoader() throws Exception {
        ClassLoader loader = new ClassLoader(this){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException();
            }
        };
        this.exception.expect(ClassNotFoundException.class);
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(loader, new Class[]{ScannerTestComponents.Component1.class});
        finder.loadClass(ScannerTestComponents.Component1.class.getName());
    }

    @Test
    public void should_LoadClasses() throws Exception {
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(new HashSet<Class>(Arrays.asList(ScannerTestComponents.Component1.class)));
        Assert.assertNotNull((Object)finder.loadClass(ScannerTestComponents.Component1.class.getName()));
    }

    @Test
    public void should_LoadClasses_when_NoClassListProvided() throws Exception {
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(Collections.emptySet());
        Assert.assertNotNull((Object)finder.loadClass(ScannerTestComponents.Component1.class.getName()));
    }

    @Test
    public void getSubTypesOf_returnsPlainSubtypes() {
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(new HashSet<Class>(Arrays.asList(Double.class, Integer.class, String.class)));
        Set subTypes = finder.getSubTypesOf(Number.class);
        Assert.assertEquals((long)2L, (long)subTypes.size());
        Assert.assertTrue((boolean)subTypes.contains(Double.class));
        Assert.assertTrue((boolean)subTypes.contains(Integer.class));
    }

    @Test
    public void getSubTypesOf_returnsGenericSubtypes() {
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(new HashSet<Class>(Arrays.asList(ArrayList.class, TestList.class, String.class)));
        Set subTypes = finder.getSubTypesOf(List.class);
        Assert.assertEquals((long)2L, (long)subTypes.size());
        Assert.assertTrue((boolean)subTypes.contains(ArrayList.class));
        Assert.assertTrue((boolean)subTypes.contains(TestList.class));
    }

    @Test
    public void orderIsDeterministic() {
        HashSet<Class<NodeTestComponents.TranslatedImports>> testClasses = new HashSet<Class<NodeTestComponents.TranslatedImports>>();
        testClasses.add(NodeTestComponents.ExtraImport.class);
        testClasses.add(NodeTestComponents.VaadinBowerComponent.class);
        testClasses.add(NodeTestComponents.TranslatedImports.class);
        Set allClasses = new ClassFinder.DefaultClassFinder(testClasses).getSubTypesOf(Object.class);
        LinkedHashSet<Class<NodeTestComponents.VaadinBowerComponent>> expected = new LinkedHashSet<Class<NodeTestComponents.VaadinBowerComponent>>();
        expected.add(NodeTestComponents.ExtraImport.class);
        expected.add(NodeTestComponents.TranslatedImports.class);
        expected.add(NodeTestComponents.VaadinBowerComponent.class);
        Assert.assertEquals(expected, (Object)allClasses);
    }

    @Test
    public void defaultsToContextClassLoader() throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        FakeClassLoader loader1 = new FakeClassLoader(this, contextClassLoader);
        FakeClassLoader loader2 = new FakeClassLoader(this, contextClassLoader);
        Class<?> cls1 = loader1.loadClass("com.vaadin.flow.server.frontend.scanner.ClassFinderTest$TestClass1");
        Class<?> cls2 = loader2.loadClass("com.vaadin.flow.server.frontend.scanner.ClassFinderTest$TestClass1");
        Assert.assertEquals((Object)loader1, (Object)cls1.getClassLoader());
        Assert.assertEquals((Object)loader2, (Object)cls2.getClassLoader());
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(Set.of(cls1, cls2));
        Assert.assertEquals((Object)contextClassLoader, (Object)finder.getClassLoader());
    }

    private static class TestList
    extends ArrayList<String> {
        private TestList() {
        }
    }

    private final class FakeClassLoader
    extends ClassLoader {
        private final ClassLoader realClassLoader;

        private FakeClassLoader(ClassFinderTest classFinderTest, ClassLoader realClassLoader) {
            super(null);
            this.realClassLoader = realClassLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)this.realClassLoader.getResourceAsStream(name.replace(".", "/") + ".class"));
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Failed", e);
            }
        }
    }

    public static class TestClass1 {
    }
}

