/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.scanner.samples.pwa.AnotherAppShellWithPwa;
import com.vaadin.flow.server.frontend.scanner.samples.pwa.AppShellWithPwa;
import com.vaadin.flow.server.frontend.scanner.samples.pwa.AppShellWithoutPwa;
import com.vaadin.flow.server.frontend.scanner.samples.pwa.NonAppShellWithPwa;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractScannerPwaTest {
    protected abstract PwaConfiguration getPwaConfiguration(Class<?> ... var1) throws Exception;

    @Test
    public void should_findPwaOnAppShell() throws Exception {
        PwaConfiguration pwaConfiguration = this.getPwaConfiguration(AppShellWithPwa.class);
        Assert.assertEquals((Object)"PWA Application", (Object)pwaConfiguration.getAppName());
        Assert.assertEquals((Object)"PWA", (Object)pwaConfiguration.getShortName());
        Assert.assertEquals((Object)"Testing PWA", (Object)pwaConfiguration.getDescription());
        Assert.assertEquals((Object)"minimal-ui", (Object)pwaConfiguration.getDisplay());
        Assert.assertEquals((Object)"#eee", (Object)pwaConfiguration.getBackgroundColor());
        Assert.assertEquals((Object)"#369", (Object)pwaConfiguration.getThemeColor());
        Assert.assertEquals((Object)"pwa.png", (Object)pwaConfiguration.getIconPath());
        Assert.assertEquals((Object)"appmanifest.json", (Object)pwaConfiguration.getManifestPath());
        Assert.assertEquals((Object)"pwa.html", (Object)pwaConfiguration.getOfflinePath());
        Object[] expectedOfflineResources = new String[]{"pwa.js", "pwa.css"};
        Assert.assertArrayEquals((Object[])expectedOfflineResources, (Object[])pwaConfiguration.getOfflineResources().toArray());
    }

    @Test
    public void should_returnDefaultConfiguration_When_AppShellWithoutPwa() throws Exception {
        PwaConfiguration pwaConfiguration = this.getPwaConfiguration(AppShellWithoutPwa.class);
        Assert.assertEquals((Object)"Vaadin Flow Application", (Object)pwaConfiguration.getAppName());
        Assert.assertEquals((Object)"Flow PWA", (Object)pwaConfiguration.getShortName());
        Assert.assertEquals((Object)"", (Object)pwaConfiguration.getDescription());
        Assert.assertEquals((Object)"standalone", (Object)pwaConfiguration.getDisplay());
        Assert.assertEquals((Object)"#f2f2f2", (Object)pwaConfiguration.getBackgroundColor());
        Assert.assertEquals((Object)"#ffffff", (Object)pwaConfiguration.getThemeColor());
        Assert.assertEquals((Object)"icons/icon.png", (Object)pwaConfiguration.getIconPath());
        Assert.assertEquals((Object)"manifest.webmanifest", (Object)pwaConfiguration.getManifestPath());
        Assert.assertEquals((Object)"offline.html", (Object)pwaConfiguration.getOfflinePath());
        Object[] defaultOfflineResources = new String[]{};
        Assert.assertArrayEquals((Object[])defaultOfflineResources, (Object[])pwaConfiguration.getOfflineResources().toArray());
    }

    @Test
    public void should_returnDefaultConfiguration_When_NoAppShell() throws Exception {
        PwaConfiguration pwaConfiguration = this.getPwaConfiguration(this.getClass());
        Assert.assertEquals((Object)"Vaadin Flow Application", (Object)pwaConfiguration.getAppName());
        Assert.assertEquals((Object)"Flow PWA", (Object)pwaConfiguration.getShortName());
        Assert.assertEquals((Object)"", (Object)pwaConfiguration.getDescription());
        Assert.assertEquals((Object)"standalone", (Object)pwaConfiguration.getDisplay());
        Assert.assertEquals((Object)"#f2f2f2", (Object)pwaConfiguration.getBackgroundColor());
        Assert.assertEquals((Object)"#ffffff", (Object)pwaConfiguration.getThemeColor());
        Assert.assertEquals((Object)"icons/icon.png", (Object)pwaConfiguration.getIconPath());
        Assert.assertEquals((Object)"manifest.webmanifest", (Object)pwaConfiguration.getManifestPath());
        Assert.assertEquals((Object)"offline.html", (Object)pwaConfiguration.getOfflinePath());
        Object[] defaultOfflineResources = new String[]{};
        Assert.assertArrayEquals((Object[])defaultOfflineResources, (Object[])pwaConfiguration.getOfflineResources().toArray());
    }

    @Test(expected=IllegalStateException.class)
    public void should_throw_When_PwaNotOnAppShell() throws Exception {
        this.getPwaConfiguration(NonAppShellWithPwa.class);
    }

    @Test(expected=IllegalStateException.class)
    public void should_throw_When_MultipleAppShellPwa() throws Exception {
        this.getPwaConfiguration(AppShellWithPwa.class, AnotherAppShellWithPwa.class);
    }
}

