/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.server.frontend.installer.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class PlatformTest {
    @Test
    public void testGuess_whenOsIsLinuxAndAlpineReleaseFileExists_unofficialNodeDownloadPathReturned() {
        try (MockedStatic os = Mockito.mockStatic(Platform.OS.class);
             MockedStatic paths = Mockito.mockStatic(Paths.class);
             MockedStatic files = Mockito.mockStatic(Files.class);){
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.LINUX);
            Path alpineReleaseFilePath = Paths.get("/etc/alpine-release", new String[0]);
            paths.when(() -> Paths.get("/etc/alpine-release", new String[0])).thenReturn((Object)alpineReleaseFilePath);
            files.when(() -> Files.exists(alpineReleaseFilePath, new LinkOption[0])).thenReturn((Object)true);
            Platform platform = Platform.guess();
            Assert.assertEquals((Object)"https://unofficial-builds.nodejs.org/download/release/", (Object)platform.getNodeDownloadRoot());
            FrontendVersion frontendVersion = (FrontendVersion)Mockito.mock(FrontendVersion.class);
            Assert.assertTrue((boolean)platform.getNodeClassifier(frontendVersion).contains("-musl"));
        }
    }

    @Test
    public void testGuess_whenOsIsLinuxAndAlpineReleaseFileDoesNotExist_officialNodeDownloadPathReturned() {
        try (MockedStatic os = Mockito.mockStatic(Platform.OS.class);){
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.LINUX);
            Platform platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)platform.getNodeDownloadRoot());
            FrontendVersion frontendVersion = (FrontendVersion)Mockito.mock(FrontendVersion.class);
            Assert.assertFalse((boolean)platform.getNodeClassifier(frontendVersion).contains("-musl"));
        }
    }

    @Test
    public void testGuess_whenOsIsAnythingOtherThanLinuxAlpineRelease_officialNodeDownloadPathReturned() {
        try (MockedStatic os = Mockito.mockStatic(Platform.OS.class);){
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.WINDOWS);
            Platform platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)platform.getNodeDownloadRoot());
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.MAC);
            platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)platform.getNodeDownloadRoot());
            os.when(Platform.OS::guess).thenReturn((Object)Platform.OS.SUN_OS);
            platform = Platform.guess();
            Assert.assertEquals((Object)"https://nodejs.org/dist/", (Object)platform.getNodeDownloadRoot());
        }
    }
}

