/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.installer;

import com.vaadin.flow.server.frontend.installer.DefaultFileDownloader;
import com.vaadin.flow.server.frontend.installer.DownloadException;
import com.vaadin.flow.server.frontend.installer.FileDownloader;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DefaultFileDownloaderTest {
    @Rule
    public final TemporaryFolder tmpDir = new TemporaryFolder();
    private String baseDir;
    private DefaultFileDownloader downloader;

    @Before
    public void setup() {
        this.baseDir = this.tmpDir.getRoot().getAbsolutePath();
        this.downloader = new DefaultFileDownloader(new ProxyConfig(Collections.emptyList()));
    }

    @Test
    public void installNodeFromFileSystem_NodeIsInstalledToTargetDirectory() throws IOException, DownloadException {
        File targetDir = new File(this.baseDir + "/installation");
        Assert.assertFalse((String)"Clean test should not contain a installation folder", (boolean)targetDir.exists());
        File downloadDir = this.tmpDir.newFolder("v24.12.0");
        String downloadFileName = "MyDownload.zip";
        File archiveFile = new File(downloadDir, downloadFileName);
        archiveFile.createNewFile();
        Path tempArchive = archiveFile.toPath();
        this.downloader.download(tempArchive.toUri(), new File(targetDir, downloadFileName), null, null, null);
        Assert.assertTrue((String)"File was not 'downloaded' to target directory", (boolean)new File(targetDir, downloadFileName).exists());
        Assert.assertFalse((String)"File 'downloaded' was a directory event though file expected", (boolean)new File(targetDir, downloadFileName).isDirectory());
    }

    @Test
    public void nullProgressListenerWorks() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = "12345678901234567890".getBytes(StandardCharsets.UTF_8);
        this.downloader.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out, (long)data.length, null);
    }

    @Test
    public void progressListenerCalledWhenSizeIsKnown() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = this.createData(32768);
        ArrayList reportedProgress = new ArrayList();
        FileDownloader.ProgressListener progressListener = (bytesTransferred, totalBytes, progress) -> reportedProgress.add(bytesTransferred + "," + totalBytes + "," + progress);
        this.downloader.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out, (long)data.length, progressListener);
        Assert.assertEquals(List.of("8192,32768,0.25", "16384,32768,0.5", "24576,32768,0.75", "32768,32768,1.0"), reportedProgress);
    }

    @Test
    public void progressListenerCalledWhenSizeIsUnknown() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = this.createData(0x219999);
        ArrayList reportedProgress = new ArrayList();
        FileDownloader.ProgressListener progressListener = (bytesTransferred, totalBytes, progress) -> reportedProgress.add(bytesTransferred + "," + totalBytes + "," + progress);
        this.downloader.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)out, -1L, progressListener);
        Assert.assertEquals((Object)"1048576,-1,-1.0", reportedProgress.get(0));
        Assert.assertEquals((Object)"2097152,-1,-1.0", reportedProgress.get(1));
        Assert.assertEquals((Object)"2202009,-1,-1.0", reportedProgress.get(2));
    }

    private byte[] createData(int size) {
        String sequence = "1234567890";
        byte[] sequenceBytes = sequence.getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = sequenceBytes[i % sequenceBytes.length];
        }
        return result;
    }
}

