/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.VersionsJsonConverter;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class VersionsJsonConverterTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void convertPlatformVersions() throws IOException {
        String json = "{\"core\": {\"flow\": {  \"javaVersion\": \"3.0.0.alpha17\"},  \"vaadin-progress-bar\": {  \"npmName\": \"@vaadin/vaadin-progress-bar\", \"jsVersion\": \"1.1.2\", \"mode\": \"lit\" }},\"vaadin-upload\": { \"npmName\": \"@vaadin/vaadin-upload\", \"jsVersion\": \"4.2.2\"},\"iron-list\": {\n            \"npmName\": \"@polymer/iron-list\",\n            \"npmVersion\": \"3.0.2\",\n            \"javaVersion\": \"3.0.0.beta1\",\n            \"jsVersion\": \"2.0.19\"\n        },\"vaadin-core\": {\n    \"jsVersion\": \"21.0.0.alpha1\",\n    \"npmName\": \"@vaadin/vaadin-core\"\n},\n\"platform\": \"foo\"}";
        VersionsJsonConverter convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), false, false);
        ObjectNode convertedJson = convert.getConvertedJson();
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertEquals((Object)"1.1.2", (Object)convertedJson.get("@vaadin/vaadin-progress-bar").textValue());
        Assert.assertEquals((Object)"4.2.2", (Object)convertedJson.get("@vaadin/vaadin-upload").textValue());
        Assert.assertEquals((Object)"3.0.2", (Object)convertedJson.get("@polymer/iron-list").textValue());
    }

    @Test
    public void reactRouterInUse_reactComponentsAreAdded() {
        String json = "{\n  \"core\": {\n    \"flow\": {\n      \"javaVersion\": \"3.0.0.alpha17\"\n    },\n    \"vaadin-progress-bar\": {\n      \"npmName\": \"@vaadin/vaadin-progress-bar\",\n      \"jsVersion\": \"1.1.2\"\n    }\n  },\n  \"vaadin-upload\": {\n    \"npmName\": \"@vaadin/vaadin-upload\",\n    \"jsVersion\": \"4.2.2\"\n  },\n  \"iron-list\": {\n    \"npmName\": \"@polymer/iron-list\",\n    \"npmVersion\": \"3.0.2\",\n    \"javaVersion\": \"3.0.0.beta1\",\n    \"jsVersion\": \"2.0.19\"\n  },\n  \"vaadin-core\": {\n      \"jsVersion\": \"21.0.0.alpha1\",\n      \"npmName\": \"%s\"\n  },\n  \"react\": {\n    \"react-components\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components\"\n    }\n  },\n  \"react-pro\": {\n    \"react-components-pro\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components-pro\"\n    }\n  },\n  \"platform\": \"foo\"\n}\n".formatted("@vaadin/vaadin-core");
        VersionsJsonConverter convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), true, true);
        ObjectNode convertedJson = convert.getConvertedJson();
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react-components-pro"));
        Assert.assertEquals((Object)"1.1.2", (Object)convertedJson.get("@vaadin/vaadin-progress-bar").textValue());
        Assert.assertEquals((Object)"4.2.2", (Object)convertedJson.get("@vaadin/vaadin-upload").textValue());
        Assert.assertEquals((Object)"3.0.2", (Object)convertedJson.get("@polymer/iron-list").textValue());
        Assert.assertEquals((Object)"24.4.0-alpha7", (Object)convertedJson.get("@vaadin/react-components").textValue());
        Assert.assertEquals((Object)"24.4.0-alpha7", (Object)convertedJson.get("@vaadin/react-components-pro").textValue());
    }

    @Test
    public void reactRouterNotUsed_reactComponentsIgnored() {
        String json = "{\n  \"core\": {\n    \"flow\": {\n      \"javaVersion\": \"3.0.0.alpha17\"\n    },\n    \"vaadin-progress-bar\": {\n      \"npmName\": \"@vaadin/vaadin-progress-bar\",\n      \"jsVersion\": \"1.1.2\"\n    }\n  },\n  \"vaadin-upload\": {\n    \"npmName\": \"@vaadin/vaadin-upload\",\n    \"jsVersion\": \"4.2.2\"\n  },\n  \"iron-list\": {\n    \"npmName\": \"@polymer/iron-list\",\n    \"npmVersion\": \"3.0.2\",\n    \"javaVersion\": \"3.0.0.beta1\",\n    \"jsVersion\": \"2.0.19\"\n  },\n  \"vaadin-core\": {\n      \"jsVersion\": \"21.0.0.alpha1\",\n      \"npmName\": \"%s\"\n  },\n  \"react\": {\n    \"react-components\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components\",\n      \"mode\": \"react\"\n    }\n  },\n  \"react-pro\": {\n    \"react-components-pro\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components-pro\",\n      \"mode\": \"react\"\n    }\n  },\n  \"platform\": \"foo\"\n}\n".formatted("@vaadin/vaadin-core");
        VersionsJsonConverter convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), false, true);
        ObjectNode convertedJson = convert.getConvertedJson();
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react-components-pro"));
        Assert.assertEquals((Object)"1.1.2", (Object)convertedJson.get("@vaadin/vaadin-progress-bar").textValue());
        Assert.assertEquals((Object)"4.2.2", (Object)convertedJson.get("@vaadin/vaadin-upload").textValue());
        Assert.assertEquals((Object)"3.0.2", (Object)convertedJson.get("@polymer/iron-list").textValue());
    }

    @Test
    public void reactRouterUsed_noVaadinRouterAdded() {
        String json = "{\n  \"core\": {\n    \"flow\": {\n      \"javaVersion\": \"3.0.0.alpha17\"\n    }\n  },\n  \"vaadin-router\": {\n    \"npmName\": \"@vaadin/router\",\n    \"jsVersion\": \"2.0.0\"\n  },\n  \"react\": {\n    \"react-components\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components\",\n      \"mode\": \"react\"\n    }\n  },\n  \"platform\": \"foo\"\n}\n".formatted("@vaadin/vaadin-core");
        VersionsJsonConverter convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), true, false);
        ObjectNode convertedJson = convert.getConvertedJson();
        Assert.assertFalse((String)"Found @vaadin/router even though it should not be in use.", (boolean)convertedJson.has("@vaadin/router"));
        Assert.assertTrue((String)"Missing react-components", (boolean)convertedJson.has("@vaadin/react-components"));
    }

    @Test
    public void testModeProperty() {
        String json = "{\n  \"core\": {\n    \"flow\": {\n      \"javaVersion\": \"3.0.0.alpha17\"\n    },\n    \"vaadin-progress-bar\": {\n      \"npmName\": \"@vaadin/vaadin-progress-bar\",\n      \"jsVersion\": \"1.1.2\",\n      \"mode\": \"lit\"\n    }\n  },\n  \"vaadin-upload\": {\n    \"npmName\": \"@vaadin/vaadin-upload\",\n    \"jsVersion\": \"4.2.2\",\n    \"mode\": \"\"\n  },\n  \"iron-list\": {\n    \"npmName\": \"@polymer/iron-list\",\n    \"npmVersion\": \"3.0.2\",\n    \"javaVersion\": \"3.0.0.beta1\",\n    \"jsVersion\": \"2.0.19\",\n    \"mode\": \"all\"\n  },\n  \"vaadin-core\": {\n      \"jsVersion\": \"21.0.0.alpha1\",\n      \"npmName\": \"%s\"\n  },\n  \"react\": {\n    \"react-components\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components\",\n      \"mode\": \"react\"\n    }\n  },\n  \"react-pro\": {\n    \"react-components-pro\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components-pro\",\n      \"mode\": \"react\"\n    }\n  },\n  \"platform\": \"foo\"\n}\n".formatted("@vaadin/vaadin-core");
        VersionsJsonConverter convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), true, false);
        ObjectNode convertedJson = convert.getConvertedJson();
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react-components-pro"));
        convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), true, true);
        convertedJson = convert.getConvertedJson();
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react-components-pro"));
        convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), false, false);
        convertedJson = convert.getConvertedJson();
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), false, true);
        convertedJson = convert.getConvertedJson();
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react-components-pro"));
    }

    @Test
    public void testExclusionsArrayProperty() {
        String json = "{\n  \"core\": {\n    \"flow\": {\n      \"javaVersion\": \"3.0.0.alpha17\"\n    },\n    \"vaadin-progress-bar\": {\n      \"npmName\": \"@vaadin/vaadin-progress-bar\",\n      \"jsVersion\": \"1.1.2\",\n      \"mode\": \"lit\"\n    }\n  },\n  \"vaadin-upload\": {\n    \"npmName\": \"@vaadin/vaadin-upload\",\n    \"jsVersion\": \"4.2.2\",\n    \"mode\": \"\"\n  },\n  \"iron-list\": {\n    \"npmName\": \"@polymer/iron-list\",\n    \"npmVersion\": \"3.0.2\",\n    \"javaVersion\": \"3.0.0.beta1\",\n    \"jsVersion\": \"2.0.19\",\n    \"mode\": \"all\"\n  },\n  \"vaadin-core\": {\n      \"jsVersion\": \"21.0.0.alpha1\",\n      \"npmName\": \"%s\"\n  },\n  \"react\": {\n    \"react-components\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components\",\n      \"mode\": \"react\",\n      \"exclusions\": [\n        \"@vaadin/vaadin-progress-bar\",\n        \"@vaadin/vaadin-upload\",\n        \"@polymer/iron-list\",\n        \"@vaadin/react-components-pro\"\n        ]\n    }\n  },\n  \"react-pro\": {\n    \"react-components-pro\": {\n      \"jsVersion\": \"24.4.0-alpha7\",\n      \"npmName\": \"@vaadin/react-components-pro\",\n      \"mode\": \"react\"\n    }\n  },\n  \"platform\": \"foo\"\n}\n".formatted("@vaadin/vaadin-core");
        VersionsJsonConverter convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), true, false);
        ObjectNode convertedJson = convert.getConvertedJson();
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertFalse((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react-components-pro"));
        convert = new VersionsJsonConverter((JsonNode)JacksonUtils.readTree((String)json), false, false);
        convertedJson = convert.getConvertedJson();
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-progress-bar"));
        Assert.assertTrue((boolean)convertedJson.has("@vaadin/vaadin-upload"));
        Assert.assertTrue((boolean)convertedJson.has("@polymer/iron-list"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components-pro"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/react-components"));
        Assert.assertFalse((boolean)convertedJson.has("flow"));
        Assert.assertFalse((boolean)convertedJson.has("core"));
        Assert.assertFalse((boolean)convertedJson.has("@vaadin/vaadin-core"));
        Assert.assertFalse((boolean)convertedJson.has("platform"));
        Assert.assertFalse((boolean)convertedJson.has("react"));
        Assert.assertFalse((boolean)convertedJson.has("react-pro"));
        Assert.assertFalse((boolean)convertedJson.has("react-components"));
        Assert.assertFalse((boolean)convertedJson.has("react-components-pro"));
    }
}

