/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.DependencyTrigger;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.frontend.AbstractUpdateImportsTest;
import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class UpdateImportsWithByteCodeScannerTest
extends AbstractUpdateImportsTest {
    private static final String CHUNK_PATTERN_STRING = "chunks\\/chunk-";
    private static final Pattern CHUNK_PATTERN = Pattern.compile("chunks\\/chunk-");

    @Override
    protected FrontendDependenciesScanner getScanner(ClassFinder finder) {
        return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(false, finder, true, null, true);
    }

    @Test
    public void assertFullSortOrder() throws MalformedURLException {
        ArrayList<String> expectedJsModuleImports = new ArrayList<String>();
        expectedJsModuleImports.add("import '@vaadin/vaadin-mixed-component/src/vaadin-mixed-component.js';");
        expectedJsModuleImports.add("import '@vaadin/vaadin-mixed-component/src/vaadin-something-else.js';");
        expectedJsModuleImports.add("import '@vaadin/vaadin-mixed-component/src/vaadin-something-else';");
        expectedJsModuleImports.add("import '@vaadin/vaadin-mixed-component/src/vaadin-custom-themed-component.js';");
        expectedJsModuleImports.add("import 'Frontend/local-p3-template.js';");
        expectedJsModuleImports.add("import 'jsmodule/h.js';");
        expectedJsModuleImports.add("import 'jsmodule/g.js';");
        expectedJsModuleImports.add("import '@vaadin/common-frontend/ConnectionIndicator.js';");
        super.assertFullSortOrder(true, expectedJsModuleImports);
    }

    @Test
    public void lazyRouteIsLazyLoaded() throws Exception {
        Class[] testClasses = new Class[]{AbstractUpdateImportsTest.MainView.class, LazyAppConf.class, NodeTestComponents.TranslatedImports.class, NodeTestComponents.LocalP3Template.class, LazyRoute.class, UI.class};
        this.createExpectedLazyImports();
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedFolder = FrontendUtils.getFlowGeneratedFolder((File)this.frontendDirectory);
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        File flowGeneratedImportsDTs = new File(flowGeneratedFolder, "generated-flow-imports.d.ts");
        Assert.assertTrue((boolean)output.containsKey(flowGeneratedImports));
        Assert.assertTrue((boolean)output.containsKey(flowGeneratedImportsDTs));
        Optional<File> chunkFile = UpdateImportsWithByteCodeScannerTest.findOptionalChunkFile(output);
        Assert.assertTrue((boolean)chunkFile.isPresent());
        Assert.assertTrue((boolean)output.containsKey(chunkFile.get()));
        String mainImportContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(flowGeneratedImports));
        String lazyChunkContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(chunkFile.get()));
        this.assertImports(mainImportContent, lazyChunkContent, new String[]{"Frontend/local-p3-template.js"}, new String[]{"Frontend/lazy-component-javascript.js", "Frontend/lazy-component-jsmodule.js", "Frontend/lazy-component-cssimport.css"});
    }

    @Test
    public void lazyAndEagerRoutesProperlyHandled() throws Exception {
        Class[] testClasses = new Class[]{LazyRoute.class, EagerRoute.class, LazyEagerAppConf.class, UI.class};
        this.createExpectedLazyImports();
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedFolder = FrontendUtils.getFlowGeneratedFolder((File)this.frontendDirectory);
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        File flowGeneratedImportsDTs = new File(flowGeneratedFolder, "generated-flow-imports.d.ts");
        Assert.assertTrue((boolean)output.containsKey(flowGeneratedImports));
        Assert.assertTrue((boolean)output.containsKey(flowGeneratedImportsDTs));
        Optional<File> chunkFile = UpdateImportsWithByteCodeScannerTest.findOptionalChunkFile(output);
        Assert.assertTrue((boolean)chunkFile.isPresent());
        Assert.assertTrue((boolean)output.containsKey(chunkFile.get()));
        String mainImportContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(flowGeneratedImports));
        String lazyChunkContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(chunkFile.get()));
        this.assertImports(mainImportContent, lazyChunkContent, new String[]{"Frontend/eager-component-cssimport.css", "Frontend/eager-component-javascript.js", "Frontend/eager-component-jsmodule-2.js", "Frontend/eager-component-jsmodule-1.js"}, new String[]{"Frontend/lazy-component-cssimport.css", "Frontend/lazy-component-javascript.js", "Frontend/lazy-component-jsmodule.js"});
    }

    private void createExpectedLazyImports() throws IOException {
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./lazy-component-javascript.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./lazy-component-jsmodule.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./lazy-component-cssimport.css");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./eager-component-javascript.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./eager-component-jsmodule-2.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./eager-component-jsmodule-1.js");
        this.createExpectedImport(this.frontendDirectory, this.nodeModulesPath, "./eager-component-cssimport.css");
    }

    @Test
    public void lazyRouteTriggeredByOtherComponent() throws Exception {
        this.createExpectedLazyImports();
        Class[] testClasses = new Class[]{LazyRouteWithOtherTrigger.class, LazyAppConf.class, UI.class};
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        String mainImportContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(flowGeneratedImports));
        Assert.assertEquals((long)1L, (long)CHUNK_PATTERN.matcher(mainImportContent).results().count());
        String routeHash = StringUtil.getHash((String)LazyRouteWithOtherTrigger.class.getName(), (Charset)StandardCharsets.UTF_8);
        String triggerHash = StringUtil.getHash((String)TriggerClass1.class.getName(), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)mainImportContent.contains("key === '" + triggerHash + "'"));
        Assert.assertFalse((boolean)mainImportContent.contains("key === '" + routeHash + "'"));
    }

    @Test
    public void lazyRouteTriggeredByOtherComponents() throws Exception {
        this.createExpectedLazyImports();
        Class[] testClasses = new Class[]{LazyRouteWithOtherTriggers.class, LazyAppConf.class, UI.class};
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        String mainImportContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(flowGeneratedImports));
        String routeHash = StringUtil.getHash((String)LazyRouteWithOtherTriggers.class.getName(), (Charset)StandardCharsets.UTF_8);
        String trigger1Hash = StringUtil.getHash((String)TriggerClass1.class.getName(), (Charset)StandardCharsets.UTF_8);
        String trigger2Hash = StringUtil.getHash((String)TriggerClass2.class.getName(), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((long)1L, (long)CHUNK_PATTERN.matcher(mainImportContent).results().count());
        Assert.assertTrue((boolean)mainImportContent.contains("key === '" + trigger1Hash + "'"));
        Assert.assertTrue((boolean)mainImportContent.contains("key === '" + trigger2Hash + "'"));
        Assert.assertFalse((boolean)mainImportContent.contains("key === '" + routeHash + "'"));
    }

    @Test
    public void cssImportFromAppShellAndThemeWork() throws Exception {
        Class[] testClasses = new Class[]{AbstractUpdateImportsTest.ThemeCssImport.class, UI.class};
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        Assert.assertNotNull(output);
        Assert.assertEquals((long)4L, (long)output.size());
        Optional<File> appShellFile = output.keySet().stream().filter(file -> file.getName().endsWith("app-shell-imports.js")).findAny();
        Assert.assertTrue((boolean)appShellFile.isPresent());
        List<String> appShellLines = output.get(appShellFile.get());
        this.assertOnce("import { injectGlobalCss } from 'Frontend/generated/jar-resources/theme-util.js';", appShellLines);
        this.assertOnce("from 'Frontend/foo.css?inline';", appShellLines);
        this.assertOnce("from 'lumo-css-import.css?inline';", appShellLines);
        Optional<File> appShellDTsFile = output.keySet().stream().filter(file -> file.getName().endsWith("app-shell-imports.d.ts")).findAny();
        Assert.assertTrue((boolean)appShellDTsFile.isPresent());
        List<String> appShellDTsLines = output.get(appShellDTsFile.get());
        Assert.assertEquals((long)1L, (long)appShellDTsLines.size());
        this.assertOnce("export {}", appShellDTsLines);
    }

    @Test
    public void cssInLazyChunkWorks() throws Exception {
        Class[] testClasses = new Class[]{AbstractUpdateImportsTest.FooCssImport.class, UI.class};
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        Assert.assertNotNull(output);
        Assert.assertEquals((long)5L, (long)output.size());
        Optional<File> chunkFile = UpdateImportsWithByteCodeScannerTest.findOptionalChunkFile(output);
        Assert.assertTrue((boolean)chunkFile.isPresent());
        List<String> chunkLines = output.get(chunkFile.get());
        this.assertOnce("import { injectGlobalCss } from", chunkLines);
        this.assertOnce("from 'Frontend/foo.css?inline';", chunkLines);
        this.assertOnce("import $cssFromFile_0 from", chunkLines);
        this.assertOnce("injectGlobalCss($cssFromFile_0", chunkLines);
        Assert.assertEquals((Object)"import { injectGlobalCss } from 'Frontend/generated/jar-resources/theme-util.js';\n", (Object)chunkLines.get(0));
        Assert.assertEquals((Object)"import { css, unsafeCSS, registerStyles } from '@vaadin/vaadin-themable-mixin';", (Object)chunkLines.get(1));
    }

    private static Optional<File> findOptionalChunkFile(Map<File, List<String>> output) {
        return output.keySet().stream().filter(file -> file.getName().contains("chunk-")).findAny();
    }

    private void assertImports(String mainImportContent, String lazyImportContent, String[] mainImports, String[] lazyImports) {
        for (String mainImport : mainImports) {
            Assert.assertTrue((String)("Main import should contain " + mainImport), (boolean)mainImportContent.contains(mainImport));
            Assert.assertFalse((String)("Lazy import should not contain " + mainImport), (boolean)lazyImportContent.contains(mainImport));
        }
        for (String lazyImport : lazyImports) {
            Assert.assertFalse((String)("Main import should not contain " + lazyImport), (boolean)mainImportContent.contains(lazyImport));
            Assert.assertTrue((String)("Lazy import should contain " + lazyImport), (boolean)lazyImportContent.contains(lazyImport));
        }
    }

    @Test
    public void loginAndRootEagerByDefault() throws Exception {
        this.createExpectedLazyImports();
        Class[] testClasses = new Class[]{RootView.class, LoginView.class, OtherView.class, UI.class};
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        List<File> lazyChunks = output.keySet().stream().filter(file -> file.getName().contains("chunk-")).toList();
        Assert.assertEquals((long)1L, (long)lazyChunks.size());
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        String mainImportContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(flowGeneratedImports));
        Assert.assertEquals((long)1L, (long)CHUNK_PATTERN.matcher(mainImportContent).results().count());
    }

    @Test
    public void onlyOneChunkForLazyViewsWithSameContent() throws Exception {
        this.createExpectedLazyImports();
        Class[] testClasses = new Class[]{OtherView.class, CloneView.class};
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        List<File> lazyChunks = output.keySet().stream().filter(file -> file.getName().contains("chunk-")).toList();
        Assert.assertEquals((long)1L, (long)lazyChunks.size());
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        String mainImportContent = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)output.get(flowGeneratedImports));
        Assert.assertEquals((long)2L, (long)CHUNK_PATTERN.matcher(mainImportContent).results().count());
    }

    @Test
    public void onlyOneChunkForLazyViewsWithSameContent_generatedWebComponentsImports() throws Exception {
        this.createExpectedLazyImports();
        Class[] testClasses = new Class[]{OtherView.class, CloneView.class};
        ClassFinder classFinder = UpdateImportsWithByteCodeScannerTest.getClassFinder(testClasses);
        this.updater = new AbstractUpdateImportsTest.UpdateImports(this.getScanner(classFinder), this.options);
        this.updater.run();
        Map<File, List<String>> output = this.updater.getOutput();
        File flowGeneratedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        List<String> ifList = output.get(flowGeneratedImports).stream().filter(line -> line.trim().startsWith("if (key === '") && line.trim().endsWith("') {")).toList();
        List<String> importChunkList = output.get(flowGeneratedImports).stream().filter(line -> line.trim().startsWith("pending.push(import('./chunks/chunk-")).toList();
        String generatedWebComponentsImports = IOUtils.toString((URI)FrontendUtils.getFlowGeneratedWebComponentsImports((File)this.options.getFrontendDirectory()).toURI(), (Charset)StandardCharsets.UTF_8);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String ifLine : ifList) {
            matchers.add(CoreMatchers.containsString((String)(ifLine + "\n" + importChunkList.get(ifList.indexOf(ifLine)) + "\n  }")));
        }
        MatcherAssert.assertThat((Object)generatedWebComponentsImports, (Matcher)CoreMatchers.allOf((Matcher[])((Matcher[])matchers.toArray(Matcher[]::new))));
    }

    @LoadDependenciesOnStartup(value={AbstractUpdateImportsTest.MainView.class})
    static class LazyAppConf
    implements AppShellConfigurator {
        LazyAppConf() {
        }
    }

    @Route(value="lazy")
    static class LazyRoute
    extends Component {
        LazyComponent lazyComponent;

        LazyRoute() {
        }
    }

    @Route(value="eager")
    static class EagerRoute
    extends Component {
        EagerComponent eagerComponent;

        EagerRoute() {
        }
    }

    @LoadDependenciesOnStartup(value={EagerRoute.class})
    static class LazyEagerAppConf
    implements AppShellConfigurator {
        LazyEagerAppConf() {
        }
    }

    @Route(value="lazy")
    @DependencyTrigger(value={TriggerClass1.class})
    static class LazyRouteWithOtherTrigger
    extends Component {
        LazyComponent lazyComponent;

        LazyRouteWithOtherTrigger() {
        }
    }

    public static class TriggerClass1
    extends Component {
    }

    @Route(value="lazy")
    @DependencyTrigger(value={TriggerClass1.class, TriggerClass2.class})
    static class LazyRouteWithOtherTriggers
    extends Component {
        LazyComponent lazyComponent;

        LazyRouteWithOtherTriggers() {
        }
    }

    public static class TriggerClass2
    extends Component {
    }

    @Route(value="")
    public static class RootView
    extends Component {
    }

    @Route(value="login")
    public static class LoginView
    extends Component {
    }

    @Route(value="other")
    @JavaScript(value="./lazy-component-javascript.js")
    public static class OtherView
    extends Component {
    }

    @Route(value="clone")
    @JavaScript(value="./lazy-component-javascript.js")
    public static class CloneView
    extends Component {
    }

    @JavaScript(value="./eager-component-javascript.js")
    @JsModule.Container(value={@JsModule(value="./eager-component-jsmodule-2.js"), @JsModule(value="./eager-component-jsmodule-1.js")})
    @CssImport(value="./eager-component-cssimport.css")
    public static class EagerComponent
    extends Component {
    }

    @JavaScript(value="./lazy-component-javascript.js")
    @JsModule(value="./lazy-component-jsmodule.js")
    @CssImport(value="./lazy-component-cssimport.css")
    public static class LazyComponent
    extends Component {
    }
}

