/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdateThemeImport;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.jcip.annotations.NotThreadSafe;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

@NotThreadSafe
public class TaskUpdateThemeImportTest {
    private static final String CUSTOM_THEME_NAME = "custom-theme";
    private static final String CUSTOM_VARIANT_NAME = "custom-variant";
    private static final String CUSTOM_THEME_PATH = String.join((CharSequence)"/", "themes", "custom-theme");
    public static final String EMPTY_BEFORE_EXECUTION = "%s should not exist before executing TaskUpdateThemeImport.";
    public static final String SHOULD_EXIST_AFTER_EXECUTION = "%s should be created as the result of executing TaskUpdateThemeImport.";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File projectRoot;
    private File npmFolder;
    private File frontendDirectory;
    private File themeImportFile;
    private File themeImportTsFile;
    private Class<? extends AbstractTheme> dummyThemeClass;
    private ThemeDefinition customTheme;
    private TaskUpdateThemeImport taskUpdateThemeImport;
    private Logger logger;

    @Before
    public void setUp() throws IOException {
        this.projectRoot = this.temporaryFolder.getRoot();
        this.npmFolder = this.temporaryFolder.getRoot();
        this.frontendDirectory = new File(this.projectRoot, "./src/main/frontend/");
        File frontendFolder = new File(this.npmFolder, "./src/main/frontend/");
        this.themeImportFile = new File(new File(frontendFolder, "generated/"), "theme.js");
        this.themeImportTsFile = new File(new File(frontendFolder, "generated/"), "theme.d.ts");
        this.dummyThemeClass = ((AbstractTheme)Mockito.mock(AbstractTheme.class)).getClass();
        this.customTheme = new ThemeDefinition(this.dummyThemeClass, CUSTOM_VARIANT_NAME, CUSTOM_THEME_NAME);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.npmFolder).withFrontendDirectory(this.frontendDirectory);
        this.logger = (Logger)Mockito.mock(Logger.class);
        this.taskUpdateThemeImport = new TaskUpdateThemeImport(this.customTheme, options){

            Logger getLogger() {
                return TaskUpdateThemeImportTest.this.logger;
            }
        };
    }

    @Test
    public void taskExecuted_customThemeWithNonExistingThemeFolder_throwsException() {
        File faultyFrontendDirectory = new File(this.projectRoot, "./src/main/frontend/");
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.npmFolder).withFrontendDirectory(faultyFrontendDirectory);
        TaskUpdateThemeImport taskUpdateThemeImportWithNonExistentThemeFolder = new TaskUpdateThemeImport(this.customTheme, options);
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)taskUpdateThemeImportWithNonExistentThemeFolder).execute());
        Assert.assertTrue((boolean)e.getMessage().contains(String.format("Discovered @Theme annotation with theme name '%s', but could not find the theme directory in the project or available as a jar dependency.", CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeWithThemeFolderInFrontend_ensuresThemeGeneratedJsCreatedSuccessfully() throws Exception {
        File themesDir = new File(this.frontendDirectory, "themes");
        File aCustomThemeDir = new File(themesDir, CUSTOM_THEME_NAME);
        boolean customThemeDirCreatedSuccessfully = aCustomThemeDir.mkdirs();
        Assert.assertTrue((String)String.format("%s directory should be created at '%s%s/%s' but failed.", CUSTOM_THEME_NAME, "./src/main/frontend/", "themes", CUSTOM_THEME_NAME), (boolean)customThemeDirCreatedSuccessfully);
        this.assertNoThemeGeneratedDefinitionFilesExist(EMPTY_BEFORE_EXECUTION);
        this.taskUpdateThemeImport.execute();
        this.assertThemeGeneratedDefinitionFilesExist(SHOULD_EXIST_AFTER_EXECUTION);
    }

    @Test
    public void taskExecuted_customThemeWithThemeFolderInMetaInf_ensuresThemeGeneratedJsCreatedSuccessfully() throws Exception {
        File correctMetaInfResourcesDirectory = new File(this.projectRoot, "src/main/resources/META-INF/resources");
        File themesDir = new File(correctMetaInfResourcesDirectory, "themes");
        File aCustomThemeDir = new File(themesDir, CUSTOM_THEME_NAME);
        boolean customThemeDirCreatedSuccessfully = aCustomThemeDir.mkdirs();
        Assert.assertTrue((String)String.format("%s directory should be created at '%s/%s/%s' but failed.", CUSTOM_THEME_NAME, "src/main/resources/META-INF/resources", "themes", CUSTOM_THEME_NAME), (boolean)customThemeDirCreatedSuccessfully);
        this.assertNoThemeGeneratedDefinitionFilesExist(EMPTY_BEFORE_EXECUTION);
        this.taskUpdateThemeImport.execute();
        this.assertThemeGeneratedDefinitionFilesExist(SHOULD_EXIST_AFTER_EXECUTION);
    }

    @Test
    public void taskExecuted_customThemeWithThemeFolderInStatic_ensuresThemeGeneratedJsCreatedSuccessfully() throws Exception {
        File correctStaticResourcesDirectory = new File(this.projectRoot, "src/main/resources/static");
        File themesDir = new File(correctStaticResourcesDirectory, "themes");
        File aCustomThemeDir = new File(themesDir, CUSTOM_THEME_NAME);
        boolean customThemeDirCreatedSuccessfully = aCustomThemeDir.mkdirs();
        Assert.assertTrue((String)String.format("%s directory should be created at '%s/%s/%s' but failed.", CUSTOM_THEME_NAME, "src/main/resources/static", "themes", CUSTOM_THEME_NAME), (boolean)customThemeDirCreatedSuccessfully);
        this.assertNoThemeGeneratedDefinitionFilesExist(EMPTY_BEFORE_EXECUTION);
        this.taskUpdateThemeImport.execute();
        this.assertThemeGeneratedDefinitionFilesExist(SHOULD_EXIST_AFTER_EXECUTION);
    }

    @Test
    public void taskExecuted_customThemeWithThemeFolderInClasspath_ensuresThemeGeneratedJsCreatedSuccessfully() throws Exception {
        File jarResourcesFolder = new File(new File(this.frontendDirectory, "generated/"), "jar-resources");
        File themesDir = new File(jarResourcesFolder, "themes");
        File aCustomThemeDir = new File(themesDir, CUSTOM_THEME_NAME);
        boolean customThemeDirCreatedSuccessfully = aCustomThemeDir.mkdirs();
        Assert.assertTrue((String)String.format("%s directory should be created at '%s' but failed.", CUSTOM_THEME_NAME, aCustomThemeDir), (boolean)customThemeDirCreatedSuccessfully);
        this.assertNoThemeGeneratedDefinitionFilesExist(EMPTY_BEFORE_EXECUTION);
        this.taskUpdateThemeImport.execute();
        this.assertThemeGeneratedDefinitionFilesExist(SHOULD_EXIST_AFTER_EXECUTION);
    }

    @Test
    public void runTaskWithTheme_createsThemeFile_afterRunWithoutTheme_removesThemeFile() throws Exception {
        File themesDir = new File(this.frontendDirectory, "themes");
        File aCustomThemeDir = new File(themesDir, CUSTOM_THEME_NAME);
        boolean customThemeDirCreatedSuccessfully = aCustomThemeDir.mkdirs();
        Assert.assertTrue((String)String.format("%s directory should be created at '%s%s/%s' but failed.", CUSTOM_THEME_NAME, "./src/main/frontend/", "themes", CUSTOM_THEME_NAME), (boolean)customThemeDirCreatedSuccessfully);
        this.assertNoThemeGeneratedDefinitionFilesExist(EMPTY_BEFORE_EXECUTION);
        this.taskUpdateThemeImport.execute();
        this.assertThemeGeneratedDefinitionFilesExist(SHOULD_EXIST_AFTER_EXECUTION);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.npmFolder).withFrontendDirectory(this.frontendDirectory);
        this.taskUpdateThemeImport = new TaskUpdateThemeImport(null, options);
        this.taskUpdateThemeImport.execute();
        this.assertNoThemeGeneratedDefinitionFilesExist("After removal of theme %s should be removed");
    }

    private void assertNoThemeGeneratedDefinitionFilesExist(String errorMessage) {
        Assert.assertFalse((String)String.format(errorMessage, "\"theme.js\""), (boolean)this.themeImportFile.exists());
        Assert.assertFalse((String)String.format(errorMessage, "\theme.d.ts\""), (boolean)this.themeImportTsFile.exists());
    }

    private void assertThemeGeneratedDefinitionFilesExist(String errorMessage) {
        Assert.assertTrue((String)String.format(errorMessage, "\"theme.js\""), (boolean)this.themeImportFile.exists());
        Assert.assertTrue((String)String.format(errorMessage, "\theme.d.ts\""), (boolean)this.themeImportTsFile.exists());
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInBothFrontendAndInClasspath_throwsException() {
        File themeDir = new File(this.frontendDirectory, CUSTOM_THEME_PATH);
        Assert.assertTrue((boolean)themeDir.mkdirs());
        String classPathThemePath = "./src/main/frontend/generated/jar-resources/" + CUSTOM_THEME_PATH;
        File classPathThemeDir = new File(this.projectRoot, classPathThemePath);
        Assert.assertTrue((boolean)classPathThemeDir.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((boolean)e.getMessage().contains(String.format("Theme '%s' should not exist inside a jar and in the project at the same time.", CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInBothMetaInfResourcesAndInClasspath_throwsException() {
        String metaInfResources = String.join((CharSequence)"/", "src/main/resources/META-INF/resources", CUSTOM_THEME_PATH);
        File themeDir = new File(this.projectRoot, metaInfResources);
        Assert.assertTrue((boolean)themeDir.mkdirs());
        String classPathThemePath = "./src/main/frontend/generated/jar-resources/" + CUSTOM_THEME_PATH;
        File classPathThemeDir = new File(this.projectRoot, classPathThemePath);
        Assert.assertTrue((boolean)classPathThemeDir.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((boolean)e.getMessage().contains(String.format("Theme '%s' should not exist inside a jar and in the project at the same time.", CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInBothStaticResourcesAndInClasspath_throwsException() {
        String staticResources = String.join((CharSequence)"/", "src/main/resources/static", CUSTOM_THEME_PATH);
        File themeDir = new File(this.projectRoot, staticResources);
        Assert.assertTrue((boolean)themeDir.mkdirs());
        String classPathThemePath = "./src/main/frontend/generated/jar-resources/" + CUSTOM_THEME_PATH;
        File classPathThemeDir = new File(this.projectRoot, classPathThemePath);
        Assert.assertTrue((boolean)classPathThemeDir.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(String.format("Theme '%s' should not exist inside a jar and in the project at the same time.", CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInBothStaticAndMetaInfResources_throwsException() {
        String staticResources = String.join((CharSequence)"/", "src/main/resources/static", CUSTOM_THEME_PATH);
        File themeDirInStatic = new File(this.projectRoot, staticResources);
        Assert.assertTrue((boolean)themeDirInStatic.mkdirs());
        String metaInfResources = String.join((CharSequence)"/", "src/main/resources/META-INF/resources", CUSTOM_THEME_PATH);
        File themeDirInMetaInf = new File(this.projectRoot, metaInfResources);
        Assert.assertTrue((boolean)themeDirInMetaInf.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((boolean)e.getMessage().contains(String.format("Discovered Theme folder for theme '%s' in more than one place in the project. Please make sure there is only one theme folder with name '%s' exists in the your project. ", CUSTOM_THEME_NAME, CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInBothFrontendAndMetaInfResources_throwsException() {
        File themeDir = new File(this.frontendDirectory, CUSTOM_THEME_PATH);
        Assert.assertTrue((boolean)themeDir.mkdirs());
        String metaInfResources = String.join((CharSequence)"/", "src/main/resources/META-INF/resources", CUSTOM_THEME_PATH);
        File themeDirInMetaInf = new File(this.projectRoot, metaInfResources);
        Assert.assertTrue((boolean)themeDirInMetaInf.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((boolean)e.getMessage().contains(String.format("Discovered Theme folder for theme '%s' in more than one place in the project. Please make sure there is only one theme folder with name '%s' exists in the your project. ", CUSTOM_THEME_NAME, CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInBothFrontendAndStaticResources_throwsException() {
        File themeDir = new File(this.frontendDirectory, CUSTOM_THEME_PATH);
        Assert.assertTrue((boolean)themeDir.mkdirs());
        String staticResources = String.join((CharSequence)"/", "src/main/resources/static", CUSTOM_THEME_PATH);
        File themeDirInStatic = new File(this.projectRoot, staticResources);
        Assert.assertTrue((boolean)themeDirInStatic.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((boolean)e.getMessage().contains(String.format("Discovered Theme folder for theme '%s' in more than one place in the project. Please make sure there is only one theme folder with name '%s' exists in the your project. ", CUSTOM_THEME_NAME, CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInFrontendAndStaticAndMetaInfResources_throwsException() {
        File themeDir = new File(this.frontendDirectory, CUSTOM_THEME_PATH);
        Assert.assertTrue((boolean)themeDir.mkdirs());
        String staticResources = String.join((CharSequence)"/", "src/main/resources/static", CUSTOM_THEME_PATH);
        File themeDirInStatic = new File(this.projectRoot, staticResources);
        Assert.assertTrue((boolean)themeDirInStatic.mkdirs());
        String metaInfResources = String.join((CharSequence)"/", "src/main/resources/META-INF/resources", CUSTOM_THEME_PATH);
        File themeDirInMetaInf = new File(this.projectRoot, metaInfResources);
        Assert.assertTrue((boolean)themeDirInMetaInf.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((boolean)e.getMessage().contains(String.format("Discovered Theme folder for theme '%s' in more than one place in the project. Please make sure there is only one theme folder with name '%s' exists in the your project. ", CUSTOM_THEME_NAME, CUSTOM_THEME_NAME)));
    }

    @Test
    public void taskExecuted_customThemeFolderExistsInClassPathAndStaticAndMetaInfResources_throwsException() {
        String classPathThemePath = "./src/main/frontend/generated/jar-resources/" + CUSTOM_THEME_PATH;
        File classPathThemeDir = new File(this.projectRoot, classPathThemePath);
        Assert.assertTrue((boolean)classPathThemeDir.mkdirs());
        String staticResources = String.join((CharSequence)"/", "src/main/resources/static", CUSTOM_THEME_PATH);
        File themeDirInStatic = new File(this.projectRoot, staticResources);
        Assert.assertTrue((boolean)themeDirInStatic.mkdirs());
        String metaInfResources = String.join((CharSequence)"/", "src/main/resources/META-INF/resources", CUSTOM_THEME_PATH);
        File themeDirInMetaInf = new File(this.projectRoot, metaInfResources);
        Assert.assertTrue((boolean)themeDirInMetaInf.mkdirs());
        ExecutionFailedException e = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskUpdateThemeImport)this.taskUpdateThemeImport).execute());
        Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains(String.format("Theme '%s' should not exist inside a jar and in the project at the same time.", CUSTOM_THEME_NAME)));
    }

    @Test
    public void runTaskWithTheme_noFeatureFlagSet_warningLogged() throws Exception {
        File themesDir = new File(this.frontendDirectory, "themes");
        File aCustomThemeDir = new File(themesDir, CUSTOM_THEME_NAME);
        File components = new File(aCustomThemeDir, "components");
        boolean customThemeDirCreatedSuccessfully = components.mkdirs();
        Assert.assertTrue((String)String.format("%s directory should be created at '%s%s/%s' but failed.", CUSTOM_THEME_NAME, "./src/main/frontend/", "themes", CUSTOM_THEME_NAME), (boolean)customThemeDirCreatedSuccessfully);
        Files.writeString(new File(components, "vaadin-button.css").toPath(), (CharSequence)"{ .button-style: 2px; }", new OpenOption[0]);
        this.taskUpdateThemeImport.execute();
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.atLeastOnce())).warn("Theme '{}' contains component styles, but the '{}' feature flag is not set, so component styles will not be applied for\n{}", new Object[]{CUSTOM_THEME_NAME, FeatureFlags.COMPONENT_STYLE_INJECTION.getId(), "vaadin-button.css"});
    }
}

