/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdateSettingsFile;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class TaskUpdateSettingsFileTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Options options;
    private File buildDirectory;
    private static final Set<String> ABSOLUTE_PATH_ENTRIES = Set.of("frontendFolder", "themeResourceFolder", "staticOutput", "statsOutput", "frontendBundleOutput", "devBundleOutput", "devBundleStatsOutput", "jarResourcesFolder", "clientServiceWorkerSource");

    @Before
    public void setUp() throws IOException {
        ClassFinder finder = (ClassFinder)Mockito.spy((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0]));
        this.buildDirectory = this.temporaryFolder.newFolder("target");
        this.options = new MockOptions(finder, this.temporaryFolder.getRoot()).withBuildDirectory("target").withJarFrontendResourcesFolder(this.temporaryFolder.newFolder("resources"));
    }

    @Test
    public void execute_withWebappResourcesDirectory_useAbsolutePaths() throws IOException {
        this.options.withBuildResultFolders(Paths.get(this.buildDirectory.getPath(), "classes", "META-INF/VAADIN/webapp/").toFile(), Paths.get(this.buildDirectory.getPath(), "classes", "META-INF/VAADIN/").toFile());
        TaskUpdateSettingsFile updateSettings = new TaskUpdateSettingsFile(this.options, "theme", new PwaConfiguration());
        updateSettings.execute();
        JsonNode settingsJson = this.readSettingsFile();
        this.assertPathsMatchProjectFolder(settingsJson);
    }

    @Test
    public void execute_withoutWebappResourcesDirectory_useAbsolutePaths() throws IOException {
        TaskUpdateSettingsFile updateSettings = new TaskUpdateSettingsFile(this.options, "theme", new PwaConfiguration());
        updateSettings.execute();
        JsonNode settingsJson = this.readSettingsFile();
        this.assertPathsMatchProjectFolder(settingsJson);
    }

    private JsonNode readSettingsFile() throws IOException {
        File settings = new File(this.temporaryFolder.getRoot(), "target/vaadin-dev-server-settings.json");
        ObjectNode settingsJson = JacksonUtils.readTree((String)IOUtils.toString((URI)settings.toURI(), (Charset)StandardCharsets.UTF_8));
        return settingsJson;
    }

    private void assertPathsMatchProjectFolder(JsonNode json) {
        ABSOLUTE_PATH_ENTRIES.forEach(key -> {
            String path = json.get(key).asString();
            Assert.assertTrue((String)("Expected '" + key + "' to have an absolute path matching " + this.temporaryFolder.getRoot().getPath() + ", but was " + path), (boolean)Paths.get(path, new String[0]).startsWith(this.temporaryFolder.getRoot().getPath()));
        });
    }
}

