/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
public class TaskUpdatePackagesNpmTest {
    private static final String PLATFORM_DIALOG_VERSION = "2.5.2";
    private static final String USER_SPECIFIED_MIXIN_VERSION = "2.4.1";
    private static final String VAADIN_ELEMENT_MIXIN = "@vaadin/vaadin-element-mixin";
    private static final String VAADIN_DIALOG = "@vaadin/vaadin-dialog";
    private static final String VAADIN_OVERLAY = "@vaadin/vaadin-overlay";
    private static final String REACT_COMPONENTS = "@vaadin/react-components";
    private static final String PLATFORM_ELEMENT_MIXIN_VERSION = "2.4.2";
    private static final String PLATFORM_OVERLAY_VERSION = "3.5.1";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File npmFolder;
    private ClassFinder finder;
    private Logger logger = (Logger)Mockito.spy((Object)LoggerFactory.getLogger(NodeUpdater.class));
    private File generatedPath;
    private File versionJsonFile;
    private File packageJson;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws IOException {
        this.npmFolder = this.temporaryFolder.newFolder();
        this.generatedPath = new File(this.npmFolder, "generated");
        this.generatedPath.mkdir();
        this.versionJsonFile = new File(this.npmFolder, "versions.json");
        this.finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)this.versionJsonFile.toURI().toURL());
        this.packageJson = new File(this.npmFolder, "package.json");
    }

    @Test
    public void npmIsInUse_platformVersionsJsonHasPinnedVersions_versionsArePinned() throws IOException {
        this.runTestWithoutPreexistingPackageJson();
    }

    private void runTestWithoutPreexistingPackageJson() throws IOException {
        this.createBasicVaadinVersionsJson();
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"Updates we're not written", (boolean)task.modified);
        this.verifyVersions(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        this.verifyVersionLockingWithNpmOverrides(true, true, true);
    }

    @Test
    public void npmIsInUse_userHasPinnedPlatformProvidedVersionInPackageJson_userPinnedVersionUsed() throws IOException {
        this.runTestWithoutPreexistingPackageJson();
        ObjectNode packageJsonJson = this.getOrCreatePackageJson();
        ObjectNode dependencies = (ObjectNode)packageJsonJson.get("dependencies");
        dependencies.put(VAADIN_ELEMENT_MIXIN, USER_SPECIFIED_MIXIN_VERSION);
        FileUtils.writeStringToFile((File)new File(this.npmFolder, "package.json"), (String)packageJsonJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"User's updates in package.json should have been noticed.", (boolean)task.modified);
        this.verifyVersions(PLATFORM_DIALOG_VERSION, USER_SPECIFIED_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
    }

    @Test
    public void npmIsInUse_applicationHasPinnedPlatformProvidedVersionInAddon_applicationPinnedVersionIsUsed() throws IOException {
        this.runTestWithoutPreexistingPackageJson();
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        applicationDependencies.put(VAADIN_ELEMENT_MIXIN, USER_SPECIFIED_MIXIN_VERSION);
        TaskUpdatePackages task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"User's added application dependency updates should have been noticed", (boolean)task.modified);
        this.verifyVersions(PLATFORM_DIALOG_VERSION, USER_SPECIFIED_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
    }

    @Test
    public void npmIsInUse_platformVersionIsBumped_versionsAreUpdated() throws IOException {
        this.runTestWithoutPreexistingPackageJson();
        String newVersion = "20.0.0";
        this.createVaadinVersionsJson("20.0.0", "20.0.0", "20.0.0");
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        applicationDependencies.put(VAADIN_DIALOG, "20.0.0");
        TaskUpdatePackages task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions("20.0.0", "20.0.0", "20.0.0");
        this.verifyVersionLockingWithNpmOverrides(true, true, true);
    }

    @Test
    public void npmIsInUse_noPlatformVersionJsonPresent_noFailure() throws IOException {
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn(null);
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)this.versionJsonFile.toURI().toURL());
        JsonNode dependencies = this.getOrCreatePackageJson().get("dependencies");
        Assert.assertEquals((Object)PLATFORM_DIALOG_VERSION, (Object)dependencies.get(VAADIN_DIALOG).asString());
    }

    @Test
    public void npmIsInUse_platformVersionsJsonAdded_versionsPinned() throws IOException {
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn(null);
        this.createTask(this.createApplicationDependencies()).execute();
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)this.versionJsonFile.toURI().toURL());
        String newVersion = "20.0.0";
        this.createVaadinVersionsJson("20.0.0", "20.0.0", "20.0.0");
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        applicationDependencies.put(VAADIN_DIALOG, "20.0.0");
        TaskUpdatePackages task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions("20.0.0", "20.0.0", "20.0.0");
        this.verifyVersionLockingWithNpmOverrides(true, true, true);
    }

    @Test
    public void overridesContainPinnedVersion_platformVersionUpdatedToNewerWhileDependencyAdded_versionGetsReference() throws IOException {
        ObjectNode packageJson = this.getOrCreatePackageJson();
        packageJson.set("overrides", (JsonNode)JacksonUtils.createObjectNode());
        ((ObjectNode)packageJson.get("overrides")).put("@vaadin/aura", "1.0");
        FileUtils.writeStringToFile((File)new File(this.npmFolder, "package.json"), (String)packageJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        JsonNode overrides = this.getOrCreatePackageJson().get("overrides");
        Assert.assertEquals((Object)"1.0", (Object)overrides.get("@vaadin/aura").asString());
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)this.versionJsonFile.toURI().toURL());
        String versionJsonString = "{\n  \"core\": {\n    \"vaadin-aura\": {\n      \"jsVersion\": \"2.0\",\n      \"npmName\": \"@vaadin/aura\"\n    }\n  }\n}\n";
        try {
            FileUtils.write((File)this.versionJsonFile, (CharSequence)versionJsonString, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<String, String> applicationDependencies = Collections.singletonMap("@vaadin/aura", "2.0");
        TaskUpdatePackages task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        overrides = this.getOrCreatePackageJson().get("overrides");
        Assert.assertEquals((Object)"$@vaadin/aura", (Object)overrides.get("@vaadin/aura").asString());
    }

    @Test
    public void pnpmIsInUse_platformVersionsJsonAdded_dependenciesAdded() throws IOException {
        this.verifyPlatformDependenciesAreAdded(true);
    }

    @Test
    public void npmIsInUse_platformVersionsJsonAdded_dependenciesAdded() throws IOException {
        this.verifyPlatformDependenciesAreAdded(false);
    }

    @Test
    public void npmIsInUse_versionJsonHasBadVersion_noFailureNothingAdded() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, "{{{foobar}}");
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, null);
        this.verifyVersionLockingWithNpmOverrides(true, true, false);
    }

    @Test
    public void npmIsInUse_executionAfterDependencyRemoved_overlayIsCleanedOfDependency() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        applicationDependencies.put(VAADIN_ELEMENT_MIXIN, PLATFORM_ELEMENT_MIXIN_VERSION);
        applicationDependencies.put(VAADIN_OVERLAY, PLATFORM_OVERLAY_VERSION);
        TaskUpdatePackages task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersionLockingWithNpmOverrides(true, true, true);
        ObjectNode versions = JacksonUtils.readTree((String)FileUtils.readFileToString((File)this.versionJsonFile, (Charset)StandardCharsets.UTF_8));
        ((ObjectNode)versions.get("core")).remove("vaadin-element-mixin");
        FileUtils.writeStringToFile((File)this.versionJsonFile, (String)versions.toString(), (Charset)StandardCharsets.UTF_8);
        applicationDependencies.remove(VAADIN_ELEMENT_MIXIN);
        task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersionLockingWithNpmOverrides(true, false, true);
    }

    @Test
    public void npmIsInUse_dependencyMovedToDevDependencies_overrideNotRemoved() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        applicationDependencies.put(VAADIN_ELEMENT_MIXIN, PLATFORM_ELEMENT_MIXIN_VERSION);
        applicationDependencies.put(VAADIN_OVERLAY, PLATFORM_OVERLAY_VERSION);
        TaskUpdatePackages task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersionLockingWithNpmOverrides(true, true, true);
        ObjectNode versions = JacksonUtils.readTree((String)FileUtils.readFileToString((File)this.versionJsonFile, (Charset)StandardCharsets.UTF_8));
        ((ObjectNode)versions.get("core")).remove("vaadin-element-mixin");
        FileUtils.writeStringToFile((File)this.versionJsonFile, (String)versions.toString(), (Charset)StandardCharsets.UTF_8);
        ObjectNode packageJson = this.getOrCreatePackageJson();
        ((ObjectNode)packageJson.get("devDependencies")).put(VAADIN_ELEMENT_MIXIN, PLATFORM_ELEMENT_MIXIN_VERSION);
        FileUtils.writeStringToFile((File)this.packageJson, (String)packageJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        applicationDependencies.remove(VAADIN_ELEMENT_MIXIN);
        task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersionLockingWithNpmOverrides(true, true, true);
    }

    @Test
    public void npmIsInUse_versionsJsonHasSnapshotVersions_notAddedToPackageJson() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, "20.0-SNAPSHOT");
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, null);
        this.verifyVersionLockingWithNpmOverrides(true, true, false);
    }

    @Test
    public void npmIsInUse_packageJsonHasNonNumericVersion_versionNotOverridden() throws IOException {
        ObjectNode packageJson = this.getOrCreatePackageJson();
        ObjectNode dependencies = (ObjectNode)packageJson.get("dependencies");
        dependencies.put(VAADIN_ELEMENT_MIXIN, "file:../foobar");
        FileUtils.writeStringToFile((File)new File(this.npmFolder, "package.json"), (String)packageJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        this.createBasicVaadinVersionsJson();
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions(PLATFORM_DIALOG_VERSION, "file:../foobar", PLATFORM_OVERLAY_VERSION);
        this.verifyVersionLockingWithNpmOverrides(true, false, true);
    }

    @Test
    public void missingTypeInPackageJson_typeModuleIsAdded() throws IOException {
        ObjectNode packageJson = this.getOrCreatePackageJson();
        Assert.assertFalse((String)"No type should be available", (boolean)packageJson.has("type"));
        this.createBasicVaadinVersionsJson();
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        packageJson = this.getOrCreatePackageJson();
        Assert.assertTrue((String)"Type should have been addded.", (boolean)packageJson.has("type"));
        Assert.assertEquals((String)"Type should be module", (Object)"module", (Object)packageJson.get("type").asString());
    }

    @Test
    public void faultyTypeInPackageJson_typeModuleIsAdded() throws IOException {
        ObjectNode packageJson = this.getOrCreatePackageJson();
        packageJson.put("type", "commonjs");
        FileUtils.writeStringToFile((File)new File(this.npmFolder, "package.json"), (String)packageJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        this.createBasicVaadinVersionsJson();
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        packageJson = this.getOrCreatePackageJson();
        Assert.assertTrue((String)"Type should not have been removed", (boolean)packageJson.has("type"));
        Assert.assertEquals((String)"Type should have been updated to 'module'", (Object)"module", (Object)packageJson.get("type").asString());
    }

    @Test
    public void npmIsInUse_packageJsonVersionIsUpdated_vaadinSectionIsNotChanged() throws IOException {
        ObjectNode packageJson = this.getOrCreatePackageJson();
        ObjectNode dependencies = (ObjectNode)packageJson.get("dependencies");
        dependencies.put(VAADIN_ELEMENT_MIXIN, "1.2.3");
        ObjectNode vaadinSection = JacksonUtils.createObjectNode();
        ObjectNode vaadinDependencies = JacksonUtils.createObjectNode();
        packageJson.set("vaadin", (JsonNode)vaadinSection);
        vaadinSection.set("dependencies", (JsonNode)vaadinDependencies);
        vaadinDependencies.put(VAADIN_ELEMENT_MIXIN, PLATFORM_ELEMENT_MIXIN_VERSION);
        FileUtils.writeStringToFile((File)new File(this.npmFolder, "package.json"), (String)packageJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        this.createBasicVaadinVersionsJson();
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        JsonNode newVaadinDeps = this.getOrCreatePackageJson().get("vaadin").get("dependencies");
        Assert.assertEquals((Object)PLATFORM_ELEMENT_MIXIN_VERSION, (Object)newVaadinDeps.get(VAADIN_ELEMENT_MIXIN).asString());
    }

    @Test
    public void npmIsInUse_versionsJsonHasVaadinCoreVersionPinned_vaadinCoreVersionIgnored() throws IOException {
        String expectedElementMixinVersion = "21.0.0-alpha2";
        String versionJsonString = "{ \"core\": {\"vaadin-element-mixin\": {\n    \"jsVersion\": \"21.0.0-alpha2\",\n    \"npmName\": \"@vaadin/vaadin-element-mixin\"\n},\n\"vaadin-core\": {\n    \"jsVersion\": \"21.0.0.alpha1\",\n    \"npmName\": \"@vaadin/vaadin-core\"\n}\n}}\n";
        FileUtils.write((File)this.versionJsonFile, (CharSequence)versionJsonString, (Charset)StandardCharsets.UTF_8);
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions(PLATFORM_DIALOG_VERSION, "21.0.0-alpha2", null);
        this.verifyVersionLockingWithNpmOverrides(true, true, false);
        ObjectNode packageJson = this.getOrCreatePackageJson();
        JsonNode dependencies = packageJson.get("dependencies");
        Assert.assertFalse((String)"@vaadin/vaadin-core version should not be written to package.json", (boolean)dependencies.has("@vaadin/vaadin-core"));
        JsonNode vaadinDependencies = packageJson.get("vaadin").get("dependencies");
        Assert.assertFalse((String)"@vaadin/vaadin-core version should not be written to vaadin dependencies in package.json", (boolean)vaadinDependencies.has("@vaadin/vaadin-core"));
    }

    @Test
    public void passUnorderedApplicationDependenciesAndReadUnorderedPackageJson_resultingPackageJsonIsOrdered() throws IOException {
        String key;
        this.createBasicVaadinVersionsJson();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("foo", "bar");
        map.put("baz", "foobar");
        ObjectNode packageJson = this.getOrCreatePackageJson();
        ObjectNode dependencies = (ObjectNode)packageJson.get("dependencies");
        packageJson.remove("dependencies");
        packageJson.put("name", "a");
        packageJson.put("license", "b");
        packageJson.put("version", "c");
        packageJson.put("type", "module");
        LinkedHashSet mainKeys = new LinkedHashSet(JacksonUtils.getKeys((JsonNode)packageJson));
        packageJson.set("dependencies", (JsonNode)dependencies);
        dependencies.put("foo-pack", "bar");
        dependencies.put("baz-pack", "foobar");
        FileUtils.writeStringToFile((File)new File(this.npmFolder, "package.json"), (String)packageJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        TaskUpdatePackages task = this.createTask(map);
        task.execute();
        packageJson = this.getOrCreatePackageJson();
        List list = JacksonUtils.getKeys((JsonNode)packageJson);
        int indexOfOverrides = list.indexOf("overrides");
        if (indexOfOverrides == -1) {
            Assert.assertEquals((long)(list.size() - 1), (long)list.indexOf("vaadin"));
        } else {
            Assert.assertEquals((long)(list.size() - 2), (long)list.indexOf("vaadin"));
        }
        ArrayList<String> keysBeforeDeps = new ArrayList<String>();
        Iterator iterator = JacksonUtils.getKeys((JsonNode)packageJson).iterator();
        while (iterator.hasNext() && !(key = (String)iterator.next()).equals("devDependencies") && !key.equals("dependencies")) {
            if (!mainKeys.contains(key)) continue;
            keysBeforeDeps.add(key);
        }
        Assert.assertArrayEquals((Object[])mainKeys.toArray(), (Object[])keysBeforeDeps.toArray());
        this.checkOrder("dependencies", packageJson.get("dependencies"));
        this.checkOrder("devDependencies", packageJson.get("devDependencies"));
        this.checkOrder("vaadin", packageJson.get("vaadin"));
    }

    private void checkOrder(String path, JsonNode object) {
        List keys = JacksonUtils.getKeys((JsonNode)object);
        if (path.isEmpty()) {
            Assert.assertTrue((String)"Keys in the package Json are not sorted", (boolean)this.isSorted(keys));
        } else {
            Assert.assertTrue((String)("Keys for the object " + path + " in the package Json are not sorted"), (boolean)this.isSorted(keys));
        }
        for (String key : keys) {
            JsonNode value = object.get(key);
            if (!(value instanceof ObjectNode)) continue;
            this.checkOrder(path + "/" + key, value);
        }
    }

    private boolean isSorted(List<String> array) {
        if (array.size() < 2) {
            return true;
        }
        for (int i = 0; i < array.size() - 1; ++i) {
            if (array.get(i).compareTo(array.get(i + 1)) <= 0) continue;
            return false;
        }
        return true;
    }

    @Test
    public void npmIsInUse_versionsJsonContainsSameVersions_nothingIsModified() throws IOException {
        String versionJsonString = "{ \"core\": {\"vaadin-element-mixin\": {\n    \"jsVersion\": \"2.5.2\",\n    \"npmName\": \"@vaadin/vaadin-dialog\"\n}\n}}\n";
        FileUtils.write((File)this.versionJsonFile, (CharSequence)versionJsonString, (Charset)StandardCharsets.UTF_8);
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertTrue((String)"Creation of package.json should be marked with modified", (boolean)task.modified);
        task = this.createTask(this.createApplicationDependencies());
        task.execute();
        Assert.assertFalse((String)"PackageJson modified without changes.", (boolean)task.modified);
    }

    @Test
    public void nonNumericVersionsNotPinned() throws IOException {
        ObjectNode packageJson = this.getOrCreatePackageJson();
        this.createBasicVaadinVersionsJson();
        ObjectNode dependencies = (ObjectNode)packageJson.get("dependencies");
        dependencies.put("localdep", "./localdeps/localdep");
        File file = new File(this.npmFolder, "package.json");
        FileUtils.writeStringToFile((File)file, (String)packageJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        Assert.assertFalse((packageJson.has("overrides") && packageJson.get("overrides").has("localdep") ? 1 : 0) != 0);
        TaskUpdatePackages task = this.createTask(this.createApplicationDependencies());
        task.execute();
        ObjectNode newPackageJson = this.getOrCreatePackageJson();
        Assert.assertFalse((newPackageJson.has("overrides") && newPackageJson.get("overrides").has("localdep") ? 1 : 0) != 0);
    }

    @Test
    public void oldVersionsJson_shouldDowngrade() throws IOException {
        this.runTestWithoutPreexistingPackageJson();
        String oldPlatformVersion = "1.0.0";
        this.createVaadinVersionsJson("1.0.0", "1.0.0", "1.0.0");
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        String appDependencyVersion = "1.5.0";
        applicationDependencies.put(VAADIN_DIALOG, "1.5.0");
        TaskUpdatePackages task = this.createTask(applicationDependencies);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions("1.5.0", "1.0.0", "1.0.0");
        this.verifyVersionLockingWithNpmOverrides(true, true, true);
    }

    @Test
    public void oldVersionsJson_shouldDowngrade_verifyPnpmOverrides() throws IOException {
        this.runTestWithoutPreexistingPackageJson();
        String oldPlatformVersion = "1.0.0";
        this.createVaadinVersionsJson("1.0.0", "1.0.0", "1.0.0");
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        String appDependencyVersion = "1.5.0";
        applicationDependencies.put(VAADIN_DIALOG, "1.5.0");
        TaskUpdatePackages task = this.createTask(applicationDependencies, true);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions("1.5.0", "1.0.0", "1.0.0");
        this.verifyVersionLockingWithPnpmOverrides(true, true, true);
    }

    @Test
    public void npmOverridesExist_customOverridesCopiedOver_verifyPnpmOverrides() throws IOException {
        this.runTestWithoutPreexistingPackageJson();
        String oldPlatformVersion = "1.0.0";
        this.createVaadinVersionsJson("1.0.0", "1.0.0", "1.0.0");
        String CUSTOM_COMPONENT = "@custom/component";
        try {
            ObjectNode versionJson = this.getOrCreatePackageJson();
            if (versionJson.has("overrides")) {
                ((ObjectNode)versionJson.get("overrides")).set(CUSTOM_COMPONENT, JacksonUtils.createNode((Object)"1.2.1"));
            } else {
                ObjectNode npmOverrides = JacksonUtils.createObjectNode();
                npmOverrides.set(CUSTOM_COMPONENT, JacksonUtils.createNode((Object)"1.2.1"));
                versionJson.set("overrides", (JsonNode)npmOverrides);
            }
            FileUtils.write((File)this.packageJson, (CharSequence)versionJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<String, String> applicationDependencies = this.createApplicationDependencies();
        String appDependencyVersion = "1.5.0";
        applicationDependencies.put(VAADIN_DIALOG, "1.5.0");
        TaskUpdatePackages task = this.createTask(applicationDependencies, true);
        task.execute();
        Assert.assertTrue((String)"Updates not picked", (boolean)task.modified);
        this.verifyVersions("1.5.0", "1.0.0", "1.0.0");
        this.verifyVersionLockingWithPnpmOverrides(true, true, true);
        JsonNode pnpm = this.getOrCreatePackageJson().get("pnpm");
        Assert.assertNotNull((String)"Object for 'pnpm' should exist", (Object)pnpm);
        JsonNode overrides = pnpm.get("overrides");
        Assert.assertNotNull((String)"Object for 'overrides' should exist", (Object)overrides);
        Assert.assertTrue((String)"Custom component override was not present", (boolean)overrides.has(CUSTOM_COMPONENT));
        Assert.assertEquals((Object)"1.2.1", (Object)overrides.get(CUSTOM_COMPONENT).asString());
    }

    @Test
    public void reactEnabled_scannerDependencies_coreDependenciesNotAdded() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        FrontendDependencies frontendDependenciesScanner = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        Mockito.when((Object)frontendDependenciesScanner.getPackages()).thenReturn(this.createApplicationDependencies());
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(true);
        TaskUpdatePackages task = new TaskUpdatePackages(this, (FrontendDependenciesScanner)frontendDependenciesScanner, options){};
        task.execute();
        ObjectNode newPackageJson = this.getOrCreatePackageJson();
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
    }

    @Test
    public void reactEnabled_scannerDependenciesAndExclusions_excludedDependenciesNotAdded() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION, Set.of(VAADIN_DIALOG, VAADIN_OVERLAY));
        FrontendDependencies frontendDependenciesScanner = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        Mockito.when((Object)frontendDependenciesScanner.getPackages()).thenReturn(this.createApplicationDependencies());
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(true);
        TaskUpdatePackages task = new TaskUpdatePackages(this, (FrontendDependenciesScanner)frontendDependenciesScanner, options){};
        task.execute();
        ObjectNode newPackageJson = this.getOrCreatePackageJson();
        Assert.assertFalse((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertFalse((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertFalse((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertFalse((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
    }

    @Test
    public void reactEnabled_noScannerDependencies_coreDependenciesNotAdded() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        FrontendDependencies frontendDependenciesScanner = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        Mockito.when((Object)frontendDependenciesScanner.getPackages()).thenReturn(new HashMap());
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(true);
        TaskUpdatePackages task = new TaskUpdatePackages(this, (FrontendDependenciesScanner)frontendDependenciesScanner, options){};
        task.execute();
        ObjectNode newPackageJson = this.getOrCreatePackageJson();
        Assert.assertFalse((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertFalse((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
    }

    @Test
    public void reactDisabled_coreDependenciesAdded() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        FrontendDependencies frontendDependenciesScanner = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        Mockito.when((Object)frontendDependenciesScanner.getPackages()).thenReturn(this.createApplicationDependencies());
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(false);
        TaskUpdatePackages task = new TaskUpdatePackages(this, (FrontendDependenciesScanner)frontendDependenciesScanner, options){};
        task.execute();
        ObjectNode newPackageJson = this.getOrCreatePackageJson();
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_DIALOG) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertTrue((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(VAADIN_OVERLAY) ? 1 : 0) != 0);
        Assert.assertFalse((newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
        Assert.assertFalse((newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(REACT_COMPONENTS) ? 1 : 0) != 0);
    }

    @Test
    public void webComponentsExcluded_reactDisabled_noExclusionsInVersions() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(false).withNpmExcludeWebComponents(true);
        this.execTaskUpdatePackages(this.createApplicationDependencies(), options);
        ObjectNode pkgJson = this.getOrCreatePackageJson();
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        this.execTaskUpdatePackages(new HashMap<String, String>(), options);
        pkgJson = this.getOrCreatePackageJson();
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
    }

    @Test
    public void webComponentsExcluded_reactDisabled_exclusionsInVersions_noWebComponentsIncluded() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION, Set.of(VAADIN_DIALOG));
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(false).withNpmExcludeWebComponents(true);
        this.execTaskUpdatePackages(this.createApplicationDependencies(), options);
        ObjectNode pkgJson = this.getOrCreatePackageJson();
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        this.execTaskUpdatePackages(new HashMap<String, String>(), options);
        pkgJson = this.getOrCreatePackageJson();
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
    }

    @Test
    public void webComponentsExcluded_reactEnabled_noExclusionsInVersions() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(true).withNpmExcludeWebComponents(true);
        this.execTaskUpdatePackages(this.createApplicationDependencies(), options);
        ObjectNode pkgJson = this.getOrCreatePackageJson();
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        this.execTaskUpdatePackages(new HashMap<String, String>(), options);
        pkgJson = this.getOrCreatePackageJson();
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
    }

    @Test
    public void webComponentsExcluded_reactEnabled_exclusionsInVersions_noWebComponentsIncluded() throws IOException {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION, Set.of(VAADIN_DIALOG));
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(false).withBundleBuild(true).withReact(true).withNpmExcludeWebComponents(true);
        this.execTaskUpdatePackages(this.createApplicationDependencies(), options);
        ObjectNode pkgJson = this.getOrCreatePackageJson();
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        this.execTaskUpdatePackages(new HashMap<String, String>(), options);
        pkgJson = this.getOrCreatePackageJson();
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_DIALOG));
        Assert.assertTrue((boolean)this.hasInDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertTrue((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, VAADIN_OVERLAY));
        Assert.assertFalse((boolean)this.hasInDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
        Assert.assertFalse((boolean)this.hasInVaadinDependencies((JsonNode)pkgJson, REACT_COMPONENTS));
    }

    private void execTaskUpdatePackages(Map<String, String> scannedApplicationDependencies, Options options) {
        FrontendDependencies frontendDependenciesScanner = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        Mockito.when((Object)frontendDependenciesScanner.getPackages()).thenReturn(scannedApplicationDependencies);
        TaskUpdatePackages task = new TaskUpdatePackages(this, (FrontendDependenciesScanner)frontendDependenciesScanner, options){};
        task.execute();
    }

    private boolean hasInDependencies(JsonNode newPackageJson, String key) {
        return newPackageJson.has("dependencies") && newPackageJson.get("dependencies").has(key);
    }

    private boolean hasInVaadinDependencies(JsonNode newPackageJson, String key) {
        return newPackageJson.has("vaadin") && newPackageJson.get("vaadin").get("dependencies").has(key);
    }

    private void createBasicVaadinVersionsJson() {
        this.createVaadinVersionsJson(PLATFORM_DIALOG_VERSION, PLATFORM_ELEMENT_MIXIN_VERSION, PLATFORM_OVERLAY_VERSION);
    }

    private void createVaadinVersionsJson(String dialogVersion, String elementMixinVersion, String overlayVersion) {
        this.createVaadinVersionsJson(dialogVersion, elementMixinVersion, overlayVersion, null);
    }

    private void createVaadinVersionsJson(String dialogVersion, String elementMixinVersion, String overlayVersion, Set<String> exclusions) {
        String exclusionsString = exclusions != null ? ",\"exclusions\": [" + exclusions.stream().map(str -> "\"" + str + "\"").collect(Collectors.joining(",")) + "]\n" : "";
        String versionJsonString = "{ \"core\": {\"vaadin-dialog\": {\n   \"component\": true,\n   \"javaVersion\": \"{{version}}\",\n    \"jsVersion\": \"" + dialogVersion + "\",\n    \"npmName\": \"@vaadin/vaadin-dialog\",\n    \"mode\": \"lit\"\n},\n\"vaadin-element-mixin\": {\n    \"jsVersion\": \"" + elementMixinVersion + "\",\n    \"npmName\": \"@vaadin/vaadin-element-mixin\"\n},\n\"vaadin-overlay\": {\n    \"jsVersion\": \"" + overlayVersion + "\",\n    \"npmName\": \"@vaadin/vaadin-overlay\",\n    \"releasenotes\": true\n}},\n\"react\": {\n        \"react-components\": {\n            \"jsVersion\": \"24.4.0-alpha13\",\n            \"npmName\": \"@vaadin/react-components\",\n            \"mode\": \"react\"\n" + exclusionsString + "        }\n    }}\n";
        try {
            FileUtils.write((File)this.versionJsonFile, (CharSequence)versionJsonString, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> createApplicationDependencies() {
        HashMap<String, String> applicationScannedDependencies = new HashMap<String, String>();
        applicationScannedDependencies.put(VAADIN_DIALOG, PLATFORM_DIALOG_VERSION);
        return applicationScannedDependencies;
    }

    private TaskUpdatePackages createTask(Map<String, String> applicationDependencies) {
        return this.createTask(applicationDependencies, false);
    }

    private TaskUpdatePackages createTask(Map<String, String> applicationDependencies, boolean enablePnpm) {
        FrontendDependencies frontendDependenciesScanner = (FrontendDependencies)Mockito.mock(FrontendDependencies.class);
        Mockito.when((Object)frontendDependenciesScanner.getPackages()).thenReturn(applicationDependencies);
        Options options = new MockOptions(this.finder, this.npmFolder).withBuildDirectory("target").withEnablePnpm(enablePnpm).withBundleBuild(true).withReact(false);
        return new TaskUpdatePackages(this, (FrontendDependenciesScanner)frontendDependenciesScanner, options){};
    }

    private ObjectNode getOrCreatePackageJson() throws IOException {
        if (this.packageJson.exists()) {
            return JacksonUtils.readTree((String)FileUtils.readFileToString((File)this.packageJson, (Charset)StandardCharsets.UTF_8));
        }
        ObjectNode packageJsonJson = JacksonUtils.createObjectNode();
        packageJsonJson.set("dependencies", (JsonNode)JacksonUtils.createObjectNode());
        FileUtils.writeStringToFile((File)new File(this.npmFolder, "package.json"), (String)packageJsonJson.toPrettyString(), (Charset)StandardCharsets.UTF_8);
        return packageJsonJson;
    }

    private void verifyVersions(String expectedDialogVersion, String expectedElementMixinVersion, String expectedOverlayVersion) throws IOException {
        JsonNode dependencies = this.getOrCreatePackageJson().get("dependencies");
        if (expectedDialogVersion == null) {
            Assert.assertNull((String)"Dependency added when it should not have been", (Object)dependencies.get(VAADIN_DIALOG));
        } else {
            Assert.assertEquals((Object)expectedDialogVersion, (Object)dependencies.get(VAADIN_DIALOG).asString());
        }
        if (expectedElementMixinVersion == null) {
            Assert.assertNull((String)"Dependency added when it should not have been", (Object)dependencies.get(VAADIN_ELEMENT_MIXIN));
        } else {
            Assert.assertEquals((Object)expectedElementMixinVersion, (Object)dependencies.get(VAADIN_ELEMENT_MIXIN).asString());
        }
        if (expectedOverlayVersion == null) {
            Assert.assertNull((String)"Dependency added when it should not have been", (Object)dependencies.get(VAADIN_OVERLAY));
        } else {
            Assert.assertEquals((Object)expectedOverlayVersion, (Object)dependencies.get(VAADIN_OVERLAY).asString());
        }
    }

    private void verifyVersionLockingWithNpmOverrides(boolean hasDialogLocking, boolean hasElementMixinLocking, boolean hasOverlayLocking) throws IOException {
        JsonNode overrides = this.getOrCreatePackageJson().get("overrides");
        Assert.assertNotNull((String)"Object for 'overrides' should exist", (Object)overrides);
        if (hasDialogLocking) {
            Assert.assertTrue((String)"Dialog override was not present", (boolean)overrides.has(VAADIN_DIALOG));
            Assert.assertEquals((Object)"$@vaadin/vaadin-dialog", (Object)overrides.get(VAADIN_DIALOG).asString());
        } else {
            Assert.assertNull((String)"vaadin-dialog dependency should not be present", (Object)overrides.get(VAADIN_DIALOG));
        }
        if (hasElementMixinLocking) {
            Assert.assertTrue((String)"Element-Mixin override was not present", (boolean)overrides.has(VAADIN_ELEMENT_MIXIN));
            Assert.assertEquals((Object)"$@vaadin/vaadin-element-mixin", (Object)overrides.get(VAADIN_ELEMENT_MIXIN).asString());
        } else {
            Assert.assertNull((String)"vaadin-element-mixin dependency should not be present", (Object)overrides.get(VAADIN_ELEMENT_MIXIN));
        }
        if (hasOverlayLocking) {
            Assert.assertTrue((String)"Overlay override was not present", (boolean)overrides.has(VAADIN_OVERLAY));
            Assert.assertEquals((Object)"$@vaadin/vaadin-overlay", (Object)overrides.get(VAADIN_OVERLAY).asString());
        } else {
            Assert.assertNull((String)"vaadin-overlay dependency should not be present", (Object)overrides.get(VAADIN_OVERLAY));
        }
    }

    private void verifyVersionLockingWithPnpmOverrides(boolean hasDialogLocking, boolean hasElementMixinLocking, boolean hasOverlayLocking) throws IOException {
        JsonNode pnpm = this.getOrCreatePackageJson().get("pnpm");
        Assert.assertNotNull((String)"Object for 'pnpm' should exist", (Object)pnpm);
        JsonNode overrides = pnpm.get("overrides");
        Assert.assertNotNull((String)"Object for 'overrides' should exist", (Object)overrides);
        if (hasDialogLocking) {
            Assert.assertTrue((String)"Dialog override was not present", (boolean)overrides.has(VAADIN_DIALOG));
            Assert.assertEquals((Object)"$@vaadin/vaadin-dialog", (Object)overrides.get(VAADIN_DIALOG).asString());
        } else {
            Assert.assertNull((String)"vaadin-dialog dependency should not be present", (Object)overrides.get(VAADIN_DIALOG));
        }
        if (hasElementMixinLocking) {
            Assert.assertTrue((String)"Element-Mixin override was not present", (boolean)overrides.has(VAADIN_ELEMENT_MIXIN));
            Assert.assertEquals((Object)"$@vaadin/vaadin-element-mixin", (Object)overrides.get(VAADIN_ELEMENT_MIXIN).asString());
        } else {
            Assert.assertNull((String)"vaadin-element-mixin dependency should not be present", (Object)overrides.get(VAADIN_ELEMENT_MIXIN));
        }
        if (hasOverlayLocking) {
            Assert.assertTrue((String)"Overlay override was not present", (boolean)overrides.has(VAADIN_OVERLAY));
            Assert.assertEquals((Object)"$@vaadin/vaadin-overlay", (Object)overrides.get(VAADIN_OVERLAY).asString());
        } else {
            Assert.assertNull((String)"vaadin-overlay dependency should not be present", (Object)overrides.get(VAADIN_OVERLAY));
        }
    }

    private void verifyPlatformDependenciesAreAdded(boolean enablePnpm) throws IOException {
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)this.versionJsonFile.toURI().toURL());
        String newVersion = "20.0.0";
        this.createVaadinVersionsJson("20.0.0", "20.0.0", "20.0.0");
        Map<String, String> applicationDependencies = Collections.emptyMap();
        TaskUpdatePackages task = this.createTask(applicationDependencies, enablePnpm);
        this.verifyVersions(null, null, null);
        task.execute();
        this.verifyVersions("20.0.0", "20.0.0", "20.0.0");
    }
}

