/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskRunNpmInstallTest;
import com.vaadin.flow.server.frontend.VersionsJsonFilter;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.testcategory.SlowTests;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@NotThreadSafe
@Category(value={SlowTests.class})
public class TaskRunPnpmInstallTest
extends TaskRunNpmInstallTest {
    private static final String PINNED_VERSION = "3.2.17";
    private static final List<String> POSTINSTALL_PACKAGES = Collections.singletonList("esbuild");

    @Override
    @Before
    public void setUp() throws IOException, NoSuchFieldException {
        super.setUp();
        FileUtils.write((File)new File(this.npmFolder, "package.json"), (CharSequence)"{}", (Charset)StandardCharsets.UTF_8);
    }

    @Override
    @Test
    public void runNpmInstall_toolIsChanged_nodeModulesIsRemoved() throws ExecutionFailedException, IOException {
        File nodeModules = this.options.getNodeModulesFolder();
        FileUtils.forceMkdir((File)nodeModules);
        File fakeFile = new File(nodeModules, ".fake.file");
        fakeFile.createNewFile();
        this.getNodeUpdater().modified = true;
        this.createTask().execute();
        Assert.assertFalse((boolean)fakeFile.exists());
    }

    @Override
    @Test
    public void runNpmInstall_toolIsNotChanged_nodeModulesIsNotRemoved() throws ExecutionFailedException, IOException {
        File packageJson = new File(this.npmFolder, "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\"dependencies\": {\"pnpm\": \"5.15.1\"}}", (Charset)StandardCharsets.UTF_8);
        this.getNodeUpdater().modified = true;
        this.createTask().execute();
        File fakeFile = new File(this.options.getNodeModulesFolder(), ".fake.file");
        fakeFile.createNewFile();
        this.getNodeUpdater().modified = true;
        this.createTask().execute();
        Assert.assertTrue((boolean)fakeFile.exists());
    }

    @Test
    public void generateVersionsJson_userHasNoCustomVersions_platformIsMergedWithDevDeps() throws IOException {
        File packageJson = new File(this.npmFolder, "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{}", (Charset)StandardCharsets.UTF_8);
        File versions = this.temporaryFolder.newFile();
        FileUtils.write((File)versions, (CharSequence)String.format("{\"vaadin-overlay\": {\"npmName\": \"@vaadin/vaadin-overlay\",\"jsVersion\": \"%s\"}}", PINNED_VERSION), (Charset)StandardCharsets.UTF_8);
        JsonNode object = this.getGeneratedVersionsContent(versions, packageJson);
        Assert.assertTrue((boolean)object.has("@vaadin/vaadin-overlay"));
        Assert.assertEquals((Object)PINNED_VERSION, (Object)object.get("@vaadin/vaadin-overlay").asString());
    }

    @Test
    public void generateVersionsJson_userDefinedVersions_versionOnlyPinnedForNotAddedDependencies() throws IOException {
        File packageJson = new File(this.npmFolder, "package.json");
        packageJson.createNewFile();
        String loginVersion = "1.1.0-alpha1";
        String menuVersion = "1.1.0-alpha2";
        String notificationVersion = "1.4.0";
        String uploadVersion = "4.2.0";
        FileUtils.write((File)packageJson, (CharSequence)String.format("{\"vaadin\": {\"dependencies\": {\"@vaadin/vaadin-login\": \"%s\",\"@vaadin/vaadin-menu-bar\": \"%s\",\"@vaadin/vaadin-notification\": \"%s\",\"@vaadin/vaadin-upload\": \"%s\"}},\"dependencies\": {\"@vaadin/vaadin-login\": \"%s\",\"@vaadin/vaadin-menu-bar\": \"%s\",\"@vaadin/vaadin-notification\": \"%s\",\"@vaadin/vaadin-upload\": \"%s\"}}", loginVersion, "1.0.0", notificationVersion, "4.0.0", loginVersion, menuVersion, notificationVersion, uploadVersion), (Charset)StandardCharsets.UTF_8);
        String versionsLoginVersion = "1.1.0-alpha1";
        String versionsMenuBarVersion = "1.1.0-alpha1";
        String versionsNotificationVersion = "1.5.0-alpha1";
        String versionsUploadVersion = "4.2.0-beta2";
        File versions = this.temporaryFolder.newFile();
        FileUtils.write((File)versions, (CharSequence)String.format("{\"vaadin-login\": {\"npmName\": \"@vaadin/vaadin-login\",\"jsVersion\": \"%s\"},\"vaadin-menu-bar\": {\"npmName\": \"@vaadin/vaadin-menu-bar\",\"jsVersion\": \"%s\"},\"vaadin-notification\": {\"npmName\": \"@vaadin/vaadin-notification\",\"jsVersion\": \"%s\"},\"vaadin-upload\": {\"npmName\": \"@vaadin/vaadin-upload\",\"jsVersion\": \"%s\"}}", versionsLoginVersion, versionsMenuBarVersion, versionsNotificationVersion, versionsUploadVersion), (Charset)StandardCharsets.UTF_8);
        JsonNode generatedVersions = this.getGeneratedVersionsContent(versions, packageJson);
        Assert.assertEquals((String)"Login version is the same for user and platform.", (Object)loginVersion, (Object)generatedVersions.get("@vaadin/vaadin-login").asString());
        Assert.assertEquals((String)"Notification version should use platform", (Object)versionsNotificationVersion, (Object)generatedVersions.get("@vaadin/vaadin-notification").asString());
    }

    @Test
    public void runPnpmInstall_npmRcFileNotFound_newNpmRcFileIsGenerated() throws IOException, ExecutionFailedException {
        TaskRunNpmInstall task = this.createTask();
        task.execute();
        File npmRcFile = new File(this.npmFolder, ".npmrc");
        Assert.assertTrue((boolean)npmRcFile.exists());
        String content = FileUtils.readFileToString((File)npmRcFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)content.contains("shamefully-hoist"));
    }

    @Test
    public void runPnpmInstall_npmRcFileGeneratedByVaadinFound_npmRcFileIsGenerated() throws IOException, ExecutionFailedException {
        File oldNpmRcFile = new File(this.npmFolder, ".npmrc");
        String originalContent = "# NOTICE: this is an auto-generated file\nshamefully-hoist=true\nsymlink=true\n";
        FileUtils.writeStringToFile((File)oldNpmRcFile, (String)originalContent, (Charset)StandardCharsets.UTF_8);
        TaskRunNpmInstall task = this.createTask();
        task.execute();
        File newNpmRcFile = new File(this.npmFolder, ".npmrc");
        Assert.assertTrue((boolean)newNpmRcFile.exists());
        String content = FileUtils.readFileToString((File)newNpmRcFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)content.contains("shamefully-hoist"));
        Assert.assertFalse((boolean)content.contains("symlink=true"));
    }

    @Test
    public void runPnpmInstall_customNpmRcFileFound_npmRcFileIsNotGenerated() throws IOException, ExecutionFailedException {
        File oldNpmRcFile = new File(this.npmFolder, ".npmrc");
        String originalContent = "# A custom npmrc file for my project\nsymlink=true\n";
        FileUtils.writeStringToFile((File)oldNpmRcFile, (String)originalContent, (Charset)StandardCharsets.UTF_8);
        TaskRunNpmInstall task = this.createTask();
        task.execute();
        File newNpmRcFile = new File(this.npmFolder, ".npmrc");
        Assert.assertTrue((boolean)newNpmRcFile.exists());
        String content = FileUtils.readFileToString((File)newNpmRcFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)originalContent, (Object)content);
    }

    @Test
    public void runPnpmInstall_userVersionNewerThanPinned_installedOverlayVersionIsNotSpecifiedByPlatform() throws IOException, ExecutionFailedException {
        File packageJson = new File(this.npmFolder, "package.json");
        packageJson.createNewFile();
        String customOverlayVersion = "3.3.0";
        String packageJsonContent = "{\"dependencies\": {\"@vaadin/vaadin-dialog\": \"2.3.0\",\"@vaadin/vaadin-overlay\": \"3.3.0\"}}";
        FileUtils.write((File)packageJson, (CharSequence)"{\"dependencies\": {\"@vaadin/vaadin-dialog\": \"2.3.0\",\"@vaadin/vaadin-overlay\": \"3.3.0\"}}", (Charset)StandardCharsets.UTF_8);
        VersionsJsonFilter versionsJsonFilter = new VersionsJsonFilter(JacksonUtils.readTree((String)"{\"dependencies\": {\"@vaadin/vaadin-dialog\": \"2.3.0\",\"@vaadin/vaadin-overlay\": \"3.3.0\"}}"), "dependencies");
        TaskRunNpmInstall task = this.createTask(versionsJsonFilter.getFilteredVersions(JacksonUtils.readTree((String)"{ \"@vaadin/vaadin-overlay\":\"3.2.17\"}"), "test-versions.json").toString());
        task.execute();
        File overlayPackageJson = new File(this.options.getNodeModulesFolder(), "@vaadin/vaadin-overlay/package.json");
        ObjectNode overlayPackage = JacksonUtils.readTree((String)FileUtils.readFileToString((File)overlayPackageJson, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"3.3.0", (Object)overlayPackage.get("version").asString());
    }

    @Test
    public void runPnpmInstall_postInstall_runOnlyForDefaultPackages() throws ExecutionFailedException, IOException {
        this.setupEsbuildAndFooInstallation();
        TaskRunNpmInstall task = this.createTask();
        task.execute();
        Assert.assertTrue((String)"Postinstall for 'esbuild' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "esbuild"), "postinstall-file.txt").exists());
        Assert.assertFalse((String)"Postinstall for 'foo' should not have been run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "foo"), "postinstall-file.txt").exists());
    }

    @Test
    public void runPnpmInstall_postInstall_runForDefinedAdditionalPackages() throws ExecutionFailedException, IOException {
        this.setupEsbuildAndFooInstallation();
        TaskRunNpmInstall task = this.createTask(Collections.singletonList("foo"));
        task.execute();
        Assert.assertTrue((String)"Postinstall for 'esbuild' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "esbuild"), "postinstall-file.txt").exists());
        Assert.assertTrue((String)"Postinstall for 'foo' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "foo"), "postinstall-file.txt").exists());
    }

    @Override
    @Test(timeout=30000L)
    public void runNpmInstall_postInstallWritingLotsOfOutput_processDoesNotStuck() throws ExecutionFailedException, IOException {
        this.setupEsbuildAndFooInstallation();
        File nodeModules = this.options.getNodeModulesFolder();
        File fooPackageJson = new File(new File(nodeModules.getParentFile(), "fake-foo"), "package.json");
        String fooPackageJsonContents = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fake-package-with-postinstall-writing-to-console.json"), (Charset)StandardCharsets.UTF_8);
        FileUtils.write((File)fooPackageJson, (CharSequence)fooPackageJsonContents, (Charset)StandardCharsets.UTF_8);
        TaskRunNpmInstall task = this.createTask(Collections.singletonList("foo"));
        task.execute();
        Assert.assertTrue((String)"Postinstall for 'foo' was not run", (boolean)new File(new File(this.options.getNodeModulesFolder(), "foo"), "postinstall-console-file.txt").exists());
    }

    @Test
    public void runPnpmInstallAndCi_emptyDir_pnpmInstallAndCiIsExecuted() throws ExecutionFailedException, IOException {
        TaskRunNpmInstall task = this.createTask();
        File nodeModules = this.options.getNodeModulesFolder();
        nodeModules.mkdir();
        this.getNodeUpdater().modified = false;
        task.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
        this.deleteDirectory(nodeModules);
        TaskRunNpmInstall ciTask = this.createCiTask();
        ciTask.execute();
        ((Logger)Mockito.verify((Object)this.logger)).info(this.getRunningMsg());
    }

    @Override
    protected String getToolName() {
        return "pnpm";
    }

    protected TaskRunNpmInstall createTask() {
        return this.createTask(new ArrayList<String>());
    }

    private TaskRunNpmInstall createCiTask() {
        NodeUpdater updater = this.getNodeUpdater();
        this.options.withEnablePnpm(true).withNodeVersion("v24.12.0").withNodeDownloadRoot(URI.create("https://nodejs.org/dist/")).withCiBuild(true);
        return new TaskRunNpmInstall(updater, this.options);
    }

    @Override
    protected TaskRunNpmInstall createTask(List<String> additionalPostInstall) {
        NodeUpdater updater = this.createAndRunNodeUpdater(null);
        this.options.withEnablePnpm(true).withNodeVersion("v24.12.0").withNodeDownloadRoot(URI.create("https://nodejs.org/dist/")).withPostinstallPackages(additionalPostInstall);
        return new TaskRunNpmInstall(updater, this.options);
    }

    protected TaskRunNpmInstall createTask(String versionsContent) {
        NodeUpdater updater = this.createAndRunNodeUpdater(versionsContent);
        this.options.withEnablePnpm(true).withNodeVersion("v24.12.0").withNodeDownloadRoot(URI.create("https://nodejs.org/dist/"));
        return new TaskRunNpmInstall(updater, this.options);
    }

    private JsonNode getGeneratedVersionsContent(File versions, File packageJsonFile) throws IOException {
        ClassFinder classFinder = this.getClassFinder();
        Mockito.when((Object)classFinder.getResource("vaadin-core-versions.json")).thenReturn((Object)versions.toURI().toURL());
        ObjectNode packageJson = JacksonUtils.readTree((String)FileUtils.readFileToString((File)packageJsonFile, (Charset)StandardCharsets.UTF_8));
        this.getNodeUpdater().generateVersionsJson(packageJson);
        return this.getNodeUpdater().versionsJson;
    }

    private NodeUpdater createAndRunNodeUpdater(String versionsContent) {
        NodeUpdater nodeUpdater = this.createNodeUpdater(versionsContent);
        try {
            nodeUpdater.execute();
        }
        catch (Exception e) {
            throw new IllegalStateException("NodeUpdater failed to genereate the versions.json file");
        }
        return nodeUpdater;
    }

    private NodeUpdater createNodeUpdater(final String versionsContent) {
        this.options.withBuildDirectory("target");
        return new NodeUpdater((FrontendDependenciesScanner)Mockito.mock(FrontendDependencies.class), this.options){

            public void execute() {
                try {
                    this.generateVersionsJson(JacksonUtils.createObjectNode());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            ObjectNode getPlatformPinnedDependencies() {
                if (versionsContent != null) {
                    return JacksonUtils.readTree((String)versionsContent);
                }
                return JacksonUtils.createObjectNode();
            }

            Logger log() {
                return TaskRunPnpmInstallTest.this.logger;
            }
        };
    }
}

