/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskRemoveOldFrontendGeneratedFiles;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskRemoveOldFrontendGeneratedFilesTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File generatedFolder;
    private Options options;

    @Before
    public void setUp() throws Exception {
        this.options = new MockOptions(this.temporaryFolder.getRoot());
        this.generatedFolder = this.options.getFrontendGeneratedFolder();
    }

    @Test
    public void execute_shouldDeleteNotGenerateFrontedFiles() throws Exception {
        TaskRemoveOldFrontendGeneratedFiles task = new TaskRemoveOldFrontendGeneratedFiles(this.options);
        GeneratedFilesSupport support = new GeneratedFilesSupport();
        File file1 = new File(this.generatedFolder, "test.txt");
        File file2 = this.generatedFolder.toPath().resolve(Path.of("a", "b", "c.txt")).toFile();
        File file3 = this.generatedFolder.toPath().resolve(Path.of("a", "z", "n.txt")).toFile();
        File file4 = this.generatedFolder.toPath().resolve(Path.of("a", "z", "y.txt")).toFile();
        support.writeIfChanged(file1, "TEST");
        support.writeIfChanged(file2, "TEST");
        support.writeIfChanged(file3, "TEST");
        support.writeIfChanged(file4, "TEST");
        task.setGeneratedFileSupport(support);
        task.execute();
        this.assertOnlyExpectedGeneratedFilesExists(file1, file2, file3, file4);
        task = new TaskRemoveOldFrontendGeneratedFiles(this.options);
        support = new GeneratedFilesSupport();
        support.writeIfChanged(file2, "TEST");
        support.writeIfChanged(file4, "TEST");
        task.setGeneratedFileSupport(support);
        task.execute();
        this.assertOnlyExpectedGeneratedFilesExists(file2, file4);
    }

    @Test
    public void execute_existingFiles_nothingTracked_deleteAll() throws Exception {
        for (File file : Set.of(new File(this.generatedFolder, "test.txt"), this.generatedFolder.toPath().resolve(Path.of("a", "b", "c.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "n.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "y.txt")).toFile())) {
            file.getParentFile().mkdirs();
            Files.writeString(file.toPath(), (CharSequence)"TEST", new OpenOption[0]);
        }
        TaskRemoveOldFrontendGeneratedFiles task = new TaskRemoveOldFrontendGeneratedFiles(this.options);
        task.setGeneratedFileSupport(new GeneratedFilesSupport());
        task.execute();
        Assert.assertFalse((String)"Generated folder has not been deleted", (boolean)this.generatedFolder.exists());
    }

    @Test
    public void execute_frontendGeneratedFolderNotExistsAtTaskCreation_nothingIsDeleted() throws Exception {
        Files.deleteIfExists(this.generatedFolder.toPath());
        TaskRemoveOldFrontendGeneratedFiles task = new TaskRemoveOldFrontendGeneratedFiles(this.options);
        this.generatedFolder.mkdirs();
        Set<File> files = Set.of(new File(this.generatedFolder, "test.txt"), this.generatedFolder.toPath().resolve(Path.of("a", "b", "c.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "n.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "y.txt")).toFile());
        for (File file : files) {
            file.getParentFile().mkdirs();
            Files.writeString(file.toPath(), (CharSequence)"TEST", new OpenOption[0]);
        }
        task.setGeneratedFileSupport(new GeneratedFilesSupport());
        task.execute();
        this.assertOnlyExpectedGeneratedFilesExists((File[])files.toArray(File[]::new));
    }

    @Test
    public void execute_missingGeneratedFileSupport_nothingIsDeleted() throws Exception {
        Set<File> files = Set.of(new File(this.generatedFolder, "test.txt"), this.generatedFolder.toPath().resolve(Path.of("a", "b", "c.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "n.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "y.txt")).toFile());
        for (File file : files) {
            file.getParentFile().mkdirs();
            Files.writeString(file.toPath(), (CharSequence)"TEST", new OpenOption[0]);
        }
        TaskRemoveOldFrontendGeneratedFiles task = new TaskRemoveOldFrontendGeneratedFiles(this.options);
        task.setGeneratedFileSupport(null);
        task.execute();
        this.assertOnlyExpectedGeneratedFilesExists((File[])files.toArray(File[]::new));
    }

    @Test
    public void execute_knownFiles_notDeleted() throws Exception {
        Set<File> knownFiles = Set.of(this.generatedFolder.toPath().resolve(Path.of("flow", "generated-flow-imports.js")).toFile(), this.generatedFolder.toPath().resolve(Path.of("flow", "generated-flow-imports.d.ts")).toFile(), this.generatedFolder.toPath().resolve(Path.of("flow", "generated-flow-webcomponent-imports.js")).toFile(), new File(this.generatedFolder, "routes.tsx"), new File(this.generatedFolder, "routes.ts"), this.generatedFolder.toPath().resolve(Path.of("flow", "Flow.tsx")).toFile(), new File(this.generatedFolder, "file-routes.ts"), new File(this.generatedFolder, "css.generated.js"), new File(this.generatedFolder, "css.generated.d.ts"));
        for (File file : knownFiles) {
            file.getParentFile().mkdirs();
            Files.writeString(file.toPath(), (CharSequence)"TEST", new OpenOption[0]);
        }
        TaskRemoveOldFrontendGeneratedFiles task = new TaskRemoveOldFrontendGeneratedFiles(this.options);
        task.setGeneratedFileSupport(new GeneratedFilesSupport());
        task.execute();
        this.assertOnlyExpectedGeneratedFilesExists((File[])knownFiles.toArray(File[]::new));
    }

    @Test
    public void execute_entriesInGeneratedFileList_notDeleted() throws Exception {
        HashSet<File> generatedFiles = new HashSet<File>(Set.of(new File(this.generatedFolder, "test.txt"), this.generatedFolder.toPath().resolve(Path.of("a", "b", "c.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "n.txt")).toFile(), this.generatedFolder.toPath().resolve(Path.of("a", "z", "y.txt")).toFile()));
        for (File file2 : generatedFiles) {
            file2.getParentFile().mkdirs();
            Files.writeString(file2.toPath(), (CharSequence)"TEST", new OpenOption[0]);
        }
        File generatedFilesList = new File(this.generatedFolder, "generated-file-list.txt");
        Files.writeString(generatedFilesList.toPath(), (CharSequence)generatedFiles.stream().map(file -> this.generatedFolder.toPath().relativize(file.toPath())).map(Path::toString).collect(Collectors.joining(System.lineSeparator())), new OpenOption[0]);
        generatedFiles.add(generatedFilesList);
        TaskRemoveOldFrontendGeneratedFiles task = new TaskRemoveOldFrontendGeneratedFiles(this.options);
        task.setGeneratedFileSupport(new GeneratedFilesSupport());
        task.execute();
        this.assertOnlyExpectedGeneratedFilesExists((File[])generatedFiles.toArray(File[]::new));
    }

    private void assertOnlyExpectedGeneratedFilesExists(File ... expectedFiles) throws IOException {
        AccumulatorPathVisitor visitor = new AccumulatorPathVisitor();
        Files.walkFileTree(this.generatedFolder.toPath(), (FileVisitor<? super Path>)visitor);
        Assert.assertEquals((String)"Expect exactly currently generated files to exists", Stream.of(expectedFiles).map(f -> this.generatedFolder.toPath().relativize(f.toPath())).collect(Collectors.toSet()), Set.copyOf(visitor.relativizeFiles(this.generatedFolder.toPath(), false, null)));
    }
}

