/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskProcessStylesheetCss;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskProcessStylesheetCssTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File metaInfResources;
    private Options options;
    private ClassFinder classFinder;

    @Before
    public void setup() throws IOException {
        File buildOutput = this.temporaryFolder.newFolder(new String[]{"target", "classes"});
        File metaInf = new File(buildOutput, "META-INF");
        this.metaInfResources = new File(metaInf, "resources");
        this.metaInfResources.mkdirs();
        this.classFinder = (ClassFinder)Mockito.mock(ClassFinder.class);
        this.options = (Options)Mockito.mock(Options.class);
        Mockito.when((Object)this.options.isProductionMode()).thenReturn((Object)true);
        Mockito.when((Object)this.options.getMetaInfResourcesDirectory()).thenReturn((Object)this.metaInfResources);
        Mockito.when((Object)this.options.getClassFinder()).thenReturn((Object)this.classFinder);
    }

    @Test
    public void execute_processesAndMinifiesCssFiles() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithStyleSheet.class));
        String originalCss = "/* A comment */\n.class {\n    color: red;\n}\n";
        File cssFile = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)cssFile, (String)originalCss, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(cssFile.toPath());
        Assert.assertEquals((Object)".class{color: red}", (Object)processedCss);
    }

    @Test
    public void execute_inlinesImports() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithStyleSheet.class));
        String mainCss = "@import 'other.css';\n.main { color: red; }";
        String otherCss = ".other { color: blue; }";
        File mainFile = new File(this.metaInfResources, "styles.css");
        File otherFile = new File(this.metaInfResources, "other.css");
        FileUtils.writeStringToFile((File)mainFile, (String)mainCss, (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)otherFile, (String)otherCss, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(mainFile.toPath());
        Assert.assertTrue((boolean)processedCss.contains(".other{color: blue}"));
        Assert.assertTrue((boolean)processedCss.contains(".main{color: red}"));
    }

    @Test
    public void execute_processesNestedDirectories() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithNestedStyleSheet.class));
        File subDir = new File(this.metaInfResources, "sub");
        subDir.mkdirs();
        String css = ".nested { color: green; }";
        File cssFile = new File(subDir, "nested.css");
        FileUtils.writeStringToFile((File)cssFile, (String)css, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(cssFile.toPath());
        Assert.assertEquals((Object)".nested{color: green}", (Object)processedCss);
    }

    @Test
    public void execute_skipsNonProductionMode() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.options.isProductionMode()).thenReturn((Object)false);
        String originalCss = "/* comment */ .class { color: red; }";
        File cssFile = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)cssFile, (String)originalCss, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(cssFile.toPath());
        Assert.assertEquals((Object)originalCss, (Object)processedCss);
    }

    @Test
    public void execute_skipsExternalStylesheets() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithExternalStyleSheet.class));
        String originalCss = "/* comment */ .class { color: red; }";
        File cssFile = new File(this.metaInfResources, "local.css");
        FileUtils.writeStringToFile((File)cssFile, (String)originalCss, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(cssFile.toPath());
        Assert.assertEquals((Object)originalCss, (Object)processedCss);
    }

    @Test
    public void execute_skipsUnreferencedCssFiles() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithStyleSheet.class));
        File referencedCss = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)referencedCss, (String)"/* comment */ .ref { }", (Charset)StandardCharsets.UTF_8);
        String unreferencedOriginal = "/* comment */ .unref { color: red; }";
        File unreferencedCss = new File(this.metaInfResources, "unreferenced.css");
        FileUtils.writeStringToFile((File)unreferencedCss, (String)unreferencedOriginal, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String unreferencedProcessed = Files.readString(unreferencedCss.toPath());
        Assert.assertEquals((Object)unreferencedOriginal, (Object)unreferencedProcessed);
        String referencedProcessed = Files.readString(referencedCss.toPath());
        Assert.assertEquals((Object)".ref{}", (Object)referencedProcessed);
    }

    @Test
    public void execute_handlesNoAnnotations() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Collections.emptySet());
        String originalCss = "/* comment */ .class { color: red; }";
        File cssFile = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)cssFile, (String)originalCss, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(cssFile.toPath());
        Assert.assertEquals((Object)originalCss, (Object)processedCss);
    }

    @Test
    public void execute_handlesNullClassFinder() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.options.getClassFinder()).thenReturn(null);
        String originalCss = "/* comment */ .class { color: red; }";
        File cssFile = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)cssFile, (String)originalCss, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(cssFile.toPath());
        Assert.assertEquals((Object)originalCss, (Object)processedCss);
    }

    @Test
    public void execute_handlesMissingDirectory() throws ExecutionFailedException, IOException {
        FileUtils.deleteDirectory((File)this.metaInfResources);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
    }

    @Test
    public void execute_handlesNullResourceOutputDirectory() throws ExecutionFailedException {
        Mockito.when((Object)this.options.getResourceOutputDirectory()).thenReturn(null);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
    }

    @Test
    public void execute_inlinesNodeModulesImports() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithStyleSheet.class));
        File nodeModules = this.temporaryFolder.newFolder("node_modules");
        File packageDir = new File(nodeModules, "some-package");
        packageDir.mkdirs();
        File nodeModulesCss = new File(packageDir, "styles.css");
        FileUtils.writeStringToFile((File)nodeModulesCss, (String)".from-node-modules { color: blue; }", (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.options.getNodeModulesFolder()).thenReturn((Object)nodeModules);
        String mainCss = "@import 'some-package/styles.css';\n.main { color: red; }";
        File mainFile = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)mainFile, (String)mainCss, (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        String processedCss = Files.readString(mainFile.toPath());
        Assert.assertTrue((String)"Should contain inlined node_modules CSS", (boolean)processedCss.contains(".from-node-modules{color: blue}"));
        Assert.assertTrue((String)"Should contain main CSS", (boolean)processedCss.contains(".main{color: red}"));
    }

    @Test
    public void execute_processesMultipleAnnotatedClasses() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithStyleSheet.class, TestClassWithNestedStyleSheet.class));
        File stylesFile = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)stylesFile, (String)"/* comment */ .styles { }", (Charset)StandardCharsets.UTF_8);
        File subDir = new File(this.metaInfResources, "sub");
        subDir.mkdirs();
        File nestedFile = new File(subDir, "nested.css");
        FileUtils.writeStringToFile((File)nestedFile, (String)"/* comment */ .nested { }", (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        Assert.assertEquals((Object)".styles{}", (Object)Files.readString(stylesFile.toPath()));
        Assert.assertEquals((Object)".nested{}", (Object)Files.readString(nestedFile.toPath()));
    }

    @Test
    public void execute_handlesRepeatedAnnotations() throws ExecutionFailedException, IOException {
        Mockito.when((Object)this.classFinder.getAnnotatedClasses(StyleSheet.class)).thenReturn(Set.of(TestClassWithMultipleStyleSheets.class));
        File stylesFile = new File(this.metaInfResources, "styles.css");
        FileUtils.writeStringToFile((File)stylesFile, (String)"/* comment */ .styles { }", (Charset)StandardCharsets.UTF_8);
        File otherFile = new File(this.metaInfResources, "other.css");
        FileUtils.writeStringToFile((File)otherFile, (String)"/* comment */ .other { }", (Charset)StandardCharsets.UTF_8);
        TaskProcessStylesheetCss task = new TaskProcessStylesheetCss(this.options);
        task.execute();
        Assert.assertEquals((Object)".styles{}", (Object)Files.readString(stylesFile.toPath()));
        Assert.assertEquals((Object)".other{}", (Object)Files.readString(otherFile.toPath()));
    }

    @StyleSheet(value="./styles.css")
    private static class TestClassWithStyleSheet {
        private TestClassWithStyleSheet() {
        }
    }

    @StyleSheet(value="./sub/nested.css")
    private static class TestClassWithNestedStyleSheet {
        private TestClassWithNestedStyleSheet() {
        }
    }

    @StyleSheet(value="https://example.com/external.css")
    private static class TestClassWithExternalStyleSheet {
        private TestClassWithExternalStyleSheet() {
        }
    }

    @StyleSheet.Container(value={@StyleSheet(value="./styles.css"), @StyleSheet(value="./other.css")})
    private static class TestClassWithMultipleStyleSheets {
        private TestClassWithMultipleStyleSheets() {
        }
    }
}

