/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateWebComponentBootstrap;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateWebComponentBootstrapTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File frontendDirectory;
    private File generatedImports;
    private TaskGenerateWebComponentBootstrap taskGenerateWebComponentBootstrap;

    @Before
    public void setup() throws Exception {
        this.frontendDirectory = this.temporaryFolder.newFolder("./src/main/frontend/");
        this.generatedImports = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        this.generatedImports.getParentFile().mkdirs();
        this.generatedImports.createNewFile();
        FrontendDependenciesScanner scanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)scanner.getThemeDefinition()).thenReturn(null);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), null).withFrontendDirectory(this.frontendDirectory).withFrontendDependenciesScanner(scanner);
        this.taskGenerateWebComponentBootstrap = new TaskGenerateWebComponentBootstrap(options);
    }

    @Test
    public void should_importGeneratedImports() throws ExecutionFailedException {
        this.taskGenerateWebComponentBootstrap.execute();
        String content = this.taskGenerateWebComponentBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains("import 'Frontend/generated/flow/generated-flow-webcomponent-imports.js'"));
    }

    @Test
    public void should_importAndInitializeFlowClient() throws ExecutionFailedException {
        this.taskGenerateWebComponentBootstrap.execute();
        String content = this.taskGenerateWebComponentBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains("import { init } from 'Frontend/generated/jar-resources/FlowClient.js';\ninit()"));
    }

    @Test
    public void should_importFeatureFlagTS() throws ExecutionFailedException {
        this.taskGenerateWebComponentBootstrap.execute();
        String content = this.taskGenerateWebComponentBootstrap.getFileContent();
        Assert.assertTrue((boolean)content.contains(String.format("import './%s';", "vaadin-featureflags.js")));
    }
}

