/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.MockLogger;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateTsConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@NotThreadSafe
public class TaskGenerateTsConfigTest {
    private static final CharSequence DEFAULT_ES_TARGET = "es2023";
    private static final CharSequence NEWER_ES_TARGET = "es2024";
    private static String LATEST_VERSION = "9.1";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File npmFolder;
    private TaskGenerateTsConfig taskGenerateTsConfig;
    private FeatureFlags featureFlags;

    @Before
    public void setUp() throws IOException {
        this.npmFolder = this.temporaryFolder.newFolder();
        this.featureFlags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.npmFolder).withFeatureFlags(this.featureFlags);
        this.taskGenerateTsConfig = new TaskGenerateTsConfig(options);
        TaskGenerateTsConfig.warningEmitted = false;
    }

    @Test
    public void should_generateTsConfig_TsConfigNotExist() throws Exception {
        this.taskGenerateTsConfig.execute();
        Assert.assertFalse((String)"Should generate tsconfig.json when tsconfig.json doesn't exist", (boolean)this.taskGenerateTsConfig.shouldGenerate());
        Assert.assertTrue((String)"The generated tsconfig.json should not exist", (boolean)this.taskGenerateTsConfig.getGeneratedFile().exists());
        Assert.assertEquals((String)"The generated content should be equals the default content", (Object)this.taskGenerateTsConfig.getFileContent(), (Object)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void viteShouldNotUseEs2019() throws Exception {
        this.taskGenerateTsConfig.execute();
        Assert.assertFalse((String)"The config file should not use es2019", (boolean)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8).contains("\"target\": \"es2019\""));
    }

    @Test
    public void viteShouldUpgradeFromEs2019() throws Exception {
        this.taskGenerateTsConfig.execute();
        String content = IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8);
        content = content.replace(DEFAULT_ES_TARGET, "es2019");
        try (FileWriter fw = new FileWriter(this.taskGenerateTsConfig.getGeneratedFile(), StandardCharsets.UTF_8);){
            fw.write(content);
        }
        Assert.assertTrue((String)"The config file should use es2019", (boolean)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8).contains("\"target\": \"es2019\""));
        this.taskGenerateTsConfig.execute();
        Assert.assertFalse((String)"Vite should have upgraded the config file to not use es2019", (boolean)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8).contains("\"target\": \"es2019\""));
    }

    @Test
    public void viteShouldUpgradeFromEs2020() throws Exception {
        this.taskGenerateTsConfig.execute();
        String content = IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8);
        content = content.replace(DEFAULT_ES_TARGET, "es2020");
        try (FileWriter fw = new FileWriter(this.taskGenerateTsConfig.getGeneratedFile(), StandardCharsets.UTF_8);){
            fw.write(content);
        }
        Assert.assertTrue((String)"The config file should use es2020", (boolean)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8).contains("\"target\": \"es2020\""));
        this.taskGenerateTsConfig.execute();
        Assert.assertFalse((String)"Vite should have upgraded the config file to not use es2020", (boolean)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8).contains("\"target\": \"es2020\""));
    }

    @Test
    public void viteShouldNotDowngradeFromNewerEsVersion() throws Exception {
        this.taskGenerateTsConfig.execute();
        String content = IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8);
        content = content.replace(DEFAULT_ES_TARGET, NEWER_ES_TARGET);
        try (FileWriter fw = new FileWriter(this.taskGenerateTsConfig.getGeneratedFile(), StandardCharsets.UTF_8);){
            fw.write(content);
        }
        Assert.assertTrue((String)("The config file should use " + String.valueOf(NEWER_ES_TARGET)), (boolean)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8).contains("\"target\": \"" + String.valueOf(NEWER_ES_TARGET) + "\""));
        this.taskGenerateTsConfig.execute();
        Assert.assertTrue((String)"Vite should not have changed the config file", (boolean)IOUtils.toString((URI)this.taskGenerateTsConfig.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8).contains("\"target\": \"" + String.valueOf(NEWER_ES_TARGET) + "\""));
    }

    @Test
    public void should_notGenerateTsConfig_TsConfigExist() throws Exception {
        Path tsconfig = Files.createFile(new File(this.npmFolder, "tsconfig.json").toPath(), new FileAttribute[0]);
        Files.writeString(tsconfig, (CharSequence)"text", StandardCharsets.UTF_8, new OpenOption[0]);
        this.taskGenerateTsConfig.execute();
        Assert.assertFalse((String)"Should not generate tsconfig.json when tsconfig.json exists", (boolean)this.taskGenerateTsConfig.shouldGenerate());
        Assert.assertTrue((String)"The tsconfig.json should already exist", (boolean)this.taskGenerateTsConfig.getGeneratedFile().exists());
    }

    @Test
    public void tsConfigUpdated_remindsUpdateVersionAndTemplates() throws IOException {
        File tsconfig = new File(this.npmFolder, "tsconfig.json");
        Files.createFile(tsconfig.toPath(), new FileAttribute[0]);
        FileUtils.writeStringToFile((File)tsconfig, (String)"{}", (Charset)StandardCharsets.UTF_8);
        try {
            this.taskGenerateTsConfig.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String tsConfigLatest = FileUtils.readFileToString((File)tsconfig, (Charset)StandardCharsets.UTF_8);
        String testTsConfig = IOUtils.toString((InputStream)Objects.requireNonNull(TaskGenerateTsConfigTest.class.getClassLoader().getResourceAsStream("tsconfig-reference.json")), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"tsconfig.json content has been updated. Please also: 1. Increment version in tsconfig.json (\"_version\" property) 2. create a new tsconfig-vX.Y.json template in flow-server resources and put the old content there 3. update vaadinVersion array in TaskGenerateTsConfig with X.Y 4. put a new content in tsconfig-reference.json in tests 5. update LATEST_VERSION in TaskGenerateTsConfigTest", (Object)testTsConfig, (Object)tsConfigLatest);
    }

    @Test
    public void tsConfigHasLatestVersion_noUpdates() throws IOException, ExecutionFailedException {
        File tsconfig = new File(this.npmFolder, "tsconfig.json");
        Files.createFile(tsconfig.toPath(), new FileAttribute[0]);
        FileUtils.writeStringToFile((File)tsconfig, (String)("{\"flow_version\": \"" + LATEST_VERSION + "\"}"), (Charset)StandardCharsets.UTF_8);
        this.taskGenerateTsConfig.execute();
        String tsConfigString = FileUtils.readFileToString((File)tsconfig, (Charset)StandardCharsets.UTF_8);
        String expected = IOUtils.toString((InputStream)Objects.requireNonNull(TaskGenerateTsConfigTest.class.getClassLoader().getResourceAsStream("tsconfig-latest-version.json")), (Charset)StandardCharsets.UTF_8).replace("latest", LATEST_VERSION);
        Assert.assertEquals((Object)expected, (Object)tsConfigString);
    }

    @Test
    public void tsConfigHasCustomCodes_updatesAndLogsWarning() throws IOException, ExecutionFailedException {
        File tsconfig = this.writeTestTsConfigContent("tsconfig-custom-content.json");
        MockLogger logger = new MockLogger();
        try (MockedStatic client = Mockito.mockStatic(AbstractTaskClientGenerator.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            client.when(() -> AbstractTaskClientGenerator.log()).thenReturn((Object)logger);
            this.taskGenerateTsConfig.execute();
        }
        String tsConfigString = FileUtils.readFileToString((File)tsconfig, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)tsConfigString.contains("\"@vaadin/flow-frontend\": [\"generated/jar-resources\"],"));
        Assert.assertTrue((boolean)logger.getLogs().contains("\n**************************************************************************\n*  TypeScript config file 'tsconfig.json' has been updated to the latest *\n*  version by Vaadin. Please verify that the updated 'tsconfig.json'     *\n*  file contains configuration needed for your project (add any missing  *\n*  parts from the old file if necessary) and restart the application.    *\n*  Old configuration is stored as a '.bak' file.                         *\n**************************************************************************\n\n"));
    }

    @Test
    public void warningIsLoggedOnlyOncePerRun() throws IOException, ExecutionFailedException {
        File tsconfig = this.writeTestTsConfigContent("tsconfig-custom-content.json");
        MockLogger logger = new MockLogger();
        try (MockedStatic client = Mockito.mockStatic(AbstractTaskClientGenerator.class, (Answer)Mockito.CALLS_REAL_METHODS);){
            client.when(() -> AbstractTaskClientGenerator.log()).thenReturn((Object)logger);
            this.taskGenerateTsConfig.execute();
            Assert.assertTrue((boolean)logger.getLogs().contains("\n**************************************************************************\n*  TypeScript config file 'tsconfig.json' has been updated to the latest *\n*  version by Vaadin. Please verify that the updated 'tsconfig.json'     *\n*  file contains configuration needed for your project (add any missing  *\n*  parts from the old file if necessary) and restart the application.    *\n*  Old configuration is stored as a '.bak' file.                         *\n**************************************************************************\n\n"));
            logger.clearLogs();
            tsconfig.delete();
            this.writeTestTsConfigContent("tsconfig-custom-content.json");
            this.taskGenerateTsConfig.execute();
            Assert.assertFalse((boolean)logger.getLogs().contains("\n**************************************************************************\n*  TypeScript config file 'tsconfig.json' has been updated to the latest *\n*  version by Vaadin. Please verify that the updated 'tsconfig.json'     *\n*  file contains configuration needed for your project (add any missing  *\n*  parts from the old file if necessary) and restart the application.    *\n*  Old configuration is stored as a '.bak' file.                         *\n**************************************************************************\n\n"));
        }
    }

    @Test
    public void defaultTsConfig_updatesSilently() throws IOException, ExecutionFailedException {
        File tsconfig = this.writeTestTsConfigContent("tsconfig-default.json");
        this.taskGenerateTsConfig.execute();
        String tsConfigString = FileUtils.readFileToString((File)tsconfig, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)tsConfigString.contains("\"@vaadin/flow-frontend\": [\"generated/jar-resources\"],"));
    }

    @Test
    public void olderTsConfig_updatesSilently() throws IOException, ExecutionFailedException {
        File tsconfig = this.writeTestTsConfigContent("tsconfig-older.json");
        this.taskGenerateTsConfig.execute();
        String tsConfigString = FileUtils.readFileToString((File)tsconfig, (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((boolean)tsConfigString.contains("\"@vaadin/flow-frontend\": [\"generated/jar-resources\"],"));
    }

    private File writeTestTsConfigContent(String s) throws IOException {
        File tsconfig = new File(this.npmFolder, "tsconfig.json");
        Files.createFile(tsconfig.toPath(), new FileAttribute[0]);
        String content = IOUtils.toString((InputStream)Objects.requireNonNull(TaskGenerateTsConfigTest.class.getClassLoader().getResourceAsStream(s)), (Charset)StandardCharsets.UTF_8);
        FileUtils.writeStringToFile((File)tsconfig, (String)content, (Charset)StandardCharsets.UTF_8);
        return tsconfig;
    }

    @Test
    public void testIsOlder() {
        Assert.assertTrue((boolean)TaskGenerateTsConfig.isOlder((String)"es2019", (String)"es2020"));
        Assert.assertTrue((boolean)TaskGenerateTsConfig.isOlder((String)"es2020", (String)"es2021"));
        Assert.assertFalse((boolean)TaskGenerateTsConfig.isOlder((String)"es2020", (String)"es2020"));
        Assert.assertFalse((boolean)TaskGenerateTsConfig.isOlder((String)"es2020", (String)"es2019"));
        Assert.assertFalse((boolean)TaskGenerateTsConfig.isOlder((String)"es2021", (String)"es2019"));
        Assert.assertTrue((boolean)TaskGenerateTsConfig.isOlder((String)"2019", (String)"2021"));
    }
}

