/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateTailwindCss;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateTailwindCssTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File npmFolder;
    private File frontendGeneratedFolder;
    private File frontendFolder;
    private TaskGenerateTailwindCss taskGenerateTailwindCss;

    @Before
    public void setUp() throws IOException {
        this.npmFolder = this.temporaryFolder.newFolder();
        File srcFolder = new File(this.npmFolder, "src");
        srcFolder.mkdirs();
        this.frontendFolder = new File(srcFolder, "frontend");
        this.frontendFolder.mkdirs();
        this.frontendGeneratedFolder = new File(this.frontendFolder, "generated");
        this.frontendGeneratedFolder.mkdirs();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.npmFolder).withFrontendDirectory(this.frontendFolder).withFrontendGeneratedFolder(this.frontendGeneratedFolder);
        this.taskGenerateTailwindCss = new TaskGenerateTailwindCss(options);
    }

    @Test
    public void should_haveCorrectFileContent() throws Exception {
        this.verifyTailwindCss(this.taskGenerateTailwindCss.getFileContent(), false);
    }

    @Test
    public void should_generateTailwindCss() throws Exception {
        File tailwindcss = new File(this.frontendGeneratedFolder, "tailwind.css");
        this.taskGenerateTailwindCss.execute();
        Assert.assertEquals((String)"Should have correct tailwind.css file path", (Object)tailwindcss, (Object)this.taskGenerateTailwindCss.getGeneratedFile());
        this.verifyTailwindCss(this.getTailwindCssFileContent(), false);
        Assert.assertTrue((String)"Should generate tailwind.css in the frontend generated folder", (boolean)this.taskGenerateTailwindCss.shouldGenerate());
    }

    @Test
    public void should_updateExistingTailwindCss() throws Exception {
        File tailwindcss = new File(this.frontendGeneratedFolder, "tailwind.css");
        Files.writeString(tailwindcss.toPath(), (CharSequence)"OLD CONTENT", new OpenOption[0]);
        this.taskGenerateTailwindCss.execute();
        Assert.assertTrue((String)"Should generate tailwind.css in the frontend generated folder", (boolean)this.taskGenerateTailwindCss.shouldGenerate());
        String tailwindCssContent = this.getTailwindCssFileContent();
        Assert.assertEquals((String)"Should update content in tailwind.css", (Object)this.taskGenerateTailwindCss.getFileContent(), (Object)tailwindCssContent);
    }

    @Test
    public void should_includeCustomImport_whenCustomFileExists() throws Exception {
        File customCss = new File(this.frontendFolder, "tailwind-custom.css");
        Files.writeString(customCss.toPath(), (CharSequence)"@theme { --color-my-theme: red; }", new OpenOption[0]);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.npmFolder).withFrontendDirectory(this.frontendFolder).withFrontendGeneratedFolder(this.frontendGeneratedFolder);
        TaskGenerateTailwindCss task = new TaskGenerateTailwindCss(options);
        String content = task.getFileContent();
        this.verifyTailwindCss(content, true);
        Assert.assertFalse((String)"Should not contain backslashes in import path", (boolean)content.contains("\\"));
    }

    private void verifyTailwindCss(String tailwindCssContent, boolean shouldHaveCustomImport) {
        Assert.assertTrue((String)"Should have tailwindcss/theme.css import", (boolean)tailwindCssContent.contains("@import 'tailwindcss/theme.css';\n"));
        Assert.assertTrue((String)"Should have tailwindcss/utilities.css import", (boolean)tailwindCssContent.contains("@import 'tailwindcss/utilities.css';\n"));
        Assert.assertTrue((String)"Should have @source directive with path", (boolean)tailwindCssContent.contains("@source '../..';\n"));
        if (shouldHaveCustomImport) {
            Assert.assertTrue((String)"Should have custom import", (boolean)tailwindCssContent.contains("@import '../tailwind-custom.css';"));
        } else {
            Assert.assertFalse((String)"Should not have custom import", (boolean)tailwindCssContent.contains("tailwind-custom.css"));
        }
    }

    private String getTailwindCssFileContent() throws IOException {
        return Files.readString(this.taskGenerateTailwindCss.getGeneratedFile().toPath());
    }
}

