/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateServiceWorker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateServicWorkerTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File frontendFolder;
    private File outputFolder;
    private TaskGenerateServiceWorker taskGenerateServiceWorker;

    @Before
    public void setUp() throws IOException {
        this.frontendFolder = this.temporaryFolder.newFolder();
        this.outputFolder = this.temporaryFolder.newFolder();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), this.temporaryFolder.getRoot()).withFrontendDirectory(this.frontendFolder).withBuildDirectory(this.outputFolder.getName());
        this.taskGenerateServiceWorker = new TaskGenerateServiceWorker(options);
    }

    @Test
    public void should_loadCorrectContentOfDefaultFile() throws Exception {
        String defaultContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("sw.ts"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Should load correct default content from sw.ts", (Object)defaultContent, (Object)this.taskGenerateServiceWorker.getFileContent());
    }

    @Test
    public void should_notGenerateServiceWorker_ServiceWorkerExists() throws Exception {
        Files.createFile(new File(this.frontendFolder, "sw.ts").toPath(), new FileAttribute[0]);
        this.taskGenerateServiceWorker.execute();
        Assert.assertFalse((String)"Should not generate sw.ts while it exists in the frontend folder", (boolean)this.taskGenerateServiceWorker.shouldGenerate());
        Assert.assertFalse((String)"The generated file should not exists", (boolean)this.taskGenerateServiceWorker.getGeneratedFile().exists());
    }

    @Test
    public void should_notGenerateServiceWorker_ServiceWorkerJsExists() throws Exception {
        Files.createFile(new File(this.frontendFolder, "sw.js").toPath(), new FileAttribute[0]);
        this.taskGenerateServiceWorker.execute();
        Assert.assertFalse((String)"Should not generate sw.ts while sw.js exists in the frontend folder", (boolean)this.taskGenerateServiceWorker.shouldGenerate());
        Assert.assertFalse((String)"The generated file should not exists", (boolean)this.taskGenerateServiceWorker.getGeneratedFile().exists());
    }

    @Test
    public void should_generateServiceWorker_ServiceWorkerNotExist() throws Exception {
        String defaultContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("sw.ts"), (Charset)StandardCharsets.UTF_8);
        this.taskGenerateServiceWorker.execute();
        Assert.assertTrue((String)"Should generate sw.ts when it doesn't exists in the frontend folder", (boolean)this.taskGenerateServiceWorker.shouldGenerate());
        Assert.assertTrue((String)"The generated file should exists", (boolean)this.taskGenerateServiceWorker.getGeneratedFile().exists());
        Assert.assertEquals((String)"Should have default content of sw.ts", (Object)defaultContent, (Object)IOUtils.toString((URI)this.taskGenerateServiceWorker.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8));
    }
}

