/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGeneratePWAIcons;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGeneratePWAIconsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final TestPwaConfiguration pwaConfiguration = new TestPwaConfiguration();
    private TaskGeneratePWAIcons task;
    private Path resourcesDirectory;
    private Path iconsOutDirectory;

    @Before
    public void setUp() throws Exception {
        File projectDirectory = this.temporaryFolder.newFolder("my-project");
        this.resourcesDirectory = this.temporaryFolder.newFolder(new String[]{"my-project", "out", "classes"}).toPath();
        Files.createDirectories(this.resourcesDirectory, new FileAttribute[0]);
        Path resourceOutDirectory = projectDirectory.toPath().resolve(Path.of("out", "VAADIN"));
        Path wabappResourceOutDirectory = resourceOutDirectory.resolve("wabapp");
        this.iconsOutDirectory = wabappResourceOutDirectory.resolve("pwa-icons/");
        FrontendDependenciesScanner scanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)scanner.getPwaConfiguration()).then(i -> this.pwaConfiguration);
        URLClassLoader classFinderClassLoader = new URLClassLoader(new URL[]{this.resourcesDirectory.toUri().toURL()}, null);
        ClassFinder.DefaultClassFinder classFinder = new ClassFinder.DefaultClassFinder((ClassLoader)classFinderClassLoader, new Class[0]);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), (ClassFinder)classFinder, projectDirectory).withBuildResultFolders(wabappResourceOutDirectory.toFile(), resourceOutDirectory.toFile());
        this.task = new TaskGeneratePWAIcons(options, (PwaConfiguration)this.pwaConfiguration);
    }

    @Test
    public void execute_PWA_disabled_iconsNotGenerated() throws ExecutionFailedException {
        this.pwaConfiguration.enabled = false;
        this.task.execute();
        Assert.assertFalse((String)"PWA icons should not have been generated", (boolean)Files.exists(this.iconsOutDirectory, new LinkOption[0]));
    }

    @Test
    public void execute_PWA_iconInClassPath_generateIcons() throws ExecutionFailedException, IOException {
        this.createBaseIcon(this.resourcesDirectory);
        this.task.execute();
        this.assertIconsGenerated();
    }

    @Test
    public void execute_PWA_iconInMetaInfResourcesFolder_generateIcons() throws ExecutionFailedException, IOException {
        this.createBaseIcon(this.resourcesDirectory.resolve(Path.of("META-INF", "resources")));
        this.task.execute();
        this.assertIconsGenerated();
    }

    @Test
    public void execute_PWA_baseIconNotFound_generateIconsFromDefaultLogo() throws ExecutionFailedException, IOException {
        this.task.execute();
        this.assertIconsGenerated();
    }

    @Test
    public void execute_PWA_invalidBaseIconNotFound_throws() throws IOException {
        this.createBaseIcon(this.resourcesDirectory.resolve(Path.of("META-INF", "resources")), new ByteArrayInputStream("NOT AN IMAGE".getBytes()));
        ExecutionFailedException exception = (ExecutionFailedException)Assert.assertThrows(ExecutionFailedException.class, () -> ((TaskGeneratePWAIcons)this.task).execute());
        Assert.assertTrue((boolean)exception.getMessage().contains("Cannot load PWA icon"));
        Assert.assertFalse((String)"PWA icons should not have been generated", (boolean)Files.exists(this.iconsOutDirectory, new LinkOption[0]));
    }

    private void createBaseIcon(Path resourcesFolder) throws IOException {
        this.createBaseIcon(resourcesFolder, this.getClass().getResourceAsStream("/META-INF/resources/icons/icon.png"));
    }

    private void createBaseIcon(Path resourcesFolder, InputStream data) throws IOException {
        Path baseIcon = resourcesFolder.resolve(resourcesFolder).resolve(this.pwaConfiguration.getIconPath().replace('/', File.separatorChar));
        Files.createDirectories(baseIcon.getParent(), new FileAttribute[0]);
        Files.copy(data, baseIcon, new CopyOption[0]);
    }

    private void assertIconsGenerated() throws IOException {
        String iconPath = this.pwaConfiguration.getIconPath();
        Path generatedIconsPath = this.iconsOutDirectory.resolve(iconPath.replace('/', File.separatorChar)).getParent();
        Assert.assertTrue((String)"PWA icons folder should have been generated", (boolean)Files.exists(generatedIconsPath, new LinkOption[0]));
        String iconName = iconPath.substring(iconPath.lastIndexOf("/") + 1, iconPath.lastIndexOf("."));
        String iconExt = iconPath.substring(iconPath.lastIndexOf(".") + 1);
        Predicate<String> iconNamePattern = Pattern.compile(iconName + "-\\d+x\\d+\\." + iconExt).asPredicate();
        List<String> generatedIcons = Files.list(generatedIconsPath).map(p -> p.getFileName().toString()).toList();
        Assert.assertFalse((String)"Expected PWA icons to be generated", (boolean)generatedIcons.isEmpty());
        List<String> invalidIcons = generatedIcons.stream().filter(iconNamePattern.negate()).toList();
        Assert.assertTrue((String)("Generated icons have invalid names: " + String.valueOf(invalidIcons)), (boolean)invalidIcons.isEmpty());
    }

    private static class TestPwaConfiguration
    extends PwaConfiguration {
        private Boolean enabled;

        public TestPwaConfiguration() {
            super(true, "Vaadin Flow Application", "Flow PWA", "", "#f2f2f2", "#ffffff", "custom/icons/logo.png", "manifest.webmanifest", "offline.html", "standalone", ".", new String[0], false);
        }

        public boolean isEnabled() {
            return this.enabled != null ? this.enabled.booleanValue() : super.isEnabled();
        }
    }
}

