/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateIndexHtml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateIndexHtmlTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File frontendFolder;
    private TaskGenerateIndexHtml taskGenerateIndexHtml;

    @Before
    public void setUp() throws IOException {
        this.frontendFolder = this.temporaryFolder.newFolder();
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), null).withFrontendDirectory(this.frontendFolder);
        this.taskGenerateIndexHtml = new TaskGenerateIndexHtml(options);
    }

    @Test
    public void should_loadCorrectContentOfDefaultFile() throws Exception {
        String defaultContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("index.html"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Should load correct default content from index.html", (Object)defaultContent, (Object)this.taskGenerateIndexHtml.getFileContent());
    }

    @Test
    public void should_notOverwriteIndexHtml_IndexHtmlExists() throws Exception {
        File indexhtml = new File(this.frontendFolder, "index.html");
        Files.createFile(indexhtml.toPath(), new FileAttribute[0]);
        this.taskGenerateIndexHtml.execute();
        Assert.assertFalse((String)"Should not generate index.html while it exists in the frontend folder", (boolean)this.taskGenerateIndexHtml.shouldGenerate());
        Assert.assertEquals((Object)"", (Object)IOUtils.toString((URI)indexhtml.toURI(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void should_generateIndexHtml_IndexHtmlNotExist() throws Exception {
        String defaultContent = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("index.html"), (Charset)StandardCharsets.UTF_8);
        Assert.assertTrue((String)"Should generate index.html when it doesn't exists in the frontend folder", (boolean)this.taskGenerateIndexHtml.shouldGenerate());
        this.taskGenerateIndexHtml.execute();
        Assert.assertTrue((String)"The generated file should exists", (boolean)this.taskGenerateIndexHtml.getGeneratedFile().exists());
        Assert.assertEquals((String)"Should have default content of index.html", (Object)defaultContent, (Object)IOUtils.toString((URI)this.taskGenerateIndexHtml.getGeneratedFile().toURI(), (Charset)StandardCharsets.UTF_8));
    }
}

