/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateCommercialBanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TaskGenerateCommercialBannerTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File frontendFolder;
    private TaskGenerateCommercialBanner task;
    private Options options;

    @Before
    public void setUp() throws IOException {
        this.frontendFolder = this.temporaryFolder.newFolder();
        this.options = new Options((Lookup)Mockito.mock(Lookup.class), null).withFrontendDirectory(this.frontendFolder);
        this.options.withProductionMode(true);
        this.options.withBundleBuild(true);
        this.options.withCommercialBanner(true);
        this.task = new TaskGenerateCommercialBanner(this.options);
    }

    @Test
    public void execute_commercialBannerBuild_commercialBannerComponentGenerated() throws Exception {
        this.task.execute();
        Assert.assertTrue((String)"The generated file should exists only for bundle builds", (boolean)this.task.getGeneratedFile().exists());
        Assert.assertEquals((String)"Should load correct default content from commercial-banner.js", (Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("commercial-banner.js"), (Charset)StandardCharsets.UTF_8), (Object)Files.readString(this.task.getGeneratedFile().toPath(), StandardCharsets.UTF_8));
    }

    @Test
    public void execute_developmentMode_commercialBannerComponentNotGenerated() throws Exception {
        this.options.withProductionMode(false);
        this.task.execute();
        Assert.assertFalse((String)"The generated file should exists in development mode", (boolean)this.task.getGeneratedFile().exists());
    }

    @Test
    public void execute_notBundleBuild_commercialBannerComponentNotGenerated() throws Exception {
        this.options.withBundleBuild(false);
        this.task.execute();
        Assert.assertFalse((String)"The generated file should exists only for bundle builds", (boolean)this.task.getGeneratedFile().exists());
    }

    @Test
    public void execute_notCommercialBannerBuild_commercialBannerComponentNotGenerated() throws Exception {
        this.options.withCommercialBanner(false);
        this.task.execute();
        Assert.assertFalse((String)"The generated file should exists only for bundle builds", (boolean)this.task.getGeneratedFile().exists());
    }
}

