/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyNpmAssetsFiles;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class TaskCopyNpmAssetsFilesTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Options options;
    private ClassFinder classFinder;
    private FrontendDependenciesScanner scanner;
    private File webappResourcesDirectory;

    @Before
    public void setUp() throws IOException {
        this.temporaryFolder.create();
        File nodeModules = this.temporaryFolder.newFolder("node_modules");
        File testButtonFolder = new File(nodeModules, "test-button");
        File imageAssets = new File(testButtonFolder, "images");
        File templateAssets = new File(testButtonFolder, "templates");
        imageAssets.mkdirs();
        templateAssets.mkdir();
        Files.write(new File(imageAssets, "image.jpg").toPath(), List.of("image file"), new OpenOption[0]);
        Files.write(new File(imageAssets, "image.gif").toPath(), List.of("gif file"), new OpenOption[0]);
        Files.write(new File(templateAssets, "button.template").toPath(), List.of("template file"), new OpenOption[0]);
        this.webappResourcesDirectory = this.temporaryFolder.newFolder("webapp");
        File resourceOutputDirectory = this.temporaryFolder.newFolder("resource");
        this.classFinder = (ClassFinder)Mockito.mock(ClassFinder.class);
        this.scanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        this.options = new Options((Lookup)Mockito.mock(Lookup.class), this.classFinder, this.temporaryFolder.getRoot());
        this.options.withBuildResultFolders(this.webappResourcesDirectory, resourceOutputDirectory).withFrontendDependenciesScanner(this.scanner);
    }

    @Test
    public void assertFolderIsCopied() throws IOException {
        Mockito.when((Object)this.scanner.getAssets()).thenReturn(Map.of("test-button", List.of("images/**:button")));
        TaskCopyNpmAssetsFiles taskCopyNpmAssetsFiles = new TaskCopyNpmAssetsFiles(this.options);
        taskCopyNpmAssetsFiles.execute();
        Set<String> filesInDirectory = TaskCopyNpmAssetsFilesTest.getFilesInDirectory(this.webappResourcesDirectory, new String[0]);
        Assert.assertEquals((long)2L, (long)filesInDirectory.size());
        Assert.assertTrue((boolean)filesInDirectory.contains("VAADIN/static/assets/button/image.jpg"));
        Assert.assertTrue((boolean)filesInDirectory.contains("VAADIN/static/assets/button/image.gif"));
    }

    @Test
    public void copiedFolderStructureIsKept() throws IOException {
        Mockito.when((Object)this.scanner.getAssets()).thenReturn(Map.of("test-button", List.of("**:button")));
        TaskCopyNpmAssetsFiles taskCopyNpmAssetsFiles = new TaskCopyNpmAssetsFiles(this.options);
        taskCopyNpmAssetsFiles.execute();
        Set<String> filesInDirectory = TaskCopyNpmAssetsFilesTest.getFilesInDirectory(this.webappResourcesDirectory, new String[0]);
        Assert.assertEquals((long)3L, (long)filesInDirectory.size());
        Assert.assertTrue((String)"Could not find file images/image.jpg", (boolean)filesInDirectory.contains("VAADIN/static/assets/button/images/image.jpg"));
        Assert.assertTrue((String)"Could not find file images/image.gif", (boolean)filesInDirectory.contains("VAADIN/static/assets/button/images/image.gif"));
        Assert.assertTrue((String)"Could not find file templates/button.template", (boolean)filesInDirectory.contains("VAADIN/static/assets/button/templates/button.template"));
    }

    @Test
    public void singleAssertFromFolderIsCopied() throws IOException {
        Mockito.when((Object)this.scanner.getAssets()).thenReturn(Map.of("test-button", List.of("images/*.jpg:copy")));
        TaskCopyNpmAssetsFiles taskCopyNpmAssetsFiles = new TaskCopyNpmAssetsFiles(this.options);
        taskCopyNpmAssetsFiles.execute();
        Set<String> filesInDirectory = TaskCopyNpmAssetsFilesTest.getFilesInDirectory(this.webappResourcesDirectory, new String[0]);
        Assert.assertEquals((long)1L, (long)filesInDirectory.size());
        Assert.assertEquals((Object)"VAADIN/static/assets/copy/image.jpg", (Object)filesInDirectory.iterator().next());
    }

    @Test
    public void allAssetsAreCopied() throws IOException {
        Mockito.when((Object)this.scanner.getAssets()).thenReturn(Map.of("test-button", Arrays.asList("images/**:button", "templates/**:button")));
        TaskCopyNpmAssetsFiles taskCopyNpmAssetsFiles = new TaskCopyNpmAssetsFiles(this.options);
        taskCopyNpmAssetsFiles.execute();
        Set<String> filesInDirectory = TaskCopyNpmAssetsFilesTest.getFilesInDirectory(this.webappResourcesDirectory, new String[0]);
        Assert.assertEquals((long)3L, (long)filesInDirectory.size());
        Assert.assertTrue((boolean)filesInDirectory.contains("VAADIN/static/assets/button/image.jpg"));
        Assert.assertTrue((boolean)filesInDirectory.contains("VAADIN/static/assets/button/image.gif"));
        Assert.assertTrue((boolean)filesInDirectory.contains("VAADIN/static/assets/button/button.template"));
    }

    @Test
    public void devBundleCopiesAssetsToCorrectFolder() throws IOException {
        Mockito.when((Object)this.scanner.getAssets()).thenReturn(Map.of("test-button", List.of("templates/**:button")));
        this.options.withBundleBuild(true).withProductionMode(false).withBuildDirectory("target");
        TaskCopyNpmAssetsFiles taskCopyNpmAssetsFiles = new TaskCopyNpmAssetsFiles(this.options);
        taskCopyNpmAssetsFiles.execute();
        File devBundleTarget = new File(DevBundleUtils.getDevBundleFolder((File)this.options.getNpmFolder(), (String)this.options.getBuildDirectoryName()), "webapp/VAADIN/static/assets/");
        Set<String> filesInDirectory = TaskCopyNpmAssetsFilesTest.getFilesInDirectory(devBundleTarget, new String[0]);
        Assert.assertEquals((long)1L, (long)filesInDirectory.size());
        Assert.assertEquals((Object)"button/button.template", (Object)filesInDirectory.iterator().next());
    }

    @Test
    public void noAssetsCopiedWhenCopyFlagFalse() throws IOException {
        Mockito.when((Object)this.scanner.getAssets()).thenReturn(Map.of("test-button", Arrays.asList("images/**:button", "templates/**:button")));
        this.options.setCopyAssets(false);
        TaskCopyNpmAssetsFiles taskCopyNpmAssetsFiles = new TaskCopyNpmAssetsFiles(this.options);
        taskCopyNpmAssetsFiles.execute();
        Set<String> filesInDirectory = TaskCopyNpmAssetsFilesTest.getFilesInDirectory(this.webappResourcesDirectory, new String[0]);
        Assert.assertEquals((String)"Nothing should be copied for CopyAssets false", (long)0L, (long)filesInDirectory.size());
    }

    static Set<String> getFilesInDirectory(File targetDirectory, String ... relativePathExclusions) throws IOException {
        if (!targetDirectory.exists()) {
            LoggerFactory.getLogger(TaskCopyNpmAssetsFiles.class).info("No directory {}", (Object)targetDirectory);
            return new HashSet<String>();
        }
        try (Stream<Path> stream = Files.walk(targetDirectory.toPath(), new FileVisitOption[0]);){
            Set<String> set = stream.filter(path -> path.toFile().isFile()).map(path -> targetDirectory.toPath().relativize((Path)path).toString().replaceAll("\\\\", "/")).collect(Collectors.toSet());
            return set;
        }
    }
}

