/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.testutil.TestUtils;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import tools.jackson.databind.JsonNode;

public class TaskCopyFrontendFilesTest
extends NodeUpdateTestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File npmFolder;
    private File generatedFolder;
    private File frontendDepsFolder;

    @Before
    public void setup() throws IOException {
        this.npmFolder = new File(this.temporaryFolder.newFolder(), "child/");
        this.generatedFolder = new File(this.npmFolder, "target/frontend");
        this.frontendDepsFolder = new File(this.npmFolder, "target/frontend-deps");
    }

    @Test
    public void should_collectJsAndCssFilesFromJars_obsoleteResourceFolder() throws IOException {
        this.should_collectJsAndCssFilesFromJars("jar-with-frontend-resources.jar", "dir-with-frontend-resources/");
    }

    @Test
    public void should_collectJsAndCssFilesFromJars_modernResourceFolder() throws IOException {
        this.should_collectJsAndCssFilesFromJars("jar-with-modern-frontend.jar", "dir-with-modern-frontend");
    }

    @Test
    public void should_collectJsAndCssFilesFromJars_removeExtraFiles() throws IOException {
        File dummy = new File(this.frontendDepsFolder, "dummy.ts");
        this.frontendDepsFolder.mkdirs();
        dummy.createNewFile();
        this.should_collectJsAndCssFilesFromJars("jar-with-modern-frontend.jar", "dir-with-modern-frontend");
    }

    @Test
    public void should_createPackageJson() throws IOException {
        Options options = new MockOptions(TaskCopyFrontendFilesTest.getClassFinder(), this.npmFolder).withBuildDirectory("target").withBundleBuild(true);
        TaskGeneratePackageJson task = new TaskGeneratePackageJson(options);
        task.execute();
        Assert.assertTrue((boolean)new File(this.npmFolder, "package.json").exists());
        Assert.assertFalse((boolean)new File(this.generatedFolder, "package.json").exists());
        JsonNode deps = task.getPackageJson().get("dependencies");
        Assert.assertFalse((boolean)deps.has("@vaadin/flow-deps"));
        Assert.assertFalse((boolean)deps.has("@vaadin/flow-frontend"));
    }

    private void should_collectJsAndCssFilesFromJars(String jarFile, String fsDir) throws IOException {
        File jar = TestUtils.getTestJar((String)jarFile);
        File dir = TestUtils.getTestFolder((String)fsDir);
        MockOptions options = new MockOptions(null);
        options.withJarFrontendResourcesFolder(this.frontendDepsFolder).copyResources(TaskCopyFrontendFilesTest.jars(jar, dir));
        TaskCopyFrontendFiles task = new TaskCopyFrontendFiles((Options)options);
        GeneratedFilesSupport generatedFileSupport = new GeneratedFilesSupport();
        task.setGeneratedFileSupport(generatedFileSupport);
        task.execute();
        List files = TestUtils.listFilesRecursively((File)this.frontendDepsFolder);
        Assert.assertEquals((long)19L, (long)files.size());
        Assert.assertTrue((String)"TS resource should have been copied from jar file", (boolean)files.contains("example.ts"));
        Assert.assertTrue((String)"TS resource source map should have been copied from jar file", (boolean)files.contains("example.ts.map"));
        Assert.assertTrue((String)"JS resource should have been copied from jar file", (boolean)files.contains("ExampleConnector.js"));
        Assert.assertTrue((String)"JS resource source map should have been copied from jar file", (boolean)files.contains("ExampleConnector.js.map"));
        Assert.assertTrue((String)"CSS resource should have been copied from jar file", (boolean)files.contains("inline.css"));
        Assert.assertTrue((String)"CSS resource source map should have been copied from jar file", (boolean)files.contains("inline.css.map"));
        Assert.assertTrue((String)"JS resource should have been copied from resource folder", (boolean)files.contains("resourceInFolder.js"));
        Assert.assertTrue((String)"JS resource source map should have been copied from resource folder", (boolean)files.contains("resourceInFolder.js.map"));
        Assert.assertTrue((String)"TSX resource should have been copied from jar file", (boolean)files.contains("react.tsx"));
        Assert.assertTrue((String)"TSX resource source map should have been copied from jar file", (boolean)files.contains("react.tsx.map"));
        Assert.assertTrue((String)"JSX resource should have been copied from jar file", (boolean)files.contains("test.jsx"));
        Assert.assertTrue((String)"JSX resource source map should have been copied from jar file", (boolean)files.contains("test.jsx.map"));
        Assert.assertTrue((String)"HTML resource should have been copied from jar file", (boolean)files.contains("ExampleTemplate.html"));
        Assert.assertFalse((String)"Resource from unsupported frontend folder location should not have been copied from jar file", (boolean)files.contains("ignored.js"));
        Assert.assertEquals((String)"Generated files should have been tracked", files.stream().map(path -> this.frontendDepsFolder.toPath().resolve((String)path)).collect(Collectors.toSet()), (Object)generatedFileSupport.getFiles());
    }

    private static Set<File> jars(File ... files) {
        return Stream.of(files).collect(Collectors.toSet());
    }
}

