/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.testcategory.SlowTests;
import com.vaadin.flow.testutil.FrontendStubs;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@Category(value={SlowTests.class})
public class NodeUpdatePackagesNpmVersionLockingTest
extends NodeUpdateTestUtil {
    private static final String TEST_DEPENDENCY = "@vaadin/vaadin-overlay";
    private static final String DEPENDENCIES = "dependencies";
    private static final String OVERRIDES = "overrides";
    private static final String PLATFORM_PINNED_DEPENDENCY_VERSION = "3.2.17";
    private static final String USER_PINNED_DEPENDENCY_VERSION = "1.0";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File baseDir;
    private ClassFinder classFinder;

    @Before
    public void setup() throws Exception {
        this.baseDir = this.temporaryFolder.getRoot();
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)this.baseDir.getAbsolutePath());
        this.classFinder = (ClassFinder)Mockito.spy((Object)NodeUpdatePackagesNpmVersionLockingTest.getClassFinder());
        File versions = this.temporaryFolder.newFile();
        FileUtils.write((File)versions, (CharSequence)String.format("{\"vaadin-overlay\": {\"npmName\": \"@vaadin/vaadin-overlay\",\"jsVersion\": \"%s\"}}", PLATFORM_PINNED_DEPENDENCY_VERSION), (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.classFinder.getResource("vaadin-core-versions.json")).thenReturn((Object)versions.toURI().toURL());
    }

    @Test
    public void shouldLockPinnedVersion_whenExistsInDependencies() throws IOException {
        TaskUpdatePackages packageUpdater = this.createPackageUpdater();
        ObjectNode packageJson = packageUpdater.getPackageJson();
        ((ObjectNode)packageJson.get(DEPENDENCIES)).put(TEST_DEPENDENCY, PLATFORM_PINNED_DEPENDENCY_VERSION);
        Assert.assertNull((Object)packageJson.get(OVERRIDES));
        packageUpdater.generateVersionsJson(packageJson);
        packageUpdater.lockVersionForNpm(packageJson);
        Assert.assertEquals((Object)"$@vaadin/vaadin-overlay", (Object)packageJson.get(OVERRIDES).get(TEST_DEPENDENCY).textValue());
    }

    @Test
    public void shouldNotLockPinnedVersion_whenNotExistsInDependencies() throws IOException {
        TaskUpdatePackages packageUpdater = this.createPackageUpdater();
        ObjectNode packageJson = packageUpdater.getPackageJson();
        Assert.assertNull((Object)packageJson.get(OVERRIDES));
        Assert.assertNull((Object)packageJson.get(DEPENDENCIES).get(TEST_DEPENDENCY));
        packageUpdater.generateVersionsJson(packageJson);
        packageUpdater.lockVersionForNpm(packageJson);
        Assert.assertNull((Object)packageJson.get(OVERRIDES).get(TEST_DEPENDENCY));
    }

    @Test
    public void shouldNotUpdatesOverrides_whenHasUserModification() throws IOException {
        TaskUpdatePackages packageUpdater = this.createPackageUpdater();
        ObjectNode packageJson = packageUpdater.getPackageJson();
        ObjectNode overridesSection = JacksonUtils.createObjectNode();
        packageJson.set(OVERRIDES, (JsonNode)overridesSection);
        ((ObjectNode)packageJson.get(DEPENDENCIES)).put(TEST_DEPENDENCY, USER_PINNED_DEPENDENCY_VERSION);
        overridesSection.put(TEST_DEPENDENCY, USER_PINNED_DEPENDENCY_VERSION);
        packageUpdater.generateVersionsJson(packageJson);
        packageUpdater.lockVersionForNpm(packageJson);
        Assert.assertEquals((Object)USER_PINNED_DEPENDENCY_VERSION, (Object)packageJson.get(OVERRIDES).get(TEST_DEPENDENCY).textValue());
    }

    @Test
    public void shouldRemoveUnusedLocking() throws IOException {
        Mockito.when((Object)this.classFinder.getResource("vaadin-core-versions.json")).thenReturn(null);
        TaskUpdatePackages packageUpdater = this.createPackageUpdater(true);
        ObjectNode packageJson = packageUpdater.getPackageJson();
        ((ObjectNode)packageJson.get(DEPENDENCIES)).put(TEST_DEPENDENCY, PLATFORM_PINNED_DEPENDENCY_VERSION);
        Assert.assertNull((Object)packageJson.get(OVERRIDES));
        packageUpdater.generateVersionsJson(packageJson);
        Assert.assertTrue((boolean)packageUpdater.versionsJson.toString().contains(TEST_DEPENDENCY));
        ((ObjectNode)packageJson.get(DEPENDENCIES)).remove(TEST_DEPENDENCY);
        packageUpdater.versionsJson = null;
        packageUpdater.generateVersionsJson(packageJson);
        Assert.assertFalse((boolean)packageUpdater.versionsJson.toString().contains(TEST_DEPENDENCY));
    }

    private TaskUpdatePackages createPackageUpdater(boolean enablePnpm) {
        FrontendDependenciesScanner scanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Options options = new MockOptions(this.baseDir).withEnablePnpm(enablePnpm).withBuildDirectory("target").withProductionMode(true);
        return new TaskUpdatePackages(scanner, options);
    }

    private TaskUpdatePackages createPackageUpdater() {
        return this.createPackageUpdater(false);
    }
}

