/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.frontend.BundleUtils;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class NodeTasksViteTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String USER_DIR = "user.dir";
    private static String globalUserDirValue;
    private static String globalFrontendDirValue;
    private String userDir;
    private File npmFolder;

    @Before
    public void setup() {
        this.userDir = this.temporaryFolder.getRoot().getAbsolutePath();
        this.npmFolder = new File(this.userDir);
        System.setProperty(USER_DIR, this.userDir);
        System.clearProperty("vaadin.frontend.folder");
    }

    @BeforeClass
    public static void setupBeforeClass() {
        globalUserDirValue = System.getProperty(USER_DIR);
        globalFrontendDirValue = System.getProperty("vaadin.frontend.folder");
    }

    @AfterClass
    public static void tearDownAfterClass() {
        NodeTasksViteTest.setPropertyIfPresent(USER_DIR, globalUserDirValue);
        NodeTasksViteTest.setPropertyIfPresent("vaadin.frontend.folder", globalFrontendDirValue);
    }

    @Test
    public void should_ExcludeExperimentalComponent_WhenFeatureDisabled() throws Exception {
        Class[] classes = new Class[]{NodeTestComponents.FlagView.class, NodeTestComponents.ExampleExperimentalComponent.class};
        Lookup mockedLookup = (Lookup)Mockito.mock(Lookup.class);
        ClassFinder finder = NodeUpdateTestUtil.getClassFinder(classes);
        ((Lookup)Mockito.doReturn((Object)finder).when((Object)mockedLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockedLookup, this.npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).withBuildResultFolders(this.npmFolder, this.npmFolder);
        Assert.assertEquals((long)1L, (long)finder.getAnnotatedClasses(JsModule.class).size());
        Assert.assertEquals((long)1L, (long)finder.getAnnotatedClasses(JavaScript.class).size());
        new NodeTasks(options).execute();
        File importsFile = FrontendUtils.getFlowGeneratedImports((File)this.getFrontendFolder());
        String content = FileUtils.readFileToString((File)importsFile, (Charset)Charset.defaultCharset());
        Assert.assertFalse((boolean)content.contains("@vaadin/example-flag/experimental-module-1.js"));
        Assert.assertFalse((boolean)content.contains("@vaadin/example-flag/experimental-module-2.js"));
        Assert.assertFalse((boolean)content.contains("experimental-Connector.js"));
    }

    @Test
    public void should_IncludeExperimentalComponent_WhenFeatureEnabled() throws Exception {
        Class[] classes = new Class[]{NodeTestComponents.FlagView.class, NodeTestComponents.ExampleExperimentalComponent.class};
        File propertiesDir = this.temporaryFolder.newFolder();
        FileUtils.write((File)new File(propertiesDir, "vaadin-featureflags.properties"), (CharSequence)"com.vaadin.experimental.exampleFeatureFlag=true\n", (Charset)StandardCharsets.UTF_8);
        Lookup mockedLookup = (Lookup)Mockito.mock(Lookup.class);
        ClassFinder finder = NodeUpdateTestUtil.getClassFinder(classes);
        ((Lookup)Mockito.doReturn((Object)finder).when((Object)mockedLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockedLookup, this.npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).setJavaResourceFolder(propertiesDir).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).withBuildResultFolders(this.npmFolder, this.npmFolder);
        new NodeTasks(options).execute();
        File importsFile = FrontendUtils.getFlowGeneratedImports((File)this.getFrontendFolder());
        String content = FileUtils.readFileToString((File)importsFile, (Charset)Charset.defaultCharset());
        Assert.assertTrue((boolean)content.contains("@vaadin/example-flag/experimental-module-1.js"));
        Assert.assertTrue((boolean)content.contains("@vaadin/example-flag/experimental-module-2.js"));
        Assert.assertTrue((boolean)content.contains("experimental-Connector.js"));
    }

    @Test
    public void should_UseDefaultFolders() throws Exception {
        Lookup mockedLookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0])).when((Object)mockedLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockedLookup, this.npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).withBuildResultFolders(this.npmFolder, this.npmFolder);
        Assert.assertEquals((Object)new File(this.userDir, "./src/main/frontend/").getAbsolutePath(), (Object)options.getFrontendDirectory().getAbsolutePath());
        new NodeTasks(options).execute();
        Assert.assertTrue((boolean)Paths.get(this.userDir, "./src/main/frontend/", "generated/", "flow", "generated-flow-imports.js").toFile().exists());
    }

    @Test
    public void should_generateServiceWorkerWhenPwa() throws Exception {
        Lookup mockedLookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0])).when((Object)mockedLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockedLookup, this.npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).withBuildResultFolders(this.npmFolder, this.npmFolder);
        Assert.assertEquals((Object)new File(this.userDir, "./src/main/frontend/").getAbsolutePath(), (Object)options.getFrontendDirectory().getAbsolutePath());
        new NodeTasks(options).execute();
        Assert.assertTrue((boolean)FrontendUtils.getFlowGeneratedImports((File)this.getFrontendFolder()).exists());
    }

    @Test
    public void should_BeAbleToCustomizeFolders() throws Exception {
        System.setProperty("vaadin.frontend.folder", "my_custom_sources_folder");
        Lookup mockedLookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0])).when((Object)mockedLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockedLookup, this.npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).withBuildResultFolders(this.npmFolder, this.npmFolder);
        Assert.assertEquals((Object)new File(this.userDir, "my_custom_sources_folder").getAbsolutePath(), (Object)options.getFrontendDirectory().getAbsolutePath());
        new NodeTasks(options).execute();
        Assert.assertTrue((boolean)new File(this.userDir, "my_custom_sources_folder/generated/flow/generated-flow-imports.js").exists());
    }

    private File getFrontendFolder() {
        return new File(this.userDir, "./src/main/frontend/");
    }

    private File getJarFrontendResourcesFolder() {
        return FrontendUtils.getJarResourcesFolder((File)this.getFrontendFolder());
    }

    @Test
    public void should_GenerateTsConfigAndTsDefinitions_When_Vaadin14BootstrapMode() throws ExecutionFailedException {
        Lookup mockedLookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0])).when((Object)mockedLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockedLookup, this.npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).withBuildResultFolders(this.npmFolder, this.npmFolder);
        new NodeTasks(options).execute();
        Assert.assertTrue((boolean)new File(this.userDir, "tsconfig.json").exists());
        Assert.assertTrue((boolean)new File(this.userDir, "types.d.ts").exists());
    }

    @Test
    public void should_copyPackageLockJson_When_frontendHotdeploy() throws ExecutionFailedException {
        Lookup mockedLookup = (Lookup)Mockito.mock(Lookup.class);
        ((Lookup)Mockito.doReturn((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0])).when((Object)mockedLookup)).lookup(ClassFinder.class);
        Options options = new Options(mockedLookup, this.npmFolder).withBuildDirectory("target").enablePackagesUpdate(false).enableImportsUpdate(true).withRunNpmInstall(false).withEmbeddableWebComponents(false).withJarFrontendResourcesFolder(this.getJarFrontendResourcesFolder()).withFrontendHotdeploy(true).withProductionMode(false).withBuildResultFolders(this.npmFolder, this.npmFolder);
        try (MockedStatic bundleUtils = Mockito.mockStatic(BundleUtils.class);
             MockedStatic validationUtil = Mockito.mockStatic(BundleValidationUtil.class);){
            new NodeTasks(options).execute();
            bundleUtils.verify(() -> BundleUtils.copyPackageLockFromBundle((Options)options), Mockito.times((int)1));
            validationUtil.verify(() -> BundleValidationUtil.needsBuild((Options)((Options)ArgumentMatchers.any(Options.class)), (FrontendDependenciesScanner)((FrontendDependenciesScanner)ArgumentMatchers.any(FrontendDependenciesScanner.class)), (Mode)((Mode)ArgumentMatchers.any(Mode.class))), Mockito.never());
        }
    }

    private static void setPropertyIfPresent(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        }
    }
}

