/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.GeneratedFilesSupport;
import com.vaadin.flow.server.frontend.NodeTasks;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskRemoveOldFrontendGeneratedFiles;
import com.vaadin.flow.server.frontend.UnknownTaskException;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class NodeTasksExecutionTest {
    private static final String DEV_SERVER_VITE = "VITE";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Parameterized.Parameter
    public String devServerImpl;
    private NodeTasks nodeTasks;
    private List<FallibleCommand> commandsMock;
    private List<Class<? extends FallibleCommand>> commandsOrder;
    private List<Class<? extends FallibleCommand>> executionOrder;
    private List<FallibleCommand> commands;
    private Options options;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> devServers() {
        return List.of(DEV_SERVER_VITE);
    }

    @Before
    public void init() throws Exception {
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(Collections.singleton(this.getClass()));
        this.options = new MockOptions((ClassFinder)finder, this.temporaryFolder.getRoot()).withBuildDirectory("target").withFrontendDirectory(this.temporaryFolder.getRoot());
        this.options.withProductionMode(false);
        this.nodeTasks = new NodeTasks(this.options);
        this.commandsOrder = NodeTasksExecutionTest.getCommandOrder(this.nodeTasks);
        this.executionOrder = new ArrayList<Class<? extends FallibleCommand>>(this.commandsOrder.size());
        this.commandsMock = this.mockCommandsRandomOrder(this.commandsOrder, this.executionOrder);
        this.commands = NodeTasksExecutionTest.getCommands(this.nodeTasks);
        this.commands.clear();
        Assert.assertEquals((String)"No commands should be added initially, update mock builder so that we don't automatically add any tasks!", (long)0L, (long)this.commands.size());
    }

    private static List<Class<? extends FallibleCommand>> getCommandOrder(NodeTasks nodeTasks) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field commandOrderField = NodeTasks.class.getDeclaredField("commandOrder");
        commandOrderField.setAccessible(true);
        return (List)commandOrderField.get(nodeTasks);
    }

    private static List<FallibleCommand> getCommands(NodeTasks nodeTasks) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field commandsField = NodeTasks.class.getDeclaredField("commands");
        commandsField.setAccessible(true);
        return (List)commandsField.get(nodeTasks);
    }

    private void createFeatureFlagsFile(String contents) throws IOException {
        Files.writeString(this.temporaryFolder.newFile("vaadin-featureflags.properties").toPath(), (CharSequence)contents, new OpenOption[0]);
    }

    @Test
    public void nodeTasks_notExecutedInParallel() throws Exception {
        final ArrayList result = new ArrayList();
        FallibleCommand command1 = new FallibleCommand(){

            public void execute() throws ExecutionFailedException {
                try {
                    result.add("Start 1");
                    Thread.sleep(100L);
                    result.add("End 1");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        FallibleCommand command2 = new FallibleCommand(){

            public void execute() throws ExecutionFailedException {
                try {
                    result.add("Start 2");
                    Thread.sleep(100L);
                    result.add("End 2");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        NodeTasks nodeTasks1 = (NodeTasks)Mockito.spy((Object)new NodeTasks(this.options));
        NodeTasksExecutionTest.getCommands(nodeTasks1).add(command1);
        ((NodeTasks)Mockito.doReturn((Object)1).when((Object)nodeTasks1)).getIndex(command1);
        NodeTasks nodeTasks2 = (NodeTasks)Mockito.spy((Object)new NodeTasks(this.options));
        NodeTasksExecutionTest.getCommands(nodeTasks2).add(command2);
        ((NodeTasks)Mockito.doReturn((Object)1).when((Object)nodeTasks2)).getIndex(command2);
        Thread t1 = new Thread(() -> {
            try {
                nodeTasks1.execute();
            }
            catch (ExecutionFailedException e) {
                e.printStackTrace();
            }
        });
        Thread t2 = new Thread(() -> {
            try {
                nodeTasks2.execute();
            }
            catch (ExecutionFailedException e) {
                e.printStackTrace();
            }
        });
        t1.start();
        Thread.sleep(100L);
        t2.start();
        t1.join();
        t2.join();
        Assert.assertEquals(List.of("Start 1", "End 1", "Start 2", "End 2"), result);
    }

    @Test
    public void nodeTasks_alwaysExecutedInDefinedOrder() throws ExecutionFailedException {
        this.commands.addAll(this.commandsMock);
        this.nodeTasks.execute();
        Assert.assertEquals((String)"Amount of tasks executed was more than expected", (long)this.commandsOrder.size(), (long)this.executionOrder.size());
        Assert.assertEquals((String)"Tasks were executed in an unexpected order", this.commandsOrder, this.executionOrder);
    }

    @Test
    public void nodeTasksContainsUnlistedCommand_throwsUnknownTaskException() {
        this.commands.add(this.commandsMock.get(0));
        this.commands.add(new NewTask(this));
        Assert.assertThrows((String)"NodeTasks execution should fail due to unknown task in execution list", UnknownTaskException.class, () -> ((NodeTasks)this.nodeTasks).execute());
    }

    @Test
    public void nodeTasks_deletesOldGeneratedFiles() throws Exception {
        this.options.withCleanOldGeneratedFiles(true);
        NodeTasks spiedNodeTasks = (NodeTasks)Mockito.spy((Object)new NodeTasks(this.options));
        ((NodeTasks)Mockito.doAnswer(i -> i.getArgument(0) instanceof TaskRemoveOldFrontendGeneratedFiles ? 1 : 0).when((Object)spiedNodeTasks)).getIndex((FallibleCommand)ArgumentMatchers.any());
        List<Path> generatedFiles = List.of(Paths.get("file.tsx", new String[0]), Paths.get("another.js", new String[0]), Paths.get("sub", "a.tsx"), Paths.get("sub", "nested", "b.js"));
        this.enqueueCreateGeneratedFilesTasks(spiedNodeTasks, generatedFiles);
        spiedNodeTasks.execute();
        this.assertOnlyExpectedGeneratedFilesExists(generatedFiles);
        generatedFiles = List.of(Paths.get("no-the-same-file.tsx", new String[0]), Paths.get("another.js", new String[0]), Paths.get("sub", "a.tsx"), Paths.get("sub", "b.tsx"), Paths.get("sub", "nested-changed", "b.js"));
        this.enqueueCreateGeneratedFilesTasks(spiedNodeTasks, generatedFiles);
        spiedNodeTasks.execute();
        this.assertOnlyExpectedGeneratedFilesExists(generatedFiles);
    }

    private void enqueueCreateGeneratedFilesTasks(NodeTasks nodeTasks, List<Path> generatedFiles) throws NoSuchFieldException, IllegalAccessException {
        List<FallibleCommand> commandList = NodeTasksExecutionTest.getCommands(nodeTasks);
        commandList.clear();
        generatedFiles.stream().map(this::createGeneratedFileTask).forEach(commandList::add);
        commandList.add((FallibleCommand)new TaskRemoveOldFrontendGeneratedFiles(this.options));
    }

    private void assertOnlyExpectedGeneratedFilesExists(List<Path> expectedFiles) throws IOException {
        AccumulatorPathVisitor visitor = new AccumulatorPathVisitor();
        Files.walkFileTree(this.options.getFrontendGeneratedFolder().toPath(), (FileVisitor<? super Path>)visitor);
        Assert.assertEquals((String)"Expect exactly currently generated files to exists", Set.copyOf(expectedFiles), Set.copyOf(visitor.relativizeFiles(this.options.getFrontendGeneratedFolder().toPath(), false, null)));
    }

    private FallibleCommand createGeneratedFileTask(Path relativePath) {
        Path resolved = this.options.getFrontendGeneratedFolder().toPath().resolve(relativePath);
        return new FileGeneratorTask(resolved.toFile());
    }

    private List<FallibleCommand> mockCommandsRandomOrder(List<Class<? extends FallibleCommand>> commandsOrder, List<Class<? extends FallibleCommand>> executionOrder) throws ExecutionFailedException {
        ArrayList<FallibleCommand> commands = new ArrayList<FallibleCommand>(commandsOrder.size());
        for (Class<? extends FallibleCommand> command : commandsOrder) {
            FallibleCommand mock = (FallibleCommand)Mockito.mock(command);
            commands.add(mock);
            ((FallibleCommand)Mockito.doAnswer(invocation -> {
                executionOrder.add(command);
                return null;
            }).when((Object)mock)).execute();
        }
        Collections.shuffle(commands);
        return commands;
    }

    private class NewTask
    implements FallibleCommand {
        private NewTask(NodeTasksExecutionTest nodeTasksExecutionTest) {
        }

        public void execute() throws ExecutionFailedException {
        }
    }

    private static class FileGeneratorTask
    implements FallibleCommand {
        private final File file;
        private GeneratedFilesSupport support;

        FileGeneratorTask(File file) {
            this.file = file;
        }

        public void setGeneratedFileSupport(GeneratedFilesSupport support) {
            this.support = support;
        }

        public void execute() throws ExecutionFailedException {
            try {
                this.support.writeIfChanged(this.file, "test file");
            }
            catch (IOException e) {
                throw new ExecutionFailedException((Throwable)e);
            }
        }
    }
}

