/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class MockLogger
implements Logger,
Serializable {
    StringBuilder logs = new StringBuilder();
    public boolean includeStackTrace = false;
    public static String TRACE = "[Trace] ";
    public static String DEBUG = "[Debug] ";
    public static String WARN = "[Warning] ";
    public static String ERROR = "[Error] ";
    public static String INFO = "[Info] ";

    public String getLogs() {
        return this.logs.toString().replaceAll("\r", "");
    }

    private void append(Throwable throwable) {
        if (throwable != null && this.includeStackTrace) {
            throwable.printStackTrace(new PrintWriter((Writer)new StringBuilderWriter(this.logs)));
        }
    }

    public void clearLogs() {
        this.logs = new StringBuilder();
    }

    public String getName() {
        return null;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String s) {
        this.logs.append(TRACE).append(s).append("\n");
    }

    public void trace(String s, Object o) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(TRACE).append(s).append("\n");
    }

    public void trace(String s, Object o, Object o1) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        s = s.replaceFirst("\\{\\}", o1.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(TRACE).append(s).append("\n");
    }

    public void trace(String s, Object ... objects) {
        this.logs.append(TRACE);
        for (Object object : objects) {
            s = s.replaceFirst("\\{\\}", object.toString().replaceAll("\\\\", "\\\\\\\\"));
        }
        this.logs.append(s).append("\n");
    }

    public void trace(String s, Throwable throwable) {
        this.logs.append(TRACE).append(s).append("\n");
        this.append(throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return true;
    }

    public void trace(Marker marker, String s) {
        throw new UnsupportedOperationException();
    }

    public void trace(Marker marker, String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        throw new UnsupportedOperationException();
    }

    public void trace(Marker marker, String s, Object ... objects) {
        throw new UnsupportedOperationException();
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String s) {
        this.logs.append(DEBUG).append(s).append("\n");
    }

    public void debug(String s, Object o) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(DEBUG).append(s).append("\n");
    }

    public void debug(String s, Object o, Object o1) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        s = s.replaceFirst("\\{\\}", o1.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(DEBUG).append(s).append("\n");
    }

    public void debug(String s, Object ... objects) {
        this.logs.append(DEBUG);
        for (Object object : objects) {
            s = s.replaceFirst("\\{\\}", object.toString().replaceAll("\\\\", "\\\\\\\\"));
        }
        this.logs.append(s).append("\n");
    }

    public void debug(String s, Throwable throwable) {
        this.logs.append(DEBUG).append(s).append("\n");
        this.append(throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return true;
    }

    public void debug(Marker marker, String s) {
        throw new UnsupportedOperationException();
    }

    public void debug(Marker marker, String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        throw new UnsupportedOperationException();
    }

    public void debug(Marker marker, String s, Object ... objects) {
        throw new UnsupportedOperationException();
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String s) {
        this.logs.append(INFO).append(s).append("\n");
    }

    public void info(String s, Object o) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(INFO).append(s).append("\n");
    }

    public void info(String s, Object o, Object o1) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        s = s.replaceFirst("\\{\\}", o1.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(INFO).append(s).append("\n");
    }

    public void info(String s, Object ... objects) {
        this.logs.append(INFO);
        for (Object object : objects) {
            s = s.replaceFirst("\\{\\}", object.toString().replaceAll("\\\\", "\\\\\\\\"));
        }
        this.logs.append(s).append("\n");
    }

    public void info(String s, Throwable throwable) {
        this.logs.append(INFO).append(s).append("\n");
        this.append(throwable);
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(Marker marker, String s) {
        throw new UnsupportedOperationException();
    }

    public void info(Marker marker, String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        throw new UnsupportedOperationException();
    }

    public void info(Marker marker, String s, Object ... objects) {
        throw new UnsupportedOperationException();
    }

    public void info(Marker marker, String s, Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String s) {
        this.logs.append(WARN).append(s).append("\n");
    }

    public void warn(String s, Object o) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(WARN).append(s).append("\n");
    }

    public void warn(String s, Object ... objects) {
        this.logs.append(WARN);
        for (Object object : objects) {
            s = s.replaceFirst("\\{\\}", object.toString().replaceAll("\\\\", "\\\\\\\\"));
        }
        this.logs.append(s).append("\n");
    }

    public void warn(String s, Object o, Object o1) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        s = s.replaceFirst("\\{\\}", o1.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(WARN).append(s).append("\n");
    }

    public void warn(String s, Throwable throwable) {
        this.logs.append(WARN).append(s).append("\n");
        this.append(throwable);
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(Marker marker, String s) {
        throw new UnsupportedOperationException();
    }

    public void warn(Marker marker, String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        throw new UnsupportedOperationException();
    }

    public void warn(Marker marker, String s, Object ... objects) {
        throw new UnsupportedOperationException();
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String s) {
        this.logs.append(ERROR).append(s).append("\n");
    }

    public void error(String s, Object o) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(ERROR).append(s).append("\n");
    }

    public void error(String s, Object o, Object o1) {
        s = s.replaceFirst("\\{\\}", o.toString().replaceAll("\\\\", "\\\\\\\\"));
        s = s.replaceFirst("\\{\\}", o1.toString().replaceAll("\\\\", "\\\\\\\\"));
        this.logs.append(ERROR).append(s).append("\n");
    }

    public void error(String s, Object ... objects) {
        this.logs.append(ERROR);
        for (Object object : objects) {
            s = s.replaceFirst("\\{\\}", object.toString().replaceAll("\\\\", "\\\\\\\\"));
        }
        this.logs.append(s).append("\n");
    }

    public void error(String s, Throwable throwable) {
        this.logs.append(ERROR).append(s).append("\n");
        this.append(throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(Marker marker, String s) {
        throw new UnsupportedOperationException();
    }

    public void error(Marker marker, String s, Object o) {
        throw new UnsupportedOperationException();
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        throw new UnsupportedOperationException();
    }

    public void error(Marker marker, String s, Object ... objects) {
        throw new UnsupportedOperationException();
    }

    public void error(Marker marker, String s, Throwable throwable) {
        throw new UnsupportedOperationException();
    }
}

