/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.CoreFeatureFlagProvider;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class FrontendUtilsTest {
    private static final String USER_HOME = "user.home";
    @Rule
    public final TemporaryFolder tmpDir = new TemporaryFolder();
    private static final String ROUTES_CONTENT_WITH_ONLY_SERVERSIDE_ROUTES = "    import {serverSideRoutes} from \"Frontend/generated/flow/Flow\";\n\n    export const routes = [\n      ...serverSideRoutes\n    ]\n";
    private static final String ROUTES_CONTENT_WITH_ONLY_CLIENTSIDE_ROUTES = "    import {serverSideRoutes} from \"Frontend/generated/flow/Flow\";\n\n    export const routes = [\n      {\n        path: 'hello',\n        component: 'hello-world-view',\n        title: 'Hello World',\n      },\n      {\n        path: '',\n        component: 'about-view',\n        title: 'About',\n      }\n    ]\n";
    private static final String ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_1 = "    import {serverSideRoutes} from \"Frontend/generated/flow/Flow\";\n\n    let routes = [\n      {\n        path: 'hello',\n        component: 'hello-world-view',\n        title: 'Hello World',\n      },\n      ...serverSideRoutes\n    ];\n\n    let unknownRoutes = [\n      ...serverSideRoutes\n    ];\n";
    private static final String ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_2 = "    import {serverSideRoutes} from \"Frontend/generated/flow/Flow\";\n\n    export const routes: RouteViewObject[] = [\n      {\n        path: 'hello',\n        component: 'hello-world-view',\n        title: 'Hello World',\n      },\n      ...serverSideRoutes\n    ]\n";
    private static final String ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_3 = "    import {serverSideRoutes} from \"Frontend/generated/flow/Flow\";\n\n    var myFunc = function() {\n         // this is checked too\n         export const routes = [\n          ...serverSideRoutes\n        ];\n    }\n\n    let unknownRoutes = [\n      ...serverSideRoutes\n    ];\n\n    const routes = [\n      {\n        path: 'hello',\n        component: 'hello-world-view',\n        title: 'Hello World',\n      },\n      ...serverSideRoutes\n    ];\n";
    private static final String ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_MAINLAYOUT_TSX = "    import { serverSideRoutes } from \"Frontend/generated/flow/Flow\";\n    import MainLayout from 'Frontend/views/MainLayout';\n    import ContactsView from 'Frontend/views/ContactsView';\n    import AboutView from 'Frontend/views/AboutView';\n    import { RouteObject } from 'react-router';\n\n    export const routes: RouteObject[] = [\n          {\n              element: <MainLayout />,\n              handle: { title: 'Hilla CRM' },\n              children: [\n                  { path: '/', element: <ContactsView />, handle: { title: 'Contacts' } },\n                  { path: '/about', element: <AboutView />, handle: { title: 'About' } },\n                  ...serverSideRoutes\n              ],\n          },\n      ];\n";
    private static final String ROUTES_CONTENT_WITH_SERVER_SIDE_ROUTES_MAINLAYOUT_TSX = "    import { serverSideRoutes } from \"Frontend/generated/flow/Flow\";\n    import MainLayout from 'Frontend/views/MainLayout';\n    import ContactsView from 'Frontend/views/ContactsView';\n    import AboutView from 'Frontend/views/AboutView';\n    import { RouteObject } from 'react-router';\n\n    export const routes: RouteObject[] = [\n          {\n              element: <MainLayout />,\n              handle: { title: 'Hilla CRM' },\n              children: [\n                  ...serverSideRoutes\n              ],\n          },\n      ];\n";
    private static final String ROUTES_CONTENT_WITH_WITH_FILE_ROUTES = "    import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n    import Flow from 'Frontend/generated/flow/Flow';\n    import fileRoutes from 'Frontend/generated/file-routes';\n\n    export const { router, routes } = new RouterConfigurationBuilder()\n        .withFileRoutes(fileRoutes)\n        .withFallback(Flow)\n        .build();\n";
    private static final String ROUTES_CONTENT_WITH_WITH_REACT_ROUTES = "    import { RouterConfigurationBuilder } from '@vaadin/hilla-file-router/runtime.js';\n    import Flow from 'Frontend/generated/flow/Flow';\n\n    export const { router, routes } = new RouterConfigurationBuilder()\n        .withReactRoutes([\n          {\n              element: <MainLayout />,\n              handle: { title: 'Hilla CRM' }\n          },\n        ])\n        .withFallback(Flow).build();\n";
    private static final String HILLA_VIEW_TSX = "    import { VerticalLayout } from \"@vaadin/react-components/VerticalLayout.js\";\n    export default function AboutView() {\n        return (\n            <VerticalLayout theme=\"padding\">\n                <p>This is a Hilla view</p>\n            </VerticalLayout>\n        );\n    }\n";

    @Test
    public void parseValidVersions() {
        FrontendVersion sixPointO = new FrontendVersion(6, 0);
        FrontendVersion requiredVersionTen = new FrontendVersion(10, 0);
        Assert.assertFalse((boolean)sixPointO.isEqualOrNewer(requiredVersionTen));
        Assert.assertFalse((boolean)sixPointO.isEqualOrNewer(new FrontendVersion(6, 1)));
        Assert.assertTrue((boolean)new FrontendVersion("10.0.0").isEqualOrNewer(requiredVersionTen));
        Assert.assertTrue((boolean)new FrontendVersion("10.0.2").isEqualOrNewer(requiredVersionTen));
        Assert.assertTrue((boolean)new FrontendVersion("10.2.0").isEqualOrNewer(requiredVersionTen));
    }

    @Test
    public void parseValidToolVersions() throws IOException {
        Assert.assertEquals((Object)"10.11.12", (Object)FrontendUtils.parseVersionString((String)"v10.11.12"));
        Assert.assertEquals((Object)"8.0.0", (Object)FrontendUtils.parseVersionString((String)"v8.0.0"));
        Assert.assertEquals((Object)"8.0.0", (Object)FrontendUtils.parseVersionString((String)"8.0.0"));
        Assert.assertEquals((Object)"6.9.0", (Object)FrontendUtils.parseVersionString((String)"Aktive Codepage: 1252\n6.9.0\n"));
    }

    @Test(expected=IOException.class)
    public void parseEmptyToolVersions() throws IOException {
        FrontendUtils.parseVersionString((String)" \n");
    }

    @Test
    public void should_getUnixRelativePath_when_givenTwoPaths() {
        Path sourcePath = (Path)Mockito.mock(Path.class);
        Path relativePath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)sourcePath.relativize((Path)Mockito.any())).thenReturn((Object)relativePath);
        Mockito.when((Object)relativePath.toString()).thenReturn((Object)"this\\is\\windows\\path");
        String relativeUnixPath = FrontendUtils.getUnixRelativePath((Path)sourcePath, (Path)this.tmpDir.getRoot().toPath());
        Assert.assertEquals((String)"Should replace windows path separator with unix path separator", (Object)"this/is/windows/path", (Object)relativeUnixPath);
        Mockito.when((Object)relativePath.toString()).thenReturn((Object)"this/is/unix/path");
        relativeUnixPath = FrontendUtils.getUnixRelativePath((Path)sourcePath, (Path)this.tmpDir.getRoot().toPath());
        Assert.assertEquals((String)"Should keep the same path when it uses unix path separator", (Object)"this/is/unix/path", (Object)relativeUnixPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void getVaadinHomeDirectory_noVaadinFolder_folderIsCreated() throws IOException {
        String originalHome = System.getProperty(USER_HOME);
        File home = this.tmpDir.newFolder();
        System.setProperty(USER_HOME, home.getPath());
        try {
            File vaadinDir = new File(home, ".vaadin");
            if (vaadinDir.exists()) {
                FileUtils.deleteDirectory((File)vaadinDir);
            }
            File vaadinHomeDirectory = FrontendUtils.getVaadinHomeDirectory();
            Assert.assertTrue((boolean)vaadinHomeDirectory.exists());
            Assert.assertTrue((boolean)vaadinHomeDirectory.isDirectory());
            vaadinHomeDirectory = FrontendUtils.getVaadinHomeDirectory();
            Assert.assertEquals((Object)".vaadin", (Object)vaadinDir.getName());
        }
        finally {
            System.setProperty(USER_HOME, originalHome);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public synchronized void getVaadinHomeDirectory_vaadinFolderIsAFile_throws() throws IOException {
        String originalHome = System.getProperty(USER_HOME);
        File home = this.tmpDir.newFolder();
        System.setProperty(USER_HOME, home.getPath());
        try {
            File vaadinDir = new File(home, ".vaadin");
            if (vaadinDir.exists()) {
                FileUtils.deleteDirectory((File)vaadinDir);
            }
            vaadinDir.createNewFile();
            FrontendUtils.getVaadinHomeDirectory();
        }
        finally {
            System.setProperty(USER_HOME, originalHome);
        }
    }

    @Test
    public void commandToString_longCommand_resultIsWrapped() {
        List<String> command = Arrays.asList("./node/node", "./node_modules/webpack-dev-server/bin/webpack-dev-server.js", "--config", "./webpack.config.js", "--port 57799", "--env watchDogPort=57798", "-d", "--inline=false");
        String wrappedCommand = FrontendUtils.commandToString((String)".", command);
        Assert.assertEquals((Object)"\n./node/node \\ \n    ./node_modules/webpack-dev-server/bin/webpack-dev-server.js \\ \n    --config ./webpack.config.js --port 57799 \\ \n    --env watchDogPort=57798 -d --inline=false \n", (Object)wrappedCommand);
    }

    @Test
    public void commandToString_commandContainsBaseDir_baseDirIsReplaced() {
        List<String> command = Arrays.asList("./node/node", "/somewhere/not/disclosable/node_modules/webpack-dev-server/bin/webpack-dev-server.js");
        String wrappedCommand = FrontendUtils.commandToString((String)"/somewhere/not/disclosable", command);
        Assert.assertEquals((Object)"\n./node/node \\ \n    ./node_modules/webpack-dev-server/bin/webpack-dev-server.js \n", (Object)wrappedCommand);
    }

    @Test
    public void deleteNodeModules_nopIfNotExists() throws IOException {
        File nodeModules = new File(this.tmpDir.getRoot(), "node_modules");
        FrontendUtils.deleteNodeModules((File)nodeModules);
    }

    @Test(expected=IOException.class)
    public void deleteNodeModules_throwsIfNotNamedNodeModules() throws IOException {
        File myModules = new File(this.tmpDir.getRoot(), "my_modules");
        myModules.mkdirs();
        FrontendUtils.deleteNodeModules((File)myModules);
    }

    @Test
    public void deleteNodeModules_canDeleteSymlinksAndNotFollowThem() throws IOException {
        Assume.assumeFalse((boolean)FrontendUtils.isWindows());
        File externalDir = new File(this.tmpDir.getRoot(), "external");
        File externalLicense = new File(externalDir, "LICENSE");
        externalLicense.getParentFile().mkdirs();
        externalLicense.createNewFile();
        File nodeModules = new File(this.tmpDir.getRoot(), "node_modules");
        File containing = new File(nodeModules, ".pnpm/a/node_modules/dep");
        containing.mkdirs();
        File license = new File(containing, "LICENSE");
        license.createNewFile();
        File linking = new File(nodeModules, ".pnpm/b/node_modules/dep");
        linking.getParentFile().mkdirs();
        Files.createSymbolicLink(linking.toPath(), new File("../../a/node_modules/dep").toPath(), new FileAttribute[0]);
        File linkingExternal = new File(nodeModules, ".pnpm/b/node_modules/external");
        Files.createSymbolicLink(linkingExternal.toPath(), new File("../../../../external").toPath(), new FileAttribute[0]);
        Assert.assertTrue((boolean)nodeModules.exists());
        Assert.assertTrue((boolean)linking.exists());
        Assert.assertTrue((boolean)new File(linking, "LICENSE").exists());
        Assert.assertTrue((boolean)new File(linkingExternal, "LICENSE").exists());
        FrontendUtils.deleteNodeModules((File)nodeModules);
        Assert.assertFalse((boolean)nodeModules.exists());
        Assert.assertTrue((boolean)externalLicense.exists());
    }

    @Test
    public void symlinkByNpm_deleteDirectory_doesNotDeleteSymlinkFolderFiles() throws IOException, ExecutionFailedException {
        File npmFolder = this.tmpDir.newFolder();
        File symbolic = new File(npmFolder, "symbolic");
        symbolic.mkdir();
        File symbolicPackageJson = new File(symbolic, "package.json");
        FileUtils.writeStringToFile((File)symbolicPackageJson, (String)"{}", (Charset)StandardCharsets.UTF_8);
        File linkFolderFile = new File(symbolic, "symbol.txt");
        linkFolderFile.createNewFile();
        ObjectNode packageJson = JacksonUtils.createObjectNode();
        packageJson.set("dependencies", (JsonNode)JacksonUtils.createObjectNode());
        ((ObjectNode)packageJson.get("dependencies")).put("@symbolic/link", "./" + symbolic.getName());
        FileUtils.writeStringToFile((File)new File(npmFolder, "package.json"), (String)packageJson.toString(), (Charset)StandardCharsets.UTF_8);
        final Logger logger = (Logger)Mockito.spy((Object)LoggerFactory.getLogger(NodeUpdater.class));
        Options options = new MockOptions(npmFolder).withBuildDirectory("target");
        NodeUpdater nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)Mockito.mock(FrontendDependencies.class), options){

            public void execute() {
            }

            Logger log() {
                return logger;
            }
        };
        options.withNodeVersion("v24.12.0").withNodeDownloadRoot(URI.create("https://nodejs.org/dist/"));
        new TaskRunNpmInstall(nodeUpdater, options).execute();
        FrontendUtils.deleteNodeModules((File)new File(npmFolder, "node_modules"));
        Assert.assertTrue((String)"Linked folder contents should not be removed.", (boolean)linkFolderFile.exists());
    }

    @Test
    public void consumeProcessStreams_streamsConsumed() throws Exception {
        Pair<String, String> streams = this.executeExternalProcess("STDOUT", "Test", "text");
        String stdOut = (String)((Object)streams.getFirst());
        String stdErr = (String)((Object)streams.getSecond());
        Assert.assertTrue((String)("Unexpected STDOUT contents: " + stdOut), (boolean)stdOut.contains("STDOUT, Test, text"));
        Assert.assertTrue((String)("Expected STDERR to be empty, but was " + stdErr), (boolean)stdErr.isBlank());
        streams = this.executeExternalProcess("STDERR", "Test", "text");
        stdOut = (String)((Object)streams.getFirst());
        stdErr = (String)((Object)streams.getSecond());
        Assert.assertTrue((String)("Expected STDOUT to be empty, but was " + stdOut), (boolean)stdOut.isBlank());
        Assert.assertTrue((String)("Unexpected STDERR contents: " + stdErr), (boolean)stdErr.contains("STDERR, Test, text"));
        streams = this.executeExternalProcess("BOTH", "Test", "text");
        stdOut = (String)((Object)streams.getFirst());
        stdErr = (String)((Object)streams.getSecond());
        Assert.assertTrue((String)("Unexpected STDERR contents: " + stdOut), (boolean)stdOut.contains("STDOUT: BOTH, Test, text"));
        Assert.assertTrue((String)("Unexpected STDERR contents: " + stdErr), (boolean)stdErr.contains("STDERR: BOTH, Test, text"));
        streams = this.executeExternalProcess("THROW EXCEPTION");
        stdOut = (String)((Object)streams.getFirst());
        stdErr = (String)((Object)streams.getSecond());
        Assert.assertTrue((String)("Expected STDOUT to be empty, but was " + stdOut), (boolean)stdOut.isBlank());
        Assert.assertTrue((String)("Unexpected STDERR contents: " + stdErr), (stdErr.contains("RuntimeException") && stdErr.contains("Invalid stream THROW EXCEPTION") ? 1 : 0) != 0);
    }

    @Test
    public void isReactRouterRequired_importsVaadinRouter_false() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("index.ts", "    import { Router } from '@vaadin/router';\n    import { routes } from './routes';\n\n    export const router = new Router(document.querySelector('#outlet'));\n    router.setRoutes(routes);\n");
        Assert.assertFalse((String)"vaadin-router expected when it imported", (boolean)FrontendUtils.isReactRouterRequired((File)frontend));
    }

    @Test
    public void isReactRouterRequired_doesntImportVaadinRouter_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("index.ts", "    import { createElement } from \"react\";\n    import { createRoot } from \"react-dom/client\";\n    import App from \"./App.js\";\n\n    createRoot(document.getElementById(\"outlet\")!).render(createElement(App));\n");
        Assert.assertTrue((String)"react-router expected when no vaadin-router imported", (boolean)FrontendUtils.isReactRouterRequired((File)frontend));
    }

    @Test
    public void isReactRouterRequired_noIndexTsFile_true() throws IOException {
        File frontend = this.tmpDir.newFolder("./src/main/frontend/");
        Assert.assertTrue((String)"react-router expected when index.ts isn't there", (boolean)FrontendUtils.isReactRouterRequired((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_onlyServerSideRoutesTs_false() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.ts", ROUTES_CONTENT_WITH_ONLY_SERVERSIDE_ROUTES);
        Assert.assertFalse((String)"hilla-views are not expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_onlyServerSideRoutesTsx_false() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_ONLY_SERVERSIDE_ROUTES);
        Assert.assertFalse((String)"hilla-views are not expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_onlyClientSideRoutesTs_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.ts", ROUTES_CONTENT_WITH_ONLY_CLIENTSIDE_ROUTES);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_onlyClientSideRoutesTsx_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_ONLY_CLIENTSIDE_ROUTES);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_clientAndServerSideRoutesTs1_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.ts", ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_1);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_clientAndServerSideRoutesTsx1_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_1);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_clientAndServerSideRoutesTs2_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.ts", ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_2);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_clientAndServerSideRoutesTsx2_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_2);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_clientAndServerSideRoutesTs3_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.ts", ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_3);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_clientAndServerSideRoutesTsx3_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_3);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_clientAndServerSideRoutesMainLayoutTsx_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_CLIENT_AND_SERVER_SIDE_ROUTES_MAINLAYOUT_TSX);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_serverSideRoutesMainLayoutTsx_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_SERVER_SIDE_ROUTES_MAINLAYOUT_TSX);
        Assert.assertTrue((String)"hilla-views are expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_withFileRoutes_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_WITH_FILE_ROUTES);
        Assert.assertTrue((String)"hilla-views are expected, as withFileRoutes is used", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_withReactRoutes_true() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("routes.tsx", ROUTES_CONTENT_WITH_WITH_REACT_ROUTES);
        Assert.assertTrue((String)"hilla-views are expected, as withReactRoutes is used", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isHillaViewsUsed_nonEmptyHillaViewInViews_true() throws IOException {
        File frontend = null;
        for (String ext : Arrays.asList(".js", ".jsx", ".ts", ".tsx")) {
            try {
                frontend = this.prepareFrontendForRoutesFile("views/HillaView" + ext, HILLA_VIEW_TSX);
                Assert.assertTrue((String)"hilla view is present, thus Hilla is expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
            }
            finally {
                if (frontend == null || !frontend.exists()) continue;
                FileUtils.deleteQuietly((File)frontend);
            }
        }
    }

    @Test
    public void isHillaViewsUsed_emptyHillaViewContent_false() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("views/HillaView.ts", "//comment");
        Assert.assertFalse((String)"empty Hilla view, Hilla not expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void isHillaViewsUsed_noViews_false() throws IOException {
        File frontend = this.prepareFrontendForRoutesFile("views/foo.css", "some css");
        Assert.assertFalse((String)"no Hilla views, Hilla not expected", (boolean)FrontendUtils.isHillaViewsUsed((File)frontend));
    }

    @Test
    public void platformVersion_returnsExpectedVersion() throws IOException {
        File npmFolder = this.tmpDir.newFolder();
        File versionJsonFile = new File(npmFolder, "versions.json");
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource("vaadin-core-versions.json")).thenReturn((Object)versionJsonFile.toURI().toURL());
        String versionJsonString = "{  \"platform\": \"21.0.0\"\n}\n";
        FileUtils.write((File)versionJsonFile, (CharSequence)versionJsonString, (Charset)StandardCharsets.UTF_8);
        Optional vaadinVersion = FrontendBuildUtils.getVaadinVersion((ClassFinder)finder);
        Assert.assertTrue((String)"versions.json should have had the platform field", (boolean)vaadinVersion.isPresent());
        Assert.assertEquals((String)"Received faulty version", (Object)"21.0.0", vaadinVersion.get());
        versionJsonString = "{}\n";
        FileUtils.write((File)versionJsonFile, (CharSequence)versionJsonString, (Charset)StandardCharsets.UTF_8);
        vaadinVersion = FrontendBuildUtils.getVaadinVersion((ClassFinder)finder);
        Assert.assertFalse((String)"versions.json should not contain platform version", (boolean)vaadinVersion.isPresent());
    }

    @Test
    public void noVersionsJson_getVersionsDoesntThrow() throws IOException {
        File npmFolder = this.tmpDir.newFolder();
        File versionJsonFile = new File(npmFolder, "versions.json");
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource("vaadin-core-versions.json")).thenReturn((Object)versionJsonFile.toURI().toURL());
        Mockito.when((Object)finder.getResource("vaadin-core-versions.json")).thenReturn(null);
        Optional vaadinVersion = FrontendBuildUtils.getVaadinVersion((ClassFinder)finder);
        Assert.assertFalse((String)"versions.json should not contain platform version", (boolean)vaadinVersion.isPresent());
    }

    @Test
    public void platformMajorVersionVersionUpdated_returnsTrueOnlyForMajorVersionChange_inNodeModulesVersion() throws IOException {
        File npmFolder = this.tmpDir.newFolder();
        File versionJsonFile = new File(npmFolder, "versions.json");
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource("vaadin-core-versions.json")).thenReturn((Object)versionJsonFile.toURI().toURL());
        String versionJsonString = "{  \"platform\": \"21.1.0\"\n}\n";
        Files.writeString(versionJsonFile.toPath(), (CharSequence)versionJsonString, StandardCharsets.UTF_8, new OpenOption[0]);
        File nodeModules = new File(npmFolder, "node_modules");
        File projectVaadinJson = new File(nodeModules, ".vaadin/vaadin.json");
        Files.createDirectories(projectVaadinJson.getParentFile().toPath(), new FileAttribute[0]);
        String projectVersionString = "        {\n          \"vaadinVersion\" : \"21.0.0\"\n        }\n";
        Files.writeString(projectVaadinJson.toPath(), (CharSequence)projectVersionString, StandardCharsets.UTF_8, new OpenOption[0]);
        Assert.assertFalse((String)"Change in minor version should return false", (boolean)FrontendBuildUtils.isPlatformMajorVersionUpdated((ClassFinder)finder, (File)npmFolder, (File)nodeModules, (File)npmFolder));
        versionJsonString = "{  \"platform\": \"22.0.0\"\n}\n";
        Files.writeString(versionJsonFile.toPath(), (CharSequence)versionJsonString, StandardCharsets.UTF_8, new OpenOption[0]);
        Assert.assertTrue((String)"Change in major version should return true", (boolean)FrontendBuildUtils.isPlatformMajorVersionUpdated((ClassFinder)finder, (File)npmFolder, (File)nodeModules, (File)npmFolder));
    }

    @Test
    public void platformMajorVersionVersionUpdated_returnsTrueOnlyForMajorVersionChange_inBundleVersion() throws IOException {
        File npmFolder = this.tmpDir.newFolder();
        File versionJsonFile = new File(npmFolder, "versions.json");
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource("vaadin-core-versions.json")).thenReturn((Object)versionJsonFile.toURI().toURL());
        String versionJsonString = "{  \"platform\": \"21.1.0\"\n}\n";
        Files.writeString(versionJsonFile.toPath(), (CharSequence)versionJsonString, StandardCharsets.UTF_8, new OpenOption[0]);
        File nodeModules = new File(npmFolder, "node_modules");
        File buildFolder = new File(npmFolder, "target");
        File bundleFolder = new File(buildFolder, "dev-bundle");
        Files.createDirectories(bundleFolder.toPath(), new FileAttribute[0]);
        File bundleVaadinJson = new File(bundleFolder, "vaadin.json");
        String bundleVersionString = "        {\n          \"vaadinVersion\" : \"21.0.0\"\n        }\n";
        Files.writeString(bundleVaadinJson.toPath(), (CharSequence)bundleVersionString, StandardCharsets.UTF_8, new OpenOption[0]);
        Assert.assertFalse((String)"Change in minor version should return false", (boolean)FrontendBuildUtils.isPlatformMajorVersionUpdated((ClassFinder)finder, (File)npmFolder, (File)nodeModules, (File)buildFolder));
        versionJsonString = "{  \"platform\": \"22.0.0\"\n}\n";
        Files.writeString(versionJsonFile.toPath(), (CharSequence)versionJsonString, StandardCharsets.UTF_8, new OpenOption[0]);
        Assert.assertTrue((String)"Change in major version should return true", (boolean)FrontendBuildUtils.isPlatformMajorVersionUpdated((ClassFinder)finder, (File)npmFolder, (File)nodeModules, (File)buildFolder));
    }

    @Test
    public void platformMajorVersionVersionUpdated_bundleVersionIsCheckedOverNodeModulesVersion() throws IOException {
        File npmFolder = this.tmpDir.newFolder();
        File versionJsonFile = new File(npmFolder, "versions.json");
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource("vaadin-core-versions.json")).thenReturn((Object)versionJsonFile.toURI().toURL());
        String versionJsonString = "{  \"platform\": \"21.1.0\"\n}\n";
        Files.writeString(versionJsonFile.toPath(), (CharSequence)versionJsonString, StandardCharsets.UTF_8, new OpenOption[0]);
        File nodeModules = new File(npmFolder, "node_modules");
        File buildFolder = new File(npmFolder, "target");
        File bundleFolder = new File(buildFolder, "dev-bundle");
        Files.createDirectories(bundleFolder.toPath(), new FileAttribute[0]);
        File bundleVaadinJson = new File(bundleFolder, "vaadin.json");
        String bundleVersionString = "        {\n          \"vaadinVersion\" : \"21.0.0\"\n        }\n";
        Files.writeString(bundleVaadinJson.toPath(), (CharSequence)bundleVersionString, StandardCharsets.UTF_8, new OpenOption[0]);
        File projectVaadinJson = new File(nodeModules, ".vaadin/vaadin.json");
        Files.createDirectories(projectVaadinJson.getParentFile().toPath(), new FileAttribute[0]);
        String projectVersionString = "        {\n          \"vaadinVersion\" : \"20.0.0\"\n        }\n";
        Files.writeString(projectVaadinJson.toPath(), (CharSequence)projectVersionString, StandardCharsets.UTF_8, new OpenOption[0]);
        Assert.assertFalse((String)"Change in minor version should return false", (boolean)FrontendBuildUtils.isPlatformMajorVersionUpdated((ClassFinder)finder, (File)npmFolder, (File)nodeModules, (File)buildFolder));
    }

    @Test
    public void isTailwindCssEnabled_withOptions() throws IOException {
        FeatureFlags featureFlags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        ((FeatureFlags)Mockito.doReturn((Object)true).when((Object)featureFlags)).isEnabled(CoreFeatureFlagProvider.TAILWIND_CSS);
        File npmFolder = this.tmpDir.newFolder();
        Options options = new MockOptions(npmFolder).withFeatureFlags(featureFlags);
        Assert.assertTrue((String)"Expected TailwindCSS to be enabled when feature flag is set in Node tasks options", (boolean)FrontendBuildUtils.isTailwindCssEnabled((Options)options));
    }

    private File prepareFrontendForRoutesFile(String fileName, String content) throws IOException {
        return this.prepareFrontendForRoutesFile(fileName, content, false);
    }

    private File prepareFrontendForRoutesFile(String fileName, String content, boolean generateDummyFSView) throws IOException {
        File frontend = this.tmpDir.newFolder("./src/main/frontend/");
        FileUtils.write((File)new File(frontend, fileName), (CharSequence)content, (Charset)StandardCharsets.UTF_8);
        if (generateDummyFSView) {
            FileUtils.write((File)new File(frontend, "views/testFSView.ts"), (CharSequence)"export default function TestFSView() { return 'TestFSView'; }", (Charset)StandardCharsets.UTF_8);
        }
        return frontend;
    }

    private Pair<String, String> executeExternalProcess(String ... args) throws Exception {
        ArrayList<String> cmd = new ArrayList<String>(List.of(Paths.get(System.getProperty("java.home"), "bin", "java").toFile().getAbsolutePath(), "-cp", System.getProperty("java.class.path"), TestExecutable.class.getName()));
        cmd.addAll(List.of(args));
        Process process = new ProcessBuilder(cmd).start();
        process.waitFor(1L, TimeUnit.SECONDS);
        return (Pair)FrontendUtils.consumeProcessStreams((Process)process).get(100L, TimeUnit.MILLISECONDS);
    }

    public static class TestExecutable {
        public static void main(String ... args) {
            switch (args[0]) {
                case "STDOUT": {
                    System.out.println(String.join((CharSequence)", ", args));
                    break;
                }
                case "STDERR": {
                    System.err.println(String.join((CharSequence)", ", args));
                    break;
                }
                case "BOTH": {
                    System.out.println("STDOUT: " + String.join((CharSequence)", ", args));
                    System.err.println("STDERR: " + String.join((CharSequence)", ", args));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid stream " + args[0]);
                }
            }
        }
    }
}

