/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.internal.FrontendVersion;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendToolsTestHelper;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.installer.ProxyConfig;
import com.vaadin.flow.testcategory.SlowTests;
import com.vaadin.flow.testutil.FrontendStubs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.slf4j.LoggerFactory;

@NotThreadSafe
@Category(value={SlowTests.class})
public class FrontendToolsTest {
    public static final String DEFAULT_NODE = FrontendUtils.isWindows() ? "node\\node.exe" : "node/node";
    public static final String NPM_CLI_STRING = FrontendUtils.isWindows() ? "node\\node_modules\\npm\\bin\\npm-cli.js" : "node/lib/node_modules/npm/bin/npm-cli.js";
    private static final String OLD_PNPM_VERSION = "4.5.0";
    private static final String SUPPORTED_PNPM_VERSION = "7.0.0";
    private String baseDir;
    private String vaadinHomeDir;
    @Rule
    public final TemporaryFolder tmpDir = new TemporaryFolder();
    @Rule
    public final TemporaryFolder tmpDirWithNpmrc = new TemporaryFolder();
    private final FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private FrontendTools tools;
    private FrontendToolsSettings settings;

    @Before
    public void setup() throws Exception {
        FrontendStubs.resetFrontendToolsNodeCache();
        this.baseDir = this.tmpDir.newFolder().getAbsolutePath();
        this.vaadinHomeDir = this.tmpDir.newFolder().getAbsolutePath();
        this.settings = new FrontendToolsSettings(this.baseDir, (SerializableSupplier & Serializable)() -> this.vaadinHomeDir);
        this.tools = new FrontendTools(this.settings);
        ReflectTools.setJavaFieldValue((Object)this.tools, (Field)FrontendTools.class.getDeclaredField("activeNodeInstallation"), null);
    }

    @Test
    public void installNode_NodeIsInstalledToTargetDirectory() throws FrontendUtils.UnknownVersionException {
        this.settings.setForceAlternativeNode(true);
        this.tools = new FrontendTools(this.settings);
        String nodeExecutable = this.tools.getNodeExecutable();
        Assert.assertNotNull((Object)nodeExecutable);
        ArrayList<String> nodeVersionCommand = new ArrayList<String>();
        nodeVersionCommand.add(nodeExecutable);
        nodeVersionCommand.add("--version");
        FrontendVersion node = FrontendUtils.getVersion((String)"node", nodeVersionCommand);
        Assert.assertEquals((Object)new FrontendVersion("v24.12.0").getFullVersion(), (Object)node.getFullVersion());
        ArrayList<String> npmVersionCommand = new ArrayList<String>(this.tools.getNpmExecutable());
        npmVersionCommand.add("--version");
        FrontendVersion npm = FrontendUtils.getVersion((String)"npm", npmVersionCommand);
        FrontendVersion npmDefault = new FrontendVersion("11.6.2");
        Assert.assertEquals((String)"Major version should match", (long)npmDefault.getMajorVersion(), (long)npm.getMajorVersion());
        Assert.assertEquals((String)"Minor version should match", (long)npmDefault.getMinorVersion(), (long)npm.getMinorVersion());
    }

    @Test
    public void nodeIsBeingLocated_updateTooOldNode_NodeInstalledToTargetDirectoryIsUpdated() throws FrontendUtils.UnknownVersionException {
        FrontendVersion updatedNodeVersion = this.getUpdatedAlternativeNodeVersion("7.7.3", (SerializableSupplier<String>)(SerializableSupplier & Serializable)() -> this.tools.getNodeExecutable());
        Assert.assertEquals((String)"Failed to update the old Node version when being located", (Object)new FrontendVersion("v24.12.0").getFullVersion(), (Object)updatedNodeVersion.getFullVersion());
    }

    @Test
    public void forceAlternativeDirectory_updateTooOldNode_NodeInstalledToTargetDirectoryIsUpdated() throws FrontendUtils.UnknownVersionException {
        FrontendVersion updatedNodeVersion = this.getUpdatedAlternativeNodeVersion("7.7.3", (SerializableSupplier<String>)(SerializableSupplier & Serializable)() -> this.tools.getNodeExecutable());
        Assert.assertEquals((String)"Failed to update the old Node version when alternative directory forced", (Object)new FrontendVersion("v24.12.0").getFullVersion(), (Object)updatedNodeVersion.getFullVersion());
    }

    private FrontendVersion getUpdatedAlternativeNodeVersion(String oldNodeVersion, SerializableSupplier<String> nodeUpdateCommand) throws FrontendUtils.UnknownVersionException {
        this.settings.setForceAlternativeNode(true);
        this.tools = new FrontendTools(this.settings);
        String toBeInstalled = "v" + oldNodeVersion;
        String nodeExecutable = FrontendToolsTestHelper.installNode(new File(this.vaadinHomeDir), this.tools.getProxies(), toBeInstalled, null);
        Assert.assertNotNull((Object)nodeExecutable);
        ArrayList<String> nodeVersionCommand = new ArrayList<String>();
        nodeVersionCommand.add(nodeExecutable);
        nodeVersionCommand.add("--version");
        FrontendVersion node = FrontendUtils.getVersion((String)"node", nodeVersionCommand);
        Assert.assertEquals((String)"Wrong node version installed", (Object)oldNodeVersion, (Object)node.getFullVersion());
        nodeExecutable = (String)nodeUpdateCommand.get();
        nodeVersionCommand = new ArrayList();
        nodeVersionCommand.add(nodeExecutable);
        nodeVersionCommand.add("--version");
        return FrontendUtils.getVersion((String)"node", nodeVersionCommand);
    }

    private void prepareNodeDownloadableZipAt(String baseDir, String version) throws IOException {
        Platform platform = Platform.guess();
        String nodeExec = platform.isWindows() ? "node.exe" : "node";
        String prefix = "node-" + version + "-" + platform.getNodeClassifier(new FrontendVersion(version));
        File downloadDir = new File(baseDir, version);
        FileUtils.forceMkdir((File)downloadDir);
        File archiveFile = new File(downloadDir, prefix + "." + platform.getArchiveExtension());
        archiveFile.createNewFile();
        Path tempArchive = archiveFile.toPath();
        if (platform.getArchiveExtension().equals("zip")) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempArchive, new OpenOption[0]));){
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/" + nodeExec));
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/node_modules/npm/bin/npm"));
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/node_modules/npm/bin/npm.cmd"));
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(prefix + "/node_modules/npm/bin/npm-cli.js"));
                zipOutputStream.closeEntry();
            }
        }
        try (OutputStream fo = Files.newOutputStream(tempArchive, new OpenOption[0]);
             GzipCompressorOutputStream gzo = new GzipCompressorOutputStream(fo);
             TarArchiveOutputStream o = new TarArchiveOutputStream((OutputStream)gzo);){
            o.putArchiveEntry(o.createArchiveEntry(new File(prefix + "/bin/" + nodeExec), prefix + "/bin/" + nodeExec));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(prefix + "/bin/npm"), prefix + "/bin/npm"));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(prefix + "/lib/node_modules/npm/bin/npm"), prefix + "/lib/node_modules/npm/bin/npm"));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(prefix + "/lib/node_modules/npm/bin/npm.cmd"), prefix + "/lib/node_modules/npm/bin/npm.cmd"));
            o.closeArchiveEntry();
            o.putArchiveEntry(o.createArchiveEntry(new File(prefix + "/lib/node_modules/npm/bin/npm-cli.js"), prefix + "/lib/node_modules/npm/bin/npm-cli.js"));
            o.closeArchiveEntry();
        }
    }

    @Test
    public void installNodeFromFileSystem_NodeIsInstalledToTargetDirectory() throws IOException {
        this.prepareNodeDownloadableZipAt(this.baseDir, "v24.12.0");
        String nodeExecutable = this.installNodeToTempFolder();
        Assert.assertNotNull((Object)nodeExecutable);
        String npmInstallPath = this.getVersionedNpmBinPath("v24.12.0") + "npm";
        Assert.assertTrue((String)"npm should have been copied to node_modules", (boolean)new File(this.vaadinHomeDir, npmInstallPath).exists());
    }

    @Test
    public void installNodeFromFileSystem_ForceAlternativeNodeExecutableInstallsToTargetDirectory() throws Exception {
        String testVersion = "v12.10.0";
        String npmPath = this.getVersionedNpmBinPath(testVersion) + "npm";
        Assert.assertFalse((String)"npm should not yet be present", (boolean)new File(this.vaadinHomeDir, npmPath).exists());
        this.settings.setNodeDownloadRoot(new File(this.baseDir).toURI());
        this.settings.setNodeVersion(testVersion);
        this.settings.setForceAlternativeNode(true);
        this.tools = new FrontendTools(this.settings);
        this.prepareNodeDownloadableZipAt(this.baseDir, testVersion);
        this.tools.getNodeExecutable();
        Assert.assertTrue((String)"npm should have been copied to node_modules", (boolean)new File(this.vaadinHomeDir, npmPath).exists());
    }

    private String getVersionedNpmBinPath(String nodeVersion) {
        return FrontendUtils.isWindows() ? "node-" + nodeVersion + "/node_modules/npm/bin/" : "node-" + nodeVersion + "/lib/node_modules/npm/bin/";
    }

    @Test
    public void homeNodeIsNotForced_useGlobalNode() throws IOException, FrontendUtils.UnknownVersionException {
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)this.vaadinHomeDir);
        String nodeCommand = FrontendUtils.isWindows() ? "node.exe" : "node";
        File file = this.frontendToolsLocator.tryLocateTool(nodeCommand).orElse(null);
        if (file == null) {
            LoggerFactory.getLogger(FrontendToolsTest.class).info("No global node found, skipping test");
            return;
        }
        LoggerFactory.getLogger(FrontendToolsTest.class).info("Found global node {}", (Object)file.getAbsolutePath());
        ArrayList versionCommand = Lists.newArrayList();
        versionCommand.add(file.getAbsolutePath());
        versionCommand.add("--version");
        FrontendVersion installedNodeVersion = FrontendUtils.getVersion((String)"node", (List)versionCommand);
        if (installedNodeVersion.isOlderThan(FrontendTools.SUPPORTED_NODE_VERSION)) {
            LoggerFactory.getLogger(FrontendToolsTest.class).info("Global version of node is {} which is older than the supported version {}", (Object)installedNodeVersion.getFullVersion(), (Object)FrontendTools.SUPPORTED_NODE_VERSION.getFullVersion());
            return;
        }
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)"node"));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)DEFAULT_NODE)));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)NPM_CLI_STRING)));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.vaadinHomeDir)));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.baseDir)));
        Assert.assertEquals((long)5L, (long)this.tools.getNpmExecutable().size());
        MatcherAssert.assertThat((Object)((String)this.tools.getNpmExecutable().get(0)), (Matcher)Matchers.containsString((String)"node"));
        MatcherAssert.assertThat((Object)((String)this.tools.getNpmExecutable().get(1)), (Matcher)Matchers.containsString((String)"npm"));
        MatcherAssert.assertThat((Object)((String)this.tools.getNpmExecutable().get(2)), (Matcher)Matchers.containsString((String)"--no-update-notifier"));
        MatcherAssert.assertThat((Object)((String)this.tools.getNpmExecutable().get(3)), (Matcher)Matchers.containsString((String)"--no-audit"));
        MatcherAssert.assertThat((Object)((String)this.tools.getNpmExecutable().get(4)), (Matcher)Matchers.containsString((String)"--scripts-prepend-node-path=true"));
    }

    @Test
    public void getNpmExecutable_removesPnpmLock() throws IOException {
        File file = new File(this.baseDir, "pnpm-lock.yaml");
        file.createNewFile();
        this.tools.getNpmExecutable();
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void knownFaultyNpmVersionThrowsException() {
        this.assertFaultyNpmVersion(new FrontendVersion(9, 2, 0));
    }

    @Ignore(value="Until a newer version of Node.js is installed in CI/CD, which doesn't let pnpm version check to fail")
    @Test
    public void getPnpmExecutable_executableIsAvailable() {
        List executable = this.tools.getPnpmExecutable();
        Assert.assertTrue((boolean)executable.contains("--shamefully-hoist=true"));
        Assert.assertTrue((boolean)executable.stream().anyMatch(cmd -> cmd.contains("pnpm")));
    }

    @Test
    public void validateNodeAndNpmVersion_pnpmLockIsNotRemoved() throws IOException {
        File file = new File(this.baseDir, "pnpm-lock.yaml");
        file.createNewFile();
        this.tools.validateNodeAndNpmVersion();
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void ensureNodeExecutableInHome_vaadinHomeNodeIsAFolder_reinstallsOrSelectsOtherVersion() throws IOException, FrontendUtils.UnknownVersionException {
        this.settings.setForceAlternativeNode(true);
        this.tools = new FrontendTools(this.settings);
        String version = "v24.12.0";
        String nodePath = FrontendUtils.isWindows() ? "node-" + version + "/node.exe" : "node-" + version + "/bin/node";
        File node = new File(this.vaadinHomeDir, nodePath);
        FileUtils.forceMkdir((File)node);
        this.tools.getNodeExecutable();
        Assert.assertEquals((Object)"v24.12.0", (Object)("v" + this.tools.getNodeVersion().getFullVersion()));
    }

    @Test
    public void getProxies_noNpmrc_shouldReturnEmptyList() {
        File npmrc = new File(this.baseDir + "/.npmrc");
        if (npmrc.exists()) {
            npmrc.delete();
        }
        List proxyList = this.tools.getProxies();
        Assert.assertTrue((boolean)proxyList.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public synchronized void getProxies_systemPropertiesAndNpmrcWithProxySetting_shouldReturnAllProxies() throws IOException {
        File npmrc = new File(this.tmpDirWithNpmrc.newFolder("test2"), ".npmrc");
        this.settings.setBaseDir(npmrc.getParent());
        this.settings.setAlternativeDirGetter(null);
        this.tools = new FrontendTools(this.settings);
        Properties properties = new Properties();
        properties.put("proxy", "http://httpuser:httppassword@httphost:8080");
        properties.put("https-proxy", "http://httpsuser:httpspassword@httpshost:8081");
        properties.put("noproxy", "192.168.1.1,vaadin.com,mycompany.com");
        try (FileOutputStream fileOutputStream = new FileOutputStream(npmrc);){
            properties.store(fileOutputStream, null);
        }
        List proxyList = null;
        try {
            System.setProperty("NOPROXY", "somethingelse,someotherip,75.41.41.33");
            System.setProperty("HTTP_PROXY", "http://anotheruser:anotherpassword@aanotherhost:9090");
            System.setProperty("HTTPS_PROXY", "http://anotherusers:anotherpasswords@aanotherhosts:9091/");
            proxyList = this.tools.getProxies();
        }
        finally {
            System.clearProperty("NOPROXY");
            System.clearProperty("HTTP_PROXY");
            System.clearProperty("HTTPS_PROXY");
        }
        Assert.assertEquals((long)4L, (long)proxyList.size());
        ProxyConfig.Proxy systemHttpsProxy = ((ProxyConfig.Proxy)proxyList.get((int)0)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(0) : (ProxyConfig.Proxy)proxyList.get(1);
        ProxyConfig.Proxy systemProxy = ((ProxyConfig.Proxy)proxyList.get((int)0)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(1) : (ProxyConfig.Proxy)proxyList.get(0);
        ProxyConfig.Proxy npmrcHttpsProxy = ((ProxyConfig.Proxy)proxyList.get((int)2)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(2) : (ProxyConfig.Proxy)proxyList.get(3);
        ProxyConfig.Proxy npmrcProxy = ((ProxyConfig.Proxy)proxyList.get((int)2)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(3) : (ProxyConfig.Proxy)proxyList.get(2);
        Assert.assertEquals((Object)"http", (Object)systemProxy.protocol);
        Assert.assertEquals((Object)"anotheruser", (Object)systemProxy.username);
        Assert.assertEquals((Object)"anotherpassword", (Object)systemProxy.password);
        Assert.assertEquals((Object)"aanotherhost", (Object)systemProxy.host);
        Assert.assertEquals((long)9090L, (long)systemProxy.port);
        Assert.assertEquals((Object)"somethingelse|someotherip|75.41.41.33", (Object)systemProxy.nonProxyHosts);
        Assert.assertEquals((Object)"http", (Object)systemHttpsProxy.protocol);
        Assert.assertEquals((Object)"anotherusers", (Object)systemHttpsProxy.username);
        Assert.assertEquals((Object)"anotherpasswords", (Object)systemHttpsProxy.password);
        Assert.assertEquals((Object)"aanotherhosts", (Object)systemHttpsProxy.host);
        Assert.assertEquals((long)9091L, (long)systemHttpsProxy.port);
        Assert.assertEquals((Object)"somethingelse|someotherip|75.41.41.33", (Object)systemHttpsProxy.nonProxyHosts);
        Assert.assertEquals((Object)"http", (Object)npmrcHttpsProxy.protocol);
        Assert.assertEquals((Object)"httpsuser", (Object)npmrcHttpsProxy.username);
        Assert.assertEquals((Object)"httpspassword", (Object)npmrcHttpsProxy.password);
        Assert.assertEquals((Object)"httpshost", (Object)npmrcHttpsProxy.host);
        Assert.assertEquals((long)8081L, (long)npmrcHttpsProxy.port);
        Assert.assertEquals((Object)"192.168.1.1|vaadin.com|mycompany.com", (Object)npmrcHttpsProxy.nonProxyHosts);
        Assert.assertEquals((Object)"http", (Object)npmrcProxy.protocol);
        Assert.assertEquals((Object)"httpuser", (Object)npmrcProxy.username);
        Assert.assertEquals((Object)"httppassword", (Object)npmrcProxy.password);
        Assert.assertEquals((Object)"httphost", (Object)npmrcProxy.host);
        Assert.assertEquals((long)8080L, (long)npmrcProxy.port);
        Assert.assertEquals((Object)"192.168.1.1|vaadin.com|mycompany.com", (Object)npmrcProxy.nonProxyHosts);
    }

    @Test
    public synchronized void getProxies_npmrcWithProxySettingNoNoproxy_shouldReturnNullNoproxy() throws IOException {
        File npmrc = new File(this.tmpDirWithNpmrc.newFolder("test1"), ".npmrc");
        Properties properties = new Properties();
        properties.put("proxy", "http://httpuser:httppassword@httphost:8080");
        properties.put("https-proxy", "http://httpsuser:httpspassword@httpshost:8081");
        try (FileOutputStream fileOutputStream = new FileOutputStream(npmrc);){
            properties.store(fileOutputStream, null);
        }
        this.settings.setBaseDir(npmrc.getParent());
        this.settings.setAlternativeDirGetter(null);
        this.tools = new FrontendTools(this.settings);
        List proxyList = this.tools.getProxies();
        Assert.assertEquals((long)2L, (long)proxyList.size());
        ProxyConfig.Proxy httpsProxy = ((ProxyConfig.Proxy)proxyList.get((int)0)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(0) : (ProxyConfig.Proxy)proxyList.get(1);
        ProxyConfig.Proxy httpProxy = ((ProxyConfig.Proxy)proxyList.get((int)0)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(1) : (ProxyConfig.Proxy)proxyList.get(0);
        Assert.assertEquals((Object)"http", (Object)httpProxy.protocol);
        Assert.assertEquals((Object)"httpuser", (Object)httpProxy.username);
        Assert.assertEquals((Object)"httppassword", (Object)httpProxy.password);
        Assert.assertEquals((Object)"httphost", (Object)httpProxy.host);
        Assert.assertEquals((long)8080L, (long)httpProxy.port);
        Assert.assertNull((Object)httpProxy.nonProxyHosts);
        Assert.assertEquals((Object)"http", (Object)httpsProxy.protocol);
        Assert.assertEquals((Object)"httpsuser", (Object)httpsProxy.username);
        Assert.assertEquals((Object)"httpspassword", (Object)httpsProxy.password);
        Assert.assertEquals((Object)"httpshost", (Object)httpsProxy.host);
        Assert.assertEquals((long)8081L, (long)httpsProxy.port);
        Assert.assertNull((Object)httpsProxy.nonProxyHosts);
    }

    @Test
    public synchronized void getProxies_npmrcWithProxySetting_shouldReturnProxiesList() throws IOException {
        File npmrc = new File(this.tmpDirWithNpmrc.newFolder("test1"), ".npmrc");
        Properties properties = new Properties();
        properties.put("proxy", "http://httpuser:httppassword@httphost:8080");
        properties.put("https-proxy", "http://httpsuser:httpspassword@httpshost:8081");
        properties.put("noproxy", "192.168.1.1,vaadin.com,mycompany.com");
        try (FileOutputStream fileOutputStream = new FileOutputStream(npmrc);){
            properties.store(fileOutputStream, null);
        }
        this.settings.setBaseDir(npmrc.getParent());
        this.settings.setAlternativeDirGetter(null);
        this.tools = new FrontendTools(this.settings);
        List proxyList = this.tools.getProxies();
        Assert.assertEquals((long)2L, (long)proxyList.size());
        ProxyConfig.Proxy httpsProxy = ((ProxyConfig.Proxy)proxyList.get((int)0)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(0) : (ProxyConfig.Proxy)proxyList.get(1);
        ProxyConfig.Proxy httpProxy = ((ProxyConfig.Proxy)proxyList.get((int)0)).id.startsWith("https-proxy") ? (ProxyConfig.Proxy)proxyList.get(1) : (ProxyConfig.Proxy)proxyList.get(0);
        Assert.assertEquals((Object)"http", (Object)httpProxy.protocol);
        Assert.assertEquals((Object)"httpuser", (Object)httpProxy.username);
        Assert.assertEquals((Object)"httppassword", (Object)httpProxy.password);
        Assert.assertEquals((Object)"httphost", (Object)httpProxy.host);
        Assert.assertEquals((long)8080L, (long)httpProxy.port);
        Assert.assertEquals((Object)"192.168.1.1|vaadin.com|mycompany.com", (Object)httpProxy.nonProxyHosts);
        Assert.assertEquals((Object)"http", (Object)httpsProxy.protocol);
        Assert.assertEquals((Object)"httpsuser", (Object)httpsProxy.username);
        Assert.assertEquals((Object)"httpspassword", (Object)httpsProxy.password);
        Assert.assertEquals((Object)"httpshost", (Object)httpsProxy.host);
        Assert.assertEquals((long)8081L, (long)httpsProxy.port);
        Assert.assertEquals((Object)"192.168.1.1|vaadin.com|mycompany.com", (Object)httpsProxy.nonProxyHosts);
    }

    @Test
    public void forceHomeNode_useHomeNpmFirst() throws Exception {
        this.settings.setForceAlternativeNode(true);
        this.settings.setNodeDownloadRoot(new File(this.baseDir).toPath().toUri());
        this.tools = new FrontendTools(this.settings);
        this.prepareNodeDownloadableZipAt(this.baseDir, "v24.12.0");
        String nodeExecutable = FrontendToolsTestHelper.installNode(new File(this.vaadinHomeDir), this.tools.getProxies(), "v24.12.0", new File(this.baseDir).toPath().toUri());
        Assert.assertNotNull((Object)nodeExecutable);
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)"node"));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)this.vaadinHomeDir));
        List npmExecutable = this.tools.getNpmExecutable();
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(0)), (Matcher)Matchers.containsString((String)this.vaadinHomeDir));
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(1)), (Matcher)Matchers.containsString((String)this.getNpmCliString("v24.12.0")));
    }

    @Test
    public void getSuitablePnpm_tooOldGlobalVersionInstalled_throws() {
        this.settings.setUseGlobalPnpm(true);
        this.tools = new FrontendTools(this.settings);
        try {
            this.installGlobalPnpm(OLD_PNPM_VERSION);
            IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.tools.getSuitablePnpm());
            Assert.assertTrue((String)("Unexpected exception message content '" + exception.getMessage() + "'"), (boolean)exception.getMessage().contains("Found too old globally installed 'pnpm'. Please upgrade 'pnpm' to at least 7.0.0"));
        }
        finally {
            this.uninstallGlobalPnpm(OLD_PNPM_VERSION);
        }
    }

    @Test
    public void getSuitablePnpm_tooOldGlobalVersionInstalledAndSkipVersionCheck_accepted() {
        this.settings.setUseGlobalPnpm(true);
        this.settings.setIgnoreVersionChecks(true);
        this.tools = new FrontendTools(this.settings);
        try {
            this.installGlobalPnpm(OLD_PNPM_VERSION);
            List pnpmCommand = this.tools.getSuitablePnpm();
            Assert.assertTrue((String)"expected old global pnpm version accepted when skip version flag is set", (boolean)((String)pnpmCommand.get(pnpmCommand.size() - 1)).contains("pnpm"));
        }
        finally {
            this.uninstallGlobalPnpm(OLD_PNPM_VERSION);
        }
    }

    @Test
    public void getSuitablePnpm_supportedGlobalVersionInstalled_accepted() {
        this.settings.setUseGlobalPnpm(true);
        this.tools = new FrontendTools(this.settings);
        try {
            this.installGlobalPnpm(SUPPORTED_PNPM_VERSION);
            List pnpmCommand = this.tools.getSuitablePnpm();
            Assert.assertTrue((String)"expected supported global pnpm version accepted", (boolean)((String)pnpmCommand.get(pnpmCommand.size() - 1)).contains("pnpm"));
        }
        finally {
            this.uninstallGlobalPnpm(SUPPORTED_PNPM_VERSION);
        }
    }

    @Test
    public void getSuitablePnpm_useGlobalPnpm_noPnpmInstalled_throws() {
        Assume.assumeFalse((String)"Skipping test on windows.", (boolean)FrontendUtils.isWindows());
        Optional pnpm = this.frontendToolsLocator.tryLocateTool("pnpm");
        Assume.assumeFalse((String)"Skip this test once globally installed pnpm is discovered", (boolean)pnpm.isPresent());
        this.settings.setNodeDownloadRoot(URI.create(this.baseDir));
        this.settings.setUseGlobalPnpm(true);
        this.tools = new FrontendTools(this.settings);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.tools.getSuitablePnpm());
        Assert.assertTrue((String)("Unexpected exception message content '" + exception.getMessage() + "'"), (boolean)exception.getMessage().contains("Vaadin is configured to use a globally installed pnpm ('pnpm.global=true'), but pnpm was not found on your system."));
    }

    @Test
    public void getViteExecutable_returnsCorrectPath() throws IOException, FrontendUtils.CommandExecutionException {
        File projectDir = this.tmpDir.newFolder();
        Path packageJson = Files.createFile(projectDir.toPath().resolve("package.json"), new FileAttribute[0]);
        Files.write(packageJson, "  {\n  \"name\": \"test\",\n  \"private\": true\n}\n".getBytes(), new OpenOption[0]);
        Files.createDirectories(projectDir.toPath().resolve("node_modules/vite/bin/"), new FileAttribute[0]);
        Path vitePackageJson = Files.createFile(projectDir.toPath().resolve("node_modules/vite/package.json"), new FileAttribute[0]);
        Files.write(vitePackageJson, "{\n  \"name\": \"vite\",\n  \"version\": \"4.0.0\",\n  \"bin\": {\n    \"vite\": \"bin/vite.js\"\n  }\n}\n".getBytes(), new OpenOption[0]);
        Files.createFile(projectDir.toPath().resolve("node_modules/vite/bin/vite.js"), new FileAttribute[0]);
        Path vite = this.tools.getNpmPackageExecutable("vite", "vite", projectDir);
        Assert.assertEquals((Object)projectDir.toPath().resolve("node_modules/vite/bin/vite.js").toRealPath(new LinkOption[0]), (Object)vite.toRealPath(new LinkOption[0]));
    }

    private void assertNpmCommand(Supplier<String> path) throws IOException, FrontendUtils.UnknownVersionException {
        FrontendStubs.createStubNode((boolean)false, (boolean)true, (String)this.vaadinHomeDir);
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)"node"));
        List npmExecutable = this.tools.getNpmExecutable();
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(0)), (Matcher)Matchers.containsString((String)"node"));
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(1)), (Matcher)Matchers.containsString((String)this.getNpmCliString(this.tools.getNodeVersion().getFullVersion())));
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(1)), (Matcher)Matchers.containsString((String)path.get()));
    }

    private void assertNodeCommand(Supplier<String> path) throws IOException, FrontendUtils.UnknownVersionException {
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)this.vaadinHomeDir);
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)this.getDefaultNode(this.tools.getNodeVersion().getFullVersion())));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)path.get()));
        List npmExecutable = this.tools.getNpmExecutable();
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(0)), (Matcher)Matchers.containsString((String)path.get()));
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(0)), (Matcher)Matchers.containsString((String)this.getDefaultNode(this.tools.getNodeVersion().getFullVersion())));
        MatcherAssert.assertThat((Object)((String)npmExecutable.get(1)), (Matcher)Matchers.containsString((String)this.getNpmCliString(this.tools.getNodeVersion().getFullVersion())));
    }

    private void assertFaultyNpmVersion(FrontendVersion version) {
        try {
            this.tools.checkForFaultyNpmVersion(version);
            Assert.fail((String)"No exception was thrown for bad npm version");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((String)("Faulty version " + version.getFullVersion() + " returned wrong exception message"), (boolean)e.getMessage().contains("Your installed 'npm' version (" + version.getFullVersion() + ") is known to have problems."));
        }
    }

    @Test
    public void nodeFolder_validFolderWithNode_usesSpecifiedNode() throws IOException, FrontendUtils.UnknownVersionException {
        Assume.assumeFalse((String)"Skipping test on windows.", (boolean)FrontendUtils.isWindows());
        File customNodeBase = this.tmpDir.newFolder("custom-node");
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)customNodeBase.getAbsolutePath());
        File customNodeFolder = new File(customNodeBase, "node");
        this.settings.setNodeFolder(customNodeFolder.getAbsolutePath());
        this.tools = new FrontendTools(this.settings);
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)customNodeFolder.getAbsolutePath()));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.vaadinHomeDir)));
    }

    @Test(expected=IllegalStateException.class)
    public void nodeFolder_invalidFolder_throwsException() throws IOException {
        File emptyFolder = this.tmpDir.newFolder("empty-node-folder");
        this.settings.setNodeFolder(emptyFolder.getAbsolutePath());
        this.tools = new FrontendTools(this.settings);
        this.tools.getNodeExecutable();
    }

    @Test(expected=IllegalStateException.class)
    public void nodeFolder_missingNpm_throwsException() throws IOException {
        File customNodeBase = this.tmpDir.newFolder("node-without-npm");
        FrontendStubs.createStubNode((boolean)true, (boolean)false, (String)customNodeBase.getAbsolutePath());
        File customNodeFolder = new File(customNodeBase, "node");
        this.settings.setNodeFolder(customNodeFolder.getAbsolutePath());
        this.tools = new FrontendTools(this.settings);
        this.tools.getNodeExecutable();
    }

    @Test
    public void nodeFolder_notSet_usesNormalResolution() throws Exception {
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)this.vaadinHomeDir);
        this.settings.setForceAlternativeNode(true);
        this.settings.setNodeFolder(null);
        this.tools = new FrontendTools(this.settings);
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)this.vaadinHomeDir));
        FrontendStubs.resetFrontendToolsNodeCache();
        this.settings.setNodeFolder("");
        this.tools = new FrontendTools(this.settings);
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)this.vaadinHomeDir));
    }

    @Test
    public void nodeFolder_takesPrecedenceOverRequireHomeNodeExec() throws IOException, FrontendUtils.UnknownVersionException {
        File customNodeBase = this.tmpDir.newFolder("custom-precedence");
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)customNodeBase.getAbsolutePath());
        File customNodeFolder = new File(customNodeBase, "node");
        FrontendStubs.createStubNode((boolean)true, (boolean)true, (String)this.vaadinHomeDir);
        this.settings.setNodeFolder(customNodeFolder.getAbsolutePath());
        this.settings.setForceAlternativeNode(true);
        this.tools = new FrontendTools(this.settings);
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.containsString((String)customNodeFolder.getAbsolutePath()));
        MatcherAssert.assertThat((Object)this.tools.getNodeExecutable(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.vaadinHomeDir)));
    }

    private void installGlobalPnpm(String pnpmVersion) {
        Optional npmInstalled = this.frontendToolsLocator.tryLocateTool(this.getCommand("npm"));
        if (!npmInstalled.isPresent()) {
            this.installNodeToTempFolder();
        }
        this.doInstallPnpmGlobally(pnpmVersion, false);
    }

    private String installNodeToTempFolder() {
        return FrontendToolsTestHelper.installNode(new File(this.vaadinHomeDir), this.tools.getProxies(), "v24.12.0", new File(this.baseDir).toPath().toUri());
    }

    private void uninstallGlobalPnpm(String pnpmVersion) {
        this.doInstallPnpmGlobally(pnpmVersion, true);
    }

    private void doInstallPnpmGlobally(String pnpmVersion, boolean uninstall) {
        String pnpmPackageSpecifier = "pnpm" + (String)(uninstall ? "" : "@" + pnpmVersion);
        List<String> installPnpmCommand = Arrays.asList(this.getCommand("npm"), uninstall ? "rm" : "install", "-g", pnpmPackageSpecifier);
        try {
            FrontendUtils.executeCommand(installPnpmCommand);
        }
        catch (FrontendUtils.CommandExecutionException e) {
            throw new RuntimeException(String.format("Pnpm installation failed, pnpm version='%s', uninstall='%s'", pnpmVersion, uninstall), e);
        }
    }

    private String getCommand(String name) {
        return FrontendUtils.isWindows() ? name + ".cmd" : name;
    }

    private String getDefaultNode(String nodeVersion) {
        return FrontendUtils.isWindows() ? "node-" + nodeVersion + "\\node.exe" : "node-" + nodeVersion + "/node";
    }

    private String getNpmCliString(String nodeVersion) {
        return FrontendUtils.isWindows() ? "node-" + nodeVersion + "\\node_modules\\npm\\bin\\npm-cli.js" : "node-" + nodeVersion + "/lib/node_modules/npm/bin/npm-cli.js";
    }
}

