/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import java.io.File;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class FrontendToolsLocatorTest {
    private final FrontendToolsLocator locator = new FrontendToolsLocator();

    @Test
    public void toolLocated() {
        Optional echoLocation = this.locator.tryLocateTool("mvn");
        Assert.assertTrue((String)"Should be able to find 'mvn' binary", (boolean)echoLocation.isPresent());
    }

    @Test
    public void toolLocated_verificationFailed() {
        Assume.assumeFalse((String)"Cannot run the test on Windows", (boolean)this.locator.isWindows());
        Optional sedLocation = this.locator.tryLocateTool("sed");
        Assert.assertFalse((String)"Sed location should not be available due to lack of '-v' flag support", (boolean)sedLocation.isPresent());
    }

    @Test
    public void toolNotLocated() {
        Optional unknownToolLocation = this.locator.tryLocateTool("sdhajgsdiasg!");
        Assert.assertFalse((String)"Unknown tool should not be found in the system", (boolean)unknownToolLocation.isPresent());
    }

    @Test
    public void nonExistentTool_notVerified() {
        Assert.assertFalse((String)"Non-existent tool should not be a valid one", (boolean)this.locator.verifyTool(new File("whatever!")));
    }
}

