/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.FrontendUtils;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.NodeUpdateTestUtil;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

@NotThreadSafe
public class ComponentFlagsTest
extends NodeUpdateTestUtil {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private FeatureFlags featureFlags;
    private File propertiesDir;
    private File importsFile;
    private File frontendDirectory;
    private File nodeModulesPath;
    private File tmpRoot;
    private Class<?>[] testClasses = new Class[]{NodeTestComponents.FlagView.class, EagerFlagRouteAppConf.class};

    @Before
    public void before() throws IOException {
        this.tmpRoot = this.temporaryFolder.getRoot();
        this.propertiesDir = this.temporaryFolder.newFolder();
        this.featureFlags = new FeatureFlags((Lookup)Mockito.mock(Lookup.class));
        this.featureFlags.setPropertiesLocation(this.propertiesDir);
        this.frontendDirectory = new File(this.tmpRoot, "./src/main/frontend/");
        this.nodeModulesPath = new File(this.tmpRoot, "node_modules/");
        this.importsFile = FrontendUtils.getFlowGeneratedImports((File)this.frontendDirectory);
        Assert.assertTrue((boolean)this.nodeModulesPath.mkdirs());
        this.createExpectedImports(this.frontendDirectory, this.nodeModulesPath);
    }

    protected FrontendDependenciesScanner getScanner(ClassFinder finder, FeatureFlags featureFlags) {
        return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(false, finder, true, featureFlags, true);
    }

    @Test
    public void should_ExcludeExperimentalComponent_WhenFlagDisabled() throws IOException {
        this.createUpdater().execute();
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        Assert.assertFalse((boolean)content.contains("@vaadin/example-flag/experimental-module-1.js"));
        Assert.assertFalse((boolean)content.contains("@vaadin/example-flag/experimental-module-2.js"));
        Assert.assertFalse((boolean)content.contains("experimental-Connector.js"));
    }

    @Test
    public void should_ExcludeExperimentalComponent_WhenFlagFoo() throws IOException {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=FOO\n");
        this.featureFlags.loadProperties();
        this.createUpdater().execute();
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        Assert.assertFalse((boolean)content.contains("@vaadin/example-flag/experimental-module-1.js"));
        Assert.assertFalse((boolean)content.contains("@vaadin/example-flag/experimental-module-2.js"));
        Assert.assertFalse((boolean)content.contains("experimental-Connector.js"));
    }

    @Test
    public void should_IncludeExperimentalComponent_WhenFlagEnabled() throws IOException {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=true\n");
        this.featureFlags.loadProperties();
        this.createUpdater().execute();
        String content = FileUtils.readFileToString((File)this.importsFile, (Charset)Charset.defaultCharset());
        Assert.assertTrue((boolean)content.contains("@vaadin/example-flag/experimental-module-1.js"));
        Assert.assertTrue((boolean)content.contains("@vaadin/example-flag/experimental-module-2.js"));
        Assert.assertTrue((boolean)content.contains("experimental-Connector.js"));
    }

    private void createFeatureFlagsFile(String data) throws IOException {
        FileUtils.write((File)new File(this.propertiesDir, "vaadin-featureflags.properties"), (CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }

    private TaskUpdateImports createUpdater() throws IOException {
        ClassFinder classFinder = ComponentFlagsTest.getClassFinder(this.testClasses);
        Options options = new MockOptions(classFinder, this.tmpRoot).withFrontendDirectory(this.frontendDirectory).withBuildDirectory("target").withProductionMode(true);
        return new TaskUpdateImports(this.getScanner(classFinder, this.featureFlags), options);
    }

    @LoadDependenciesOnStartup
    public static class EagerFlagRouteAppConf
    implements AppShellConfigurator {
    }
}

