/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.LoadDependenciesOnStartup;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.FrontendBuildUtils;
import com.vaadin.flow.server.frontend.NodeTestComponents;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.ProdBundleUtils;
import com.vaadin.flow.server.frontend.TaskGenerateIndexHtml;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.testutil.TestUtils;
import com.vaadin.flow.theme.ThemeDefinition;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

@RunWith(value=Parameterized.class)
public class BundleValidationTest {
    public static final String BLANK_PACKAGE_JSON_WITH_HASH = "{\n \"dependencies\": {}, \"vaadin\": { \"hash\": \"a5\"} \n}";
    public static final String PACKAGE_JSON_DEPENDENCIES = "packageJsonDependencies";
    public static final String ENTRY_SCRIPTS = "entryScripts";
    public static final String BUNDLE_IMPORTS = "bundleImports";
    public static final String FRONTEND_HASHES = "frontendHashes";
    public static final String THEME_JSON_CONTENTS = "themeJsonContents";
    public static final String PACKAGE_JSON_HASH = "packageJsonHash";
    private static final String THEME_UTIL_JS;
    @Parameterized.Parameter
    public Mode mode;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Options options;
    ClassFinder finder;
    private Map<String, String> jarResources = new HashMap<String, String>();
    private MockedStatic<FrontendBuildUtils> frontendBuildUtils;
    private MockedStatic<DevBundleUtils> devBundleUtils;
    private MockedStatic<ProdBundleUtils> prodBundleUtils;
    private MockedStatic<BundleValidationUtil> bundleUtils;
    private MockedStatic<FileIOUtils> ioUtils;
    private String bundleLocation;

    @Parameterized.Parameters
    public static Collection<Mode> modes() {
        return List.of(Mode.PRODUCTION_PRECOMPILED_BUNDLE, Mode.DEVELOPMENT_BUNDLE);
    }

    @Before
    public void init() {
        this.finder = (ClassFinder)Mockito.spy((Object)new ClassFinder.DefaultClassFinder(this.getClass().getClassLoader(), new Class[0]));
        this.options = new MockOptions(this.finder, this.temporaryFolder.getRoot()).withBuildDirectory("target");
        this.options.copyResources(Collections.emptySet());
        this.options.withProductionMode(this.mode.isProduction());
        this.bundleLocation = this.mode.isProduction() ? "vaadin-prod-bundle" : "vaadin-dev-bundle";
        this.frontendBuildUtils = Mockito.mockStatic(FrontendBuildUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.devBundleUtils = Mockito.mockStatic(DevBundleUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.prodBundleUtils = Mockito.mockStatic(ProdBundleUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.bundleUtils = Mockito.mockStatic(BundleValidationUtil.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.ioUtils = Mockito.mockStatic(FileIOUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
    }

    @After
    public void teardown() {
        this.frontendBuildUtils.close();
        this.devBundleUtils.close();
        this.prodBundleUtils.close();
        this.bundleUtils.close();
        this.ioUtils.close();
        File needsBuildFile = new File(this.options.getResourceOutputDirectory(), "config/needs-build");
        if (needsBuildFile.exists()) {
            needsBuildFile.delete();
        }
    }

    private ObjectNode getBasicStats() {
        ObjectNode stats = JacksonUtils.createObjectNode();
        ObjectNode packageJsonDependencies = JacksonUtils.createObjectNode();
        ObjectNode frontendHashes = JacksonUtils.createObjectNode();
        ObjectNode themeJsonContents = JacksonUtils.createObjectNode();
        ArrayNode entryScripts = JacksonUtils.createArrayNode();
        ArrayNode bundleImports = JacksonUtils.createArrayNode();
        stats.set(PACKAGE_JSON_DEPENDENCIES, (JsonNode)packageJsonDependencies);
        stats.set(ENTRY_SCRIPTS, (JsonNode)entryScripts);
        stats.set(BUNDLE_IMPORTS, (JsonNode)bundleImports);
        stats.set(FRONTEND_HASHES, (JsonNode)frontendHashes);
        stats.set(THEME_JSON_CONTENTS, (JsonNode)themeJsonContents);
        stats.put(PACKAGE_JSON_HASH, "aHash");
        NodeUpdater nodeUpdater = new NodeUpdater(this, (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class), this.options){

            public void execute() {
            }
        };
        for (Map.Entry dependency : nodeUpdater.getDefaultDependencies().entrySet()) {
            packageJsonDependencies.put((String)dependency.getKey(), (String)dependency.getValue());
        }
        bundleImports.add("./generated/jar-resources/theme-util.js");
        frontendHashes.put("theme-util.js", BundleValidationUtil.calculateHash((String)THEME_UTIL_JS));
        this.jarResources.put("theme-util.js", THEME_UTIL_JS);
        return stats;
    }

    @Test
    public void noDevBundle_bundleCompilationRequires() {
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)((FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class)), (Mode)this.mode);
        Assert.assertTrue((String)"Bundle should require creation if not available", (boolean)needsBuild);
    }

    @Test
    public void devBundleStatsJsonMissing_bundleCompilationRequires() {
        this.devBundleUtils.when(() -> DevBundleUtils.getDevBundleFolder((File)((File)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)this.temporaryFolder.getRoot());
        this.devBundleUtils.when(() -> DevBundleUtils.findBundleStatsJson((File)this.temporaryFolder.getRoot(), (String)"target")).thenReturn(null);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)((FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class)), (Mode)this.mode);
        Assert.assertTrue((String)"Missing stats.json should require bundling", (boolean)needsBuild);
    }

    @Test
    public void hashesMatch_noNpmPackages_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\"dependencies\": {\"@vaadin/router\": \"1.7.5\"}, \"vaadin\": { \"hash\": \"aHash\"} }", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Matching hashes should not require compilation", (boolean)needsBuild);
    }

    @Test
    public void loadDependenciesOnStartup_annotatedClassInProject_compilationRequiredForProduction() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\"dependencies\": {\"@vaadin/router\": \"1.7.5\"}, \"vaadin\": { \"hash\": \"aHash\"} }", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        this.setupFrontendUtilsMock(stats);
        Mockito.when((Object)this.finder.getAnnotatedClasses(LoadDependenciesOnStartup.class)).thenReturn(Collections.singleton(AllEagerAppConf.class));
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"'LoadDependenciesOnStartup' annotation requires build", (boolean)needsBuild);
    }

    @Test
    public void hashesMatch_statsMissingNpmPackages_compilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\"dependencies\": {\"@vaadin/router\": \"1.7.5\"}, \"vaadin\": { \"hash\": \"aHash\"} }", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@vaadin/router", "1.7.5");
        packages.put("@vaadin/text", "1.0.0");
        Mockito.when((Object)depScanner.getPackages()).thenReturn(packages);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Missing npmPackage should require bundling", (boolean)needsBuild);
    }

    @Test
    public void hashesMatch_statsMissingPackageJsonPackage_compilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"1.7.5\",\n    \"@vaadin/text\":\"1.0.0\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Bundle missing module dependency should rebuild", (boolean)needsBuild);
    }

    @Test
    public void hashesMatch_packageJsonMissingNpmPackages_statsHasJsonPackages_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\"dependencies\": {\"@vaadin/router\": \"1.7.5\"}, \"vaadin\": { \"hash\": \"aHash\"} }", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.singletonMap("@vaadin/text", "1.0.0"));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/text", "1.0.0");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Not missing npmPackage in stats.json should not require compilation", (boolean)needsBuild);
    }

    @Test
    public void packageJsonContainsOldVersion_versionsJsonUpdates_noCompilation() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        File versions = new File(this.temporaryFolder.getRoot(), "vaadin-core-versions.json");
        versions.createNewFile();
        FileUtils.write((File)versions, (CharSequence)"{\n  \"core\": {\n    \"vaadin-router\": {\n      \"jsVersion\": \"2.0.3\",\n      \"npmName\": \"@vaadin/router\",\n      \"releasenotes\": true\n    }\n  },\n  \"platform\": \"123-SNAPSHOT\"\n}\n", (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)versions.toURI().toURL());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "2.0.3");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"vaadin-core-versions.json should have updated version to expected.", (boolean)needsBuild);
    }

    @Test
    public void packageJsonContainsOldVersionsAfterVersionUpdate_updatedStatsMatches_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"1.7.5\",\n    \"@vaadin/text\": \"1.0.0\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        HashMap<String, String> packages = new HashMap<String, String>();
        packages.put("@vaadin/router", "1.9.2");
        packages.put("@vaadin/text", "2.1.0");
        Mockito.when((Object)depScanner.getPackages()).thenReturn(packages);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.9.2");
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/text", "2.1.0");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Not missing npmPackage in stats.json should not require compilation", (boolean)needsBuild);
    }

    @Test
    public void noPackageJsonHashAfterCleanFrontend_statsHasDefaultJsonPackages_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"name\": \"no-name\",\n  \"license\": \"UNLICENSED\",\n  \"dependencies\": {\n    \"@vaadin/router\": \"1.7.5\"\n  },\n  \"devDependencies\": {}\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.singletonMap("@vaadin/text", "1.0.0"));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/text", "1.0.0");
        stats.put(PACKAGE_JSON_HASH, "af45419b27dcb44b875197df4347b97316cc8fa6055458223a73aedddcfe7cc6");
        ((ArrayNode)stats.get(ENTRY_SCRIPTS)).add("VAADIN/build/indexhtml-aa31f040.js");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Not missing npmPackage in stats.json should not require compilation", (boolean)needsBuild);
    }

    @Test
    public void noPackageJsonHashAfterCleanFrontend_statsMissingDefaultJsonPackages_compilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"name\": \"no-name\",\n  \"license\": \"UNLICENSED\",\n  \"dependencies\": {\n    \"@vaadin/router\": \"1.7.5\"\n  },\n  \"devDependencies\": {}\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.singletonMap("@vaadin/text", "1.0.0"));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Missing npmPackage in stats.json should require compilation", (boolean)needsBuild);
    }

    @Test
    public void hashesMatch_packageJsonHasRange_statsHasFixed_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Not missing npmPackage in stats.json should not require compilation", (boolean)needsBuild);
    }

    @Test
    public void hashesMatch_packageJsonHasTildeRange_statsHasNewerFixed_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"~1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.6");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"No compilation if tilde range only patch update", (boolean)needsBuild);
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.1");
        this.setupFrontendUtilsMock(stats);
        needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Compilation required if minor version change for tilde range", (boolean)needsBuild);
    }

    @Test
    public void hashesMatch_packageJsonHasCaretRange_statsHasNewerFixed_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"No compilation if caret range only minor version update", (boolean)needsBuild);
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "2.0.0");
        this.setupFrontendUtilsMock(stats);
        needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Compilation required if major version change for caret range", (boolean)needsBuild);
    }

    @Test
    public void packageJsonHasOldPlatformDependencies_statsDoesNotHaveThem_noCompilationRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@polymer/iron-list\": \"3.1.0\",\n    \"@vaadin/vaadin-accordion\": \"23.3.7\"\n  },\n  \"vaadin\": {\n    \"dependencies\": {\n      \"@polymer/iron-list\": \"3.1.0\",\n      \"@vaadin/vaadin-accordion\": \"23.3.7\"\n    },\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/accordion", "24.0.0.beta2");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"No compilation expected if package.json has only dependencies from older Vaadin version not presenting in a newer version", (boolean)needsBuild);
    }

    @Test
    public void noPackageJson_defaultPackagesAndModulesInStats_noBuildNeeded() {
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.singletonMap("@vaadin/text", "1.0.0"));
        String defaultHash = BundleValidationUtil.getDefaultPackageJson((Options)this.options, (FrontendDependenciesScanner)depScanner, null).get("vaadin").get("hash").textValue();
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/text", "1.0.0");
        stats.put(PACKAGE_JSON_HASH, defaultHash);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Default package.json should be built and validated", (boolean)needsBuild);
    }

    @Test
    public void noPackageJson_defaultPackagesInStats_missingNpmModules_buildNeeded() {
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.singletonMap("@vaadin/text", "1.0.0"));
        String defaultHash = BundleValidationUtil.getDefaultPackageJson((Options)this.options, (FrontendDependenciesScanner)depScanner, null).get("vaadin").get("hash").textValue();
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        stats.put(PACKAGE_JSON_HASH, defaultHash);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Missing NpmPackage with default bundle should require rebuild", (boolean)needsBuild);
    }

    @Test
    public void noPackageJson_defaultPackagesInStats_noBuildNeeded() {
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        String defaultHash = BundleValidationUtil.getDefaultPackageJson((Options)this.options, (FrontendDependenciesScanner)depScanner, null).get("vaadin").get("hash").textValue();
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        stats.put(PACKAGE_JSON_HASH, defaultHash);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Default package.json should be built and validated", (boolean)needsBuild);
    }

    @Test
    public void generatedFlowImports_bundleMissingImports_buildRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("@polymer/paper-checkbox/paper-checkbox.js")));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("@Frontend/generated/jar-resources/dndConnector-es6.js");
        bundleImports.add("@polymer/paper-input/paper-input.js");
        bundleImports.add("@vaadin/common-frontend/ConnectionIndicator.js");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Compilation required as stats.json missing import", (boolean)needsBuild);
    }

    @Test
    public void generatedFlowImports_bundleHasAllImports_noBuildRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("@polymer/paper-checkbox/paper-checkbox.js")));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("@polymer/paper-checkbox/paper-checkbox.js");
        bundleImports.add("@polymer/paper-input/paper-input.js");
        bundleImports.add("@vaadin/grid/theme/lumo/vaadin-grid.js");
        bundleImports.add("Frontend/generated/jar-resources/dndConnector-es6.js");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"All imports in stats, no compilation required", (boolean)needsBuild);
    }

    @Test
    public void themedGeneratedFlowImports_bundleUsesTheme_noBuildRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("@vaadin/grid/src/vaadin-grid.js")));
        Mockito.when((Object)depScanner.getTheme()).thenReturn((Object)new NodeTestComponents.LumoTest());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("@polymer/paper-checkbox/paper-checkbox.js");
        bundleImports.add("@polymer/paper-input/paper-input.js");
        bundleImports.add("@vaadin/grid/src/vaadin-grid.js");
        bundleImports.add("Frontend/generated/jar-resources/dndConnector-es6.js");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"All themed imports in stats, no compilation required", (boolean)needsBuild);
    }

    @Test
    public void frontendFileHashMatches_noBundleRebuild() throws IOException {
        String fileContent = "TodoContent";
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("Frontend/generated/jar-resources/TodoTemplate.js")));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("./generated/jar-resources/TodoTemplate.js");
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("TodoTemplate.js", BundleValidationUtil.calculateHash((String)fileContent));
        this.jarResources.put("TodoTemplate.js", fileContent);
        this.setupFrontendUtilsMock(stats);
        this.devBundleUtils.when(() -> DevBundleUtils.getDevBundleFolder((File)((File)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)this.temporaryFolder.getRoot());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Jar fronted file content hash should match.", (boolean)needsBuild);
    }

    @Test
    public void noFrontendFileHash_bundleRebuild() throws IOException {
        String fileContent = "TodoContent";
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("Frontend/generated/jar-resources/TodoTemplate.js")));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ((ArrayNode)stats.get(BUNDLE_IMPORTS)).add("Frontend/generated/jar-resources/TodoTemplate.js");
        this.devBundleUtils.when(() -> DevBundleUtils.getDevBundleFolder((File)((File)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)this.temporaryFolder.getRoot());
        this.frontendBuildUtils.when(() -> FrontendBuildUtils.getJarResourceString((String)((String)Mockito.eq((Object)"TodoTemplate.js")), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)fileContent);
        this.devBundleUtils.when(() -> DevBundleUtils.findBundleStatsJson((File)this.temporaryFolder.getRoot(), (String)"target")).thenReturn((Object)stats.toString());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Content should not have been validated.", (boolean)needsBuild);
    }

    @Test
    public void frontendFileHashMissmatch_bundleRebuild() throws IOException {
        String fileContent = "TodoContent2";
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("Frontend/generated/jar-resources/TodoTemplate.js")));
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ((ArrayNode)stats.get(BUNDLE_IMPORTS)).add("Frontend/generated/jar-resources/TodoTemplate.js");
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("TodoTemplate.js", "dea5180dd21d2f18d1472074cd5305f60b824e557dae480fb66cdf3ea73edc65");
        this.devBundleUtils.when(() -> DevBundleUtils.getDevBundleFolder((File)((File)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)this.temporaryFolder.getRoot());
        this.frontendBuildUtils.when(() -> FrontendBuildUtils.getJarResourceString((String)((String)Mockito.eq((Object)"TodoTemplate.js")), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)fileContent);
        this.devBundleUtils.when(() -> DevBundleUtils.findBundleStatsJson((File)this.temporaryFolder.getRoot(), (String)"target")).thenReturn((Object)stats.toString());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Jar fronted file content hash should not be a match.", (boolean)needsBuild);
    }

    @Test
    public void cssImportWithInline_statsAndImportsMatchAndNoBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File stylesheetFile = new File(this.temporaryFolder.getRoot(), "./src/main/frontend/my-styles.css");
        FileUtils.forceMkdir((File)stylesheetFile.getParentFile());
        boolean created = stylesheetFile.createNewFile();
        Assert.assertTrue((boolean)created);
        FileUtils.write((File)stylesheetFile, (CharSequence)"body{color:yellow}", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("Frontend/my-styles.css?inline")));
        ObjectNode stats = this.getBasicStats();
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("Frontend/my-styles.css");
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("my-styles.css", "0d94fe659d24e1e56872b47fc98d9f09227e19816c62a3db709bad347fbd0cdd");
        this.setupFrontendUtilsMock(stats);
        this.jarResources.put("my-styles.css", "body{color:yellow}");
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"CSS 'inline' suffix should be ignored for imports checking", (boolean)needsBuild);
    }

    @Test
    public void projectFrontendFileChange_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectFrontendFileStub();
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("Frontend/views/lit-view.ts")));
        ObjectNode stats = this.getBasicStats();
        ((ArrayNode)stats.get(BUNDLE_IMPORTS)).add("Frontend/views/lit-view.ts");
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("views/lit-view.ts", "old_hash");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Project frontend file change should trigger rebuild", (boolean)needsBuild);
    }

    @Test
    public void projectFrontendFileNotChanged_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectFrontendFileStub();
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("Frontend/views/lit-view.ts")));
        ObjectNode stats = this.getBasicStats();
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("Frontend/views/lit-view.ts");
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("views/lit-view.ts", "eaf04adbc43cb363f6b58c45c6e0e8151084941247abac9493beed8d29f08add");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"No bundle rebuild expected when no changes in frontend file", (boolean)needsBuild);
    }

    @Test
    public void projectFrontendFileDeleted_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("Frontend/views/lit-view.ts")));
        ObjectNode stats = this.getBasicStats();
        ((ArrayNode)stats.get(BUNDLE_IMPORTS)).add("Frontend/views/lit-view.ts");
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("views/lit-view.ts", "eaf04adbc43cb363f6b58c45c6e0e8151084941247abac9493beed8d29f08add");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Project frontend file delete should trigger rebuild", (boolean)needsBuild);
    }

    @Test
    public void reusedTheme_noReusedThemes_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        stats.remove(THEME_JSON_CONTENTS);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Shouldn't rebuild the bundle if no reused themes", (boolean)needsBuild);
    }

    @Test
    public void reusedTheme_newlyAddedTheme_noThemeJson_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File jarWithTheme = TestUtils.getTestJar((String)"jar-with-no-theme-json.jar");
        this.options.copyResources(Collections.singleton(jarWithTheme));
        File jarResourcesFolder = new File(this.temporaryFolder.getRoot(), "./src/main/frontend/generated/jar-resources/themes/custom-theme");
        boolean created = jarResourcesFolder.mkdirs();
        Assert.assertTrue((boolean)created);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        this.setupFrontendUtilsMock(this.getBasicStats());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Should not trigger a bundle rebuild when the new theme has no theme.json", (boolean)needsBuild);
    }

    @Test
    public void reusedTheme_noPreviouslyAddedThemes_justAddedNewTheme_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File jarWithTheme = TestUtils.getTestJar((String)"jar-with-theme-json-and-assets.jar");
        this.options.copyResources(Collections.singleton(jarWithTheme));
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        this.setupFrontendUtilsMock(this.getBasicStats());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should trigger a bundle rebuild when a new reusable theme is added", (boolean)needsBuild);
    }

    @Test
    public void reusedTheme_previouslyAddedThemes_justAddedNewTheme_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File jarWithTheme = TestUtils.getTestJar((String)"jar-with-theme-json-and-assets.jar");
        this.options.copyResources(Collections.singleton(jarWithTheme));
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put("other-theme", "other-theme-hash");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should trigger a bundle rebuild when a new reusable theme is added", (boolean)needsBuild);
    }

    @Test
    public void reusedTheme_previouslyAddedThemes_assetsUpdate_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File jarWithTheme = TestUtils.getTestJar((String)"jar-with-theme-json-and-assets.jar");
        this.options.copyResources(Collections.singleton(jarWithTheme));
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put("reusable-theme", "{\n  \"importCss\": [\"@fortawesome/fontawesome-free/css/all.min.css\"],\n  \"assets\": {\n    \"@fortawesome/fontawesome-free\": {\n      \"svgs/brands/**\": \"fontawesome/svgs/brands\",\n      \"webfonts/**\": \"webfonts\"\n    }\n  }\n}\n");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should trigger a bundle rebuild when the assets updated", (boolean)needsBuild);
    }

    @Test
    public void reusedTheme_previouslyAddedThemes_noUpdates_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File jarWithTheme = TestUtils.getTestJar((String)"jar-with-theme-json-and-assets.jar");
        this.options.copyResources(Collections.singleton(jarWithTheme));
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put("reusable-theme", "{\n  \"importCss\": [\"@fortawesome/fontawesome-free/css/all.min.css\"],\n  \"assets\": {\n    \"@fortawesome/fontawesome-free\": {\n      \"svgs/brands/**\": \"fontawesome/svgs/brands\",\n      \"webfonts/**\": \"webfonts\"\n    },\n    \"line-awesome\": {\n      \"dist/line-awesome/css/**\": \"line-awesome/dist/line-awesome/css\",\n      \"dist/line-awesome/fonts/**\": \"line-awesome/dist/line-awesome/fonts\"\n    }\n  }\n}\n");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Should not trigger a bundle rebuild when the themes not changed", (boolean)needsBuild);
    }

    @Test
    public void themeJsonUpdates_statsHasNoThemeJson_projectHasThemeJson_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectThemeJsonStub("{\"lumoImports\": [\"typography\"]}", "my-theme");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        stats.remove(THEME_JSON_CONTENTS);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should trigger a bundle rebuild when no themeJsonContents, but project has theme.json", (boolean)needsBuild);
    }

    @Test
    public void themeJsonUpdates_containsParentTheme_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectThemeJsonStub("{\"parent\": \"my-parent-theme\"}", "my-theme");
        new File(this.temporaryFolder.getRoot(), "./src/main/frontend/themes/my-parent-theme").mkdirs();
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put(this.bundleLocation, "{\"lumoImports\": [\"typography\"]}");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Should not trigger a bundle rebuild when parent theme is used", (boolean)needsBuild);
    }

    @Test
    public void themeJsonUpdates_statsHasThemeJson_projectHasNoThemeJson_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        new File(this.temporaryFolder.getRoot(), "./src/main/frontend/themes/my-theme").mkdirs();
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put(this.bundleLocation, "{\"lumoImports\": [\"typography\"]}");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Should not trigger a bundle rebuild when project has no theme.json", (boolean)needsBuild);
    }

    @Test
    public void themeJsonUpdates_statsAndProjectThemeJsonEquals_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectThemeJsonStub("{\n  \"boolean-property\": true,\n  \"numeric-property\": 42.42,\n  \"string-property\": \"foo\",\n  \"array-property\": [\"one\", \"two\"],\n  \"object-property\": {\n    \"foo\": \"bar\"\n  }\n}\n", "my-theme");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put("my-theme", "{\n\n\n\n\n\n  \"boolean-property\": true,\n  \"numeric-property\": 42.42,\n  \"string-property\": \"foo\",\n  \"array-property\": [\"one\", \"two\"],\n  \"object-property\": {\n    \"foo\": \"bar\"\n  }\n}\n");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Should not trigger a bundle rebuild when project theme.json has the same content as in the bundle", (boolean)needsBuild);
    }

    @Test
    public void themeJsonUpdates_bundleMissesSomeEntries_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectThemeJsonStub("{\n  \"importCss\": [\"@fortawesome/fontawesome-free/css/all.css\",\n    \"@vaadin/vaadin-lumo-styles/utility.css\"],\n  \"assets\": {\n    \"line-awesome\": {\n      \"dist/line-awesome/css/**\": \"line-awesome/dist/line-awesome/css\",\n    }\n  }\n}\n", "my-theme");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put(this.bundleLocation, "{\n  \"importCss\": [\"@vaadin/vaadin-lumo-styles/utility.css\"],\n  \"assets\": {\n    \"line-awesome\": {\n      \"dist/line-awesome/css/**\": \"line-awesome/dist/line-awesome/css\",\n      \"dist/line-awesome/fonts/**\": \"line-awesome/dist/line-awesome/fonts\"\n    }\n  }\n}\n");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should rebuild when project theme.json adds extra entries", (boolean)needsBuild);
    }

    @Test
    public void themeJsonUpdates_bundleHaveAllEntriesAndMore_noBundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectThemeJsonStub("{\n  \"importCss\": [\"@vaadin/vaadin-lumo-styles/utility.css\"]\n}\n", "my-theme");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put(this.bundleLocation, "{\n  \"importCss\": [\"@vaadin/vaadin-lumo-styles/utility.css\"],\n  \"assets\": {\n    \"line-awesome\": {\n      \"dist/line-awesome/css/**\": \"line-awesome/dist/line-awesome/css\",\n      \"dist/line-awesome/fonts/**\": \"line-awesome/dist/line-awesome/fonts\"\n    }\n  }\n}\n");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Shouldn't re-bundle when the dev bundle already have all the entries defined in the project's theme.json", (boolean)needsBuild);
    }

    @Test
    public void themeJsonUpdates_noProjectThemeHashInStats_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectThemeJsonStub("{\"lumoImports\": [\"typography\"]}", "my-theme");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should trigger a bundle rebuild when project has theme.json but stats doesn't", (boolean)needsBuild);
    }

    @Test
    public void parentThemeInFrontend_parentHasEntriesInJson_bundleMissesSomeEntries_bundleRebuild() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        this.createProjectThemeJsonStub("{ \"importCss\": [\"foo\"]}", "parent-theme");
        this.createProjectThemeJsonStub("{\"parent\": \"parent-theme\"}", "my-theme");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put(this.bundleLocation, "{}");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should rebuild when 'theme.json' from parent theme in frontend folder adds extra entries", (boolean)needsBuild);
    }

    @Test
    public void projectThemeComponentsCSS_contentsAdded_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForProjectThemeComponentsCSS(false, false, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets are present  in './src/main/frontend/<theme>/components' folder", (boolean)needsBuild);
    }

    @Test
    public void projectThemeComponentsCSS_contentsChanged_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForProjectThemeComponentsCSS(true, true, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents have changed", (boolean)needsBuild);
    }

    @Test
    public void projectThemeComponentsCSS_contentsNotChanged_noBundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForProjectThemeComponentsCSS(false, true, new String[0]);
        Assert.assertFalse((String)"Should not rebuild when Shadow DOM Stylesheets contents have not changed", (boolean)needsBuild);
    }

    @Test
    public void projectThemeComponentsCSS_removedFromProject_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForProjectThemeComponentsCSS(false, true, "deleted-component-stylesheet.css");
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents have been removed", (boolean)needsBuild);
    }

    @Test
    public void jarResourceThemeComponentsCSS_contentsAdded_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedThemeComponentsCSS(false, false, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets are present  in 'frontend/generated/jar-resources/<theme>/components' folder", (boolean)needsBuild);
    }

    @Test
    public void jarResourceThemeComponentsCSS_contentsChanged_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedThemeComponentsCSS(true, true, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents have changed", (boolean)needsBuild);
    }

    @Test
    public void jarResourceThemeComponentsCSS_contentsNotChanged_noBundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedThemeComponentsCSS(false, true, new String[0]);
        Assert.assertFalse((String)"Should not rebuild when Shadow DOM Stylesheets contents have not changed", (boolean)needsBuild);
    }

    @Test
    public void jarResourceThemeComponentsCSS_removedFromProject_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedThemeComponentsCSS(false, true, "deleted-component-stylesheet.css");
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents have been removed", (boolean)needsBuild);
    }

    @Test
    public void projectParentThemeComponentsCSS_contentsAdded_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForParentProjectThemeComponentsCSS(false, false, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets are present  in parent theme folder", (boolean)needsBuild);
    }

    @Test
    public void projectParentThemeComponentsCSS_contentsChanged_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForParentProjectThemeComponentsCSS(true, true, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents in parent theme have changed", (boolean)needsBuild);
    }

    @Test
    public void projectParentThemeComponentsCSS_contentsNotChanged_noBundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForParentProjectThemeComponentsCSS(false, true, new String[0]);
        Assert.assertFalse((String)"Should not rebuild when Shadow DOM Stylesheets contents in parent theme have not changed", (boolean)needsBuild);
    }

    @Test
    public void projectParentThemeComponentsCSS_removedFromProject_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForParentProjectThemeComponentsCSS(false, true, "deleted-component-stylesheet.css");
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents in parent theme have been removed", (boolean)needsBuild);
    }

    @Test
    public void projectParentInJarThemeComponentsCSS_contentsAdded_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedParentThemeComponentsCSS(false, false, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets are present  in parent theme folder", (boolean)needsBuild);
    }

    @Test
    public void projectParentInJarThemeComponentsCSS_contentsChanged_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedParentThemeComponentsCSS(true, true, new String[0]);
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents in parent theme have changed", (boolean)needsBuild);
    }

    @Test
    public void projectParentInJarThemeComponentsCSS_contentsNotChanged_noBundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedParentThemeComponentsCSS(false, true, new String[0]);
        Assert.assertFalse((String)"Should not rebuild when Shadow DOM Stylesheets contents in parent theme have not changed", (boolean)needsBuild);
    }

    @Test
    public void projectParentInJarThemeComponentsCSS_removedFromProject_bundleRebuild() throws IOException {
        boolean needsBuild = this.checkBundleRebuildForJarPackagedParentThemeComponentsCSS(false, true, "deleted-component-stylesheet.css");
        Assert.assertTrue((String)"Should rebuild when Shadow DOM Stylesheets contents in parent theme have been removed", (boolean)needsBuild);
    }

    @Test
    public void indexTsAdded_rebuildRequired() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File frontendFolder = this.temporaryFolder.newFolder("./src/main/frontend/");
        File indexTs = new File(frontendFolder, "index.ts");
        indexTs.createNewFile();
        FileUtils.write((File)indexTs, (CharSequence)"window.alert('');", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Adding 'index.ts' should require bundling", (boolean)needsBuild);
    }

    @Test
    public void changeInIndexTs_rebuildRequired() throws IOException {
        this.createPackageJsonStub("{\"dependencies\": {}, \"vaadin\": { \"hash\": \"aHash\"} }");
        File frontendFolder = this.temporaryFolder.newFolder("./src/main/frontend/");
        File indexTs = new File(frontendFolder, "index.ts");
        indexTs.createNewFile();
        FileUtils.write((File)indexTs, (CharSequence)"window.alert('');", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("index.ts", "15931fa8c20e3c060c8ea491831e95cc8463962700a9bfb82c8e3844cf608f04");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"'index.ts' equal content should not require bundling", (boolean)needsBuild);
        FileUtils.write((File)indexTs, (CharSequence)"window.alert('hello');", (Charset)StandardCharsets.UTF_8);
        needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"changed content for 'index.ts' should require bundling", (boolean)needsBuild);
    }

    @Test
    public void indexTsDeleted_rebuildRequired() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("index.ts", "15931fa8c20e3c060c8ea491831e95cc8463962700a9bfb82c8e3844cf608f04");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"'index.ts' delete should require re-bundling", (boolean)needsBuild);
    }

    @Test
    public void indexHtmlNotChanged_rebuildNotRequired() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File frontendFolder = this.temporaryFolder.newFolder("./src/main/frontend/");
        File indexHtml = new File(frontendFolder, "index.html");
        indexHtml.createNewFile();
        String defaultIndexHtml = new String(TaskGenerateIndexHtml.class.getResourceAsStream("index.html").readAllBytes(), StandardCharsets.UTF_8);
        FileUtils.write((File)indexHtml, (CharSequence)defaultIndexHtml, (Charset)StandardCharsets.UTF_8);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("index.html", BundleValidationUtil.calculateHash((String)defaultIndexHtml));
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Default 'index.html' should not require bundling", (boolean)needsBuild);
    }

    @Test
    public void indexHtmlChanged_productionMode_rebuildRequired() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File frontendFolder = this.temporaryFolder.newFolder("./src/main/frontend/");
        File indexHtml = new File(frontendFolder, "index.html");
        indexHtml.createNewFile();
        String defaultIndexHtml = new String(this.getClass().getResourceAsStream("index.html").readAllBytes(), StandardCharsets.UTF_8);
        String customIndexHtml = defaultIndexHtml.replace("<body>", "<body><div>custom content</div>");
        FileUtils.write((File)indexHtml, (CharSequence)customIndexHtml, (Charset)StandardCharsets.UTF_8);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("index.html", BundleValidationUtil.calculateHash((String)defaultIndexHtml));
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"In production mode, custom 'index.html' should require bundling", (boolean)needsBuild);
    }

    @Test
    public void indexHtmlChanged_developmentMode_rebuildNotRequired() throws IOException {
        Assume.assumeFalse((boolean)this.mode.isProduction());
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        File frontendFolder = this.temporaryFolder.newFolder("./src/main/frontend/");
        File indexHtml = new File(frontendFolder, "index.html");
        indexHtml.createNewFile();
        String defaultIndexHtml = new String(this.getClass().getResourceAsStream("index.html").readAllBytes(), StandardCharsets.UTF_8);
        String customIndexHtml = defaultIndexHtml.replace("<body>", "<body><div>custom content</div>");
        FileUtils.write((File)indexHtml, (CharSequence)customIndexHtml, (Charset)StandardCharsets.UTF_8);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("index.html", BundleValidationUtil.calculateHash((String)defaultIndexHtml));
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"In dev mode, custom 'index.html' should not require bundling", (boolean)needsBuild);
    }

    @Test
    public void standardVaadinComponent_notAddedToProjectAsJar_noRebuildRequired() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("Frontend/generated/jar-resources/vaadin-spreadsheet/vaadin-spreadsheet.js");
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("vaadin-spreadsheet/vaadin-spreadsheet.js", "e545ad23a2d1d4b3a3370a0305dd71c15bbfc645216f50c6e327bd818b7484c4");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Should not require bundling if component JS is missing in jar-resources", (boolean)needsBuild);
    }

    @Test
    public void cssImport_cssInMetaInfResources_notThrow_bundleRequired() throws IOException {
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        CssData cssData = new CssData("./addons-styles/my-styles.css", null, null, null);
        Mockito.when((Object)depScanner.getCss()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList(cssData)));
        ObjectNode stats = this.getBasicStats();
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should re-bundle if CSS is imported from META-INF/resources", (boolean)needsBuild);
    }

    @Test
    public void flowFrontendPackageInPackageJson_noBundleRebuild() throws IOException {
        this.createPackageJsonStub("{\"dependencies\": {\"@vaadin/flow-frontend\": \"./target/flow-frontend\"}, \"vaadin\": { \"hash\": \"aHash\"} }");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Shouldn't re-bundle when old @vaadin/flow-frontend package is in package.json", (boolean)needsBuild);
    }

    @Test
    public void localPackageInPackageJson_notChanged_noBundleRebuild() throws IOException {
        this.createPackageJsonStub("{\"dependencies\": {\"my-pkg\": \"file:my-pkg\"}, \"vaadin\": { \"hash\": \"aHash\"} }");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("my-pkg", "file:my-pkg");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Shouldn't re-bundle when referencing local packages in package.json", (boolean)needsBuild);
    }

    @Test
    public void localPackageInPackageJson_differentReference_bundleRebuild() throws IOException {
        this.createPackageJsonStub("{\"dependencies\": {\"my-pkg\": \"file:my-pkg\"}, \"vaadin\": { \"hash\": \"aHash\"} }");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("my-pkg", "./another-folder");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should re-bundle when local packages have different values", (boolean)needsBuild);
    }

    @Test
    public void localPackageInPackageJson_parsableVersionInStats_bundleRebuild() throws IOException {
        this.createPackageJsonStub("{\"dependencies\": {\"my-pkg\": \"file:my-pkg\"}, \"vaadin\": { \"hash\": \"aHash\"} }");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("my-pkg", "1.0.0");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should re-bundle when local package in package.json but parsable version in stats", (boolean)needsBuild);
    }

    @Test
    public void localPackageInStats_parsableVersionInPackageJson_bundleRebuild() throws IOException {
        this.createPackageJsonStub("{\"dependencies\": {\"my-pkg\": \"1.0.0\"}, \"vaadin\": { \"hash\": \"aHash\"} }");
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("my-pkg", "file:my-pkg");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Should re-bundle when local package in stats but parsable version in package.json", (boolean)needsBuild);
    }

    @Test
    public void bundleMissesSomeEntries_devMode_skipBundleBuildSet_noBundleRebuild() throws IOException {
        Assume.assumeTrue((this.mode == Mode.DEVELOPMENT_BUNDLE ? 1 : 0) != 0);
        this.options.skipDevBundleBuild(true);
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"1.7.5\", \"@vaadin/text\":\"1.0.0\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.7.5");
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Rebuild should be skipped", (boolean)needsBuild);
    }

    @Test
    public void forceProductionBundle_bundleRequired() {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        this.options.withForceProductionBuild(true);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)((FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class)), (Mode)this.mode);
        Assert.assertTrue((String)"Production bundle required due to force.production.bundle flag.", (boolean)needsBuild);
    }

    @Test
    public void noDevFolder_compressedDevBundleExists_noBuildRequired() throws IOException {
        Assume.assumeTrue((!this.mode.isProduction() ? 1 : 0) != 0);
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("@polymer/paper-checkbox/paper-checkbox.js")));
        File bundleSourceFolder = this.temporaryFolder.newFolder("compiled");
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("@polymer/paper-checkbox/paper-checkbox.js");
        bundleImports.add("@polymer/paper-input/paper-input.js");
        bundleImports.add("@vaadin/grid/theme/lumo/vaadin-grid.js");
        bundleImports.add("Frontend/generated/jar-resources/dndConnector-es6.js");
        File configFolder = new File(bundleSourceFolder, "config/");
        configFolder.mkdir();
        File statsFile = new File(configFolder, "stats.json");
        FileUtils.write((File)statsFile, (CharSequence)stats.toString(), (Charset)StandardCharsets.UTF_8);
        DevBundleUtils.compressBundle((File)this.temporaryFolder.getRoot(), (File)bundleSourceFolder);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Jar fronted file content hash should match.", (boolean)needsBuild);
    }

    @Test
    public void compressedProdBundleExists_noBuildRequired() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("@polymer/paper-checkbox/paper-checkbox.js")));
        File bundleSourceFolder = this.temporaryFolder.newFolder("compiled");
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("@polymer/paper-checkbox/paper-checkbox.js");
        bundleImports.add("@polymer/paper-input/paper-input.js");
        bundleImports.add("@vaadin/grid/theme/lumo/vaadin-grid.js");
        bundleImports.add("Frontend/generated/jar-resources/dndConnector-es6.js");
        File configFolder = new File(bundleSourceFolder, "config/");
        configFolder.mkdir();
        File statsFile = new File(configFolder, "stats.json");
        FileUtils.write((File)statsFile, (CharSequence)stats.toString(), (Charset)StandardCharsets.UTF_8);
        ProdBundleUtils.compressBundle((File)this.temporaryFolder.getRoot(), (File)bundleSourceFolder);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Jar fronted file content hash should match.", (boolean)needsBuild);
    }

    @Test
    public void noFileBundleOrJar_compressedBundleExists_noBuildRequired() throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"@vaadin/router\": \"^1.7.5\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)depScanner.getModules()).thenReturn(Collections.singletonMap(ChunkInfo.GLOBAL, Collections.singletonList("@polymer/paper-checkbox/paper-checkbox.js")));
        File bundleSourceFolder = this.temporaryFolder.newFolder("compiled");
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/router", "1.8.6");
        ArrayNode bundleImports = (ArrayNode)stats.get(BUNDLE_IMPORTS);
        bundleImports.add("@polymer/paper-checkbox/paper-checkbox.js");
        bundleImports.add("@polymer/paper-input/paper-input.js");
        bundleImports.add("@vaadin/grid/theme/lumo/vaadin-grid.js");
        bundleImports.add("Frontend/generated/jar-resources/dndConnector-es6.js");
        File configFolder = new File(bundleSourceFolder, "config/");
        configFolder.mkdir();
        File statsFile = new File(configFolder, "stats.json");
        FileUtils.write((File)statsFile, (CharSequence)stats.toString(), (Charset)StandardCharsets.UTF_8);
        if (this.mode.isProduction()) {
            ProdBundleUtils.compressBundle((File)this.temporaryFolder.getRoot(), (File)bundleSourceFolder);
            Mockito.when((Object)this.finder.getResource("vaadin-prod-bundle/config/stats.json")).thenReturn(null);
        } else {
            DevBundleUtils.compressBundle((File)this.temporaryFolder.getRoot(), (File)bundleSourceFolder);
            Mockito.when((Object)this.finder.getResource("vaadin-dev-bundle/config/stats.json")).thenReturn(null);
        }
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Jar frontend file content hash should match.", (boolean)needsBuild);
    }

    @Test
    public void defaultDevBundleExists_noCompressedDevBundleFile_reactDisabled_buildRequired() throws IOException {
        this.options.withReact(false);
        Assume.assumeTrue((!this.mode.isProduction() ? 1 : 0) != 0);
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\"vaadin\": { \"hash\": \"aHash\"} }", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        URL url = (URL)Mockito.mock(URL.class);
        Mockito.when((Object)this.finder.getResource("vaadin-dev-bundle/config/stats.json")).thenReturn((Object)url);
        this.ioUtils.when(() -> FileIOUtils.urlToString((URL)url)).thenReturn((Object)stats.toString());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Dev bundle build is expected when react is disabled and using otherwise default dev bundle.", (boolean)needsBuild);
    }

    @Test
    public void defaultProdBundleExists_noCompressedProdBundleFile_noBuildRequired() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"react\": \"18.2.0\",\n    \"react-dom\": \"18.2.0\",\n    \"react-router\": \"7.0.0\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        URL url = (URL)Mockito.mock(URL.class);
        Mockito.when((Object)this.finder.getResource("vaadin-prod-bundle/config/stats.json")).thenReturn((Object)url);
        this.ioUtils.when(() -> FileIOUtils.urlToString((URL)url)).thenReturn((Object)stats.toString());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Jar frontend file content hash should match.", (boolean)needsBuild);
    }

    @Test
    public void defaultProdBundleExists_noCompressedProdBundleFileAndWithVersionsJsonExclusions_noBuildRequired() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        this.frontendBuildUtils.when(() -> FrontendBuildUtils.isReactModuleAvailable((Options)((Options)Mockito.any()))).thenAnswer(q -> true);
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\n  \"dependencies\": {\n    \"react\": \"18.2.0\",\n    \"react-dom\": \"18.2.0\",\n    \"react-router\": \"7.0.0\"\n  },\n  \"vaadin\": {\n    \"hash\": \"aHash\"\n  }\n}\n", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        Mockito.when((Object)depScanner.getPackages()).thenReturn(Collections.singletonMap("@vaadin/button", "2.0.0"));
        File versions = new File(this.temporaryFolder.getRoot(), "vaadin-core-versions.json");
        versions.createNewFile();
        FileUtils.write((File)versions, (CharSequence)"{\n  \"core\": {\n    \"vaadin-button\": {\n      \"jsVersion\": \"2.0.0\",\n      \"npmName\": \"@vaadin/button\"\n    }\n  },\n  \"react\": {\n    \"react-components\": {\n      \"exclusions\": [\"@vaadin/button\"],\n      \"jsVersion\": \"24.4.0\",\n      \"mode\": \"react\",\n      \"npmName\": \"@vaadin/react-components\"\n    }\n  },\n  \"platform\": \"123-SNAPSHOT\"\n}\n", (Charset)StandardCharsets.UTF_8);
        Mockito.when((Object)this.finder.getResource("vaadin-core-versions.json")).thenReturn((Object)versions.toURI().toURL());
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(PACKAGE_JSON_DEPENDENCIES)).put("@vaadin/react-components", "24.4.0");
        URL url = (URL)Mockito.mock(URL.class);
        Mockito.when((Object)this.finder.getResource("vaadin-prod-bundle/config/stats.json")).thenReturn((Object)url);
        this.ioUtils.when(() -> FileIOUtils.urlToString((URL)url)).thenReturn((Object)stats.toString());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"Jar frontend file content hash should match.", (boolean)needsBuild);
    }

    @Test
    public void defaultProdBundleExists_noCompressedProdBundleFile_reactDisabled_buildRequired() throws IOException {
        this.options.withReact(false);
        Assume.assumeTrue((boolean)this.mode.isProduction());
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        packageJson.createNewFile();
        FileUtils.write((File)packageJson, (CharSequence)"{\"vaadin\": { \"hash\": \"aHash\"} }", (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        URL url = (URL)Mockito.mock(URL.class);
        Mockito.when((Object)this.finder.getResource("vaadin-prod-bundle/config/stats.json")).thenReturn((Object)url);
        this.ioUtils.when(() -> FileIOUtils.urlToString((URL)url)).thenReturn((Object)stats.toString());
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"Prod bundle build is expected when react is disabled and using otherwise default prod bundle.", (boolean)needsBuild);
    }

    @Test
    public void commercialBannerBuild_commercialBannerComponentMissing_rebuildRequired() {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        this.options.withCommercialBanner(true);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"In commercial banner build mode, missing 'commercial-banner.js' should require bundling", (boolean)needsBuild);
    }

    @Test
    public void commercialBannerBuild_commercialBannerComponentChanged_rebuildRequired() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        this.options.withCommercialBanner(true);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        String defaultCommercialBannerJS = new String(this.getClass().getResourceAsStream("commercial-banner.js").readAllBytes(), StandardCharsets.UTF_8);
        String oldCommercialBannerJS = defaultCommercialBannerJS.replace("vaadin-commercial-banner", "vaadin-commercial-banner-old");
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("generated/commercial-banner.js", BundleValidationUtil.calculateHash((String)oldCommercialBannerJS));
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"In commercial banner build mode, modified 'commercial-banner.js' should require bundling", (boolean)needsBuild);
    }

    @Test
    public void commercialBannerBuild_commercialBannerComponentNotChanged_rebuildNotRequired() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        this.options.withCommercialBanner(true);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        String defaultCommercialBannerJS = new String(this.getClass().getResourceAsStream("commercial-banner.js").readAllBytes(), StandardCharsets.UTF_8);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("generated/commercial-banner.js", BundleValidationUtil.calculateHash((String)defaultCommercialBannerJS));
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"In commercial banner build mode, unmodified 'commercial-banner.js' should not require bundling", (boolean)needsBuild);
    }

    @Test
    public void nonCommercialBannerBuild_commercialBannerComponentPresent_rebuildRequired() throws IOException {
        Assume.assumeTrue((boolean)this.mode.isProduction());
        this.options.withCommercialBanner(false);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        File frontendGeneratedFolder = this.temporaryFolder.newFolder(new String[]{"./src/main/frontend/", "generated/"});
        File commercialBannerJS = new File(frontendGeneratedFolder, "commercial-banner.js");
        commercialBannerJS.createNewFile();
        String defaultCommercialBannerJS = new String(this.getClass().getResourceAsStream("commercial-banner.js").readAllBytes(), StandardCharsets.UTF_8);
        FileUtils.write((File)commercialBannerJS, (CharSequence)defaultCommercialBannerJS, (Charset)StandardCharsets.UTF_8);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("generated/commercial-banner.js", BundleValidationUtil.calculateHash((String)defaultCommercialBannerJS));
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"In non commercial banner build mode, presence of 'commercial-banner.js' should require bundling", (boolean)needsBuild);
    }

    @Test
    public void developmentMode_commercialBannerComponentNotPresent_rebuildNotRequired() {
        Assume.assumeTrue((!this.mode.isProduction() ? 1 : 0) != 0);
        this.options.withCommercialBanner(true);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ObjectNode stats = this.getBasicStats();
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertFalse((String)"In development mode, absence of 'commercial-banner.js' should not require bundling", (boolean)needsBuild);
    }

    @Test
    public void developmentMode_commercialBannerComponentPresent_rebuildRequired() throws IOException {
        Assume.assumeTrue((!this.mode.isProduction() ? 1 : 0) != 0);
        this.options.withCommercialBanner(true);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        String defaultCommercialBannerJS = new String(this.getClass().getResourceAsStream("commercial-banner.js").readAllBytes(), StandardCharsets.UTF_8);
        ObjectNode stats = this.getBasicStats();
        ((ObjectNode)stats.get(FRONTEND_HASHES)).put("generated/commercial-banner.js", BundleValidationUtil.calculateHash((String)defaultCommercialBannerJS));
        this.setupFrontendUtilsMock(stats);
        boolean needsBuild = BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
        Assert.assertTrue((String)"In development mode, presence of 'commercial-banner.js' should require bundling", (boolean)needsBuild);
    }

    private void createPackageJsonStub(String content) throws IOException {
        File packageJson = new File(this.temporaryFolder.getRoot(), "package.json");
        boolean created = packageJson.createNewFile();
        Assert.assertTrue((boolean)created);
        FileUtils.write((File)packageJson, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
    }

    private void createProjectThemeJsonStub(String content, String theme) throws IOException {
        this.createThemeJsonStub(content, theme, true);
    }

    private void createThemeJsonStub(String content, String theme, boolean projectTheme) throws IOException {
        String themeLocation = projectTheme ? "" : "generated/jar-resources/";
        File themeJson = new File(this.temporaryFolder.getRoot(), "./src/main/frontend/" + themeLocation + "themes/" + theme + "/theme.json");
        FileUtils.forceMkdir((File)themeJson.getParentFile());
        boolean created = themeJson.createNewFile();
        Assert.assertTrue((boolean)created);
        FileUtils.write((File)themeJson, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
    }

    private void createProjectFrontendFileStub() throws IOException {
        File frontendFile = new File(this.temporaryFolder.getRoot(), "./src/main/frontend/views/lit-view.ts");
        FileUtils.forceMkdir((File)frontendFile.getParentFile());
        boolean created = frontendFile.createNewFile();
        Assert.assertTrue((boolean)created);
        FileUtils.write((File)frontendFile, (CharSequence)"Some codes", (Charset)StandardCharsets.UTF_8);
    }

    private void setupFrontendUtilsMock(ObjectNode stats) {
        if (this.mode.isProduction()) {
            this.prodBundleUtils.when(() -> ProdBundleUtils.findBundleStatsJson((File)((File)Mockito.any(File.class)), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenReturn((Object)stats.toString());
        } else {
            this.devBundleUtils.when(() -> DevBundleUtils.getDevBundleFolder((File)((File)Mockito.any()), (String)((String)Mockito.any()))).thenReturn((Object)this.temporaryFolder.getRoot());
            this.devBundleUtils.when(() -> DevBundleUtils.findBundleStatsJson((File)this.temporaryFolder.getRoot(), (String)"target")).thenAnswer(q -> stats.toString());
        }
        this.frontendBuildUtils.when(() -> FrontendBuildUtils.getJarResourceString((String)Mockito.anyString(), (ClassFinder)((ClassFinder)Mockito.any(ClassFinder.class)))).thenAnswer(q -> this.jarResources.get(q.getArgument(0)));
    }

    private boolean checkBundleRebuildForProjectThemeComponentsCSS(boolean contentChanged, boolean bundled, String ... otherBundledComponentCss) throws IOException {
        return this.checkBundleRebuildForThemeComponentsCSS(true, false, contentChanged, bundled, otherBundledComponentCss);
    }

    private boolean checkBundleRebuildForJarPackagedThemeComponentsCSS(boolean contentChanged, boolean bundled, String ... otherBundledComponentCss) throws IOException {
        return this.checkBundleRebuildForThemeComponentsCSS(false, false, contentChanged, bundled, otherBundledComponentCss);
    }

    private boolean checkBundleRebuildForParentProjectThemeComponentsCSS(boolean contentChanged, boolean bundled, String ... otherBundledComponentCss) throws IOException {
        return this.checkBundleRebuildForThemeComponentsCSS(true, true, contentChanged, bundled, otherBundledComponentCss);
    }

    private boolean checkBundleRebuildForJarPackagedParentThemeComponentsCSS(boolean contentChanged, boolean bundled, String ... otherBundledComponentCss) throws IOException {
        return this.checkBundleRebuildForThemeComponentsCSS(false, true, contentChanged, bundled, otherBundledComponentCss);
    }

    private boolean checkBundleRebuildForThemeComponentsCSS(boolean projectTheme, boolean useParentTheme, boolean contentChanged, boolean bundled, String ... otherBundledComponentCss) throws IOException {
        String cssTemplate = "[part=\"input-field\"]{background: %s; }";
        this.createPackageJsonStub(BLANK_PACKAGE_JSON_WITH_HASH);
        String themeContents = "{ \"importCss\": [\"foo\"] }";
        String themeWithParentContents = "{\"parent\": \"parent-theme\"}";
        if (useParentTheme) {
            this.createThemeJsonStub(themeContents, "parent-theme", projectTheme);
            this.createThemeJsonStub(themeWithParentContents, "my-theme", projectTheme);
        } else {
            this.createThemeJsonStub(themeContents, "my-theme", projectTheme);
        }
        String themeLocation = (projectTheme ? "" : "generated/jar-resources/") + "themes/" + (useParentTheme ? "parent-theme" : "my-theme") + "/components/";
        File stylesheetFile = new File(this.temporaryFolder.getRoot(), "./src/main/frontend/" + themeLocation + "vaadin-text-field.css");
        FileUtils.forceMkdir((File)stylesheetFile.getParentFile());
        boolean created = stylesheetFile.createNewFile();
        Assert.assertTrue((boolean)created);
        FileUtils.write((File)stylesheetFile, (CharSequence)String.format(cssTemplate, "blue"), (Charset)StandardCharsets.UTF_8);
        FrontendDependenciesScanner depScanner = (FrontendDependenciesScanner)Mockito.mock(FrontendDependenciesScanner.class);
        ThemeDefinition themeDefinition = (ThemeDefinition)Mockito.mock(ThemeDefinition.class);
        Mockito.when((Object)themeDefinition.getName()).thenReturn((Object)"my-theme");
        Mockito.when((Object)depScanner.getThemeDefinition()).thenReturn((Object)themeDefinition);
        ObjectNode stats = this.getBasicStats();
        if (useParentTheme) {
            ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put("parent-theme", themeContents);
            ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put("my-theme", themeWithParentContents);
        } else {
            ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put("my-theme", themeContents);
        }
        ((ObjectNode)stats.get(THEME_JSON_CONTENTS)).put(this.bundleLocation, themeContents);
        if (bundled) {
            ((ObjectNode)stats.get(FRONTEND_HASHES)).put(themeLocation + "vaadin-text-field.css", BundleValidationUtil.calculateHash((String)String.format(cssTemplate, contentChanged ? "red" : "blue")));
        }
        for (String path : otherBundledComponentCss) {
            ((ObjectNode)stats.get(FRONTEND_HASHES)).put(themeLocation + path, BundleValidationUtil.calculateHash((String)"[part=\"input-field\"]{background: green; }"));
        }
        this.setupFrontendUtilsMock(stats);
        return BundleValidationUtil.needsBuild((Options)this.options, (FrontendDependenciesScanner)depScanner, (Mode)this.mode);
    }

    static {
        try {
            THEME_UTIL_JS = IOUtils.toString((InputStream)BundleValidationTest.class.getClassLoader().getResourceAsStream("META-INF/frontend/theme-util.js"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @LoadDependenciesOnStartup
    static class AllEagerAppConf
    implements AppShellConfigurator {
        AllEagerAppConf() {
        }
    }
}

