/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.BundleUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.tests.util.MockOptions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class BundleUtilsTest {
    private List<AutoCloseable> closeOnTearDown = new ArrayList<AutoCloseable>();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @After
    public void tearDown() {
        for (AutoCloseable closeable : this.closeOnTearDown) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void frontendImportVariantsIncluded() {
        this.mockStatsJson("Frontend/foo.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/foo.js"));
        Assert.assertTrue((boolean)bundleImports.contains("foo.js"));
        Assert.assertTrue((boolean)bundleImports.contains("./foo.js"));
    }

    @Test
    public void jarImportVariantsIncluded() {
        this.mockStatsJson("Frontend/generated/jar-resources/my/addon.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/generated/jar-resources/my/addon.js"));
        Assert.assertTrue((boolean)bundleImports.contains("./my/addon.js"));
        Assert.assertTrue((boolean)bundleImports.contains("my/addon.js"));
    }

    @Test
    public void frontendInTheMiddleNotTouched() {
        this.mockStatsJson("my/Frontend/foo.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertEquals(Set.of("my/Frontend/foo.js"), (Object)bundleImports);
    }

    @Test
    public void themeVariantsHandled() {
        this.mockStatsJson("@foo/bar/theme/lumo/file.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("@foo/bar/theme/lumo/file.js"));
        Assert.assertTrue((boolean)bundleImports.contains("@foo/bar/src/file.js"));
    }

    @Test
    public void themeVariantsFromJarHandled() {
        this.mockStatsJson("Frontend/generated/jar-resources/theme/lumo/file.js", "Frontend/generated/jar-resources/theme/material/file.js");
        Set bundleImports = BundleUtils.loadBundleImports();
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/generated/jar-resources/theme/lumo/file.js"));
        Assert.assertTrue((boolean)bundleImports.contains("Frontend/generated/jar-resources/theme/material/file.js"));
        Assert.assertTrue((boolean)bundleImports.contains("./src/file.js"));
    }

    private void mockStatsJson(String ... imports) {
        ObjectNode statsJson = JacksonUtils.createObjectNode();
        ArrayNode importsArray = JacksonUtils.createArrayNode();
        for (String anImport : imports) {
            importsArray.add(anImport);
        }
        statsJson.set("bundleImports", (JsonNode)importsArray);
        this.mockStatsJsonLoading((JsonNode)statsJson);
    }

    private void mockStatsJsonLoading(JsonNode statsJson) {
        MockedStatic mock = Mockito.mockStatic(BundleUtils.class);
        mock.when(() -> BundleUtils.loadStatsJson()).thenReturn((Object)statsJson);
        mock.when(() -> BundleUtils.loadBundleImports()).thenCallRealMethod();
        this.closeOnTearDown.add((AutoCloseable)mock);
    }

    @Test
    public void packageLockExists_nothingIsCopied() throws IOException {
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource(Mockito.anyString())).thenReturn(null);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), finder, this.temporaryFolder.getRoot()).withBuildDirectory("target");
        File packageLockFile = this.temporaryFolder.newFile("package-lock.json");
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "package-lock.json");
        String existingLockFile = "{ \"existing\" }";
        FileUtils.write((File)packageLockFile, (CharSequence)"{ \"existing\" }");
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"bundleFile\"}");
        BundleUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)packageLockFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Existing file should not be overwritten", (Object)"{ \"existing\" }", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_devBundleLockIsCopied_notJarLock() throws IOException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "package-lock.json");
        String packageLockContent = "{ \"bundleFile\"}";
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"bundleFile\"}");
        BundleUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"dev-bundle file should be used", (Object)"{ \"bundleFile\"}", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_jarDevBundleLockIsCopied() throws IOException, ClassNotFoundException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        File jarHybridPackageLock = new File(options.getNpmFolder(), "hybrid-temp.json");
        String jarHybridPackageLockContent = "{ \"hybridJarData\"}";
        FileUtils.write((File)jarHybridPackageLock, (CharSequence)"{ \"hybridJarData\"}");
        ((ClassFinder)Mockito.doThrow((Throwable[])new Throwable[]{new ClassNotFoundException("No Hilla")}).when((Object)options.getClassFinder())).loadClass("com.vaadin.hilla.EndpointController");
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-package-lock.json")).thenReturn((Object)jarHybridPackageLock.toURI().toURL());
        BundleUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"File should be gotten from jar on classpath", (Object)"{ \"jarData\"}", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_hillaUsed_jarHybridDevBundleLockIsCopied() throws IOException, ClassNotFoundException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        Path dummyView = options.getFrontendDirectory().toPath().resolve(Path.of("views", "dummy.tsx"));
        Files.createDirectories(dummyView.getParent(), new FileAttribute[0]);
        Files.writeString(dummyView, (CharSequence)"const x = 1;", new OpenOption[0]);
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        File jarHybridPackageLock = new File(options.getNpmFolder(), "hybrid-temp.json");
        String jarHybridPackageLockContent = "{ \"hybridJarData\"}";
        FileUtils.write((File)jarHybridPackageLock, (CharSequence)"{ \"hybridJarData\"}");
        Mockito.when((Object)options.getClassFinder().loadClass("com.vaadin.hilla.EndpointController")).thenReturn(Object.class);
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-package-lock.json")).thenReturn((Object)jarHybridPackageLock.toURI().toURL());
        BundleUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"File should be gotten from jar on classpath", (Object)"{ \"hybridJarData\"}", (Object)packageLockContents);
    }

    @Test
    public void noPackageLockExists_hillaUsed_hybridPackageLockNotPresentInJar_jarDevBundleIsCopied() throws IOException, ClassNotFoundException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target");
        Path dummyView = options.getFrontendDirectory().toPath().resolve(Path.of("views", "dummy.tsx"));
        Files.createDirectories(dummyView.getParent(), new FileAttribute[0]);
        Files.writeString(dummyView, (CharSequence)"const x = 1;", new OpenOption[0]);
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        Mockito.when((Object)options.getClassFinder().loadClass("com.vaadin.hilla.EndpointController")).thenReturn(Object.class);
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/package-lock.json")).thenReturn((Object)jarPackageLock.toURI().toURL());
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/hybrid-package-lock.json")).thenReturn(null);
        BundleUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "package-lock.json"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"File should be gotten from jar on classpath", (Object)"{ \"jarData\"}", (Object)packageLockContents);
    }

    @Test
    public void pnpm_noPackageLockExists_devBundleLockYamlIsCopied_notJarLockOrJson() throws IOException {
        Options options = new MockOptions(this.temporaryFolder.getRoot()).withBuildDirectory("target").withEnablePnpm(true);
        File jarPackageLock = new File(options.getNpmFolder(), "temp.json");
        String jarPackageLockContent = "{ \"jarData\"}";
        FileUtils.write((File)jarPackageLock, (CharSequence)"{ \"jarData\"}");
        Mockito.when((Object)options.getClassFinder().getResource("vaadin-dev-bundle/pnpm-lock.yaml")).thenReturn((Object)jarPackageLock.toURI().toURL());
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "package-lock.json");
        File devPackageLock = new File(devBundleFolder, "pnpm-lock.yaml");
        String packageLockContent = "{ \"bundleFile\"}";
        FileUtils.write((File)devPackageLock, (CharSequence)"{ \"bundleFile\"}");
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"json\"}");
        BundleUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)new File(options.getNpmFolder(), "pnpm-lock.yaml"), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"dev-bundle file should be used", (Object)"{ \"bundleFile\"}", (Object)packageLockContents);
    }

    @Test
    public void pnpm_packageLockExists_nothingIsCopied() throws IOException {
        ClassFinder finder = (ClassFinder)Mockito.mock(ClassFinder.class);
        Mockito.when((Object)finder.getResource(Mockito.anyString())).thenReturn(null);
        Options options = new Options((Lookup)Mockito.mock(Lookup.class), finder, this.temporaryFolder.getRoot()).withBuildDirectory("target").withEnablePnpm(true);
        File packageLockFile = this.temporaryFolder.newFile("pnpm-lock.yaml");
        File devBundleFolder = new File(new File(options.getNpmFolder(), options.getBuildDirectoryName()), "dev-bundle");
        devBundleFolder.mkdirs();
        File devPackageLockJson = new File(devBundleFolder, "pnpm-lock.yaml");
        String existingLockFile = "{ \"existing\" }";
        FileUtils.write((File)packageLockFile, (CharSequence)"{ \"existing\" }");
        FileUtils.write((File)devPackageLockJson, (CharSequence)"{ \"bundleFile\"}");
        BundleUtils.copyPackageLockFromBundle((Options)options);
        String packageLockContents = FileUtils.readFileToString((File)packageLockFile, (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((String)"Existing file should not be overwritten", (Object)"{ \"existing\" }", (Object)packageLockContents);
    }

    @Test
    public void loadStatsJson_cachesResult_returnsSameInstance() {
        ObjectNode first = BundleUtils.loadStatsJson();
        ObjectNode second = BundleUtils.loadStatsJson();
        Assert.assertSame((String)"Should return cached instance on second call", (Object)first, (Object)second);
    }

    @Test
    public void loadStatsJson_cachedResultIsConsistent() {
        ObjectNode first = BundleUtils.loadStatsJson();
        ObjectNode second = BundleUtils.loadStatsJson();
        Assert.assertEquals((String)"Cached result should be consistent", (Object)first.toString(), (Object)second.toString());
    }

    @Test
    public void isPreCompiledProductionBundle_usesCachedStats() {
        boolean first = BundleUtils.isPreCompiledProductionBundle();
        boolean second = BundleUtils.isPreCompiledProductionBundle();
        boolean third = BundleUtils.isPreCompiledProductionBundle();
        Assert.assertEquals((String)"Should return consistent results", (Object)first, (Object)second);
        Assert.assertEquals((String)"Should return consistent results", (Object)second, (Object)third);
    }
}

