/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.dau;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.SystemMessagesInfo;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceDauTest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.dau.DAUCustomizer;
import com.vaadin.flow.server.dau.DAUUtils;
import com.vaadin.flow.server.dau.DauEnforcementException;
import com.vaadin.flow.server.dau.EnforcementNotificationMessages;
import com.vaadin.flow.server.dau.FlowDauIntegration;
import com.vaadin.pro.licensechecker.dau.DauIntegration;
import com.vaadin.pro.licensechecker.dau.EnforcementException;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.function.Predicate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.JsonNodeType;

public class DAUUtilsTest {
    private String subscriptionKey;

    @Before
    public void setUp() throws Exception {
        this.subscriptionKey = System.getProperty("vaadin.subscriptionKey");
        System.setProperty("vaadin.subscriptionKey", "sub-1234");
    }

    @After
    public void tearDown() throws Exception {
        if (this.subscriptionKey != null) {
            System.setProperty("vaadin.subscriptionKey", this.subscriptionKey);
        } else {
            System.clearProperty("vaadin.subscriptionKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void trackUser_uidlRequest_deferTracking() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.UIDL.getIdentifier());
        HashMap attributes = new HashMap();
        ((VaadinRequest)Mockito.doAnswer(i -> attributes.put((String)i.getArgument(0), i.getArgument(1))).when((Object)request)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        Mockito.when((Object)request.getAttribute(ArgumentMatchers.anyString())).thenAnswer(i -> attributes.get(i.getArgument(0)));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            dauIntegration.when(() -> DauIntegration.trackUser((String)"trackingHash", null)).thenThrow(new Throwable[]{new EnforcementException("STOP")});
            FlowDauIntegration.trackUser((VaadinRequest)request, (String)"trackingHash", null);
            dauIntegration.verifyNoInteractions();
            Assert.assertThrows(DauEnforcementException.class, () -> FlowDauIntegration.applyEnforcement((VaadinRequest)request, unused -> true));
            dauIntegration.verify(() -> DauIntegration.trackUser((String)"trackingHash", null));
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void trackUser_notUidlRequest_track() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)request.getParameter("v-r")).thenReturn((Object)HandlerHelper.RequestType.INIT.getIdentifier());
        HashMap attributes = new HashMap();
        ((VaadinRequest)Mockito.doAnswer(i -> attributes.put((String)i.getArgument(0), i.getArgument(1))).when((Object)request)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        Mockito.when((Object)request.getAttribute(ArgumentMatchers.anyString())).thenAnswer(i -> attributes.get(i.getArgument(0)));
        try (MockedStatic dauIntegration = Mockito.mockStatic(DauIntegration.class);){
            dauIntegration.when(() -> DauIntegration.trackUser((String)"trackingHash", null)).thenThrow(new Throwable[]{new EnforcementException("STOP")});
            FlowDauIntegration.trackUser((VaadinRequest)request, (String)"trackingHash", null);
            dauIntegration.verify(() -> DauIntegration.trackUser((String)"trackingHash", null));
            Assert.assertThrows(DauEnforcementException.class, () -> FlowDauIntegration.applyEnforcement((VaadinRequest)request, unused -> true));
        }
        finally {
            VaadinSession.setCurrent(null);
        }
    }

    @Test
    public void jsonEnforcementResponse_noDauCustomizer_defaultMessages() {
        try (MockedStatic dauIntegrationMock = Mockito.mockStatic(DauIntegration.class);){
            VaadinService service = VaadinServiceDauTest.vaadinServiceWithDau(null);
            VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)request.getService()).thenReturn((Object)service);
            String response = DAUUtils.jsonEnforcementResponse((VaadinRequest)request, (DauEnforcementException)new DauEnforcementException(new EnforcementException("STOP")));
            response = response.replace("for(;;);[", "").replaceFirst("]$", "");
            JsonNode json = JacksonUtils.readTree((String)response).get("meta").get("appError");
            EnforcementNotificationMessages expectedMessages = EnforcementNotificationMessages.DEFAULT;
            this.assertJsonErrorProperty("caption", expectedMessages.caption(), json);
            this.assertJsonErrorProperty("message", expectedMessages.message(), json);
            this.assertJsonErrorProperty("details", expectedMessages.details(), json);
            this.assertJsonErrorProperty("url", expectedMessages.url(), json);
        }
    }

    @Test
    public void jsonEnforcementResponse_customMessages() {
        try (MockedStatic dauIntegrationMock = Mockito.mockStatic(DauIntegration.class);){
            final EnforcementNotificationMessages expectedMessages = new EnforcementNotificationMessages("caption", "message", "details", "url");
            DAUCustomizer customizer = new DAUCustomizer(){

                public EnforcementNotificationMessages getEnforcementNotificationMessages(SystemMessagesInfo systemMessagesInfo) {
                    return expectedMessages;
                }
            };
            VaadinService service = VaadinServiceDauTest.vaadinServiceWithDau(customizer);
            VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
            Mockito.when((Object)request.getService()).thenReturn((Object)service);
            String response = DAUUtils.jsonEnforcementResponse((VaadinRequest)request, (DauEnforcementException)new DauEnforcementException(new EnforcementException("STOP")));
            response = response.replace("for(;;);[", "").replaceFirst("]$", "");
            JsonNode json = JacksonUtils.readTree((String)response).get("meta").get("appError");
            this.assertJsonErrorProperty("caption", expectedMessages.caption(), json);
            this.assertJsonErrorProperty("message", expectedMessages.message(), json);
            this.assertJsonErrorProperty("details", expectedMessages.details(), json);
            this.assertJsonErrorProperty("url", expectedMessages.url(), json);
        }
    }

    @Test
    public void trackDAU_trackingIntegratedWithRequest_noEnforcement() {
        MocksForTrackDAU mocks = new MocksForTrackDAU();
        VaadinService service = mocks.service;
        HttpServletRequest request = mocks.request;
        HttpServletResponse response = mocks.response;
        try (MockedStatic flowDauIntegration = Mockito.mockStatic(FlowDauIntegration.class);){
            DAUUtils.EnforcementResult result = DAUUtils.trackDAU((VaadinService)service, (HttpServletRequest)request, (HttpServletResponse)response);
            mocks.assertNoEnforcement(result);
            flowDauIntegration.verify(() -> FlowDauIntegration.applyEnforcement((VaadinRequest)((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class)), (Predicate)((Predicate)ArgumentMatchers.any())));
            result.endRequestAction().run();
            ((VaadinService)Mockito.verify((Object)service)).requestEnd((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class), (VaadinResponse)Mockito.isNull(), (VaadinSession)Mockito.isNull());
        }
    }

    @Test
    public void trackDAU_trackingIntegratedWithRequest_enforcement() {
        MocksForTrackDAU mocks = new MocksForTrackDAU();
        VaadinService service = mocks.service;
        HttpServletRequest request = mocks.request;
        HttpServletResponse response = mocks.response;
        try (MockedStatic flowDauIntegration = Mockito.mockStatic(FlowDauIntegration.class);){
            flowDauIntegration.when(() -> FlowDauIntegration.applyEnforcement((VaadinRequest)((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class)), (Predicate)((Predicate)ArgumentMatchers.any()))).thenThrow(new Throwable[]{new DauEnforcementException(new EnforcementException("STOP"))});
            DAUUtils.EnforcementResult result = DAUUtils.trackDAU((VaadinService)service, (HttpServletRequest)request, (HttpServletResponse)response);
            mocks.assertEnforcement(result);
            flowDauIntegration.verify(() -> FlowDauIntegration.applyEnforcement((VaadinRequest)((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class)), (Predicate)((Predicate)ArgumentMatchers.any())));
            result.endRequestAction().run();
            ((VaadinService)Mockito.verify((Object)service)).requestEnd((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class), (VaadinResponse)Mockito.isNull(), (VaadinSession)Mockito.isNull());
        }
    }

    private void assertJsonErrorProperty(String expectedKey, String expectedValue, JsonNode json) {
        if (expectedValue != null) {
            Assert.assertEquals((String)expectedKey, (Object)expectedValue, (Object)json.get(expectedKey).asString());
        } else {
            Assert.assertEquals((String)("expected key " + expectedKey + " to be null"), (Object)JsonNodeType.NULL, (Object)json.get(expectedKey).getNodeType());
        }
    }

    private static class MocksForTrackDAU {
        private VaadinService service = (VaadinService)Mockito.mock(VaadinServletService.class);
        private HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        private HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);

        public MocksForTrackDAU() {
            VaadinContext vaadinContext = (VaadinContext)Mockito.mock(VaadinContext.class);
            Mockito.when((Object)vaadinContext.getAttribute((Class)ArgumentMatchers.any())).thenReturn(null);
            MockDeploymentConfiguration config = new MockDeploymentConfiguration();
            config.setProductionMode(true);
            config.setApplicationOrSystemProperty("dau.enable", "true");
            Mockito.when((Object)this.service.getDeploymentConfiguration()).thenReturn((Object)config);
            Mockito.when((Object)this.service.getContext()).thenReturn((Object)vaadinContext);
        }

        private void assertNoEnforcement(DAUUtils.EnforcementResult result) {
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)result.endRequestAction());
            Assert.assertNull((Object)result.messages());
            Assert.assertNull((Object)result.origin());
            ((VaadinService)Mockito.verify((Object)this.service)).requestStart((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class), (VaadinResponse)ArgumentMatchers.any(VaadinResponse.class));
            ((VaadinService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).requestEnd((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class), (VaadinResponse)Mockito.isNull(), (VaadinSession)Mockito.isNull());
        }

        private void assertEnforcement(DAUUtils.EnforcementResult result) {
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)result.endRequestAction());
            Assert.assertNotNull((Object)result.messages());
            Assert.assertNotNull((Object)result.origin());
            ((VaadinService)Mockito.verify((Object)this.service)).requestStart((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class), (VaadinResponse)ArgumentMatchers.any(VaadinResponse.class));
            ((VaadinService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).requestEnd((VaadinRequest)ArgumentMatchers.any(VaadinRequest.class), (VaadinResponse)Mockito.isNull(), (VaadinSession)Mockito.isNull());
        }
    }
}

