/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.server.MockServletContext;
import com.vaadin.flow.server.VaadinServletContext;
import jakarta.servlet.ServletContext;
import org.mockito.Mockito;

public class MockVaadinContext
extends VaadinServletContext {
    private Lookup lookup = (Lookup)Mockito.mock(Lookup.class);

    public MockVaadinContext() {
        this(new MockServletContext(), new RoutePathProviderImpl());
    }

    public MockVaadinContext(RoutePathProvider provider) {
        this(new MockServletContext(), provider);
    }

    public MockVaadinContext(ServletContext context) {
        this(context, new RoutePathProviderImpl());
    }

    public MockVaadinContext(ServletContext context, RoutePathProvider provider) {
        super(context);
        Mockito.when((Object)((RoutePathProvider)this.lookup.lookup(RoutePathProvider.class))).thenReturn(null);
        Mockito.when((Object)((RoutePathProvider)this.lookup.lookup(RoutePathProvider.class))).thenReturn((Object)provider);
        this.setAttribute(this.lookup);
    }

    public <T> T getAttribute(Class<T> type) {
        if (type.equals(Lookup.class)) {
            return type.cast(this.lookup);
        }
        return (T)super.getAttribute(type);
    }

    public static class RoutePathProviderImpl
    implements RoutePathProvider {
        public String getRoutePath(Class<?> navigationTarget) {
            Route route = navigationTarget.getAnnotation(Route.class);
            return route.value();
        }
    }
}

