/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.router.internal.AbstractRouteRegistry;
import com.vaadin.flow.router.internal.ConfiguredRoutes;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.TestAbstractRouteRegistry;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AbstractRouteRegistryTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private AbstractRouteRegistry registry;

    @Before
    public void init() {
        this.registry = new TestAbstractRouteRegistry();
    }

    @Test
    public void lockingConfiguration_configurationIsUpdatedOnlyAfterUnlock() {
        final CountDownLatch waitReaderThread = new CountDownLatch(1);
        final CountDownLatch waitUpdaterThread = new CountDownLatch(2);
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                AbstractRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assert.assertTrue((String)"Registry should still remain empty", (boolean)AbstractRouteRegistryTest.this.registry.getRegisteredRoutes().isEmpty());
                AbstractRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assert.assertTrue((String)"Registry should still remain empty", (boolean)AbstractRouteRegistryTest.this.registry.getRegisteredRoutes().isEmpty());
                waitReaderThread.countDown();
            }
        };
        readerThread.start();
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("", MyRoute.class, Collections.emptyList());
            this.registry.setRoute("path", Secondary.class, Collections.emptyList());
        });
        Assert.assertEquals((String)"After unlock registry should be updated for others to configure with new data", (long)2L, (long)this.registry.getRegisteredRoutes().size());
    }

    @Test
    public void routeChangeListener_correctChangesAreReturned() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.registry.setRoute("", MyRoute.class, Collections.emptyList());
        Assert.assertFalse((String)"Added should contain data for one entry", (boolean)added.isEmpty());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        Assert.assertEquals(MyRoute.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assert.assertEquals((Object)"", (Object)((RouteBaseData)added.get(0)).getTemplate());
        Assert.assertEquals(Collections.emptyList(), (Object)((RouteBaseData)added.get(0)).getParentLayouts());
        this.registry.setRoute("home", Secondary.class, Collections.emptyList());
        Assert.assertFalse((String)"Added should contain data for one entry", (boolean)added.isEmpty());
        Assert.assertEquals((String)"Only latest change should be available", (long)1L, (long)added.size());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        Assert.assertEquals(Secondary.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assert.assertEquals((Object)"home", (Object)((RouteBaseData)added.get(0)).getTemplate());
        this.registry.removeRoute("home");
        Assert.assertTrue((String)"No routes should have been added", (boolean)added.isEmpty());
        Assert.assertFalse((String)"One route should have gotten removed", (boolean)removed.isEmpty());
        Assert.assertEquals(Secondary.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assert.assertEquals((String)"The 'home' route should have been removed", (Object)"home", (Object)((RouteBaseData)removed.get(0)).getTemplate());
    }

    @Test
    public void routeChangeListener_blockChangesAreGivenCorrectlyInEvent() {
        this.registry.setRoute("", MyRoute.class, Collections.emptyList());
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.removeRoute("");
            this.registry.setRoute("path", Secondary.class, Collections.emptyList());
            this.registry.setRoute("", MyRoute.class, Collections.singletonList(MainLayout.class));
        });
        Assert.assertFalse((String)"", (boolean)added.isEmpty());
        Assert.assertEquals((String)"", (long)2L, (long)added.size());
        Assert.assertFalse((String)"", (boolean)removed.isEmpty());
        for (RouteBaseData data : added) {
            if (data.getTemplate().equals("")) {
                Assert.assertEquals((String)"MyRoute should have been added", MyRoute.class, (Object)data.getNavigationTarget());
                Assert.assertEquals((String)"MyRoute should have been seen as a update as the parent layouts changed.", MainLayout.class, (Object)data.getParentLayout());
                continue;
            }
            Assert.assertEquals((String)"", Secondary.class, (Object)data.getNavigationTarget());
        }
        Assert.assertEquals((String)"MyRoute should have been both removed and added", MyRoute.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assert.assertEquals((String)"Removed version should not have a parent layout", Collections.emptyList(), (Object)((RouteBaseData)removed.get(0)).getParentLayouts());
    }

    @Test
    public void routeWithAliases_eventShowsCorrectlyAsRemoved() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("main", Secondary.class, Collections.emptyList());
            this.registry.setRoute("Alias1", Secondary.class, Collections.emptyList());
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        });
        Assert.assertEquals((String)"Main route and aliases should all be seen as added.", (long)3L, (long)added.size());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        this.registry.removeRoute("Alias2");
        Assert.assertTrue((String)"No routes should have been added", (boolean)added.isEmpty());
        Assert.assertEquals((String)"Removing the alias route should be seen in the event", (long)1L, (long)removed.size());
    }

    @Test
    public void changeListenerAddedDuringUpdate_eventIsFiredForListener() {
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("main", Secondary.class, Collections.emptyList());
            this.registry.setRoute("Alias1", Secondary.class, Collections.emptyList());
            this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
                added.clear();
                removed.clear();
                added.addAll(event.getAddedRoutes());
                removed.addAll(event.getRemovedRoutes());
            });
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        });
        Assert.assertEquals((String)"Main route and aliases should all be seen as added.", (long)3L, (long)added.size());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        this.registry.removeRoute("Alias2");
        Assert.assertTrue((String)"No routes should have been added", (boolean)added.isEmpty());
        Assert.assertEquals((String)"Removing the alias route should be seen in the event", (long)1L, (long)removed.size());
    }

    @Test
    public void removeChangeListener_noEventsAreFired() {
        ArrayList events = new ArrayList();
        Registration registration = this.registry.addRoutesChangeListener(events::add);
        this.registry.setRoute("home", MyRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"Event should have been fired for listener", (long)1L, (long)events.size());
        registration.remove();
        this.registry.setRoute("away", MyRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"No new event should have fired", (long)1L, (long)events.size());
    }

    @Test
    public void routeChangedEvent_testRouteAddedAndRemoved() {
        this.registry.setRoute("MyRoute1", MyRoute.class, Collections.emptyList());
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            Assert.assertEquals((String)"MyRoute2 and Alias2 must be added", (long)2L, (long)event.getAddedRoutes().size());
            Assert.assertEquals((String)"MyRoute1 must be deleted", (long)1L, (long)event.getRemovedRoutes().size());
            Assert.assertTrue((String)"MyRoute2 must be added", (boolean)event.isRouteAdded(MyRoute.class));
            Assert.assertTrue((String)"Alias2 must be added", (boolean)event.isRouteAdded(Secondary.class));
            Assert.assertTrue((String)"MyRoute1 must be deleted", (boolean)event.isRouteRemoved(MyRoute.class));
            Assert.assertTrue((String)"MyRoute2 must be added", (boolean)event.getAddedNavigationTargets().contains(MyRoute.class));
            Assert.assertTrue((String)"Alias2 must be added", (boolean)event.getAddedNavigationTargets().contains(Secondary.class));
            Assert.assertTrue((String)"MyRoute1 must be deleted", (boolean)event.getRemovedNavigationTargets().contains(MyRoute.class));
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("MyRoute2", MyRoute.class, Collections.emptyList());
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
            this.registry.removeRoute("MyRoute1");
        });
    }

    @Test
    public void routeChangedEvent_testPathAddedAndRemoved() {
        this.registry.setRoute("MyRoute1", MyRoute.class, Collections.emptyList());
        this.registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            Assert.assertEquals((String)"MyRoute2 and Alias2 must be added", (long)2L, (long)event.getAddedRoutes().size());
            Assert.assertEquals((String)"MyRoute1 must be deleted", (long)1L, (long)event.getRemovedRoutes().size());
            Assert.assertTrue((String)"MyRoute2 must be added", (boolean)event.isPathAdded("MyRoute2"));
            Assert.assertTrue((String)"Alias2 must be added", (boolean)event.isPathAdded("Alias2"));
            Assert.assertTrue((String)"MyRoute1 must be deleted", (boolean)event.isPathRemoved("MyRoute1"));
            Assert.assertTrue((String)"MyRoute2 must be added", (boolean)event.getAddedURLs().contains("MyRoute2"));
            Assert.assertTrue((String)"Alias2 must be added", (boolean)event.getAddedURLs().contains("Alias2"));
            Assert.assertTrue((String)"MyRoute1 must be deleted", (boolean)event.getRemovedURLs().contains("MyRoute1"));
        });
        this.registry.update((Command & Serializable)() -> {
            this.registry.setRoute("MyRoute2", MyRoute.class, Collections.emptyList());
            this.registry.setRoute("Alias2", Secondary.class, Collections.emptyList());
            this.registry.removeRoute("MyRoute1");
        });
    }

    @Test
    public void only_normal_target_works_as_expected() {
        this.addTarget(NormalRoute.class);
        Assert.assertEquals((String)"NormalRoute should have been returned", NormalRoute.class, this.getTarget());
    }

    @Test
    public void only_has_url_target_works_as_expected() {
        this.addTarget(HasUrlRoute.class);
        Assert.assertNull((String)"No has url should have been returned without parameter", this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"HasUrlRoute should have been returned", HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")));
    }

    @Test
    public void only_optional_target_works_as_expected() {
        this.addTarget(OptionalRoute.class);
        Assert.assertEquals((String)"OptionalRoute should have been returned with no parameter", OptionalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"OptionalRoute should have been returned", OptionalRoute.class, this.getTarget(Arrays.asList("optional")));
    }

    @Test
    public void only_wildcard_target_works_as_expected() {
        this.addTarget(WildcardRoute.class);
        Assert.assertEquals((String)"WildcardRoute should have been returned with no parameter", WildcardRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"WildcardRoute should have been returned for one parameter", WildcardRoute.class, this.getTarget(Arrays.asList("wild")));
        Assert.assertEquals((String)"WildcardRoute should have been returned for multiple parameters", WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")));
    }

    @Test
    public void normal_and_has_url_work_together() {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        Assert.assertEquals((String)"NormalRoute should have been returned", NormalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"HasUrlRoute should have been returned", HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")));
    }

    @Test
    public void has_url_and_normal_work_together() {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(NormalRoute.class);
        Assert.assertEquals((String)"NormalRoute should have been returned", NormalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"HasUrlRoute should have been returned", HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")));
    }

    @Test
    public void normal_and_wildcard_work_together() {
        this.addTarget(NormalRoute.class);
        this.addTarget(WildcardRoute.class);
        Assert.assertEquals((String)"NormalRoute should have been returned", NormalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"WildcardRoute should have been returned", WildcardRoute.class, this.getTarget(Arrays.asList("parameter")));
        Assert.assertEquals((String)"WildcardRoute should have been returned for multiple parameters", WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")));
    }

    @Test
    public void wildcard_and_normal_work_together() {
        this.addTarget(WildcardRoute.class);
        this.addTarget(NormalRoute.class);
        Assert.assertEquals((String)"NormalRoute should have been returned", NormalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"WildcardRoute should have been returned", WildcardRoute.class, this.getTarget(Arrays.asList("parameter")));
        Assert.assertEquals((String)"WildcardRoute should have been returned for multiple parameters", WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")));
    }

    @Test
    public void normal_and_has_url_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void normal_and_wildcard_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(NormalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void wildcard_and_normal_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(NormalRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void has_url_and_wildcard_and_normal_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(NormalRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    @Test
    public void has_url_and_normal_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(NormalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertNormalHasUrlAndWildcard();
    }

    private void assertNormalHasUrlAndWildcard() {
        Assert.assertEquals((String)"NormalRoute should have been returned", NormalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"HasUrlRoute should have been returned", HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")));
        Assert.assertEquals((String)"WildcardRoute should have been returned for multiple parameters", WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")));
    }

    @Test
    public void has_url_and_optional_parameter_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(OptionalRoute.class);
        Assert.assertEquals((String)"OptionalRoute should have been returned", OptionalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"HasUrlRoute should have been returned", HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")));
    }

    @Test
    public void has_url_and_wildcard_and_optional_parameter_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(OptionalRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void optional_parameter_and_has_url_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(OptionalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void optional_parameter_and_wildcard_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(OptionalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void wildcard_and_has_url_and_optional_parameter_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(OptionalRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void wildcard_and_optional_parameter_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(OptionalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    @Test
    public void has_url_and_optional_parameter_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(OptionalRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertHasUrlOptionalAndWildcard();
    }

    private void assertHasUrlOptionalAndWildcard() {
        Assert.assertEquals((String)"OptionalRoute should have been returned", OptionalRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"HasUrlRoute should have been returned", HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")));
        Assert.assertEquals((String)"WildcardRoute should have been returned for multiple parameters", WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")));
    }

    @Test
    public void has_url_and_wildcard_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        this.assertHasUrlAndWildcard();
    }

    @Test
    public void wildcard_and_has_url_work_together() throws InvalidRouteConfigurationException {
        this.addTarget(WildcardRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.assertHasUrlAndWildcard();
    }

    private void assertHasUrlAndWildcard() {
        Assert.assertEquals((String)"WildcardRoute should have been returned", WildcardRoute.class, this.getTarget(new ArrayList<String>()));
        Assert.assertEquals((String)"HasUrlRoute should have been returned", HasUrlRoute.class, this.getTarget(Arrays.asList("parameter")));
        Assert.assertEquals((String)"WildcardRoute should have been returned for multiple parameters", WildcardRoute.class, this.getTarget(Arrays.asList("wild", "card", "target")));
    }

    @Test
    public void multiple_normal_routes_throw_exception() throws InvalidRouteConfigurationException {
        this.expectedEx.expect(InvalidRouteConfigurationException.class);
        this.expectedEx.expectMessage(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' having the same route.", NormalRoute.class.getName(), SecondNormalRoute.class.getName()));
        this.addTarget(NormalRoute.class);
        this.addTarget(SecondNormalRoute.class);
    }

    @Test
    public void normal_and_optional_throws_exception() throws InvalidRouteConfigurationException {
        this.expectedEx.expect(InvalidRouteConfigurationException.class);
        this.expectedEx.expectMessage(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", NormalRoute.class.getName(), OptionalRoute.class.getName(), OptionalRoute.class.getName()));
        this.addTarget(NormalRoute.class);
        this.addTarget(OptionalRoute.class);
    }

    @Test
    public void two_optionals_throw_exception() throws InvalidRouteConfigurationException {
        this.expectedEx.expect(InvalidRouteConfigurationException.class);
        this.expectedEx.expectMessage(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' with parameter having the same route.", OptionalRoute.class.getName(), SecondOptionalRoute.class.getName()));
        this.addTarget(OptionalRoute.class);
        this.addTarget(SecondOptionalRoute.class);
    }

    @Test
    public void optional_and_normal_throws_exception() throws InvalidRouteConfigurationException {
        this.expectedEx.expect(InvalidRouteConfigurationException.class);
        this.expectedEx.expectMessage(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", NormalRoute.class.getName(), OptionalRoute.class.getName(), OptionalRoute.class.getName()));
        this.addTarget(OptionalRoute.class);
        this.addTarget(NormalRoute.class);
    }

    @Test
    public void two_has_route_parameters_throw_exception() throws InvalidRouteConfigurationException {
        this.expectedEx.expect(InvalidRouteConfigurationException.class);
        this.expectedEx.expectMessage(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' with parameter having the same route.", HasUrlRoute.class.getName(), SecondHasUrlRoute.class.getName()));
        this.addTarget(HasUrlRoute.class);
        this.addTarget(SecondHasUrlRoute.class);
    }

    @Test
    public void two_wildcard_parameters_throw_exception() throws InvalidRouteConfigurationException {
        this.expectedEx.expect(InvalidRouteConfigurationException.class);
        this.expectedEx.expectMessage(String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' with parameter having the same route.", WildcardRoute.class.getName(), SecondWildcardRoute.class.getName()));
        this.addTarget(WildcardRoute.class);
        this.addTarget(SecondWildcardRoute.class);
    }

    @Test
    public void removing_target_leaves_others() {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        Assert.assertEquals((String)"Expected three routes to be registered", (long)3L, (long)this.config().getTargetRoutes().size());
        this.registry.removeRoute(HasUrlRoute.class);
        Assert.assertEquals((String)"Only 2 routes should remain after removing one.", (long)2L, (long)this.config().getTargetRoutes().size());
        Assert.assertTrue((String)"NormalRoute should still be available", (boolean)this.config().hasRouteTarget(NormalRoute.class));
        Assert.assertTrue((String)"WildcardRoute should still be available", (boolean)this.config().hasRouteTarget(WildcardRoute.class));
    }

    @Test
    public void removing_all_targets_is_possible_and_returns_empty() {
        this.addTarget(NormalRoute.class);
        this.addTarget(HasUrlRoute.class);
        this.addTarget(WildcardRoute.class);
        Assert.assertEquals((String)"Expected three routes to be registered", (long)3L, (long)this.config().getTargetRoutes().size());
        this.registry.removeRoute(HasUrlRoute.class);
        this.registry.removeRoute(NormalRoute.class);
        this.registry.removeRoute(WildcardRoute.class);
        Assert.assertTrue((String)"All routes should have been removed from the target.", (boolean)this.config().getTargetRoutes().isEmpty());
    }

    @Test
    public void check_has_parameters_returns_correctly() {
        this.registry.setRoute("", NormalRoute.class, null);
        this.registry.setRoute("url", HasUrlRoute.class, null);
        this.registry.setRoute("optional", OptionalRoute.class, null);
        this.registry.setRoute("wild", WildcardRoute.class, null);
        this.registry.setRoute(ParameterView.class.getAnnotation(Route.class).value(), ParameterView.class, null);
        Assert.assertEquals((String)"All routes should be registered.", (long)5L, (long)this.config().getTargetRoutes().size());
        Assert.assertFalse((String)"Normal route should not mark as requiring parameter", (boolean)this.registry.hasMandatoryParameter(NormalRoute.class));
        Assert.assertFalse((String)"Optional parameter should not mark as requiring parameter", (boolean)this.registry.hasMandatoryParameter(OptionalRoute.class));
        Assert.assertFalse((String)"Wildcard parameter should not mark as requiring parameter", (boolean)this.registry.hasMandatoryParameter(WildcardRoute.class));
        Assert.assertTrue((String)"HasUrl should require parameter", (boolean)this.registry.hasMandatoryParameter(HasUrlRoute.class));
        Assert.assertTrue((String)"Template parameter should require parameter", (boolean)this.registry.hasMandatoryParameter(ParameterView.class));
        Assert.assertThrows((String)"Checking unregistered route should throw exception", NotFoundException.class, () -> this.registry.hasMandatoryParameter(Secondary.class));
    }

    @Test
    public void multipleLayouts_stricterLayoutMatches_correctLayoutsReturned() {
        this.registry.setLayout(DefaultLayout.class);
        this.registry.setLayout(ViewLayout.class);
        Assert.assertEquals((String)"Path match returned wrong layout", ViewLayout.class, (Object)this.registry.getLayout("/view"));
        Assert.assertEquals((String)"Beginning path match returned wrong layout", ViewLayout.class, (Object)this.registry.getLayout("/view/home"));
        Assert.assertEquals((String)"Any route match returned wrong layout", DefaultLayout.class, (Object)this.registry.getLayout("/path"));
    }

    @Test
    public void singleLayout_nonMatchingPathsReturnFalseOnHasLayout() {
        this.registry.setLayout(ViewLayout.class);
        Assert.assertTrue((String)"Existing layout should have returned true", (boolean)this.registry.hasLayout("/view"));
        Assert.assertFalse((String)"Path outside layout should return false", (boolean)this.registry.hasLayout("/path"));
    }

    private void awaitCountDown(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    private ConfiguredRoutes config() {
        return this.registry.getConfiguration();
    }

    private void addTarget(Class<? extends Component> navigationTarget) {
        this.registry.setRoute("", navigationTarget, Collections.emptyList());
    }

    private void addTarget(Class<? extends Component> navigationTarget, List<Class<? extends RouterLayout>> parentChain) {
        this.registry.setRoute("", navigationTarget, parentChain);
    }

    private Class<? extends Component> getTarget() {
        return this.registry.getNavigationTarget("").orElse(null);
    }

    private Class<? extends Component> getTarget(String segment) {
        return this.registry.getNavigationTarget(segment).orElse(null);
    }

    private Class<? extends Component> getTarget(List<String> segments) {
        return this.registry.getNavigationTarget(PathUtil.getPath(segments)).orElse(null);
    }

    @Tag(value="div")
    @Route(value="MyRoute")
    private static class MyRoute
    extends Component {
        private MyRoute() {
        }
    }

    @Tag(value="div")
    private static class Secondary
    extends Component {
        private Secondary() {
        }
    }

    @Tag(value="div")
    private static class MainLayout
    extends Component
    implements RouterLayout {
        private MainLayout() {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class NormalRoute
    extends Component {
        private NormalRoute() {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class HasUrlRoute
    extends Component
    implements HasUrlParameter<String> {
        private HasUrlRoute() {
        }

        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class OptionalRoute
    extends Component
    implements HasUrlParameter<String> {
        private OptionalRoute() {
        }

        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class WildcardRoute
    extends Component
    implements HasUrlParameter<String> {
        private WildcardRoute() {
        }

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondNormalRoute
    extends Component {
        private SecondNormalRoute() {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondOptionalRoute
    extends Component
    implements HasUrlParameter<String> {
        private SecondOptionalRoute() {
        }

        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondHasUrlRoute
    extends Component
    implements HasUrlParameter<String> {
        private SecondHasUrlRoute() {
        }

        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Route(value="")
    @Tag(value="div")
    private static class SecondWildcardRoute
    extends Component
    implements HasUrlParameter<String> {
        private SecondWildcardRoute() {
        }

        public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
        }
    }

    @Route(value="item/:long(^[+-]?[0-9]{1,19}$)")
    @Tag(value="div")
    private static class ParameterView
    extends Component {
        private ParameterView() {
        }
    }

    @Tag(value="div")
    @Layout
    private static class DefaultLayout
    extends Component
    implements RouterLayout {
        private DefaultLayout() {
        }
    }

    @Tag(value="div")
    @Layout(value="/view")
    private static class ViewLayout
    extends Component
    implements RouterLayout {
        private ViewLayout() {
        }
    }

    @Tag(value="div")
    private static class Parent
    extends Component
    implements RouterLayout {
        private Parent() {
        }
    }
}

