/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NodeListEmptyRequiredFeatureTest {
    private StateNode node;
    private NodeList<StateNode> nodeList;

    @Before
    public void setUp() {
        this.node = new StateNode(Arrays.asList(ElementChildrenList.class), new Class[0]){

            public boolean isAttached() {
                return true;
            }
        };
        this.nodeList = (NodeList)this.node.getFeature(ElementChildrenList.class);
    }

    @Test
    public void generateChangesFromEmpty_featureHasChangesToCollect() {
        this.nodeList.generateChangesFromEmpty();
        AtomicReference change = new AtomicReference();
        this.node.collectChanges(change::set);
        Assert.assertTrue((boolean)(change.get() instanceof EmptyChange));
        this.nodeList.generateChangesFromEmpty();
        change.set(null);
        this.node.collectChanges(change::set);
        Assert.assertNull(change.get());
    }

    @Test
    public void generateChangesFromEmpty_noEmptyChange() {
        this.nodeList.add((Serializable)new StateNode(new Class[0]));
        this.node.clearChanges();
        this.nodeList.generateChangesFromEmpty();
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
    }

    @Test
    public void collectChanges_featureHasEmptyChange() {
        AtomicReference change = new AtomicReference();
        this.nodeList.collectChanges(change::set);
        Assert.assertTrue((boolean)(change.get() instanceof EmptyChange));
        change.set(null);
        this.nodeList.collectChanges(change::set);
        Assert.assertNull(change.get());
    }

    @Test
    public void collectChanges_noEmptyChange() {
        this.nodeList.add((Serializable)new StateNode(new Class[0]));
        ArrayList changes = new ArrayList();
        this.node.collectChanges(changes::add);
        Assert.assertEquals((long)1L, (long)changes.size());
        Assert.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
    }
}

