/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateNodeTest;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.internal.nodefeature.BasicTypeValue;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.ElementAttributeMap;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ElementListenerMap;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementStylePropertyMap;
import com.vaadin.flow.internal.nodefeature.InertData;
import com.vaadin.flow.internal.nodefeature.LoadingIndicatorConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.internal.nodefeature.PollConfigurationMap;
import com.vaadin.flow.internal.nodefeature.PolymerEventListenerMap;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.internal.nodefeature.PushConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReconnectDialogConfigurationMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ShadowRootData;
import com.vaadin.flow.internal.nodefeature.ShadowRootHost;
import com.vaadin.flow.internal.nodefeature.TextBindingFeature;
import com.vaadin.flow.internal.nodefeature.TextNodeMap;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class NodeFeatureTest {
    @Test(expected=AssertionError.class)
    public void testCreateNullTypeThrows() {
        NodeFeatureRegistry.create(null, (StateNode)StateNodeTest.createEmptyNode());
    }

    @Test(expected=AssertionError.class)
    public void testCreateNullNodeThrows() {
        NodeFeatureRegistry.create(ElementData.class, null);
    }

    @Test(expected=AssertionError.class)
    public void testCreateUnknownFeatureThrows() {
        NodeFeatureRegistry.create(UnregisteredNodeFeature.class, (StateNode)StateNodeTest.createEmptyNode());
    }

    private static Map<Class<? extends NodeFeature>, Integer> buildExpectedIdMap() {
        HashMap<Class<? extends NodeFeature>, Integer> expectedIds = new HashMap<Class<? extends NodeFeature>, Integer>();
        expectedIds.put(ElementData.class, 0);
        expectedIds.put(ElementPropertyMap.class, 1);
        expectedIds.put(ElementAttributeMap.class, 3);
        expectedIds.put(ElementChildrenList.class, 2);
        expectedIds.put(ElementListenerMap.class, 4);
        expectedIds.put(PushConfigurationMap.class, 5);
        expectedIds.put(PushConfigurationMap.PushConfigurationParametersMap.class, 6);
        expectedIds.put(TextNodeMap.class, 7);
        expectedIds.put(PollConfigurationMap.class, 8);
        expectedIds.put(ReconnectDialogConfigurationMap.class, 9);
        expectedIds.put(LoadingIndicatorConfigurationMap.class, 10);
        expectedIds.put(ElementClassList.class, 11);
        expectedIds.put(ElementStylePropertyMap.class, 12);
        expectedIds.put(ComponentMapping.class, 15);
        expectedIds.put(ModelList.class, 16);
        expectedIds.put(PolymerServerEventHandlers.class, 17);
        expectedIds.put(PolymerEventListenerMap.class, 18);
        expectedIds.put(ClientCallableHandlers.class, 19);
        expectedIds.put(ShadowRootData.class, 20);
        expectedIds.put(ShadowRootHost.class, 21);
        expectedIds.put(AttachExistingElementFeature.class, 22);
        expectedIds.put(BasicTypeValue.class, 23);
        expectedIds.put(VirtualChildrenList.class, 24);
        expectedIds.put(ReturnChannelMap.class, 25);
        expectedIds.put(InertData.class, 26);
        expectedIds.put(TextBindingFeature.class, 27);
        return expectedIds;
    }

    @Test
    public void testGetIdValues() {
        Map<Class<? extends NodeFeature>, Integer> expectedIds = NodeFeatureTest.buildExpectedIdMap();
        Assert.assertEquals((String)"The number of expected features is not up to date", (long)expectedIds.size(), (long)NodeFeatureRegistry.nodeFeatures.size());
        expectedIds.forEach((type, expectedId) -> Assert.assertEquals((String)("Unexpected id for " + type.getName()), (long)expectedId.intValue(), (long)NodeFeatureRegistry.getId((Class)type)));
    }

    @Test
    public void testGetById() {
        Map<Class<? extends NodeFeature>, Integer> expectedIds = NodeFeatureTest.buildExpectedIdMap();
        expectedIds.forEach((expectedType, id) -> Assert.assertEquals((String)("Unexpected type for id " + id), (Object)expectedType, (Object)NodeFeatureRegistry.getFeature((int)id)));
    }

    @Test
    public void priorityOrder() {
        List priorityOrder = NodeFeatureTest.buildExpectedIdMap().keySet().stream().sorted(NodeFeatureRegistry.PRIORITY_COMPARATOR).collect(Collectors.toList());
        List<Class> expectedOrder = Arrays.asList(ElementData.class, TextNodeMap.class, TextBindingFeature.class, ModelList.class, BasicTypeValue.class, ElementChildrenList.class, ElementPropertyMap.class, ComponentMapping.class, ClientCallableHandlers.class, ElementClassList.class, ElementAttributeMap.class, ElementListenerMap.class, VirtualChildrenList.class, ReturnChannelMap.class, PolymerEventListenerMap.class, PolymerServerEventHandlers.class, ElementStylePropertyMap.class, ShadowRootData.class, ShadowRootHost.class, AttachExistingElementFeature.class, InertData.class, PushConfigurationMap.class, PushConfigurationMap.PushConfigurationParametersMap.class, LoadingIndicatorConfigurationMap.class, PollConfigurationMap.class, ReconnectDialogConfigurationMap.class);
        Assert.assertEquals((long)expectedOrder.size(), (long)priorityOrder.size());
        for (int i = 0; i < priorityOrder.size(); ++i) {
            if (priorityOrder.get(i) == expectedOrder.get(i)) continue;
            Assert.fail((String)("Invalid priority ordering at index " + i + ". Expected " + expectedOrder.get(i).getSimpleName() + " but got " + ((Class)priorityOrder.get(i)).getSimpleName()));
        }
    }

    private static abstract class UnregisteredNodeFeature
    extends NodeFeature {
        public UnregisteredNodeFeature(StateNode node) {
            super(node);
        }
    }
}

